/*
 * Decompiled with CFR 0.152.
 */
package org.bsplines.ltexls.languagetool;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bsplines.ltexls.parsing.AnnotatedTextFragment;
import org.bsplines.ltexls.server.LtexTextDocumentItem;
import org.bsplines.ltexls.tools.Tools;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 /2\u00020\u0001:\u0001/BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003Jc\u0010#\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001J\u0016\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020%J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00060"}, d2={"Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "", "ruleId", "", "sentence", "fromPos", "", "toPos", "message", "suggestedReplacements", "", "type", "Lorg/languagetool/rules/RuleMatch$Type;", "languageShortCode", "(Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;Ljava/util/List;Lorg/languagetool/rules/RuleMatch$Type;Ljava/lang/String;)V", "getFromPos", "()I", "getLanguageShortCode", "()Ljava/lang/String;", "getMessage", "getRuleId", "getSentence", "getSuggestedReplacements", "()Ljava/util/List;", "getToPos", "getType", "()Lorg/languagetool/rules/RuleMatch$Type;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "isIntersectingWithRange", "range", "Lorg/eclipse/lsp4j/Range;", "document", "Lorg/bsplines/ltexls/server/LtexTextDocumentItem;", "isUnknownWordRule", "toString", "Companion", "ltexls"})
public final class LanguageToolRuleMatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String ruleId;
    @Nullable
    private final String sentence;
    private final int fromPos;
    private final int toPos;
    @NotNull
    private final String message;
    @NotNull
    private final List<String> suggestedReplacements;
    @NotNull
    private final RuleMatch.Type type;
    @NotNull
    private final String languageShortCode;
    @NotNull
    private static final Regex TWO_OR_MORE_SPACES_REGEX = new Regex("[ \n]{2,}");

    public LanguageToolRuleMatch(@Nullable String ruleId, @Nullable String sentence, int fromPos, int toPos, @NotNull String message, @NotNull List<String> suggestedReplacements, @NotNull RuleMatch.Type type, @NotNull String languageShortCode) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestedReplacements, (String)"suggestedReplacements");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)languageShortCode, (String)"languageShortCode");
        this.ruleId = ruleId;
        this.sentence = sentence;
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.message = message;
        this.suggestedReplacements = suggestedReplacements;
        this.type = type;
        this.languageShortCode = languageShortCode;
    }

    @Nullable
    public final String getRuleId() {
        return this.ruleId;
    }

    @Nullable
    public final String getSentence() {
        return this.sentence;
    }

    public final int getFromPos() {
        return this.fromPos;
    }

    public final int getToPos() {
        return this.toPos;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final List<String> getSuggestedReplacements() {
        return this.suggestedReplacements;
    }

    @NotNull
    public final RuleMatch.Type getType() {
        return this.type;
    }

    @NotNull
    public final String getLanguageShortCode() {
        return this.languageShortCode;
    }

    public final boolean isIntersectingWithRange(@NotNull Range range, @NotNull LtexTextDocumentItem document) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)document), (String)"document");
        return Tools.INSTANCE.areRangesIntersecting(new Range(document.convertPosition(this.fromPos), document.convertPosition(this.toPos)), range);
    }

    public final boolean isUnknownWordRule() {
        return Companion.isUnknownWordRule(this.ruleId);
    }

    @Nullable
    public final String component1() {
        return this.ruleId;
    }

    @Nullable
    public final String component2() {
        return this.sentence;
    }

    public final int component3() {
        return this.fromPos;
    }

    public final int component4() {
        return this.toPos;
    }

    @NotNull
    public final String component5() {
        return this.message;
    }

    @NotNull
    public final List<String> component6() {
        return this.suggestedReplacements;
    }

    @NotNull
    public final RuleMatch.Type component7() {
        return this.type;
    }

    @NotNull
    public final String component8() {
        return this.languageShortCode;
    }

    @NotNull
    public final LanguageToolRuleMatch copy(@Nullable String ruleId, @Nullable String sentence, int fromPos, int toPos, @NotNull String message, @NotNull List<String> suggestedReplacements, @NotNull RuleMatch.Type type, @NotNull String languageShortCode) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(suggestedReplacements, (String)"suggestedReplacements");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)languageShortCode, (String)"languageShortCode");
        return new LanguageToolRuleMatch(ruleId, sentence, fromPos, toPos, message, suggestedReplacements, type, languageShortCode);
    }

    public static /* synthetic */ LanguageToolRuleMatch copy$default(LanguageToolRuleMatch languageToolRuleMatch, String string, String string2, int n, int n2, String string3, List list, RuleMatch.Type type, String string4, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = languageToolRuleMatch.ruleId;
        }
        if ((n3 & 2) != 0) {
            string2 = languageToolRuleMatch.sentence;
        }
        if ((n3 & 4) != 0) {
            n = languageToolRuleMatch.fromPos;
        }
        if ((n3 & 8) != 0) {
            n2 = languageToolRuleMatch.toPos;
        }
        if ((n3 & 0x10) != 0) {
            string3 = languageToolRuleMatch.message;
        }
        if ((n3 & 0x20) != 0) {
            list = languageToolRuleMatch.suggestedReplacements;
        }
        if ((n3 & 0x40) != 0) {
            type = languageToolRuleMatch.type;
        }
        if ((n3 & 0x80) != 0) {
            string4 = languageToolRuleMatch.languageShortCode;
        }
        return languageToolRuleMatch.copy(string, string2, n, n2, string3, list, type, string4);
    }

    @NotNull
    public String toString() {
        return "LanguageToolRuleMatch(ruleId=" + this.ruleId + ", sentence=" + this.sentence + ", fromPos=" + this.fromPos + ", toPos=" + this.toPos + ", message=" + this.message + ", suggestedReplacements=" + this.suggestedReplacements + ", type=" + this.type + ", languageShortCode=" + this.languageShortCode + ")";
    }

    public int hashCode() {
        int result = this.ruleId == null ? 0 : this.ruleId.hashCode();
        result = result * 31 + (this.sentence == null ? 0 : this.sentence.hashCode());
        result = result * 31 + Integer.hashCode(this.fromPos);
        result = result * 31 + Integer.hashCode(this.toPos);
        result = result * 31 + this.message.hashCode();
        result = result * 31 + ((Object)this.suggestedReplacements).hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.languageShortCode.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LanguageToolRuleMatch)) {
            return false;
        }
        LanguageToolRuleMatch languageToolRuleMatch = (LanguageToolRuleMatch)other;
        if (!Intrinsics.areEqual((Object)this.ruleId, (Object)languageToolRuleMatch.ruleId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sentence, (Object)languageToolRuleMatch.sentence)) {
            return false;
        }
        if (this.fromPos != languageToolRuleMatch.fromPos) {
            return false;
        }
        if (this.toPos != languageToolRuleMatch.toPos) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)languageToolRuleMatch.message)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.suggestedReplacements, languageToolRuleMatch.suggestedReplacements)) {
            return false;
        }
        if (this.type != languageToolRuleMatch.type) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.languageShortCode, (Object)languageToolRuleMatch.languageShortCode);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJP\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch$Companion;", "", "()V", "TWO_OR_MORE_SPACES_REGEX", "Lkotlin/text/Regex;", "fromLanguageTool", "Lorg/bsplines/ltexls/languagetool/LanguageToolRuleMatch;", "jsonMatch", "Lcom/google/gson/JsonObject;", "annotatedTextFragment", "Lorg/bsplines/ltexls/parsing/AnnotatedTextFragment;", "ruleId", "", "sentence", "fromPos", "", "toPos", "languageToolMessage", "suggestedReplacements", "", "type", "Lorg/languagetool/rules/RuleMatch$Type;", "match", "Lorg/languagetool/rules/RuleMatch;", "isUnknownWordRule", "", "ltexls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageToolRuleMatch fromLanguageTool(@NotNull RuleMatch match, @NotNull AnnotatedTextFragment annotatedTextFragment) {
            Intrinsics.checkNotNullParameter((Object)match, (String)"match");
            Intrinsics.checkNotNullParameter((Object)annotatedTextFragment, (String)"annotatedTextFragment");
            Rule rule = match.getRule();
            String string = rule != null ? rule.getId() : null;
            AnalyzedSentence analyzedSentence = match.getSentence();
            String string2 = analyzedSentence != null ? analyzedSentence.getText() : null;
            int n = match.getFromPos();
            int n2 = match.getToPos();
            String string3 = match.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"match.message");
            List list = match.getSuggestedReplacements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"match.suggestedReplacements");
            RuleMatch.Type type = match.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"match.type");
            return this.fromLanguageTool(string, string2, n, n2, string3, list, type, annotatedTextFragment);
        }

        @NotNull
        public final LanguageToolRuleMatch fromLanguageTool(@NotNull JsonObject jsonMatch, @NotNull AnnotatedTextFragment annotatedTextFragment) {
            Intrinsics.checkNotNullParameter((Object)jsonMatch, (String)"jsonMatch");
            Intrinsics.checkNotNullParameter((Object)annotatedTextFragment, (String)"annotatedTextFragment");
            int fromPos = jsonMatch.get("offset").getAsInt();
            ArrayList<String> suggestedReplacements = new ArrayList<String>();
            for (Object e : jsonMatch.get("replacements").getAsJsonArray()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"jsonMatch.get(\"replacements\").asJsonArray");
                JsonElement replacement = (JsonElement)e;
                suggestedReplacements.add(replacement.getAsJsonObject().get("value").getAsString());
            }
            String string = jsonMatch.get("rule").getAsJsonObject().get("id").getAsString();
            String string2 = jsonMatch.get("sentence").getAsString();
            int n = fromPos + jsonMatch.get("length").getAsInt();
            String string3 = jsonMatch.get("message").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsonMatch.get(\"message\").asString");
            return this.fromLanguageTool(string, string2, fromPos, n, string3, (List<String>)suggestedReplacements, RuleMatch.Type.Hint, annotatedTextFragment);
        }

        @NotNull
        public final LanguageToolRuleMatch fromLanguageTool(@Nullable String ruleId, @Nullable String sentence, int fromPos, int toPos, @NotNull String languageToolMessage, @NotNull List<String> suggestedReplacements, @NotNull RuleMatch.Type type, @NotNull AnnotatedTextFragment annotatedTextFragment) {
            Intrinsics.checkNotNullParameter((Object)languageToolMessage, (String)"languageToolMessage");
            Intrinsics.checkNotNullParameter(suggestedReplacements, (String)"suggestedReplacements");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)annotatedTextFragment, (String)"annotatedTextFragment");
            StringBuilder messageBuilder = new StringBuilder();
            if (this.isUnknownWordRule(ruleId)) {
                messageBuilder.append("'");
                messageBuilder.append(annotatedTextFragment.getSubstringOfPlainText(fromPos, toPos));
                messageBuilder.append("': ");
            }
            messageBuilder.append(languageToolMessage);
            String string = messageBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageBuilder.toString()");
            CharSequence charSequence = string;
            Regex regex = TWO_OR_MORE_SPACES_REGEX;
            String string2 = " ";
            String message = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string2))).toString();
            return new LanguageToolRuleMatch(ruleId, sentence, fromPos, toPos, message, suggestedReplacements, type, annotatedTextFragment.getCodeFragment().getLanguageShortCode());
        }

        public final boolean isUnknownWordRule(@Nullable String ruleId) {
            return ruleId != null && (StringsKt.startsWith$default((String)ruleId, (String)"MORFOLOGIK_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)ruleId, (String)"HUNSPELL_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)ruleId, (String)"_SPELLER_RULE", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)ruleId, (String)"_SPELLING_RULE", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)ruleId, (Object)"MUZSKY_ROD_NEZIV_A") || Intrinsics.areEqual((Object)ruleId, (Object)"ZENSKY_ROD_A") || Intrinsics.areEqual((Object)ruleId, (Object)"STREDNY_ROD_A"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

