/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.chunking;

import edu.washington.cs.knowitall.logic.Expression;
import java.util.function.Predicate;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.chunking.ChunkTaggedToken;
import org.languagetool.rules.patterns.StringMatcher;

final class TokenPredicate
extends Expression.Arg.Pred<ChunkTaggedToken> {
    private final Predicate<ChunkTaggedToken> predicate;

    TokenPredicate(String description, boolean caseSensitive) {
        super(description);
        this.predicate = this.compile(description, caseSensitive);
    }

    private Predicate<ChunkTaggedToken> compile(String description, boolean caseSensitive) {
        String exprValue;
        String exprType;
        String[] parts = description.split("=");
        if (parts.length == 1) {
            exprType = "string";
            exprValue = TokenPredicate.unquote(parts[0]);
        } else if (parts.length == 2) {
            exprType = parts[0];
            exprValue = TokenPredicate.unquote(parts[1]);
        } else {
            throw new RuntimeException("Could not parse expression: " + this.getDescription());
        }
        switch (exprType) {
            case "string": 
            case "regex": 
            case "regexCS": {
                StringMatcher matcher = StringMatcher.create((String)exprValue, (!"string".equals(exprType) ? 1 : 0) != 0, (caseSensitive || "regexCS".equals(exprType) ? 1 : 0) != 0);
                return analyzedToken -> matcher.matches(analyzedToken.getToken());
            }
            case "chunk": {
                StringMatcher chunkPattern = StringMatcher.create((String)exprValue, (boolean)true, (boolean)true);
                return analyzedToken -> {
                    for (ChunkTag chunkTag : analyzedToken.getChunkTags()) {
                        if (!chunkPattern.matches(chunkTag.getChunkTag())) continue;
                        return true;
                    }
                    return false;
                };
            }
            case "pos": {
                return analyzedToken -> {
                    AnalyzedTokenReadings readings = analyzedToken.getReadings();
                    if (readings != null) {
                        for (AnalyzedToken token : readings) {
                            if (token.getPOSTag() == null || !token.getPOSTag().contains(exprValue)) continue;
                            return true;
                        }
                    }
                    return false;
                };
            }
            case "posre": 
            case "posregex": {
                StringMatcher posPattern = StringMatcher.create((String)exprValue, (boolean)true, (boolean)true);
                return analyzedToken -> {
                    AnalyzedTokenReadings readings = analyzedToken.getReadings();
                    if (readings != null) {
                        for (AnalyzedToken token : readings) {
                            if (token.getPOSTag() == null || !posPattern.matches(token.getPOSTag())) continue;
                            return true;
                        }
                    }
                    return false;
                };
            }
        }
        throw new RuntimeException("Expression type not supported: '" + exprType + "'");
    }

    private static String unquote(String s) {
        return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
    }

    public boolean apply(ChunkTaggedToken analyzedToken) {
        return this.predicate.test(analyzedToken);
    }
}

