/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.it;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.UK);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.startsWith("do") || day.equals("domenica")) {
            return 1;
        }
        if (day.startsWith("lu") || day.equals("luned\u00ec")) {
            return 2;
        }
        if (day.startsWith("ma") || day.equals("marted\u00ec")) {
            return 3;
        }
        if (day.startsWith("me") || day.equals("mercoled\u00ec")) {
            return 4;
        }
        if (day.startsWith("gi") || day.equals("gioved\u00ec")) {
            return 5;
        }
        if (day.startsWith("ve") || day.equals("venerd\u00ec")) {
            return 6;
        }
        if (day.startsWith("sa") || day.equals("sabato")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "domenica";
        }
        if (englishDay.equals("Monday")) {
            return "luned\u00ec";
        }
        if (englishDay.equals("Tuesday")) {
            return "marted\u00ec";
        }
        if (englishDay.equals("Wednesday")) {
            return "mercoled\u00ec";
        }
        if (englishDay.equals("Thursday")) {
            return "gioved\u00ec";
        }
        if (englishDay.equals("Friday")) {
            return "venerd\u00ec";
        }
        if (englishDay.equals("Saturday")) {
            return "sabato";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("gen")) {
            return 1;
        }
        if (mon.startsWith("feb")) {
            return 2;
        }
        if (mon.startsWith("mar")) {
            return 3;
        }
        if (mon.startsWith("apr")) {
            return 4;
        }
        if (mon.startsWith("mag")) {
            return 5;
        }
        if (mon.startsWith("giu")) {
            return 6;
        }
        if (mon.startsWith("lug")) {
            return 7;
        }
        if (mon.startsWith("ago")) {
            return 8;
        }
        if (mon.startsWith("set")) {
            return 9;
        }
        if (mon.startsWith("ott")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("dic")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

