%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of Logtalk <https://logtalk.org/>
%  Copyright 1998-2022 Paulo Moura <pmoura@logtalk.org>
%  SPDX-License-Identifier: Apache-2.0
%
%  Licensed under the Apache License, Version 2.0 (the "License");
%  you may not use this file except in compliance with the License.
%  You may obtain a copy of the License at
%
%      http://www.apache.org/licenses/LICENSE-2.0
%
%  Unless required by applicable law or agreed to in writing, software
%  distributed under the License is distributed on an "AS IS" BASIS,
%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%  See the License for the specific language governing permissions and
%  limitations under the License.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% the trivial implementation of the Observer design pattern is to use the
% built-in support for events


% ensure events are generated by default
:- initialization(set_logtalk_flag(events, allow)).

:- object(observer,
	% the monitoring protocol declares the event handling
	% predicates, before/3 and after/3
	implements(monitoring)).

	% react to any message sent to the subject object from
	% the user object (i.e. the from the top-level)
	:- initialization(
		define_events(_Event, subject, _Message, user, observer)
	).

	before(subject, Message, user) :-
		write('user is asking observer:  '), write(Message), nl.

	after(subject, Message, user) :-
		write('observer replied to user: '), write(Message), nl.

:- end_object.


:- object(subject).

	:- public(ping/1).
	ping(pong).

:- end_object.
