________________________________________________________________________

Notes on supported backend Prolog compilers  
Last updated on November 1, 2015

This file is part of Logtalk <http://logtalk.org/>  
Copyright 1998-2015 Paulo Moura <pmoura@logtalk.org>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


This file contains some notes about the adapter files provided. The folder
`unsupported` contains adapter files for Prolog compilers that are not yet
or no longer officially supported.

If you improve or correct some of these files, or write new ones for other
Prolog compilers, please send me a copy. It is simply not feasible to 
individually test Logtalk under all possible combinations of compatible
Prolog versions and operating-system versions.

As a general rule, always try to use the latest version of your Prolog 
compiler of choice. For Prolog compilers with long release cycles, this 
may require use of development versions. Most Prolog compilers are moving 
towards better compatibility with de facto and official standards and thus
improved Logtalk compatibility. Also, visit the issue tracker on the Logtalk
development website and check for any know Prolog compiler bugs that break
Logtalk functionality.

For details on how to integrate Logtalk with specific Prolog compilers,
see the files in the `integration` directory of the Logtalk distribution.

The adapter files may include hacked definitions for official and de-facto
Prolog standard built-in predicates. These definitions aim only to fulfill
the requirements of the Logtalk compiler and runtime and are not intended
as a full replacement for missing functionality.

Top-level interpreter shorthands
--------------------------------

The adapter files define shorthands to often used Logtalk built-in
predicates such as `logtalk_load/1` and `logtalk_make/1`:

* `{*}`  
	shorthand for `logtalk_make(all)`;
	reloads all modified Logtalk source files since last loaded
* `{!}`  
	shorthand for `logtalk_make(clean)`;
	deletes (cuts) all intermediate files generated by the compilation of Logtalk source files
* `{File}`  
	shorthand for `logtalk_load(File)`;
	compiles and loads a single Logtalk source file (using default flags)
* `{File1, File2, ...}`  
	shorthand for `logtalk_load([File1, File2, ...])`;
	compiles and loads several Logtalk source files (using default flags)

Note, however, that these shorthands, which should only be used for
iterative development at the top-level interpreter, are not part of
the Logtalk language specification and can be commented out in case
of conflict with backend Prolog compiler features or third-party
libraries.


Optional features support per backend Prolog compiler
-----------------------------------------------------

Some Logtalk features are optional and require compatible support for specific
(and sometimes not yet standard) features by the backend Prolog compilers. The
following table summarizes the availability of these features:

|  Compiler        |    Tabling    |  Coinduction  |    Unicode    |    Threads    |  
| :--------------: | :-----------: | :-----------: | :-----------: | :-----------: |  
|  B-Prolog        |      yes      |       no      |       no      |       no      |  
|  CxProlog        |       no      |      yes      |      yes      |       no      |  
|  ECLiPSe         |       no      |      yes      |       no      |       no      |  
|  JIProlog        |       no      |       no      |      yes      |       no      |  
|  GNU Prolog      |       no      |       no      |       no      |       no      |  
|  Lean Prolog     |       no      |       no      |      yes      |       no      |  
|  Qu-Prolog       |       no      |       no      |       no      |       no      |  
|  Quintus Prolog  |       no      |       no      |       no      |       no      |  
|  SICStus Prolog  |       no      |      yes      |      yes      |       no      |  
|  SWI-Prolog      |       no      |      yes      |      yes      |      yes      |  
|  XSB             |      yes      |       no      |       no      |      yes      |  
|  YAP             |      yes      |      yes      |      yes      |      yes      |  

A value of "yes" means at least partial support (but some limitations may
be present). A value of "no" just means that the backend Prolog compiler
doesn't provide a *compatible* implementation of the required features.


template adapter file
---------------------

	template.pl

If a adapter file for your favorite Prolog is not available, use this 
file as a template for writing one. For each predicate in the file, 
check if it is built-in in your Prolog, available in a library, or if 
you can write a better definition.


B-Prolog 7.8 and later versions
-------------------------------

	b.pl

For B-Prolog 7.8 and later versions. Note that this adapter file
redefines the B-Prolog `::/2` finite-domain built-in predicate
(you may use the alternative `in/2` built-in predicate instead).

Some of the B-Prolog built-in predicates (e.g. `set_to_list/2` or `(@=)/2`) 
are not core predicates and can be redefined by the user. The predicate 
`predicate_property/2` does not return the property `built_in` for these 
predicates. The solution is to encapsulate calls to these predicates 
within objects and categories using the Logtalk `{}/1` control construct.

You may need to increase the sizes of the code areas on the integration
scripts if you run into out-of-memory errors with complex applications.

Matching clauses and action rules are currently not supported.

On Windows, the environment variable `BPDIR` must be defined and pointing
to the B-Prolog installation directory for the installer to detect it.


CxProlog 0.97.7 or later versions
---------------------------------

	cx.pl

Developed and tested with the help of the CxProlog author, Artur Miguel Dias.

Due to the long release cycle of CxProlog, you may need to use its development
version if the recommended version is not yet available as a stable release.


ECLiPSe 6.1#143 or later versions
---------------------------------

	eclipse.pl

There is a clash between Logtalk and ECLiPSe regarding the `::/2` operator.
You may still use the `::/2` operator defined on the ECLiPSe constraint 
solver libraries by using explicit module qualification by writing 
`{library:(Var::Domain)}` (replace `library` by the actual library name; 
the `{}/1` control construct allows you to bypass the Logtalk compiler).

ECLiPSe defines an alias `in_set_range/2` for `::/2` that can be used to
avoid conflicts with Logtalk `::/2` message sending operator.

Adopted from a adapter file written and tested with help of Taner Bilgic 
for Logtalk 1.x.

With this Prolog compiler, avoid reloading Logtalk source files defining
dynamic predicates. Due to the semantics of the ECLiPSe built-in predicate
`compile/1`, new clauses for dynamic predicates are appended to the old ones
instead of replacing them.

The Logtalk flag `prolog_compiler` is not usable due to lack of ECLiPSe
built-in predicates for separate compilation and loading. To generate
`.eco` files when compiling Logtalk source files, set the Logtalk `clean`
flag to `off` and add the option `output:eco` to the Logtalk `prolog_loader`
flag.


GNU Prolog 1.4.2 and later versions
-----------------------------------

	gnu.pl

GNU Prolog supports the ISO Prolog standard. No problems expected.

You can generate a new Prolog top level that embeds Logtalk by following
the steps (exemplified for POSIX systems):

	$ mkdir -p $HOME/collect
	$ cd $HOME/collect
	$ gplgt
	...
	| ?- logtalk_compile([
			core(expanding),
			core(monitoring),
			core(forwarding),
			core(user),
			core(logtalk),
			core(core_messages)],
			[scratch_directory('$HOME/collect')]).

	$ cp $LOGTALKHOME/adapters/gnu.pl $HOME/collect/gnu.pl
	$ cp $LOGTALKHOME/paths/paths.pl $HOME/collect/paths.pl
	$ cp $LOGTALKHOME/core/core.pl $HOME/collect/core.pl

Edit the `$HOME/collect/core.pl` file and add the line `:- built_in.` to
the top. Then:

	$ cd $HOME/collect
	$ gplc -o logtalk gnu.pl expanding_lgt.pl monitoring_lgt.pl forwarding_lgt.pl user_lgt.pl logtalk_lgt.pl core_messages_lgt.pl core.pl paths.pl

You can ignore any suspicious predicate warnings about the `{}/1` predicate
that might be printed when running the `gplc` command. Note that the order of
the files when calling `gplc` is important. Finally, move the new executable
to a directory in your system PATH. For example:

	$ mv logtalk /usr/local/bin/

This way, every time you want to work with Logtalk you will just need 
to type:

	$ logtalk


JIProlog 4.1.2.8 and later versions
-----------------------------------

	ji.pl

Written with the help of Ugo Chirico, JIProlog author (but if you find any
Logtalk problem please report it to me).

To generate `.jip` files from Logtalk source files, use the built-in
`logtalk_compile/1-2` or the `logtalk_load/1-2` predicates with the
`clean` flag turned off.

Logtalk can be embedded in JIProlog by creating a `logtalk.jar` by following
these steps:

	$ mkdir -p $HOME/collect
	$ cd $HOME/collect
	$ jiplgt
	...
	| ?- logtalk_compile([
			core(expanding),
			core(monitoring),
			core(forwarding),
			core(user),
			core(logtalk),
			core(core_messages)],
			[scratch_directory('$HOME/collect')]).
	...

	$ cp $LOGTALKHOME/adapters/ji.pl $HOME/collect/ji.pl
	$ cp $LOGTALKHOME/paths/paths.pl $HOME/collect/paths.pl
	$ cp $LOGTALKHOME/core/core.pl $HOME/collect/core.pl

	| ?- compile('ji.pl'), compile('paths.pl'), compile('core.pl').
	...

Next, create a `$HOME/collect/init.pl` with the contents:

	:- load('ji.jip').
	:- load('paths.jip').
	:- load('expanding_lgt.jip').
	:- load('monitoring_lgt.jip').
	:- load('forwarding_lgt.jip').
	:- load('user_lgt.jip').
	:- load('logtalk_lgt.jip').
	:- load('core_messages_lgt.jip').
	:- load('core.jip').

We now have all the necessary files to create the `logtalk.jar` file:

	$ jar cf logtalk.jar init.pl *.jip

The `logtalk.jar` file can be distributed with the other JIProlog `.jar`
files. Logtalk can also be loaded on demand from the `logtalk.jar` file
by using the `load_library/1` JIProlog built-in predicate:

	| ?- load_library('logtalk.jar').


Lean Prolog 4.5.4 and later versions
------------------------------------

	lean.pl

Experimental. Lean Prolog lacks compliance with both official and de facto
standards. Notably, it lacks support for stream aliases, for the `0'Char`
notation, for escape sequences in atoms, and its limited parser often
requires atoms to be quoted and written between ()'s. Moreover, due to
Lean Prolog limitation of compiling more than one file per session, the
compilation of Logtalk source files generates intermediate Prolog files
that are consulted (i.e. interpreted) instead of being compiled, severely
hurting performance. Thus, practical use requires embedding Logtalk and the
Logtalk application in Lean Prolog by including all necessary files in a
single file than can then be compiled. For example, you can collect all
Logtalk core files in a single file by following the steps (exemplified
for POSIX systems):

	$ lplgt
	...
	| ?- logtalk_compile([
			core(expanding),
			core(monitoring),
			core(forwarding),
			core(user),
			core(logtalk),
			core(core_messages)],
			[scratch_directory('$HOME/collect')]).

	$ cp $LOGTALKHOME/adapters/lean.pl $HOME/collect/lean.pl
	$ cp $LOGTALKHOME/paths/paths.pl $HOME/collect/paths.pl
	$ cp $LOGTALKHOME/core/core.pl $HOME/collect/core.pl

	$ cd $HOME/collect
	$ cat lean.pl paths.pl expanding_lgt.pl monitoring_lgt.pl forwarding_lgt.pl user_lgt.pl logtalk_lgt.pl core_messages_lgt.pl core.pl > logtalk_core.pl

Starting Lean Prolog with a Java allocation of at least 2GB is recommended
(by passing a `-Xmx2G` option to Java).


Qu-Prolog 9.0 and later versions
--------------------------------

	qp.pl

Know issues in Qu-Prolog 9.0: (1) this version doesn't support static
multifile predicates. This limitation may be fixed in later versions;
(2) a bug in the Windows version of Qu-Prolog in the expansion of file
paths containing environment variables prevents using it with Logtalk
in this operating-system.

Written and tested with the help of Peter Robinson.


Quintus Prolog 3.3~3.5
----------------------

	quintus.pl

Experimental. Quintus Prolog is still maintained but (apparently) no
longer developed and thus it lacks compliance with current official and
de facto standards. Notably, the `open/4` and `read_term/2-3` built-in
predicates use a different argument order and there are also significant
differences in arithmetic functions support. This adapter file copes with
some of these issues using the dialect-level goal-expansion mechanism.

The original version of this adapter file was written and tested with help
of a friend of mine, Paulo Urbano, for a previous version. Adopted for the
current release using version 3.5 for Windows for testing.


SICStus Prolog 4.1.0 and later versions
---------------------------------------

	sicstus.pl

Adapter file for SICStus Prolog. Use of the latest SICStus Prolog version
is recommended due to improved standards compliance. No problems expected.
Please report any problem found (with a solution if possible).


SWI-Prolog 6.6.0 and later versions
-----------------------------------

	swi.pl
	swihooks.pl

No problems expected. Please report any problem found (with a solution 
if possible).

To improve the integration between Logtalk and SWI-Prolog, the file
`swihooks.pl` allows loading of Logtalk source files using SWI-Prolog
`load_files/2` and `consult/1` predicates and adds support for the `edit/1`
and `make/0` predicates, the XPCE profiler, and the XPCE graphical tracer.
Note, however, that in the case of syntax errors in a Logtalk source file,
the `make/0` predicate will not detect the fixed file as no intermediate
Prolog file was generated in the first loading attempt (use instead the
`logtalk_make/0-1` predicates in this case).

The adapter file may set the `iso` SWI-Prolog flag to `true`. This setting
may improve compatibility of Logtalk code across different back-end 
Prolog compilers buy may also cause compatibility problems with some 
SWI-Prolog libraries. Comment out the corresponding `set_prolog_flag/2` 
directive if necessary.

For using XPCE from Logtalk, see the `xpce` example in the Logtalk
distribution.

With multi-threading support turned on, you may get an harmless message
when halting the system regarding threads that wouldn't die: you can 
suppress the message on POSIX systems by using `% swilgt 2> /dev/null`.

The definition of the predicate `{}/1` at the end of the adapter files
conflicts with e.g. the `clpq` and `clpr` SWI-Prolog constraint libraries.
The `{}/1` predicate is used in Logtalk as a shortcut to the `logtalk_load/1`
and  `logtalk_make/1` built-in predicates. Comment out the definition in the
adapter file if necessary. Note that Logtalk also defines a `{}/1` control
construct but this is only used within objects and categories.

Logtalk doesn't rely on the SWI-Prolog auto-loading mechanism for library
predicates. Calls of these predicates within objects and categories must
be explicitly qualified or implicit qualified by listing the predicates
in `use_module/2` directives). You may also set the Logtalk `portability`,
and `unknown_predicates` compiler flags to `warning` in order to detect
unqualified calls to library predicates. All the module libraries should
be loaded prior to compilation of object and categories containing calls
to the library predicates.

MacOS X users of the `SWI-Prolog.app` application, must add the definitions
for the `LOGTALKHOME` and `LOGTALKUSER` environment variables to their
`~/.plrc` or `~/.swiplrc` init file (as Mac OS X GUI applications *don't*
inherit shell environment variable values):

	:- setenv('LOGTALKHOME', ...).
	:- setenv('LOGTALKUSER', ...).

To load Logtalk *on-demand* when using the `SWI-Prolog.app` application, you
can use the goal:

	?- ['$LOGTALKHOME/integration/logtalk_swi.pl'].

In alternative, you can copy the `scripts/pack/logtalk/prolog/logtalk.pl`
file to the SWI-Prolog library directory and then use the query:

	?- use_module(library(logtalk)).

If you want to load automatically Logtalk at startup and be able to use it
with both the shell integration script and the Mac OS X GUI application, you
can add to the `~/.plrc` or `~/.swiplrc` init file the lines:

	:- if((current_prolog_flag(home,HOME), sub_atom(HOME,_,_,0,'SWI-Prolog.app/Contents/swipl'))).
		:- ['$LOGTALKHOME/integration/logtalk_swi.pl'].
	:- endif.

The Logtalk flag `prolog_compiler` is not usable due to lack of SWI-Prolog
built-in predicates for separate compilation and loading. To generate
`.qlf` files when compiling Logtalk source files, set the Logtalk `clean`
flag to `off` and add the option `qcompile(auto)` to the Logtalk flag
`prolog_loader`.

To use the SWI-Prolog graphical tracer for debugging Logtalk source code,
see the `settings-sample.lgt` file for the necessary settings. Note that
those settings result in large intermediate Prolog files as in addition
to the information collected for Logtalk own reflection features, all file
terms are decorated with additional source file location information for
integration with the SWI-Prolog own development tools.


XSB 3.5.0 and later versions
----------------------------

	xsb.pl

XSB generates intermediate files (with a `.xwam` extension) when compiling
Prolog source files (thus including the Logtalk core files). Thus, you
must either install Logtalk on on a location where you have write access
or perform the first run of the integration scripts from a user with the
required privileges (e.g. using `sudo` on POSIX systems or choosing `Run as
administrator` on Windows systems).

Due to the relative long release cycle of XSB, you may need to use its
development version if the recommended version is not yet available as
a stable release.

A know issue in XSB 3.5.0 is that this version doesn't support static
multifile predicates. This limitation may be fixed in later versions.

The definition of the `as` operator used in Logtalk when declaring predicate
(or non-terminal) aliases conflicts with the definition of this operator in
XSB due to the use of a different priority. XSB uses this operator within
`table/1` directives to represent tabling options. In practice there's only
a conflict when, in the same `table/1` directive, more than one predicate is
declared as tabled and/or when more than one tabling option is specified.
This cases are not common, however. The workaround is to use parenthesis
around the predicates and/or the tabling options.

To generate `.xwam` files from Logtalk source files, set the `prolog_compiler`
flag to the list of options that will be passed to the XSB `compile/2` built-in
predicate and use either the built-in predicates `logtalk_compile/1-2` or the
built-in predicates `logtalk_load/1-2` with the `clean` flag turned off.


YAP 6.3.4 and later versions
----------------------------

	yap.pl
	yaphooks.pl

The adapter file may set the flag `language` to `iso`, but that is only
recommended and should not be needed to run Logtalk as some of the YAP
libraries may not be compatible with this flag setting. Comment out the
corresponding `set_prolog_flag/2` directive if necessary.

The `yaphooks.pl` file defines YAP hook predicates for improving the
integration between Logtalk and YAP.

Note that YAP can be compiled with or without support for features like
tabling or threads.
