[![Logisim-evolution](img/logisim-evolution-logo.png)](https://github.com/logisim-evolution/logisim-evolution)

---

* [« Go back](developers.md)
* **Translations**
  * [Updating existing translation](#updating-existing-translation)
  * [Adding new translation](#adding-new-translation)
  * [Using trans-tool](#using-trans-tool)

---

# Updating existing translation #

In the path `src/main/resources/resources/logisim/` folder you will find the language directories (for example `en` for English,
`es` for Spanish, `pl` for Polish etc.). Inside these directories you will find the `*.properties` files that contain all the
application strings translated for specific language.

Each of these files contain content following `key = value` format, where the `key` is the string identifier used by the application
to obtain given string and therefore it **MUST** stay unaltered and the `value` is the text in the specific language. You can also
fine entry starting with `#` which indicates comment line (these, if found, should not be translated because it may be lost in
further automated processing anyway). You will however more often encounter lines like:

```ini
# ==> key =
```

or

```ini
# ==> key = English text
```

This line is automatically generated by `trans-tool` utility (see below) and it means that a language specific translation of `key`
available and that at runtime, `Logisim-evolution` takes the default (English) value for this key instead. Once you translate this
line, make sure you incomment it (by removing `# ==>`) too.

# Adding new translation #

To add new, non yet existing language version you will need to create `*.properties` files for your language but also add your
language code to `src/main/resources/resources/logisim/settings.properties`. Please create new ticket if you are willing to
contribute new language version but please ensure you got sufficient man-power to do that first, as there's a lot of text to
translate.

---

# Using trans-tool #

![Trans-tool logo](https://raw.githubusercontent.com/MarcinOrlowski/trans-tool/master/artwork/trans-tool-logo.png)

Quick guide on how to use [trans-tool](https://github.com/MarcinOrlowski/trans-tool) to check Logisim translations.

# Setup #

* `trans-tool` requires Python 3.6+ so you need to have it installed

# Installation #

I recommend using virtual environment to avoid installing anything globally:

```bash
$ python -m venv venv
```

Activate your environment in Bash compatible shell (if you are using different shell, i.e. Fish, check contents of `venv/bin/`
folder for alternative scripts):

```bash
$ source venv/bin/activate
```

Now, while in venv active, install the trans-tool:

```bash
$ pip install trans-tool
```

Now you should have `trans-tool` (and `transtool` too, same binary, just name alias) in your path. **Remember that you always need
go activate venv prior use in new session/terminal/after reboot/etc.**

Go to Logisim's source code root folder and create a small bash script (i.e. `scan.sh`) with this content:

```bash
#!/bin/bash
LANG="pl"
FILES=$(find src/* -name "*.properties" | grep -E '*/[a-zA-Z]+.properties$' | grep "src/main/resources/resources/logisim/strings/")
for f in $FILES; do
    trans-tool -l "${LANG}" -b "${f}"
read
done
```

**Replace `pl` value of `LANG` with code of your language!**

This script will look for `*.properties` files that contain no `_` in name (so all English base files) and run `trans-tool` to check
them AND language version of yours (if you do not like pause after each file, remove `read` from the script).

Make script executable:

```bash
$ chmod u+x scan.sh
```

and run

```bash
$ ./scan.sh
```

if you prefer working on single files untill you done, you can replace invocation of `trans-tool` with just `echo "${f}"` (and
remove `read`) so it will print all base files found. And the invoke `trans-tool` manually (where `-l` specifies your language code
and `-b` points to base file(s)):

```bash
$ trans-tool -l pl -b src/main/resources/resources/logisim/strings/soc/soc.properties

Base: src/main/resources/resources/logisim/strings/soc/soc.properties
  Errors: 1
    Brackets
      E: Line 163:90: "AssemblerRunSuccess": No opening character matching ")".
  PL: src/main/resources/resources/logisim/strings/soc/soc_pl.properties
    Errors: 3, warnings: 4
      Brackets
        E: Line 175:83: "AssemblerRunSuccess": No opening character matching ")".
      Formatting values
        E: Line 383:167: "PioMenuOutClearRemark": Expected "%s", found "%s.".
        E: Line 387:167: "PioMenuOutSetRemark": Expected "%s", found "%s.".
      Missing translations
        W: "ElfHeaderEIDataError": Missing translation.
        W: "AsmPanErrorCreateFile": Missing translation.
      Punctuation mismatch
        W: Line 12: "SocInsertTransWindowTitle": Ends with "y". Expected ":".
      First words case mismatch.
        W: Line 332: "Rv32imProgramCounter": Starts UPPER-cased, expected lower-case.
```

# Proofreading existing translations #

I often like to see original text when I proofread or translate, without need of switching editor view or anything,
therefore `trans-tool` have an option to rewrite existing translation file (or create new one) with original texts added as
comments. Let's say you want to work on your `pl` translation of
said `src/main/resources/resources/logisim/strings/soc/soc.properties` file. There's already a `soc_pl.properties` file in the same
folder as base one, so we need just update it:

```bash
$ trans-tool -l pl -b src/main/resources/resources/logisim/strings/soc/soc.properties -wr
```

the `-wr` is short form for `--write-ref` option.

If you have no translation file but would like from scratch, using `--write`, `--write-contents` or `--write-ref` options will
create template file for you:

```bash
$ trans-tool -l pl -b src/main/resources/resources/logisim/strings/soc/soc.properties --create -wr
```

# Notes #

Some issues `trans-tool` reports (even as errors) are still "false positives" as not all validators are perfectly tuned (or smart
enough yet), so feel free to consider program report as "improvement suggestions" and investigate the reported problems and judge
yourself you want to fix it or not. Feel free to suggest an [improvements](https://github.com/MarcinOrlowski/trans-tool/issues) to
default configuration tweaks.

# Issues #

* Please see [trans-tool](https://github.com/MarcinOrlowski/trans-tool) for detailed docs
* If you spot any issues with the tool, please [create a ticket](https://github.com/MarcinOrlowski/trans-tool/issues)
