/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import net.sf.log4jdbc.CallableStatementSpy;
import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.PreparedStatementSpy;
import net.sf.log4jdbc.RdbmsSpecifics;
import net.sf.log4jdbc.Spy;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;
import net.sf.log4jdbc.StatementSpy;

public class ConnectionSpy
implements Connection,
Spy {
    private Connection realConnection;
    private SpyLogDelegator log;
    private int connectionNumber;
    private static int lastConnectionNumber = 0;
    private static final Object connectionNumberLock = new Object();
    private RdbmsSpecifics rdbmsSpecifics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionSpy(Connection realConnection) {
        this.setRdbmsSpecifics(DriverSpy.defaultRdbmsSpecifics);
        if (realConnection == null) {
            throw new IllegalArgumentException("Must pass in a non null real Connection");
        }
        this.realConnection = realConnection;
        this.log = SpyLogFactory.getSpyLogDelegator();
        Object object = connectionNumberLock;
        synchronized (object) {
            this.connectionNumber = ++lastConnectionNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionSpy(Connection realConnection, RdbmsSpecifics rdbmsSpecifics) {
        this.setRdbmsSpecifics(rdbmsSpecifics);
        if (realConnection == null) {
            throw new IllegalArgumentException("Must pass in a non null real Connection");
        }
        this.realConnection = realConnection;
        this.log = SpyLogFactory.getSpyLogDelegator();
        Object object = connectionNumberLock;
        synchronized (object) {
            this.connectionNumber = ++lastConnectionNumber;
        }
    }

    void setRdbmsSpecifics(RdbmsSpecifics rdbmsSpecifics) {
        this.rdbmsSpecifics = rdbmsSpecifics;
    }

    RdbmsSpecifics getRdbmsSpecifics() {
        return this.rdbmsSpecifics;
    }

    @Override
    public int getConnectionNumber() {
        return this.connectionNumber;
    }

    @Override
    public String getClassType() {
        return "Connection";
    }

    protected void reportException(String methodCall, SQLException exception, String sql) {
        this.log.exceptionOccured(this, methodCall, exception, sql, -1L);
    }

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportAllReturns(String methodCall, String returnValue) {
        this.log.methodReturned(this, methodCall, returnValue);
    }

    private boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private Object reportReturn(String methodCall, Object value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.realConnection.isClosed());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return (SQLWarning)this.reportReturn(methodCall, this.realConnection.getWarnings());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String methodCall = "setSavepoint()";
        try {
            return (Savepoint)this.reportReturn(methodCall, this.realConnection.setSavepoint());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String methodCall = "releaseSavepoint(" + savepoint + ")";
        try {
            this.realConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String methodCall = "rollback(" + savepoint + ")";
        try {
            this.realConnection.rollback(savepoint);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return (DatabaseMetaData)this.reportReturn(methodCall, this.realConnection.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.realConnection.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Statement createStatement() throws SQLException {
        String methodCall = "createStatement()";
        try {
            Statement statement = this.realConnection.createStatement();
            return (Statement)this.reportReturn(methodCall, new StatementSpy(this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "createStatement(" + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            Statement statement = this.realConnection.createStatement(resultSetType, resultSetConcurrency);
            return (Statement)this.reportReturn(methodCall, new StatementSpy(this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            Statement statement = this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            return (Statement)this.reportReturn(methodCall, new StatementSpy(this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String methodCall = "setReadOnly(" + readOnly + ")";
        try {
            this.realConnection.setReadOnly(readOnly);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql);
            return (PreparedStatement)this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + autoGeneratedKeys + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, autoGeneratedKeys);
            return (PreparedStatement)this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return (PreparedStatement)this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return (PreparedStatement)this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + columnIndexes + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, columnIndexes);
            return (PreparedStatement)this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String methodCall = "setSavepoint(" + name + ")";
        try {
            return (Savepoint)this.reportReturn(methodCall, this.realConnection.setSavepoint(name));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + columnNames + ")";
        try {
            PreparedStatement statement = this.realConnection.prepareStatement(sql, columnNames);
            return (PreparedStatement)this.reportReturn(methodCall, new PreparedStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        String methodCall = "createClob()";
        try {
            return (Clob)this.reportReturn(methodCall, this.realConnection.createClob());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        String methodCall = "createBlob()";
        try {
            return (Blob)this.reportReturn(methodCall, this.realConnection.createBlob());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        String methodCall = "createNClob()";
        try {
            return (NClob)this.reportReturn(methodCall, this.realConnection.createNClob());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        String methodCall = "createSQLXML()";
        try {
            return (SQLXML)this.reportReturn(methodCall, this.realConnection.createSQLXML());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        String methodCall = "isValid(" + timeout + ")";
        try {
            return this.reportReturn(methodCall, this.realConnection.isValid(timeout));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String methodCall = "setClientInfo(" + name + ", " + value + ")";
        try {
            this.realConnection.setClientInfo(name, value);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        String methodCall = "setClientInfo(" + properties + ")";
        try {
            this.realConnection.setClientInfo(properties);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String methodCall = "getClientInfo(" + name + ")";
        try {
            return (String)this.reportReturn(methodCall, this.realConnection.getClientInfo(name));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        String methodCall = "getClientInfo()";
        try {
            return (Properties)this.reportReturn(methodCall, this.realConnection.getClientInfo());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        String methodCall = "createArrayOf(" + typeName + ", " + elements + ")";
        try {
            return (Array)this.reportReturn(methodCall, this.realConnection.createArrayOf(typeName, elements));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        String methodCall = "createStruct(" + typeName + ", " + attributes + ")";
        try {
            return (Struct)this.reportReturn(methodCall, this.realConnection.createStruct(typeName, attributes));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String methodCall = "isReadOnly()";
        try {
            return this.reportReturn(methodCall, this.realConnection.isReadOnly());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        String methodCall = "setHoldability(" + holdability + ")";
        try {
            this.realConnection.setHoldability(holdability);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String methodCall = "prepareCall(" + sql + ")";
        try {
            CallableStatement statement = this.realConnection.prepareCall(sql);
            return (CallableStatement)this.reportReturn(methodCall, new CallableStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            CallableStatement statement = this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
            return (CallableStatement)this.reportReturn(methodCall, new CallableStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            CallableStatement statement = this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return (CallableStatement)this.reportReturn(methodCall, new CallableStatementSpy(sql, this, statement));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String methodCall = "setCatalog(" + catalog + ")";
        try {
            this.realConnection.setCatalog(catalog);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String methodCall = "nativeSQL(" + sql + ")";
        try {
            return (String)this.reportReturn(methodCall, this.realConnection.nativeSQL(sql));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        String methodCall = "getTypeMap()";
        try {
            return (Map)this.reportReturn(methodCall, this.realConnection.getTypeMap());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String methodCall = "setAutoCommit(" + autoCommit + ")";
        try {
            this.realConnection.setAutoCommit(autoCommit);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getCatalog() throws SQLException {
        String methodCall = "getCatalog()";
        try {
            return (String)this.reportReturn(methodCall, this.realConnection.getCatalog());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        String methodCall = "setTypeMap(" + map + ")";
        try {
            this.realConnection.setTypeMap(map);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String methodCall = "setTransactionIsolation(" + level + ")";
        try {
            this.realConnection.setTransactionIsolation(level);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        String methodCall = "getAutoCommit()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getAutoCommit());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodCall = "getHoldability()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getHoldability());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        String methodCall = "getTransactionIsolation()";
        try {
            return this.reportReturn(methodCall, this.realConnection.getTransactionIsolation());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void commit() throws SQLException {
        String methodCall = "commit()";
        try {
            this.realConnection.commit();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void rollback() throws SQLException {
        String methodCall = "rollback()";
        try {
            this.realConnection.rollback();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.realConnection.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == Connection.class || iface == Spy.class) ? this : this.realConnection.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == Connection.class || iface == Spy.class) || this.realConnection.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

