/*
 * Copyright (C) 2019 Emeric Poupon
 *
 * This file is part of LMS.
 *
 * LMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LMS.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "FeaturesDefs.hpp"

#include <algorithm>
#include <iterator>

#include "core/Exception.hpp"

namespace lms::recommendation
{

    static const std::unordered_map<FeatureName, FeatureDef> featureDefinitions{
        { "lowlevel.average_loudness", { 1 } },
        { "lowlevel.barkbands.dmean", { 27 } },
        { "lowlevel.barkbands.dmean2", { 27 } },
        { "lowlevel.barkbands.dvar", { 27 } },
        { "lowlevel.barkbands.dvar2", { 27 } },
        { "lowlevel.barkbands.max", { 27 } },
        { "lowlevel.barkbands.mean", { 27 } },
        { "lowlevel.barkbands.median", { 27 } },
        { "lowlevel.barkbands.min", { 27 } },
        { "lowlevel.barkbands.var", { 27 } },
        { "lowlevel.barkbands_crest.dmean", { 1 } },
        { "lowlevel.barkbands_crest.dmean2", { 1 } },
        { "lowlevel.barkbands_crest.dvar", { 1 } },
        { "lowlevel.barkbands_crest.dvar2", { 1 } },
        { "lowlevel.barkbands_crest.max", { 1 } },
        { "lowlevel.barkbands_crest.mean", { 1 } },
        { "lowlevel.barkbands_crest.median", { 1 } },
        { "lowlevel.barkbands_crest.min", { 1 } },
        { "lowlevel.barkbands_crest.var", { 1 } },
        { "lowlevel.barkbands_flatness_db.dmean", { 1 } },
        { "lowlevel.barkbands_flatness_db.dmean2", { 1 } },
        { "lowlevel.barkbands_flatness_db.dvar", { 1 } },
        { "lowlevel.barkbands_flatness_db.dvar2", { 1 } },
        { "lowlevel.barkbands_flatness_db.max", { 1 } },
        { "lowlevel.barkbands_flatness_db.mean", { 1 } },
        { "lowlevel.barkbands_flatness_db.median", { 1 } },
        { "lowlevel.barkbands_flatness_db.min", { 1 } },
        { "lowlevel.barkbands_flatness_db.var", { 1 } },
        { "lowlevel.barkbands_kurtosis.dmean", { 1 } },
        { "lowlevel.barkbands_kurtosis.dmean2", { 1 } },
        { "lowlevel.barkbands_kurtosis.dvar", { 1 } },
        { "lowlevel.barkbands_kurtosis.dvar2", { 1 } },
        { "lowlevel.barkbands_kurtosis.max", { 1 } },
        { "lowlevel.barkbands_kurtosis.mean", { 1 } },
        { "lowlevel.barkbands_kurtosis.median", { 1 } },
        { "lowlevel.barkbands_kurtosis.min", { 1 } },
        { "lowlevel.barkbands_kurtosis.var", { 1 } },
        { "lowlevel.barkbands_skewness.dmean", { 1 } },
        { "lowlevel.barkbands_skewness.dmean2", { 1 } },
        { "lowlevel.barkbands_skewness.dvar", { 1 } },
        { "lowlevel.barkbands_skewness.dvar2", { 1 } },
        { "lowlevel.barkbands_skewness.max", { 1 } },
        { "lowlevel.barkbands_skewness.mean", { 1 } },
        { "lowlevel.barkbands_skewness.median", { 1 } },
        { "lowlevel.barkbands_skewness.min", { 1 } },
        { "lowlevel.barkbands_skewness.var", { 1 } },
        { "lowlevel.barkbands_spread.dmean", { 1 } },
        { "lowlevel.barkbands_spread.dmean2", { 1 } },
        { "lowlevel.barkbands_spread.dvar", { 1 } },
        { "lowlevel.barkbands_spread.dvar2", { 1 } },
        { "lowlevel.barkbands_spread.max", { 1 } },
        { "lowlevel.barkbands_spread.mean", { 1 } },
        { "lowlevel.barkbands_spread.median", { 1 } },
        { "lowlevel.barkbands_spread.min", { 1 } },
        { "lowlevel.barkbands_spread.var", { 1 } },
        { "lowlevel.dissonance.dmean", { 1 } },
        { "lowlevel.dissonance.dmean2", { 1 } },
        { "lowlevel.dissonance.dvar", { 1 } },
        { "lowlevel.dissonance.dvar2", { 1 } },
        { "lowlevel.dissonance.max", { 1 } },
        { "lowlevel.dissonance.mean", { 1 } },
        { "lowlevel.dissonance.median", { 1 } },
        { "lowlevel.dissonance.min", { 1 } },
        { "lowlevel.dissonance.var", { 1 } },
        { "lowlevel.dynamic_complexity", { 1 } },
        { "lowlevel.erbbands.dmean", { 40 } },
        { "lowlevel.erbbands.dmean2", { 40 } },
        { "lowlevel.erbbands.dvar", { 40 } },
        { "lowlevel.erbbands.dvar2", { 40 } },
        { "lowlevel.erbbands.max", { 40 } },
        { "lowlevel.erbbands.mean", { 40 } },
        { "lowlevel.erbbands.median", { 40 } },
        { "lowlevel.erbbands.min", { 40 } },
        { "lowlevel.erbbands.var", { 40 } },
        { "lowlevel.gfcc.mean", { 13 } },
        { "lowlevel.hfc.dmean", { 1 } },
        { "lowlevel.hfc.dmean2", { 1 } },
        { "lowlevel.hfc.dvar", { 1 } },
        { "lowlevel.hfc.dvar2", { 1 } },
        { "lowlevel.hfc.max", { 1 } },
        { "lowlevel.hfc.mean", { 1 } },
        { "lowlevel.hfc.median", { 1 } },
        { "lowlevel.hfc.min", { 1 } },
        { "lowlevel.hfc.var", { 1 } },
        { "tonal.hpcp.median", { 36 } },
        { "lowlevel.melbands.dmean", { 40 } },
        { "lowlevel.melbands.dmean2", { 40 } },
        { "lowlevel.melbands.dvar", { 40 } },
        { "lowlevel.melbands.dvar2", { 40 } },
        { "lowlevel.melbands.max", { 40 } },
        { "lowlevel.melbands.mean", { 40 } },
        { "lowlevel.melbands.median", { 40 } },
        { "lowlevel.melbands.min", { 40 } },
        { "lowlevel.melbands.var", { 40 } },
        { "lowlevel.melbands_crest.dmean", { 1 } },
        { "lowlevel.melbands_crest.dmean2", { 1 } },
        { "lowlevel.melbands_crest.dvar", { 1 } },
        { "lowlevel.melbands_crest.dvar2", { 1 } },
        { "lowlevel.melbands_crest.max", { 1 } },
        { "lowlevel.melbands_crest.mean", { 1 } },
        { "lowlevel.melbands_crest.median", { 1 } },
        { "lowlevel.melbands_crest.min", { 1 } },
        { "lowlevel.melbands_crest.var", { 1 } },
        { "lowlevel.melbands_flatness_db.dmean", { 1 } },
        { "lowlevel.melbands_flatness_db.dmean2", { 1 } },
        { "lowlevel.melbands_flatness_db.dvar", { 1 } },
        { "lowlevel.melbands_flatness_db.dvar2", { 1 } },
        { "lowlevel.melbands_flatness_db.max", { 1 } },
        { "lowlevel.melbands_flatness_db.mean", { 1 } },
        { "lowlevel.melbands_flatness_db.median", { 1 } },
        { "lowlevel.melbands_flatness_db.min", { 1 } },
        { "lowlevel.melbands_flatness_db.var", { 1 } },
        { "lowlevel.melbands_kurtosis.dmean", { 1 } },
        { "lowlevel.melbands_kurtosis.dmean2", { 1 } },
        { "lowlevel.melbands_kurtosis.dvar", { 1 } },
        { "lowlevel.melbands_kurtosis.dvar2", { 1 } },
        { "lowlevel.melbands_kurtosis.max", { 1 } },
        { "lowlevel.melbands_kurtosis.mean", { 1 } },
        { "lowlevel.melbands_kurtosis.median", { 1 } },
        { "lowlevel.melbands_kurtosis.min", { 1 } },
        { "lowlevel.melbands_kurtosis.var", { 1 } },
        { "lowlevel.melbands_skewness.dmean", { 1 } },
        { "lowlevel.melbands_skewness.dmean2", { 1 } },
        { "lowlevel.melbands_skewness.dvar", { 1 } },
        { "lowlevel.melbands_skewness.dvar2", { 1 } },
        { "lowlevel.melbands_skewness.max", { 1 } },
        { "lowlevel.melbands_skewness.mean", { 1 } },
        { "lowlevel.melbands_skewness.median", { 1 } },
        { "lowlevel.melbands_skewness.min", { 1 } },
        { "lowlevel.melbands_skewness.var", { 1 } },
        { "lowlevel.melbands_spread.dmean", { 1 } },
        { "lowlevel.melbands_spread.dmean2", { 1 } },
        { "lowlevel.melbands_spread.dvar", { 1 } },
        { "lowlevel.melbands_spread.dvar2", { 1 } },
        { "lowlevel.melbands_spread.max", { 1 } },
        { "lowlevel.melbands_spread.mean", { 1 } },
        { "lowlevel.melbands_spread.median", { 1 } },
        { "lowlevel.melbands_spread.min", { 1 } },
        { "lowlevel.melbands_spread.var", { 1 } },
        { "lowlevel.mfcc.mean", { 13 } },
        { "lowlevel.pitch_salience.dmean", { 1 } },
        { "lowlevel.pitch_salience.dmean2", { 1 } },
        { "lowlevel.pitch_salience.dvar", { 1 } },
        { "lowlevel.pitch_salience.dvar2", { 1 } },
        { "lowlevel.pitch_salience.max", { 1 } },
        { "lowlevel.pitch_salience.mean", { 1 } },
        { "lowlevel.pitch_salience.median", { 1 } },
        { "lowlevel.pitch_salience.min", { 1 } },
        { "lowlevel.pitch_salience.var", { 1 } },
        { "lowlevel.silence_rate_30dB.dmean", { 1 } },
        { "lowlevel.silence_rate_30dB.dmean2", { 1 } },
        { "lowlevel.silence_rate_30dB.dvar", { 1 } },
        { "lowlevel.silence_rate_30dB.dvar2", { 1 } },
        { "lowlevel.silence_rate_30dB.max", { 1 } },
        { "lowlevel.silence_rate_30dB.mean", { 1 } },
        { "lowlevel.silence_rate_30dB.median", { 1 } },
        { "lowlevel.silence_rate_30dB.min", { 1 } },
        { "lowlevel.silence_rate_30dB.var", { 1 } },
        { "lowlevel.silence_rate_60dB.dmean", { 1 } },
        { "lowlevel.silence_rate_60dB.dmean2", { 1 } },
        { "lowlevel.silence_rate_60dB.dvar", { 1 } },
        { "lowlevel.silence_rate_60dB.dvar2", { 1 } },
        { "lowlevel.silence_rate_60dB.max", { 1 } },
        { "lowlevel.silence_rate_60dB.mean", { 1 } },
        { "lowlevel.silence_rate_60dB.median", { 1 } },
        { "lowlevel.silence_rate_60dB.min", { 1 } },
        { "lowlevel.silence_rate_60dB.var", { 1 } },
        { "lowlevel.spectral_centroid.dmean", { 1 } },
        { "lowlevel.spectral_centroid.dmean2", { 1 } },
        { "lowlevel.spectral_centroid.dvar", { 1 } },
        { "lowlevel.spectral_centroid.dvar2", { 1 } },
        { "lowlevel.spectral_centroid.max", { 1 } },
        { "lowlevel.spectral_centroid.mean", { 1 } },
        { "lowlevel.spectral_centroid.median", { 1 } },
        { "lowlevel.spectral_centroid.min", { 1 } },
        { "lowlevel.spectral_centroid.var", { 1 } },
        { "lowlevel.spectral_complexity.dmean", { 1 } },
        { "lowlevel.spectral_complexity.dmean2", { 1 } },
        { "lowlevel.spectral_complexity.dvar", { 1 } },
        { "lowlevel.spectral_complexity.dvar2", { 1 } },
        { "lowlevel.spectral_complexity.max", { 1 } },
        { "lowlevel.spectral_complexity.mean", { 1 } },
        { "lowlevel.spectral_complexity.median", { 1 } },
        { "lowlevel.spectral_complexity.min", { 1 } },
        { "lowlevel.spectral_complexity.var", { 1 } },
        { "lowlevel.spectral_contrast_coeffs.dmean", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.dmean2", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.dvar", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.dvar2", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.max", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.mean", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.median", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.min", { 6 } },
        { "lowlevel.spectral_contrast_coeffs.var", { 6 } },
        { "lowlevel.spectral_contrast_valleys.dmean", { 6 } },
        { "lowlevel.spectral_contrast_valleys.dmean2", { 6 } },
        { "lowlevel.spectral_contrast_valleys.dvar", { 6 } },
        { "lowlevel.spectral_contrast_valleys.dvar2", { 6 } },
        { "lowlevel.spectral_contrast_valleys.max", { 6 } },
        { "lowlevel.spectral_contrast_valleys.mean", { 6 } },
        { "lowlevel.spectral_contrast_valleys.median", { 6 } },
        { "lowlevel.spectral_contrast_valleys.min", { 6 } },
        { "lowlevel.spectral_contrast_valleys.var", { 6 } },
        { "lowlevel.spectral_decrease.dmean", { 1 } },
        { "lowlevel.spectral_decrease.dmean2", { 1 } },
        { "lowlevel.spectral_decrease.dvar", { 1 } },
        { "lowlevel.spectral_decrease.dvar2", { 1 } },
        { "lowlevel.spectral_decrease.max", { 1 } },
        { "lowlevel.spectral_decrease.mean", { 1 } },
        { "lowlevel.spectral_decrease.median", { 1 } },
        { "lowlevel.spectral_decrease.min", { 1 } },
        { "lowlevel.spectral_decrease.var", { 1 } },
        { "lowlevel.spectral_energy.dmean", { 1 } },
        { "lowlevel.spectral_energy.dmean2", { 1 } },
        { "lowlevel.spectral_energy.dvar", { 1 } },
        { "lowlevel.spectral_energy.dvar2", { 1 } },
        { "lowlevel.spectral_energy.max", { 1 } },
        { "lowlevel.spectral_energy.mean", { 1 } },
        { "lowlevel.spectral_energy.median", { 1 } },
        { "lowlevel.spectral_energy.min", { 1 } },
        { "lowlevel.spectral_energy.var", { 1 } },
        { "lowlevel.spectral_energyband_high.dmean", { 1 } },
        { "lowlevel.spectral_energyband_high.dmean2", { 1 } },
        { "lowlevel.spectral_energyband_high.dvar", { 1 } },
        { "lowlevel.spectral_energyband_high.dvar2", { 1 } },
        { "lowlevel.spectral_energyband_high.max", { 1 } },
        { "lowlevel.spectral_energyband_high.mean", { 1 } },
        { "lowlevel.spectral_energyband_high.median", { 1 } },
        { "lowlevel.spectral_energyband_high.min", { 1 } },
        { "lowlevel.spectral_energyband_high.var", { 1 } },
        { "lowlevel.spectral_energyband_low.dmean", { 1 } },
        { "lowlevel.spectral_energyband_low.dmean2", { 1 } },
        { "lowlevel.spectral_energyband_low.dvar", { 1 } },
        { "lowlevel.spectral_energyband_low.dvar2", { 1 } },
        { "lowlevel.spectral_energyband_low.max", { 1 } },
        { "lowlevel.spectral_energyband_low.mean", { 1 } },
        { "lowlevel.spectral_energyband_low.median", { 1 } },
        { "lowlevel.spectral_energyband_low.min", { 1 } },
        { "lowlevel.spectral_energyband_low.var", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.dmean", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.dmean2", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.dvar", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.dvar2", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.max", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.mean", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.median", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.min", { 1 } },
        { "lowlevel.spectral_energyband_middle_high.var", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.dmean", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.dmean2", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.dvar", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.dvar2", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.max", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.mean", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.median", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.min", { 1 } },
        { "lowlevel.spectral_energyband_middle_low.var", { 1 } },
        { "lowlevel.spectral_entropy.dmean", { 1 } },
        { "lowlevel.spectral_entropy.dmean2", { 1 } },
        { "lowlevel.spectral_entropy.dvar", { 1 } },
        { "lowlevel.spectral_entropy.dvar2", { 1 } },
        { "lowlevel.spectral_entropy.max", { 1 } },
        { "lowlevel.spectral_entropy.mean", { 1 } },
        { "lowlevel.spectral_entropy.median", { 1 } },
        { "lowlevel.spectral_entropy.min", { 1 } },
        { "lowlevel.spectral_entropy.var", { 1 } },
        { "lowlevel.spectral_flux.dmean", { 1 } },
        { "lowlevel.spectral_flux.dmean2", { 1 } },
        { "lowlevel.spectral_flux.dvar", { 1 } },
        { "lowlevel.spectral_flux.dvar2", { 1 } },
        { "lowlevel.spectral_flux.max", { 1 } },
        { "lowlevel.spectral_flux.mean", { 1 } },
        { "lowlevel.spectral_flux.median", { 1 } },
        { "lowlevel.spectral_flux.min", { 1 } },
        { "lowlevel.spectral_flux.var", { 1 } },
        { "lowlevel.spectral_kurtosis.dmean", { 1 } },
        { "lowlevel.spectral_kurtosis.dmean2", { 1 } },
        { "lowlevel.spectral_kurtosis.dvar", { 1 } },
        { "lowlevel.spectral_kurtosis.dvar2", { 1 } },
        { "lowlevel.spectral_kurtosis.max", { 1 } },
        { "lowlevel.spectral_kurtosis.mean", { 1 } },
        { "lowlevel.spectral_kurtosis.median", { 1 } },
        { "lowlevel.spectral_kurtosis.min", { 1 } },
        { "lowlevel.spectral_kurtosis.var", { 1 } },
        { "lowlevel.spectral_rms.dmean", { 1 } },
        { "lowlevel.spectral_rms.dmean2", { 1 } },
        { "lowlevel.spectral_rms.dvar", { 1 } },
        { "lowlevel.spectral_rms.dvar2", { 1 } },
        { "lowlevel.spectral_rms.max", { 1 } },
        { "lowlevel.spectral_rms.mean", { 1 } },
        { "lowlevel.spectral_rms.median", { 1 } },
        { "lowlevel.spectral_rms.min", { 1 } },
        { "lowlevel.spectral_rms.var", { 1 } },
        { "lowlevel.spectral_rolloff.dmean", { 1 } },
        { "lowlevel.spectral_rolloff.dmean2", { 1 } },
        { "lowlevel.spectral_rolloff.dvar", { 1 } },
        { "lowlevel.spectral_rolloff.dvar2", { 1 } },
        { "lowlevel.spectral_rolloff.max", { 1 } },
        { "lowlevel.spectral_rolloff.mean", { 1 } },
        { "lowlevel.spectral_rolloff.median", { 1 } },
        { "lowlevel.spectral_rolloff.min", { 1 } },
        { "lowlevel.spectral_rolloff.var", { 1 } },
        { "lowlevel.spectral_skewness.dmean", { 1 } },
        { "lowlevel.spectral_skewness.dmean2", { 1 } },
        { "lowlevel.spectral_skewness.dvar", { 1 } },
        { "lowlevel.spectral_skewness.dvar2", { 1 } },
        { "lowlevel.spectral_skewness.max", { 1 } },
        { "lowlevel.spectral_skewness.mean", { 1 } },
        { "lowlevel.spectral_skewness.median", { 1 } },
        { "lowlevel.spectral_skewness.min", { 1 } },
        { "lowlevel.spectral_skewness.var", { 1 } },
        { "lowlevel.spectral_spread.dmean", { 1 } },
        { "lowlevel.spectral_spread.dmean2", { 1 } },
        { "lowlevel.spectral_spread.dvar", { 1 } },
        { "lowlevel.spectral_spread.dvar2", { 1 } },
        { "lowlevel.spectral_spread.max", { 1 } },
        { "lowlevel.spectral_spread.mean", { 1 } },
        { "lowlevel.spectral_spread.median", { 1 } },
        { "lowlevel.spectral_spread.min", { 1 } },
        { "lowlevel.spectral_spread.var", { 1 } },
        { "lowlevel.spectral_strongpeak.dmean", { 1 } },
        { "lowlevel.spectral_strongpeak.dmean2", { 1 } },
        { "lowlevel.spectral_strongpeak.dvar", { 1 } },
        { "lowlevel.spectral_strongpeak.dvar2", { 1 } },
        { "lowlevel.spectral_strongpeak.max", { 1 } },
        { "lowlevel.spectral_strongpeak.mean", { 1 } },
        { "lowlevel.spectral_strongpeak.median", { 1 } },
        { "lowlevel.spectral_strongpeak.min", { 1 } },
        { "lowlevel.spectral_strongpeak.var", { 1 } },
        { "lowlevel.zerocrossingrate.dmean", { 1 } },
        { "lowlevel.zerocrossingrate.dmean2", { 1 } },
        { "lowlevel.zerocrossingrate.dvar", { 1 } },
        { "lowlevel.zerocrossingrate.dvar2", { 1 } },
        { "lowlevel.zerocrossingrate.max", { 1 } },
        { "lowlevel.zerocrossingrate.mean", { 1 } },
        { "lowlevel.zerocrossingrate.median", { 1 } },
        { "lowlevel.zerocrossingrate.min", { 1 } },
        { "lowlevel.zerocrossingrate.var", { 1 } },
    };

    FeatureDef getFeatureDef(const FeatureName& featureName)
    {
        auto it{ featureDefinitions.find(featureName) };
        if (it == std::cend(featureDefinitions))
            throw core::LmsException{ "Unhandled requested feature '" + featureName + "'" };

        return it->second;
    }

    FeatureNames getFeatureNames()
    {
        FeatureNames res;

        std::transform(std::cbegin(featureDefinitions), std::cend(featureDefinitions),
            std::inserter(res, std::begin(res)), [](auto itFeature) { return itFeature.first; });

        return res;
    }

} // namespace lms::recommendation
