/*
 * Copyright (C) 2022 Emeric Poupon
 *
 * This file is part of LMS.
 *
 * LMS is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LMS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LMS.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <string_view>

#include "ListenTypes.hpp"

namespace lms::scrobbling::listenBrainz
{
    class ListensParser
    {
    public:
        struct Result
        {
            std::size_t listenCount{};   // may be > than listens.size()
            std::vector<Listen> listens; // successfully parsed listens
        };

        static Result parse(std::string_view msgBody);
    };
} // namespace lms::scrobbling::listenBrainz
