; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL

;
; Truncate
;

define i1 @trunc_v2i64_v2i1(<2 x i64>) {
; SSE-LABEL: trunc_v2i64_v2i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psllq $63, %xmm0
; SSE-NEXT:    movmskpd %xmm0, %eax
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_v2i64_v2i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX-NEXT:    vmovmskpd %xmm0, %eax
; AVX-NEXT:    testb %al, %al
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $3, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v2i64_v2i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $3, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v2i64_v2i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $63, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmq %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <2 x i64> %0 to <2 x i1>
  %b = call i1 @llvm.vector.reduce.or.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v4i32_v4i1(<4 x i32>) {
; SSE-LABEL: trunc_v4i32_v4i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $31, %xmm0
; SSE-NEXT:    movmskps %xmm0, %eax
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_v4i32_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX-NEXT:    vmovmskps %xmm0, %eax
; AVX-NEXT:    testb %al, %al
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v4i32_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v4i32_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <4 x i32> %0 to <4 x i1>
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i16_v8i1(<8 x i8>) {
; SSE2-LABEL: trunc_v8i16_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psllw $15, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i16_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    psllw $15, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: trunc_v8i16_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX-NEXT:    vpsllw $15, %xmm0, %xmm0
; AVX-NEXT:    vpmovmskb %xmm0, %eax
; AVX-NEXT:    testl $43690, %eax # imm = 0xAAAA
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: trunc_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v8i16_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512BW-NEXT:    vpmovb2m %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v8i16_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovb2m %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i8> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i8_v16i1(<16 x i8>) {
; SSE-LABEL: trunc_v16i8_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX-LABEL: trunc_v16i8_v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX-NEXT:    vpmovmskb %xmm0, %eax
; AVX-NEXT:    testw %ax, %ax
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i8_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512-NEXT:    vpmovmskb %xmm0, %eax
; AVX512-NEXT:    testw %ax, %ax
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    retq
  %a = trunc <16 x i8> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v4i64_v4i1(<4 x i64>) {
; SSE-LABEL: trunc_v4i64_v4i1:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE-NEXT:    pslld $31, %xmm0
; SSE-NEXT:    movmskps %xmm0, %eax
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vmovmskps %xmm0, %eax
; AVX1-NEXT:    testb %al, %al
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq $63, %ymm0, %ymm0
; AVX2-NEXT:    vmovmskpd %ymm0, %eax
; AVX2-NEXT:    testb %al, %al
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v4i64_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllq $63, %ymm0, %ymm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v4i64_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllq $63, %ymm0, %ymm0
; AVX512BW-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v4i64_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $63, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmq %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <4 x i64> %0 to <4 x i1>
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i32_v8i1(<8 x i32>) {
; SSE2-LABEL: trunc_v8i32_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $16, %xmm1
; SSE2-NEXT:    psrad $16, %xmm1
; SSE2-NEXT:    pslld $16, %xmm0
; SSE2-NEXT:    psrad $16, %xmm0
; SSE2-NEXT:    packssdw %xmm1, %xmm0
; SSE2-NEXT:    psllw $15, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i32_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3],xmm1[4],xmm2[5],xmm1[6],xmm2[7]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3],xmm0[4],xmm2[5],xmm0[6],xmm2[7]
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    psllw $15, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovmskps %ymm0, %eax
; AVX1-NEXT:    testb %al, %al
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vmovmskps %ymm0, %eax
; AVX2-NEXT:    testb %al, %al
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v8i32_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v8i32_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512BW-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v8i32_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i32> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i16_v16i1(<16 x i16>) {
; SSE-LABEL: trunc_v16i16_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpmovmskb %xmm0, %eax
; AVX2-NEXT:    testw %ax, %ax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v16i16_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v16i16_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $15, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovw2m %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v16i16_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $15, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovw2m %ymm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <16 x i16> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v32i8_v32i1(<32 x i8>) {
; SSE-LABEL: trunc_v32i8_v32i1:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v32i8_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v32i8_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovmskb %ymm0, %eax
; AVX512BW-NEXT:    testl %eax, %eax
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v32i8_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovmskb %ymm0, %eax
; AVX512VL-NEXT:    testl %eax, %eax
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <32 x i8> %0 to <32 x i1>
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i64_v8i1(<8 x i64>) {
; SSE2-LABEL: trunc_v8i64_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm3[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,0,2,4,5,6,7]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = xmm0[0],xmm2[1]
; SSE2-NEXT:    psllw $15, %xmm2
; SSE2-NEXT:    pmovmskb %xmm2, %eax
; SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0],xmm4[1,2,3],xmm3[4],xmm4[5,6,7]
; SSE41-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0],xmm4[1,2,3],xmm2[4],xmm4[5,6,7]
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0],xmm4[1,2,3],xmm1[4],xmm4[5,6,7]
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0],xmm4[1,2,3],xmm0[4],xmm4[5,6,7]
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packusdw %xmm2, %xmm0
; SSE41-NEXT:    psllw $15, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,2],xmm2[0,2]
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,2],xmm2[0,2]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovmskps %ymm0, %eax
; AVX1-NEXT:    testb %al, %al
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm2[0,2],ymm0[4,6],ymm2[4,6]
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vmovmskps %ymm0, %eax
; AVX2-NEXT:    testb %al, %al
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v8i64_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v8i64_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512BW-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v8i64_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512VL-NEXT:    vptestmq %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i64> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i32_v16i1(<16 x i32>) {
; SSE2-LABEL: trunc_v16i32_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    packuswb %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    packuswb %xmm1, %xmm0
; SSE2-NEXT:    packuswb %xmm2, %xmm0
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testw %ax, %ax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v16i32_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0]
; SSE41-NEXT:    pand %xmm4, %xmm3
; SSE41-NEXT:    pand %xmm4, %xmm2
; SSE41-NEXT:    packusdw %xmm3, %xmm2
; SSE41-NEXT:    pand %xmm4, %xmm1
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    packusdw %xmm1, %xmm0
; SSE41-NEXT:    packuswb %xmm2, %xmm0
; SSE41-NEXT:    psllw $7, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testw %ax, %ax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vandps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpmovmskb %xmm0, %eax
; AVX2-NEXT:    testw %ax, %ax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <16 x i32> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v32i16_v32i1(<32 x i16>) {
; SSE-LABEL: trunc_v32i16_v32i1:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    packuswb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    packuswb %xmm1, %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vandps {{.*}}(%rip), %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpackuswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastw {{.*#+}} ymm2 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v32i16_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v32i16_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $15, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovw2m %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v32i16_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $15, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovw2m %zmm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <32 x i16> %0 to <32 x i1>
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v64i8_v64i1(<64 x i8>) {
; SSE-LABEL: trunc_v64i8_v64i1:
; SSE:       # %bb.0:
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    psllw $7, %xmm1
; SSE-NEXT:    pmovmskb %xmm1, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: trunc_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vorps %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v64i8_v64i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX512F-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512F-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v64i8_v64i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovb2m %zmm0, %k0
; AVX512BW-NEXT:    kortestq %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v64i8_v64i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovb2m %zmm0, %k0
; AVX512VL-NEXT:    kortestq %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <64 x i8> %0 to <64 x i1>
  %b = call i1 @llvm.vector.reduce.or.v64i1(<64 x i1> %a)
  ret i1 %b
}

;
; Comparison
;

define i1 @icmp_v2i64_v2i1(<2 x i64>) {
; SSE2-LABEL: icmp_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    movmskpd %xmm0, %eax
; SSE2-NEXT:    testb %al, %al
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm0, %xmm1
; SSE41-NEXT:    movmskpd %xmm1, %eax
; SSE41-NEXT:    testb %al, %al
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp_v2i64_v2i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovmskpd %xmm0, %eax
; AVX-NEXT:    testb %al, %al
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: icmp_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $3, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v2i64_v2i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $3, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v2i64_v2i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmq %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <2 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v4i32_v4i1(<4 x i32>) {
; SSE-LABEL: icmp_v4i32_v4i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    movmskps %xmm1, %eax
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX-LABEL: icmp_v4i32_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovmskps %xmm0, %eax
; AVX-NEXT:    testb %al, %al
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: icmp_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v4i32_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v4i32_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmd %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <4 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i16_v8i1(<8 x i8>) {
; SSE-LABEL: icmp_v8i16_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE-NEXT:    pmovmskb %xmm1, %eax
; SSE-NEXT:    testb %al, %al
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX-LABEL: icmp_v8i16_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmovmskb %xmm0, %eax
; AVX-NEXT:    testb %al, %al
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: icmp_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v8i16_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v8i16_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i8_v16i1(<16 x i8>) {
; SSE-LABEL: icmp_v16i8_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE-NEXT:    pmovmskb %xmm1, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX-LABEL: icmp_v16i8_v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmovmskb %xmm0, %eax
; AVX-NEXT:    testw %ax, %ax
; AVX-NEXT:    setne %al
; AVX-NEXT:    retq
;
; AVX512F-LABEL: icmp_v16i8_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovmskb %xmm0, %eax
; AVX512F-NEXT:    testw %ax, %ax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v16i8_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v16i8_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <16 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v4i64_v4i1(<4 x i64>) {
; SSE2-LABEL: icmp_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    packssdw %xmm3, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    testb %al, %al
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE41-NEXT:    packssdw %xmm1, %xmm0
; SSE41-NEXT:    movmskps %xmm0, %eax
; SSE41-NEXT:    testb %al, %al
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovmskpd %ymm0, %eax
; AVX1-NEXT:    testb %al, %al
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovmskpd %ymm0, %eax
; AVX2-NEXT:    testb %al, %al
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v4i64_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v4i64_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v4i64_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmq %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <4 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i32_v8i1(<8 x i32>) {
; SSE-LABEL: icmp_v8i32_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovmskps %ymm0, %eax
; AVX1-NEXT:    testb %al, %al
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovmskps %ymm0, %eax
; AVX2-NEXT:    testb %al, %al
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v8i32_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v8i32_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v8i32_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i16_v16i1(<16 x i16>) {
; SSE-LABEL: icmp_v16i16_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v16i16_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v16i16_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v16i16_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmw %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <16 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v32i8_v32i1(<32 x i8>) {
; SSE-LABEL: icmp_v32i8_v32i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v32i8_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v32i8_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v32i8_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <32 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i64_v8i1(<8 x i64>) {
; SSE2-LABEL: icmp_v8i64_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,0,3,2]
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    packssdw %xmm5, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    packssdw %xmm2, %xmm1
; SSE2-NEXT:    packssdw %xmm3, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm3
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm2
; SSE41-NEXT:    packssdw %xmm3, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm0
; SSE41-NEXT:    packssdw %xmm1, %xmm0
; SSE41-NEXT:    packssdw %xmm2, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovmskps %ymm0, %eax
; AVX1-NEXT:    testb %al, %al
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovmskps %ymm0, %eax
; AVX2-NEXT:    testb %al, %al
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v8i64_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v8i64_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v8i64_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i32_v16i1(<16 x i32>) {
; SSE-LABEL: icmp_v16i32_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqd %xmm4, %xmm3
; SSE-NEXT:    pcmpeqd %xmm4, %xmm2
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    pcmpeqd %xmm4, %xmm1
; SSE-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm2, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v32i16_v32i1(<32 x i16>) {
; SSE-LABEL: icmp_v32i16_v32i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqw %xmm4, %xmm1
; SSE-NEXT:    pcmpeqw %xmm4, %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pcmpeqw %xmm4, %xmm3
; SSE-NEXT:    pcmpeqw %xmm4, %xmm2
; SSE-NEXT:    packsswb %xmm3, %xmm2
; SSE-NEXT:    por %xmm0, %xmm2
; SSE-NEXT:    pmovmskb %xmm2, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v32i16_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v32i16_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v32i16_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <32 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v64i8_v64i1(<64 x i8>) {
; SSE-LABEL: icmp_v64i8_v64i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm4, %xmm4
; SSE-NEXT:    pcmpeqb %xmm4, %xmm2
; SSE-NEXT:    pcmpeqb %xmm4, %xmm0
; SSE-NEXT:    pcmpeqb %xmm4, %xmm3
; SSE-NEXT:    pcmpeqb %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pmovmskb %xmm1, %eax
; SSE-NEXT:    testw %ax, %ax
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testw %ax, %ax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v64i8_v64i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm2
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX512F-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512F-NEXT:    vpor %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kshiftrw $1, %k0, %k1
; AVX512F-NEXT:    korw %k1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    # kill: def $al killed $al killed $eax
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v64i8_v64i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestq %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v64i8_v64i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kortestq %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <64 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v64i1(<64 x i1> %a)
  ret i1 %b
}

declare i1 @llvm.vector.reduce.or.v2i1(<2 x i1>)
declare i1 @llvm.vector.reduce.or.v4i1(<4 x i1>)
declare i1 @llvm.vector.reduce.or.v8i1(<8 x i1>)
declare i1 @llvm.vector.reduce.or.v16i1(<16 x i1>)
declare i1 @llvm.vector.reduce.or.v32i1(<32 x i1>)
declare i1 @llvm.vector.reduce.or.v64i1(<64 x i1>)
