; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs  < %s 2>%t | FileCheck %s

; RUN: FileCheck --check-prefix=WARN --allow-empty %s <%t

; If this check fails please read test/CodeGen/AArch64/README for instructions on how to resolve it.
; WARN-NOT: warning


target triple = "x86_64-unknown-unknown"

;
; VECTOR_REVERSE
;

define <16 x i8> @reverse_v16i8(<16 x i8> %a) #0 {
; CHECK-LABEL: reverse_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pxor      %xmm1, %xmm1
; CHECK-NEXT:    movdqa    %xmm0, %xmm2
; CHECK-NEXT:    punpcklbw  %xmm1, %xmm
; CHECK-NEXT:    pshufd     $78, %xmm2, %xmm2
; CHECK-NEXT:    pshuflw    $27, %xmm2, %xmm2
; CHECK-NEXT:    pshufhw    $27, %xmm2, %xmm2
; CHECK-NEXT:    punpckhbw  %xmm1, %xmm0
; CHECK-NEXT:    pshufd     $78, %xmm0, %xmm0
; CHECK-NEXT:    pshuflw    $27, %xmm0, %xmm0
; CHECK-NEXT:    pshufhw    $27, %xmm0, %xmm0
; CHECK-NEXT:    packuswb   %xmm2, %xmm0
; CHECK-NEXT:    retq

  %res = call <16 x i8> @llvm.experimental.vector.reverse.v16i8(<16 x i8> %a)
  ret <16 x i8> %res
}

define <8 x i16> @reverse_v8i16(<8 x i16> %a) #0 {
; CHECK-LABEL: reverse_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pshufd     $78, %xmm0, %xmm
; CHECK-NEXT:    pshuflw    $27, %xmm0, %xmm0
; CHECK-NEXT:    pshufhw    $27, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %res = call <8 x i16> @llvm.experimental.vector.reverse.v8i16(<8 x i16> %a)
  ret <8 x i16> %res
}

define <4 x i32> @reverse_v4i32(<4 x i32> %a) #0 {
; CHECK-LABEL: reverse_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pshufd    $27, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %res = call <4 x i32> @llvm.experimental.vector.reverse.v4i32(<4 x i32> %a)
  ret <4 x i32> %res
}

define <2 x i64> @reverse_v2i64(<2 x i64> %a) #0 {
; CHECK-LABEL: reverse_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pshufd    $78, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %res = call <2 x i64> @llvm.experimental.vector.reverse.v2i64(<2 x i64> %a)
  ret <2 x i64> %res
}

define <4 x float> @reverse_v4f32(<4 x float> %a) #0 {
; CHECK-LABEL: reverse_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shufps    $27, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %res = call <4 x float> @llvm.experimental.vector.reverse.v4f32(<4 x float> %a)
  ret <4 x float> %res
}

define <2 x double> @reverse_v2f64(<2 x double> %a) #0 {
; CHECK-LABEL: reverse_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    shufps    $78, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %res = call <2 x double> @llvm.experimental.vector.reverse.v2f64(<2 x double> %a)
  ret <2 x double> %res
}

; Verify promote type legalisation works as expected.
define <2 x i8> @reverse_v2i8(<2 x i8> %a) #0 {
; CHECK-LABEL: reverse_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movdqa   %xmm0, %xmm1
; CHECK-NEXT:    psrlw    $8, %xmm1
; CHECK-NEXT:    psllw    $8, %xmm0
; CHECK-NEXT:    por      %xmm1, %xmm0
; CHECK-NEXT:    retq
  %res = call <2 x i8> @llvm.experimental.vector.reverse.v2i8(<2 x i8> %a)
  ret <2 x i8> %res
}

; Verify splitvec type legalisation works as expected.
define <8 x i32> @reverse_v8i32(<8 x i32> %a) #0 {
; CHECK-LABEL: reverse_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    pshufd    $27, %xmm1, %xmm2
; CHECK-NEXT:    pshufd    $27, %xmm0, %xmm1
; CHECK-NEXT:    movdqa %xmm2, %xmm0
; CHECK-NEXT:    retq
  %res = call <8 x i32> @llvm.experimental.vector.reverse.v8i32(<8 x i32> %a)
  ret <8 x i32> %res
}

; Verify splitvec type legalisation works as expected.
define <16 x float> @reverse_v16f32(<16 x float> %a) #0 {
; CHECK-LABEL: reverse_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movaps    %xmm1, %xmm4
; CHECK-NEXT:    movaps    %xmm0, %xmm5
; CHECK-NEXT:    shufps    $27, %xmm3, %xmm
; CHECK-NEXT:    shufps    $27, %xmm2, %xmm2
; CHECK-NEXT:    shufps    $27, %xmm1, %xmm4
; CHECK-NEXT:    shufps    $27, %xmm0, %xmm5
; CHECK-NEXT:    movaps    %xmm3, %xmm0
; CHECK-NEXT:    movaps    %xmm2, %xmm1
; CHECK-NEXT:    movaps    %xmm4, %xmm2
; CHECK-NEXT:    movaps    %xmm5, %xmm3

  %res = call <16 x float> @llvm.experimental.vector.reverse.v16f32(<16 x float> %a)
  ret <16 x float> %res
}


declare <2 x i8> @llvm.experimental.vector.reverse.v2i8(<2 x i8>)
declare <16 x i8> @llvm.experimental.vector.reverse.v16i8(<16 x i8>)
declare <8 x i16> @llvm.experimental.vector.reverse.v8i16(<8 x i16>)
declare <4 x i32> @llvm.experimental.vector.reverse.v4i32(<4 x i32>)
declare <8 x i32> @llvm.experimental.vector.reverse.v8i32(<8 x i32>)
declare <2 x i64> @llvm.experimental.vector.reverse.v2i64(<2 x i64>)
declare <8 x half> @llvm.experimental.vector.reverse.v8f16(<8 x half>)
declare <4 x float> @llvm.experimental.vector.reverse.v4f32(<4 x float>)
declare <16 x float> @llvm.experimental.vector.reverse.v16f32(<16 x float>)
declare <2 x double> @llvm.experimental.vector.reverse.v2f64(<2 x double>)

attributes #0 = { nounwind }
