; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2,LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+m,+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1,LMULMAX1-RV64

define void @ctpop_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: ctpop_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v26, v25, 1
; CHECK-NEXT:    addi a1, zero, 85
; CHECK-NEXT:    vand.vx v26, v26, a1
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    addi a1, zero, 51
; CHECK-NEXT:    vand.vx v26, v25, a1
; CHECK-NEXT:    vsrl.vi v25, v25, 2
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vadd.vv v25, v26, v25
; CHECK-NEXT:    vsrl.vi v26, v25, 4
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vand.vi v25, v25, 15
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %a)
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}
declare <16 x i8> @llvm.ctpop.v16i8(<16 x i8>)

define void @ctpop_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; LMULMAX2-RV32-LABEL: ctpop_v8i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v25, v26, v25
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    addi a1, zero, 257
; LMULMAX2-RV32-NEXT:    vmul.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 8
; LMULMAX2-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctpop_v8i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v25, v26, v25
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    addi a1, zero, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 8
; LMULMAX2-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctpop_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 3
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v26, v25
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 1
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    addi a1, zero, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 8
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctpop_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 3
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v26, v25
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 1
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    addi a1, zero, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 8
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %a)
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}
declare <8 x i16> @llvm.ctpop.v8i16(<8 x i16>)

define void @ctpop_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; LMULMAX2-RV32-LABEL: ctpop_v4i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v25, v26, v25
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    lui a1, 4112
; LMULMAX2-RV32-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32-NEXT:    vmul.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 24
; LMULMAX2-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctpop_v4i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v25, v26, v25
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    lui a1, 4112
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 24
; LMULMAX2-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctpop_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v26, v25
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    lui a1, 4112
; LMULMAX1-RV32-NEXT:    addi a1, a1, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 24
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctpop_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    lui a1, 349525
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 209715
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v26, v25
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 61681
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    lui a1, 4112
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 24
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %a)
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}
declare <4 x i32> @llvm.ctpop.v4i32(<4 x i32>)

define void @ctpop_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; LMULMAX2-RV32-LABEL: ctpop_v2i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX2-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v27, v25, v26
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV32-NEXT:    vand.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    vadd.vv v25, v27, v25
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 4112
; LMULMAX2-RV32-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmul.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    addi a1, zero, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctpop_v2i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 13107
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v25, v26, v25
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 3855
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    lui a1, 4112
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64-NEXT:    slli a1, a1, 16
; LMULMAX2-RV64-NEXT:    addi a1, a1, 257
; LMULMAX2-RV64-NEXT:    slli a1, a1, 16
; LMULMAX2-RV64-NEXT:    addi a1, a1, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    addi a1, zero, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctpop_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v27, v25, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 4112
; LMULMAX1-RV32-NEXT:    addi a1, a1, 257
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    addi a1, zero, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctpop_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 1
; LMULMAX1-RV64-NEXT:    lui a1, 21845
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 13107
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v26, v25
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 3855
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    lui a1, 4112
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    slli a1, a1, 16
; LMULMAX1-RV64-NEXT:    addi a1, a1, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    addi a1, zero, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}
declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)

define void @ctpop_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: ctpop_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a1, zero, 32
; LMULMAX2-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-NEXT:    addi a1, zero, 85
; LMULMAX2-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    addi a1, zero, 51
; LMULMAX2-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-NEXT:    vadd.vv v26, v28, v26
; LMULMAX2-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vand.vi v26, v26, 15
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: ctpop_v32i8:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle8.v v25, (a1)
; LMULMAX1-NEXT:    vle8.v v26, (a0)
; LMULMAX1-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-NEXT:    addi a2, zero, 85
; LMULMAX1-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-NEXT:    addi a3, zero, 51
; LMULMAX1-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-NEXT:    vsrl.vi v27, v25, 4
; LMULMAX1-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-NEXT:    vand.vi v25, v25, 15
; LMULMAX1-NEXT:    vsrl.vi v27, v26, 1
; LMULMAX1-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-NEXT:    vand.vi v26, v26, 15
; LMULMAX1-NEXT:    vse8.v v26, (a0)
; LMULMAX1-NEXT:    vse8.v v25, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = call <32 x i8> @llvm.ctpop.v32i8(<32 x i8> %a)
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}
declare <32 x i8> @llvm.ctpop.v32i8(<32 x i8>)

define void @ctpop_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-RV32-LABEL: ctpop_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV32-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v28, v26
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    addi a1, zero, 257
; LMULMAX2-RV32-NEXT:    vmul.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 8
; LMULMAX2-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctpop_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v28, v26
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    addi a1, zero, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 8
; LMULMAX2-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctpop_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-RV32-NEXT:    lui a2, 5
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a3, 3
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a4, 1
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV32-NEXT:    addi a5, zero, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v25, v25, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 8
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 1
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV32-NEXT:    vmul.vx v26, v26, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 8
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctpop_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-RV64-NEXT:    lui a2, 5
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a3, 3
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a4, 1
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV64-NEXT:    addi a5, zero, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v25, v25, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 8
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 1
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV64-NEXT:    vmul.vx v26, v26, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 8
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = call <16 x i16> @llvm.ctpop.v16i16(<16 x i16> %a)
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}
declare <16 x i16> @llvm.ctpop.v16i16(<16 x i16>)

define void @ctpop_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-RV32-LABEL: ctpop_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV32-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v28, v26
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    lui a1, 4112
; LMULMAX2-RV32-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32-NEXT:    vmul.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 24
; LMULMAX2-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctpop_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v28, v26
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    lui a1, 4112
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 24
; LMULMAX2-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctpop_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a3, 209715
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV32-NEXT:    lui a5, 4112
; LMULMAX1-RV32-NEXT:    addi a5, a5, 257
; LMULMAX1-RV32-NEXT:    vmul.vx v25, v25, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 24
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 1
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV32-NEXT:    vmul.vx v26, v26, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 24
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctpop_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-RV64-NEXT:    lui a2, 349525
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a3, 209715
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a4, 61681
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV64-NEXT:    lui a5, 4112
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v25, v25, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 24
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 1
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV64-NEXT:    vmul.vx v26, v26, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 24
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = call <8 x i32> @llvm.ctpop.v8i32(<8 x i32> %a)
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}
declare <8 x i32> @llvm.ctpop.v8i32(<8 x i32>)

define void @ctpop_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-RV32-LABEL: ctpop_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v28, v28, v30
; LMULMAX2-RV32-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v30, v26, v28
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v30, v26
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 4112
; LMULMAX2-RV32-NEXT:    addi a1, a1, 257
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    addi a1, zero, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: ctpop_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 1
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV64-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 13107
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v28, v26
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 3855
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    lui a1, 4112
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 257
; LMULMAX2-RV64-NEXT:    slli a1, a1, 16
; LMULMAX2-RV64-NEXT:    addi a1, a1, 257
; LMULMAX2-RV64-NEXT:    slli a1, a1, 16
; LMULMAX2-RV64-NEXT:    addi a1, a1, 257
; LMULMAX2-RV64-NEXT:    vmul.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    addi a1, zero, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ctpop_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v28, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v27, v27, v28
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a2, 209715
; LMULMAX1-RV32-NEXT:    addi a2, a2, 819
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v29, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v29, v25
; LMULMAX1-RV32-NEXT:    vsrl.vi v29, v25, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v29
; LMULMAX1-RV32-NEXT:    lui a2, 61681
; LMULMAX1-RV32-NEXT:    addi a2, a2, -241
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v29, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v29
; LMULMAX1-RV32-NEXT:    lui a2, 4112
; LMULMAX1-RV32-NEXT:    addi a2, a2, 257
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v30, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v30
; LMULMAX1-RV32-NEXT:    addi a2, zero, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v25, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v31, v26, 1
; LMULMAX1-RV32-NEXT:    vand.vv v28, v31, v28
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v28
; LMULMAX1-RV32-NEXT:    vand.vv v28, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v28, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v29
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v30
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v26, a2
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ctpop_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a6)
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 1
; LMULMAX1-RV64-NEXT:    lui a2, 21845
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a3, 13107
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v27, v25
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a4, 3855
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV64-NEXT:    lui a5, 4112
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    slli a5, a5, 16
; LMULMAX1-RV64-NEXT:    addi a5, a5, 257
; LMULMAX1-RV64-NEXT:    vmul.vx v25, v25, a5
; LMULMAX1-RV64-NEXT:    addi a1, zero, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 1
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a2
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 4
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV64-NEXT:    vmul.vx v26, v26, a5
; LMULMAX1-RV64-NEXT:    vsrl.vx v26, v26, a1
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a6)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = call <4 x i64> @llvm.ctpop.v4i64(<4 x i64> %a)
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}
declare <4 x i64> @llvm.ctpop.v4i64(<4 x i64>)
