; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s

declare <vscale x 1 x i16> @llvm.abs.nxv1i16(<vscale x 1 x i16>, i1)

define <vscale x 1 x i16> @vabs_nxv1i16(<vscale x 1 x i16> %v) {
; CHECK-LABEL: vabs_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,mf4,ta,mu
; CHECK-NEXT:    vrsub.vi v25, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v25
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x i16> @llvm.abs.nxv1i16(<vscale x 1 x i16> %v, i1 false)
  ret <vscale x 1 x i16> %r
}

declare <vscale x 2 x i16> @llvm.abs.nxv2i16(<vscale x 2 x i16>, i1)

define <vscale x 2 x i16> @vabs_nxv2i16(<vscale x 2 x i16> %v) {
; CHECK-LABEL: vabs_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,mf2,ta,mu
; CHECK-NEXT:    vrsub.vi v25, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v25
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x i16> @llvm.abs.nxv2i16(<vscale x 2 x i16> %v, i1 false)
  ret <vscale x 2 x i16> %r
}

declare <vscale x 4 x i16> @llvm.abs.nxv4i16(<vscale x 4 x i16>, i1)

define <vscale x 4 x i16> @vabs_nxv4i16(<vscale x 4 x i16> %v) {
; CHECK-LABEL: vabs_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vrsub.vi v25, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v25
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x i16> @llvm.abs.nxv4i16(<vscale x 4 x i16> %v, i1 false)
  ret <vscale x 4 x i16> %r
}

declare <vscale x 8 x i16> @llvm.abs.nxv8i16(<vscale x 8 x i16>, i1)

define <vscale x 8 x i16> @vabs_nxv8i16(<vscale x 8 x i16> %v) {
; CHECK-LABEL: vabs_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m2,ta,mu
; CHECK-NEXT:    vrsub.vi v26, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v26
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x i16> @llvm.abs.nxv8i16(<vscale x 8 x i16> %v, i1 false)
  ret <vscale x 8 x i16> %r
}

declare <vscale x 16 x i16> @llvm.abs.nxv16i16(<vscale x 16 x i16>, i1)

define <vscale x 16 x i16> @vabs_nxv16i16(<vscale x 16 x i16> %v) {
; CHECK-LABEL: vabs_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m4,ta,mu
; CHECK-NEXT:    vrsub.vi v28, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v28
; CHECK-NEXT:    ret
  %r = call <vscale x 16 x i16> @llvm.abs.nxv16i16(<vscale x 16 x i16> %v, i1 false)
  ret <vscale x 16 x i16> %r
}

declare <vscale x 32 x i16> @llvm.abs.nxv32i16(<vscale x 32 x i16>, i1)

define <vscale x 32 x i16> @vabs_nxv32i16(<vscale x 32 x i16> %v) {
; CHECK-LABEL: vabs_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16,m8,ta,mu
; CHECK-NEXT:    vrsub.vi v16, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 32 x i16> @llvm.abs.nxv32i16(<vscale x 32 x i16> %v, i1 false)
  ret <vscale x 32 x i16> %r
}

declare <vscale x 1 x i32> @llvm.abs.nxv1i32(<vscale x 1 x i32>, i1)

define <vscale x 1 x i32> @vabs_nxv1i32(<vscale x 1 x i32> %v) {
; CHECK-LABEL: vabs_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,mf2,ta,mu
; CHECK-NEXT:    vrsub.vi v25, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v25
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x i32> @llvm.abs.nxv1i32(<vscale x 1 x i32> %v, i1 false)
  ret <vscale x 1 x i32> %r
}

declare <vscale x 2 x i32> @llvm.abs.nxv2i32(<vscale x 2 x i32>, i1)

define <vscale x 2 x i32> @vabs_nxv2i32(<vscale x 2 x i32> %v) {
; CHECK-LABEL: vabs_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vrsub.vi v25, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v25
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x i32> @llvm.abs.nxv2i32(<vscale x 2 x i32> %v, i1 false)
  ret <vscale x 2 x i32> %r
}

declare <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32>, i1)

define <vscale x 4 x i32> @vabs_nxv4i32(<vscale x 4 x i32> %v) {
; CHECK-LABEL: vabs_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m2,ta,mu
; CHECK-NEXT:    vrsub.vi v26, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v26
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x i32> @llvm.abs.nxv4i32(<vscale x 4 x i32> %v, i1 false)
  ret <vscale x 4 x i32> %r
}

declare <vscale x 8 x i32> @llvm.abs.nxv8i32(<vscale x 8 x i32>, i1)

define <vscale x 8 x i32> @vabs_nxv8i32(<vscale x 8 x i32> %v) {
; CHECK-LABEL: vabs_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m4,ta,mu
; CHECK-NEXT:    vrsub.vi v28, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v28
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x i32> @llvm.abs.nxv8i32(<vscale x 8 x i32> %v, i1 false)
  ret <vscale x 8 x i32> %r
}

declare <vscale x 16 x i32> @llvm.abs.nxv16i32(<vscale x 16 x i32>, i1)

define <vscale x 16 x i32> @vabs_nxv16i32(<vscale x 16 x i32> %v) {
; CHECK-LABEL: vabs_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32,m8,ta,mu
; CHECK-NEXT:    vrsub.vi v16, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 16 x i32> @llvm.abs.nxv16i32(<vscale x 16 x i32> %v, i1 false)
  ret <vscale x 16 x i32> %r
}

declare <vscale x 1 x i64> @llvm.abs.nxv1i64(<vscale x 1 x i64>, i1)

define <vscale x 1 x i64> @vabs_nxv1i64(<vscale x 1 x i64> %v) {
; CHECK-LABEL: vabs_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; CHECK-NEXT:    vrsub.vi v25, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v25
; CHECK-NEXT:    ret
  %r = call <vscale x 1 x i64> @llvm.abs.nxv1i64(<vscale x 1 x i64> %v, i1 false)
  ret <vscale x 1 x i64> %r
}

declare <vscale x 2 x i64> @llvm.abs.nxv2i64(<vscale x 2 x i64>, i1)

define <vscale x 2 x i64> @vabs_nxv2i64(<vscale x 2 x i64> %v) {
; CHECK-LABEL: vabs_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m2,ta,mu
; CHECK-NEXT:    vrsub.vi v26, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v26
; CHECK-NEXT:    ret
  %r = call <vscale x 2 x i64> @llvm.abs.nxv2i64(<vscale x 2 x i64> %v, i1 false)
  ret <vscale x 2 x i64> %r
}

declare <vscale x 4 x i64> @llvm.abs.nxv4i64(<vscale x 4 x i64>, i1)

define <vscale x 4 x i64> @vabs_nxv4i64(<vscale x 4 x i64> %v) {
; CHECK-LABEL: vabs_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m4,ta,mu
; CHECK-NEXT:    vrsub.vi v28, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v28
; CHECK-NEXT:    ret
  %r = call <vscale x 4 x i64> @llvm.abs.nxv4i64(<vscale x 4 x i64> %v, i1 false)
  ret <vscale x 4 x i64> %r
}

declare <vscale x 8 x i64> @llvm.abs.nxv8i64(<vscale x 8 x i64>, i1)

define <vscale x 8 x i64> @vabs_nxv8i64(<vscale x 8 x i64> %v) {
; CHECK-LABEL: vabs_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64,m8,ta,mu
; CHECK-NEXT:    vrsub.vi v16, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v16
; CHECK-NEXT:    ret
  %r = call <vscale x 8 x i64> @llvm.abs.nxv8i64(<vscale x 8 x i64> %v, i1 false)
  ret <vscale x 8 x i64> %r
}
