; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-b -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IB
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zbp -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32IBP

define i32 @gorc1_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc1_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.p a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc1_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.p a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 1
  %shl = and i32 %and, -1431655766
  %and1 = lshr i32 %a, 1
  %shr = and i32 %and1, 1431655765
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc1_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc1_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.p a0, a0
; RV32IB-NEXT:    orc.p a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc1_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.p a0, a0
; RV32IBP-NEXT:    orc.p a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 1
  %shl = and i64 %and, -6148914691236517206
  %and1 = lshr i64 %a, 1
  %shr = and i64 %and1, 6148914691236517205
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc2_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc2_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc2_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.n a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 2
  %shl = and i32 %and, -858993460
  %and1 = lshr i32 %a, 2
  %shr = and i32 %and1, 858993459
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc2_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc2_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.n a0, a0
; RV32IB-NEXT:    orc2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc2_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.n a0, a0
; RV32IBP-NEXT:    orc2.n a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 2
  %shl = and i64 %and, -3689348814741910324
  %and1 = lshr i64 %a, 2
  %shr = and i64 %and1, 3689348814741910323
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc3_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc3_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc3_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc3_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.n a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc3_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc3_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 1
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc3_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.n a0, a0
; RV32IB-NEXT:    orc.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc3_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.n a0, a0
; RV32IBP-NEXT:    orc.n a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc4_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc4_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc4_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc4.b a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 4
  %shl = and i32 %and, -252645136
  %and1 = lshr i32 %a, 4
  %shr = and i32 %and1, 252645135
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc4_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc4_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc4.b a0, a0
; RV32IB-NEXT:    orc4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc4_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc4.b a0, a0
; RV32IBP-NEXT:    orc4.b a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 4
  %shl = and i64 %and, -1085102592571150096
  %and1 = lshr i64 %a, 4
  %shr = and i64 %and1, 1085102592571150095
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc5_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc5_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc5_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    gorci a0, a0, 5
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc5_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    gorci a0, a0, 5
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1b, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc5_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc5_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 1
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc5_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    gorci a0, a0, 5
; RV32IB-NEXT:    gorci a1, a1, 5
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc5_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    gorci a0, a0, 5
; RV32IBP-NEXT:    gorci a1, a1, 5
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1b, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc6_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc6_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc6_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc6_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1b, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

define i64 @gorc6_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc6_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 2
; RV32I-NEXT:    srli a5, a1, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc6_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.b a0, a0
; RV32IB-NEXT:    orc2.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc6_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.b a0, a0
; RV32IBP-NEXT:    orc2.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1b, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

define i32 @gorc7_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc7_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc7_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc7_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  %and3 = shl i32 %or2b, 4
  %shl3 = and i32 %and3, -252645136
  %and3b = lshr i32 %or2b, 4
  %shr3 = and i32 %and3b, 252645135
  %or3 = or i32 %shr3, %or2b
  %or3b = or i32 %or3, %shl3
  ret i32 %or3b
}

define i64 @gorc7_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc7_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a0, 2
; RV32I-NEXT:    srli a5, a1, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 4
; RV32I-NEXT:    srli a5, a0, 4
; RV32I-NEXT:    lui a3, 61681
; RV32I-NEXT:    addi a3, a3, -241
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc7_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.b a0, a0
; RV32IB-NEXT:    orc.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc7_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.b a0, a0
; RV32IBP-NEXT:    orc.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  %and3 = shl i64 %or2b, 4
  %shl3 = and i64 %and3, -1085102592571150096
  %and3b = lshr i64 %or2b, 4
  %shr3 = and i64 %and3b, 1085102592571150095
  %or3 = or i64 %shr3, %or2b
  %or3b = or i64 %or3, %shl3
  ret i64 %or3b
}

define i32 @gorc8_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc8_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc8.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc8_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc8.h a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 8
  %shl = and i32 %and, -16711936
  %and1 = lshr i32 %a, 8
  %shr = and i32 %and1, 16711935
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i64 @gorc8_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a4, a1, 8
; RV32I-NEXT:    srli a5, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    addi a3, a3, 255
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc8_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc8.h a0, a0
; RV32IB-NEXT:    orc8.h a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc8_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc8.h a0, a0
; RV32IBP-NEXT:    orc8.h a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 8
  %shl = and i64 %and, -71777214294589696
  %and1 = lshr i64 %a, 8
  %shr = and i64 %and1, 71777214294589695
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

define i32 @gorc16_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc16_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc16 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc16_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc16 a0, a0
; RV32IBP-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = lshr i32 %a, 16
  %or = or i32 %shr, %a
  %or2 = or i32 %or, %shl
  ret i32 %or2
}

define i32 @gorc16_rotl_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_rotl_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc16_rotl_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc16 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc16_rotl_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc16 a0, a0
; RV32IBP-NEXT:    ret
  %rot = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 16)
  %or = or i32 %rot, %a
  ret i32 %or
}

define i32 @gorc16_rotr_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc16_rotr_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a2, a0, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc16_rotr_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc16 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc16_rotr_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc16 a0, a0
; RV32IBP-NEXT:    ret
  %rot = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 16)
  %or = or i32 %rot, %a
  ret i32 %or
}

define i64 @gorc16_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc16_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 16
; RV32I-NEXT:    slli a3, a0, 16
; RV32I-NEXT:    srli a4, a0, 16
; RV32I-NEXT:    srli a5, a1, 16
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a0, a4, a0
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc16_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc16 a0, a0
; RV32IB-NEXT:    orc16 a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc16_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc16 a0, a0
; RV32IBP-NEXT:    orc16 a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 16
  %shl = and i64 %and, -281470681808896
  %and1 = lshr i64 %a, 16
  %shr = and i64 %and1, 281470681808895
  %or = or i64 %shr, %a
  %or2 = or i64 %or, %shl
  ret i64 %or2
}

; gorc2, gorc2 -> gorc2
define i32 @gorc2b_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc2b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a3, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 2
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc2b_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc2b_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.n a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  ret i32 %or2b
}

; gorc2, gorc2 -> gorc2
define i64 @gorc2b_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc2b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a7, a2, a4
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a3, a3, a2
; RV32I-NEXT:    and a5, a5, a2
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a1, a1, a7
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    slli a5, a1, 2
; RV32I-NEXT:    and a6, a5, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    srli a4, a1, 2
; RV32I-NEXT:    srli a5, a0, 2
; RV32I-NEXT:    and a5, a5, a2
; RV32I-NEXT:    and a2, a4, a2
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc2b_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc2.n a0, a0
; RV32IB-NEXT:    orc2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc2b_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc2.n a0, a0
; RV32IBP-NEXT:    orc2.n a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  ret i64 %or2b
}

; gorc1, gorc2, gorc1 -> gorc2
define i32 @gorc3b_i32(i32 %a) nounwind {
; RV32I-LABEL: gorc3b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a3, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a3, 838861
; RV32I-NEXT:    addi a3, a3, -820
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    srli a3, a0, 2
; RV32I-NEXT:    lui a5, 209715
; RV32I-NEXT:    addi a5, a5, 819
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 1
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc3b_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc3b_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.n a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shr1, %a
  %or1b = or i32 %or1, %shl1
  %and2 = shl i32 %or1b, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1b, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shr2, %or1b
  %or2b = or i32 %or2, %shl2
  %and3 = shl i32 %or2b, 1
  %shl3 = and i32 %and3, -1431655766
  %and3b = lshr i32 %or2b, 1
  %shr3 = and i32 %and3b, 1431655765
  %or3 = or i32 %shr3, %or2b
  %or3b = or i32 %or3, %shl3
  ret i32 %or3b
}

; gorc1, gorc2, gorc1 -> gorc2
define i64 @gorc3b_i64(i64 %a) nounwind {
; RV32I-LABEL: gorc3b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a6, a3, a4
; RV32I-NEXT:    and a7, a2, a4
; RV32I-NEXT:    srli a5, a1, 1
; RV32I-NEXT:    srli a3, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a3, a3, a2
; RV32I-NEXT:    and a5, a5, a2
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a0, a0, a7
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    slli a6, a1, 2
; RV32I-NEXT:    slli a5, a0, 2
; RV32I-NEXT:    lui a3, 838861
; RV32I-NEXT:    addi a3, a3, -820
; RV32I-NEXT:    and a7, a5, a3
; RV32I-NEXT:    and a6, a6, a3
; RV32I-NEXT:    srli t0, a0, 2
; RV32I-NEXT:    srli a3, a1, 2
; RV32I-NEXT:    lui a5, 209715
; RV32I-NEXT:    addi a5, a5, 819
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    and a5, t0, a5
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    or a0, a0, a7
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    slli a5, a1, 1
; RV32I-NEXT:    and a6, a5, a4
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    srli a4, a1, 1
; RV32I-NEXT:    srli a5, a0, 1
; RV32I-NEXT:    and a5, a5, a2
; RV32I-NEXT:    and a2, a4, a2
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: gorc3b_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    orc.n a0, a0
; RV32IB-NEXT:    orc.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: gorc3b_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    orc.n a0, a0
; RV32IBP-NEXT:    orc.n a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shr1, %a
  %or1b = or i64 %or1, %shl1
  %and2 = shl i64 %or1b, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1b, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shr2, %or1b
  %or2b = or i64 %or2, %shl2
  %and3 = shl i64 %or2b, 1
  %shl3 = and i64 %and3, -6148914691236517206
  %and3b = lshr i64 %or2b, 1
  %shr3 = and i64 %and3b, 6148914691236517205
  %or3 = or i64 %shr3, %or2b
  %or3b = or i64 %or3, %shl3
  ret i64 %or3b
}

define i32 @grev1_i32(i32 %a) nounwind {
; RV32I-LABEL: grev1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev1_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev1_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 1
  %shl = and i32 %and, -1431655766
  %and1 = lshr i32 %a, 1
  %shr = and i32 %and1, 1431655765
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev1_i64(i64 %a) nounwind {
; RV32I-LABEL: grev1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev1_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.p a0, a0
; RV32IB-NEXT:    rev.p a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev1_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.p a0, a0
; RV32IBP-NEXT:    rev.p a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 1
  %shl = and i64 %and, -6148914691236517206
  %and1 = lshr i64 %a, 1
  %shr = and i64 %and1, 6148914691236517205
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev2_i32(i32 %a) nounwind {
; RV32I-LABEL: grev2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev2_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev2_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 2
  %shl = and i32 %and, -858993460
  %and1 = lshr i32 %a, 2
  %shr = and i32 %and1, 858993459
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev2_i64(i64 %a) nounwind {
; RV32I-LABEL: grev2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev2_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev2_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev2.n a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 2
  %shl = and i64 %and, -3689348814741910324
  %and1 = lshr i64 %a, 2
  %shr = and i64 %and1, 3689348814741910323
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev3_i32(i32 %a) nounwind {
; RV32I-LABEL: grev3_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev3_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev3_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.n a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i64 @grev3_i64(i64 %a) nounwind {
; RV32I-LABEL: grev3_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev3_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.n a0, a0
; RV32IB-NEXT:    rev.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev3_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.n a0, a0
; RV32IBP-NEXT:    rev.n a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev4_i32(i32 %a) nounwind {
; RV32I-LABEL: grev4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev4_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev4_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 4
  %shl = and i32 %and, -252645136
  %and1 = lshr i32 %a, 4
  %shr = and i32 %and1, 252645135
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev4_i64(i64 %a) nounwind {
; RV32I-LABEL: grev4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev4_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev4.b a0, a0
; RV32IB-NEXT:    rev4.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev4_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev4.b a0, a0
; RV32IBP-NEXT:    rev4.b a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 4
  %shl = and i64 %and, -1085102592571150096
  %and1 = lshr i64 %a, 4
  %shr = and i64 %and1, 1085102592571150095
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev5_i32(i32 %a) nounwind {
; RV32I-LABEL: grev5_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev5_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    grevi a0, a0, 5
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev5_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    grevi a0, a0, 5
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i64 @grev5_i64(i64 %a) nounwind {
; RV32I-LABEL: grev5_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev5_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    grevi a0, a0, 5
; RV32IB-NEXT:    grevi a1, a1, 5
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev5_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    grevi a0, a0, 5
; RV32IBP-NEXT:    grevi a1, a1, 5
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1

  %and2 = shl i64 %or1, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev6_i32(i32 %a) nounwind {
; RV32I-LABEL: grev6_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev6_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev6_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 2
  %shl1 = and i32 %and1, -858993460
  %and1b = lshr i32 %a, 2
  %shr1 = and i32 %and1b, 858993459
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 4
  %shl2 = and i32 %and2, -252645136
  %and2b = lshr i32 %or1, 4
  %shr2 = and i32 %and2b, 252645135
  %or2 = or i32 %shl2, %shr2
  ret i32 %or2
}

define i64 @grev6_i64(i64 %a) nounwind {
; RV32I-LABEL: grev6_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev6_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.b a0, a0
; RV32IB-NEXT:    rev2.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev6_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.b a0, a0
; RV32IBP-NEXT:    rev2.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 2
  %shl1 = and i64 %and1, -3689348814741910324
  %and1b = lshr i64 %a, 2
  %shr1 = and i64 %and1b, 3689348814741910323
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 4
  %shl2 = and i64 %and2, -1085102592571150096
  %and2b = lshr i64 %or1, 4
  %shr2 = and i64 %and2b, 1085102592571150095
  %or2 = or i64 %shl2, %shr2
  ret i64 %or2
}

define i32 @grev7_i32(i32 %a) nounwind {
; RV32I-LABEL: grev7_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi a2, a2, -241
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev7_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev7_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.b a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 4
  %shl3 = and i32 %and3, -252645136
  %and3b = lshr i32 %or2, 4
  %shr3 = and i32 %and3b, 252645135
  %or3 = or i32 %shl3, %shr3
  ret i32 %or3
}

define i64 @grev7_i64(i64 %a) nounwind {
; RV32I-LABEL: grev7_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    slli a3, a1, 4
; RV32I-NEXT:    lui a4, 986895
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a4, a4, -241
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev7_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.b a0, a0
; RV32IB-NEXT:    rev.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev7_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.b a0, a0
; RV32IBP-NEXT:    rev.b a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 4
  %shl3 = and i64 %and3, -1085102592571150096
  %and3b = lshr i64 %or2, 4
  %shr3 = and i64 %and3b, 1085102592571150095
  %or3 = or i64 %shl3, %shr3
  ret i64 %or3
}

define i32 @grev8_i32(i32 %a) nounwind {
; RV32I-LABEL: grev8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 8
; RV32I-NEXT:    lui a2, 1044496
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a2, 4080
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev8_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev8_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8.h a0, a0
; RV32IBP-NEXT:    ret
  %and = shl i32 %a, 8
  %shl = and i32 %and, -16711936
  %and1 = lshr i32 %a, 8
  %shr = and i32 %and1, 16711935
  %or = or i32 %shl, %shr
  ret i32 %or
}

define i64 @grev8_i64(i64 %a) nounwind {
; RV32I-LABEL: grev8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    lui a4, 1044496
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    lui a4, 4080
; RV32I-NEXT:    addi a4, a4, 255
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev8_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8.h a0, a0
; RV32IB-NEXT:    rev8.h a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev8_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8.h a0, a0
; RV32IBP-NEXT:    rev8.h a1, a1
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 8
  %shl = and i64 %and, -71777214294589696
  %and1 = lshr i64 %a, 8
  %shr = and i64 %and1, 71777214294589695
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i32 @grev16_i32(i32 %a) nounwind {
; RV32I-LABEL: grev16_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = lshr i32 %a, 16
  %or = or i32 %shl, %shr
  ret i32 %or
}


define i32 @grev3b_i32(i32 %a) nounwind {
; RV32I-LABEL: grev3b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi a2, a2, 819
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 349525
; RV32I-NEXT:    addi a2, a2, 1365
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev3b_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev3b_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.n a0, a0
; RV32IBP-NEXT:    ret
  %and2 = shl i32 %a, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %a, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and1 = shl i32 %or2, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %or2, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  ret i32 %or1
}

define i64 @grev3b_i64(i64 %a) nounwind {
; RV32I-LABEL: grev3b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev3b_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.n a0, a0
; RV32IB-NEXT:    rev.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev3b_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.n a0, a0
; RV32IBP-NEXT:    rev.n a1, a1
; RV32IBP-NEXT:    ret
  %and2 = shl i64 %a, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %a, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and1 = shl i64 %or2, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %or2, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  ret i64 %or1
}

; grev1, grev2, grev1 -> grev2
define i32 @grev2b_i32(i32 %a) nounwind {
; RV32I-LABEL: grev2b_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a4, 209715
; RV32I-NEXT:    addi a4, a4, 819
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev2b_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev2b_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 1
  %shl3 = and i32 %and3, -1431655766
  %and3b = lshr i32 %or2, 1
  %shr3 = and i32 %and3b, 1431655765
  %or3 = or i32 %shl3, %shr3
  ret i32 %or3
}

; grev1, grev2, grev1 -> grev2
define i64 @grev2b_i64(i64 %a) nounwind {
; RV32I-LABEL: grev2b_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a5, 349525
; RV32I-NEXT:    addi a5, a5, 1365
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    slli a6, a1, 2
; RV32I-NEXT:    slli a3, a0, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a7, a3, a2
; RV32I-NEXT:    and a2, a6, a2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a7, a0
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    slli a3, a1, 1
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev2b_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev2.n a0, a0
; RV32IB-NEXT:    rev2.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev2b_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev2.n a0, a0
; RV32IBP-NEXT:    rev2.n a1, a1
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 1
  %shl3 = and i64 %and3, -6148914691236517206
  %and3b = lshr i64 %or2, 1
  %shr3 = and i64 %and3b, 6148914691236517205
  %or3 = or i64 %shl3, %shr3
  ret i64 %or3
}

; grev1, grev2, grev1, grev2 -> identity
define i32 @grev0_i32(i32 %a) nounwind {
; RV32I-LABEL: grev0_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a5, 209715
; RV32I-NEXT:    addi a5, a5, 819
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev0_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev0_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    ret
  %and1 = shl i32 %a, 1
  %shl1 = and i32 %and1, -1431655766
  %and1b = lshr i32 %a, 1
  %shr1 = and i32 %and1b, 1431655765
  %or1 = or i32 %shl1, %shr1
  %and2 = shl i32 %or1, 2
  %shl2 = and i32 %and2, -858993460
  %and2b = lshr i32 %or1, 2
  %shr2 = and i32 %and2b, 858993459
  %or2 = or i32 %shl2, %shr2
  %and3 = shl i32 %or2, 1
  %shl3 = and i32 %and3, -1431655766
  %and3b = lshr i32 %or2, 1
  %shr3 = and i32 %and3b, 1431655765
  %or3 = or i32 %shl3, %shr3
  %and4 = shl i32 %or3, 2
  %shl4 = and i32 %and4, -858993460
  %and4b = lshr i32 %or3, 2
  %shr4 = and i32 %and4b, 858993459
  %or4 = or i32 %shl4, %shr4
  ret i32 %or4
}

; grev1, grev2, grev1, grev2 -> identity
define i64 @grev0_i64(i64 %a) nounwind {
; RV32I-LABEL: grev0_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 1
; RV32I-NEXT:    slli a3, a0, 1
; RV32I-NEXT:    lui a4, 699051
; RV32I-NEXT:    addi a4, a4, -1366
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a5, 349525
; RV32I-NEXT:    addi a5, a5, 1365
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    slli a6, a0, 2
; RV32I-NEXT:    slli a3, a1, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a7, a3, a2
; RV32I-NEXT:    and a6, a6, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a3, 209715
; RV32I-NEXT:    addi a3, a3, 819
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or t0, a6, a0
; RV32I-NEXT:    or a1, a7, a1
; RV32I-NEXT:    slli a6, a1, 1
; RV32I-NEXT:    slli a0, t0, 1
; RV32I-NEXT:    and a7, a0, a4
; RV32I-NEXT:    and a4, a6, a4
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    srli a0, t0, 1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    or a1, a4, a1
; RV32I-NEXT:    or a0, a7, a0
; RV32I-NEXT:    slli a4, a0, 2
; RV32I-NEXT:    slli a5, a1, 2
; RV32I-NEXT:    and a5, a5, a2
; RV32I-NEXT:    and a2, a4, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev0_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev0_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    ret
  %and1 = shl i64 %a, 1
  %shl1 = and i64 %and1, -6148914691236517206
  %and1b = lshr i64 %a, 1
  %shr1 = and i64 %and1b, 6148914691236517205
  %or1 = or i64 %shl1, %shr1
  %and2 = shl i64 %or1, 2
  %shl2 = and i64 %and2, -3689348814741910324
  %and2b = lshr i64 %or1, 2
  %shr2 = and i64 %and2b, 3689348814741910323
  %or2 = or i64 %shl2, %shr2
  %and3 = shl i64 %or2, 1
  %shl3 = and i64 %and3, -6148914691236517206
  %and3b = lshr i64 %or2, 1
  %shr3 = and i64 %and3b, 6148914691236517205
  %or3 = or i64 %shl3, %shr3
  %and4 = shl i64 %or3, 2
  %shl4 = and i64 %and4, -3689348814741910324
  %and4b = lshr i64 %or3, 2
  %shr4 = and i64 %and4b, 3689348814741910323
  %or4 = or i64 %shl4, %shr4
  ret i64 %or4
}

declare i32 @llvm.fshl.i32(i32, i32, i32)
declare i32 @llvm.fshr.i32(i32, i32, i32)

define signext i32 @grev16_i32_fshl(i32 signext %a) nounwind {
; RV32I-LABEL: grev16_i32_fshl:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i32_fshl:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i32_fshl:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    ret
  %or = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 16)
  ret i32 %or
}

define signext i32 @grev16_i32_fshr(i32 signext %a) nounwind {
; RV32I-LABEL: grev16_i32_fshr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i32_fshr:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i32_fshr:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    ret
  %or = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 16)
  ret i32 %or
}

define i64 @grev16_i64(i64 %a) nounwind {
; RV32I-LABEL: grev16_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a1, 16
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    srli a1, a1, 16
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: grev16_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rori a0, a0, 16
; RV32IB-NEXT:    rori a1, a1, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: grev16_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rori a0, a0, 16
; RV32IBP-NEXT:    rori a1, a1, 16
; RV32IBP-NEXT:    ret
  %and = shl i64 %a, 16
  %shl = and i64 %and, -281470681808896
  %and1 = lshr i64 %a, 16
  %shr = and i64 %and1, 281470681808895
  %or = or i64 %shl, %shr
  ret i64 %or
}

declare i16 @llvm.bswap.i16(i16)

define zeroext i16 @bswap_i16(i16 zeroext %a) nounwind {
; RV32I-LABEL: bswap_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_i16:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8 a0, a0
; RV32IB-NEXT:    srli a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_i16:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8 a0, a0
; RV32IBP-NEXT:    srli a0, a0, 16
; RV32IBP-NEXT:    ret
  %1 = tail call i16 @llvm.bswap.i16(i16 %a)
  ret i16 %1
}

declare i32 @llvm.bswap.i32(i32)

define i32 @bswap_i32(i32 %a) nounwind {
; RV32I-LABEL: bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8 a0, a0
; RV32IBP-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bswap.i64(i64)

define i64 @bswap_i64(i64 %a) {
; RV32I-LABEL: bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    lui a5, 4080
; RV32I-NEXT:    and a4, a4, a5
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    or a2, a1, a2
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    and a3, a3, a5
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8 a2, a1
; RV32IB-NEXT:    rev8 a1, a0
; RV32IB-NEXT:    mv a0, a2
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8 a2, a1
; RV32IBP-NEXT:    rev8 a1, a0
; RV32IBP-NEXT:    mv a0, a2
; RV32IBP-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}

declare i8 @llvm.bitreverse.i8(i8)

define zeroext i8 @bitreverse_i8(i8 zeroext %a) nounwind {
; RV32I-LABEL: bitreverse_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 4
; RV32I-NEXT:    andi a0, a0, 15
; RV32I-NEXT:    slli a0, a0, 4
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    andi a1, a0, 51
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    andi a0, a0, 204
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    andi a1, a0, 85
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    andi a0, a0, 170
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_i8:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev a0, a0
; RV32IB-NEXT:    srli a0, a0, 24
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_i8:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev a0, a0
; RV32IBP-NEXT:    srli a0, a0, 24
; RV32IBP-NEXT:    ret
  %1 = tail call i8 @llvm.bitreverse.i8(i8 %a)
  ret i8 %1
}

declare i16 @llvm.bitreverse.i16(i16)

define zeroext i16 @bitreverse_i16(i16 zeroext %a) nounwind {
; RV32I-LABEL: bitreverse_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    slli a0, a0, 8
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 1
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    lui a2, 15
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 3
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    lui a2, 13
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 5
; RV32I-NEXT:    addi a1, a1, 1365
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    lui a2, 11
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_i16:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev a0, a0
; RV32IB-NEXT:    srli a0, a0, 16
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_i16:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev a0, a0
; RV32IBP-NEXT:    srli a0, a0, 16
; RV32IBP-NEXT:    ret
  %1 = tail call i16 @llvm.bitreverse.i16(i16 %a)
  ret i16 %1
}

declare i32 @llvm.bitreverse.i32(i32)

define i32 @bitreverse_i32(i32 %a) nounwind {
; RV32I-LABEL: bitreverse_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    lui a2, 986895
; RV32I-NEXT:    addi a2, a2, 240
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    lui a2, 838861
; RV32I-NEXT:    addi a2, a2, -820
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 349525
; RV32I-NEXT:    addi a1, a1, 1365
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev a0, a0
; RV32IBP-NEXT:    ret
  %1 = tail call i32 @llvm.bitreverse.i32(i32 %a)
  ret i32 %1
}

declare i64 @llvm.bitreverse.i64(i64)

define i64 @bitreverse_i64(i64 %a) nounwind {
; RV32I-LABEL: bitreverse_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi t0, a3, -256
; RV32I-NEXT:    and a2, a2, t0
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a2, a2, a4
; RV32I-NEXT:    slli a4, a1, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    and a4, a4, a6
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    lui a2, 61681
; RV32I-NEXT:    addi t1, a2, -241
; RV32I-NEXT:    and a2, a1, t1
; RV32I-NEXT:    slli a2, a2, 4
; RV32I-NEXT:    lui a5, 986895
; RV32I-NEXT:    addi t2, a5, 240
; RV32I-NEXT:    and a1, a1, t2
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    lui a2, 209715
; RV32I-NEXT:    addi t3, a2, 819
; RV32I-NEXT:    and a3, a1, t3
; RV32I-NEXT:    slli a3, a3, 2
; RV32I-NEXT:    lui a4, 838861
; RV32I-NEXT:    addi a4, a4, -820
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    lui a3, 349525
; RV32I-NEXT:    addi a3, a3, 1365
; RV32I-NEXT:    and a5, a1, a3
; RV32I-NEXT:    slli a5, a5, 1
; RV32I-NEXT:    lui a2, 699051
; RV32I-NEXT:    addi a2, a2, -1366
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a7, a1, a5
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, t0
; RV32I-NEXT:    srli a5, a0, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    slli a5, a0, 8
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    and a1, a0, t1
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    and a0, a0, t2
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    and a1, a0, t3
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    and a1, a0, a3
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a1, a0, a1
; RV32I-NEXT:    mv a0, a7
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev a2, a1
; RV32IB-NEXT:    rev a1, a0
; RV32IB-NEXT:    mv a0, a2
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev a2, a1
; RV32IBP-NEXT:    rev a1, a0
; RV32IBP-NEXT:    mv a0, a2
; RV32IBP-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  ret i64 %1
}

define i32 @bswap_rotr_i32(i32 %a) {
; RV32I-LABEL: bswap_rotr_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_rotr_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_rotr_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8.h a0, a0
; RV32IBP-NEXT:    ret
  %1 = call i32 @llvm.bswap.i32(i32 %a)
  %2 = call i32 @llvm.fshr.i32(i32 %1, i32 %1, i32 16)
  ret i32 %2
}

define i32 @bswap_rotl_i32(i32 %a) {
; RV32I-LABEL: bswap_rotl_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bswap_rotl_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev8.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bswap_rotl_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev8.h a0, a0
; RV32IBP-NEXT:    ret
  %1 = call i32 @llvm.bswap.i32(i32 %a)
  %2 = call i32 @llvm.fshl.i32(i32 %1, i32 %1, i32 16)
  ret i32 %2
}

define i32 @bitreverse_bswap_i32(i32 %a) {
; RV32I-LABEL: bitreverse_bswap_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    lui a4, 4080
; RV32I-NEXT:    and a3, a3, a4
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 61681
; RV32I-NEXT:    addi a1, a1, -241
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 4
; RV32I-NEXT:    lui a3, 986895
; RV32I-NEXT:    addi a3, a3, 240
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 209715
; RV32I-NEXT:    addi a1, a1, 819
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 2
; RV32I-NEXT:    lui a3, 838861
; RV32I-NEXT:    addi a3, a3, -820
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    lui a1, 349525
; RV32I-NEXT:    addi a1, a1, 1365
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a1, a1, 1
; RV32I-NEXT:    lui a3, 699051
; RV32I-NEXT:    addi a3, a3, -1366
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    srli a1, a0, 8
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 24
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    and a2, a2, a4
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_bswap_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_bswap_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.b a0, a0
; RV32IBP-NEXT:    ret
  %1 = call i32 @llvm.bitreverse.i32(i32 %a)
  %2 = call i32 @llvm.bswap.i32(i32 %1)
  ret i32 %2
}

define i64 @bitreverse_bswap_i64(i64 %a) {
; RV32I-LABEL: bitreverse_bswap_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a3, a1, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi t1, a2, -256
; RV32I-NEXT:    and a3, a3, t1
; RV32I-NEXT:    srli a4, a1, 24
; RV32I-NEXT:    or a4, a3, a4
; RV32I-NEXT:    slli a5, a1, 8
; RV32I-NEXT:    lui a6, 4080
; RV32I-NEXT:    and a5, a5, a6
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    lui a4, 61681
; RV32I-NEXT:    addi a7, a4, -241
; RV32I-NEXT:    and a5, a1, a7
; RV32I-NEXT:    slli a5, a5, 4
; RV32I-NEXT:    lui a3, 986895
; RV32I-NEXT:    addi t0, a3, 240
; RV32I-NEXT:    and a1, a1, t0
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    lui a5, 209715
; RV32I-NEXT:    addi t2, a5, 819
; RV32I-NEXT:    and a4, a1, t2
; RV32I-NEXT:    slli a4, a4, 2
; RV32I-NEXT:    lui a3, 838861
; RV32I-NEXT:    addi t3, a3, -820
; RV32I-NEXT:    and a1, a1, t3
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    lui a4, 349525
; RV32I-NEXT:    addi a4, a4, 1365
; RV32I-NEXT:    and a2, a1, a4
; RV32I-NEXT:    slli a2, a2, 1
; RV32I-NEXT:    lui a5, 699051
; RV32I-NEXT:    addi a5, a5, -1366
; RV32I-NEXT:    and a1, a1, a5
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    and a2, a2, t1
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a2, a2, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    and a3, a3, a6
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    and a2, a0, a7
; RV32I-NEXT:    slli a2, a2, 4
; RV32I-NEXT:    and a0, a0, t0
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    and a2, a0, t2
; RV32I-NEXT:    slli a2, a2, 2
; RV32I-NEXT:    and a0, a0, t3
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    and a2, a0, a4
; RV32I-NEXT:    slli a2, a2, 1
; RV32I-NEXT:    and a0, a0, a5
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a0, 8
; RV32I-NEXT:    and a2, a2, t1
; RV32I-NEXT:    srli a3, a0, 24
; RV32I-NEXT:    or a2, a2, a3
; RV32I-NEXT:    slli a3, a0, 8
; RV32I-NEXT:    and a3, a3, a6
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    srli a2, a1, 8
; RV32I-NEXT:    and a2, a2, t1
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    or a2, a2, a3
; RV32I-NEXT:    slli a3, a1, 8
; RV32I-NEXT:    and a3, a3, a6
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: bitreverse_bswap_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    rev.b a0, a0
; RV32IB-NEXT:    rev.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: bitreverse_bswap_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    rev.b a0, a0
; RV32IBP-NEXT:    rev.b a1, a1
; RV32IBP-NEXT:    ret
  %1 = call i64 @llvm.bitreverse.i64(i64 %a)
  %2 = call i64 @llvm.bswap.i64(i64 %1)
  ret i64 %2
}

define i32 @shfl1_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl1_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 629146
; RV32I-NEXT:    addi a1, a1, -1639
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 1
; RV32I-NEXT:    lui a3, 279620
; RV32I-NEXT:    addi a3, a3, 1092
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    lui a2, 139810
; RV32I-NEXT:    addi a2, a2, 546
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl1_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip.n a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl1_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip.n a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -1717986919
  %shl = shl i32 %a, 1
  %and1 = and i32 %shl, 1145324612
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 1
  %and2 = and i32 %shr, 572662306
  %or3 = or i32 %or, %and2
  ret i32 %or3
}

define i64 @shfl1_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl1_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 629146
; RV32I-NEXT:    addi a2, a2, -1639
; RV32I-NEXT:    and a6, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 1
; RV32I-NEXT:    slli a5, a0, 1
; RV32I-NEXT:    lui a3, 279620
; RV32I-NEXT:    addi a3, a3, 1092
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a2, a2, a3
; RV32I-NEXT:    or a3, a6, a5
; RV32I-NEXT:    srli a0, a0, 1
; RV32I-NEXT:    srli a1, a1, 1
; RV32I-NEXT:    lui a4, 139810
; RV32I-NEXT:    addi a4, a4, 546
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl1_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip.n a0, a0
; RV32IB-NEXT:    zip.n a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl1_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip.n a0, a0
; RV32IBP-NEXT:    zip.n a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -7378697629483820647
  %shl = shl i64 %a, 1
  %and1 = and i64 %shl, 4919131752989213764
  %or = or i64 %and, %and1
  %shr = lshr i64 %a, 1
  %and2 = and i64 %shr, 2459565876494606882
  %or3 = or i64 %or, %and2
  ret i64 %or3
}

define i32 @shfl2_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl2_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 801852
; RV32I-NEXT:    addi a1, a1, 963
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    lui a3, 197379
; RV32I-NEXT:    addi a3, a3, 48
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    or a1, a2, a1
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    lui a2, 49345
; RV32I-NEXT:    addi a2, a2, -1012
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl2_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip2.b a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl2_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip2.b a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -1010580541
  %shl = shl i32 %a, 2
  %and1 = and i32 %shl, 808464432
  %or = or i32 %and1, %and
  %shr = lshr i32 %a, 2
  %and2 = and i32 %shr, 202116108
  %or3 = or i32 %and2, %or
  ret i32 %or3
}

define i64 @shfl2_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl2_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 801852
; RV32I-NEXT:    addi a2, a2, 963
; RV32I-NEXT:    and a6, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a1, 2
; RV32I-NEXT:    slli a5, a0, 2
; RV32I-NEXT:    lui a3, 197379
; RV32I-NEXT:    addi a3, a3, 48
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    or a2, a2, a3
; RV32I-NEXT:    or a3, a6, a5
; RV32I-NEXT:    srli a0, a0, 2
; RV32I-NEXT:    srli a1, a1, 2
; RV32I-NEXT:    lui a4, 49345
; RV32I-NEXT:    addi a4, a4, -1012
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl2_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip2.b a0, a0
; RV32IB-NEXT:    zip2.b a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl2_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip2.b a0, a0
; RV32IBP-NEXT:    zip2.b a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -4340410370284600381
  %shl = shl i64 %a, 2
  %and1 = and i64 %shl, 3472328296227680304
  %or = or i64 %and, %and1
  %shr = lshr i64 %a, 2
  %and2 = and i64 %shr, 868082074056920076
  %or3 = or i64 %and2, %or
  ret i64 %or3
}

define i32 @shfl4_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl4_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 983295
; RV32I-NEXT:    addi a1, a1, 15
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 4
; RV32I-NEXT:    lui a3, 61441
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a3, 3840
; RV32I-NEXT:    addi a3, a3, 240
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl4_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip4.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl4_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip4.h a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -267390961
  %shl = shl i32 %a, 4
  %and1 = and i32 %shl, 251662080
  %shr = lshr i32 %a, 4
  %and2 = and i32 %shr, 15728880
  %or = or i32 %and2, %and
  %or3 = or i32 %or, %and1
  ret i32 %or3
}

define i64 @shfl4_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl4_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 983295
; RV32I-NEXT:    addi a2, a2, 15
; RV32I-NEXT:    and a6, a1, a2
; RV32I-NEXT:    and a2, a0, a2
; RV32I-NEXT:    slli a4, a1, 4
; RV32I-NEXT:    slli a5, a0, 4
; RV32I-NEXT:    lui a3, 61441
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    srli a1, a1, 4
; RV32I-NEXT:    srli a0, a0, 4
; RV32I-NEXT:    lui a4, 3840
; RV32I-NEXT:    addi a4, a4, 240
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    or a0, a5, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl4_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip4.h a0, a0
; RV32IB-NEXT:    zip4.h a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl4_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip4.h a0, a0
; RV32IBP-NEXT:    zip4.h a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -1148435428713435121
  %shl = shl i64 %a, 4
  %and1 = and i64 %shl, 1080880403494997760
  %shr = lshr i64 %a, 4
  %and2 = and i64 %shr, 67555025218437360
  %or = or i64 %and1, %and2
  %or3 = or i64 %or, %and
  ret i64 %or3
}

define i32 @shfl8_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: shfl8_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1044480
; RV32I-NEXT:    addi a1, a1, 255
; RV32I-NEXT:    and a1, a0, a1
; RV32I-NEXT:    slli a2, a0, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a2, a2, a3
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a3, 16
; RV32I-NEXT:    addi a3, a3, -256
; RV32I-NEXT:    and a0, a0, a3
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl8_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip8 a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl8_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip8 a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, -16776961
  %shl = shl i32 %a, 8
  %and1 = and i32 %shl, 16711680
  %shr = lshr i32 %a, 8
  %and2 = and i32 %shr, 65280
  %or = or i32 %and, %and2
  %or3 = or i32 %or, %and1
  ret i32 %or3
}

define i64 @shfl8_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: shfl8_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 1044480
; RV32I-NEXT:    addi a2, a2, 255
; RV32I-NEXT:    and a6, a0, a2
; RV32I-NEXT:    and a2, a1, a2
; RV32I-NEXT:    slli a4, a0, 8
; RV32I-NEXT:    slli a5, a1, 8
; RV32I-NEXT:    lui a3, 4080
; RV32I-NEXT:    and a5, a5, a3
; RV32I-NEXT:    and a3, a4, a3
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    lui a4, 16
; RV32I-NEXT:    addi a4, a4, -256
; RV32I-NEXT:    and a0, a0, a4
; RV32I-NEXT:    and a1, a1, a4
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    or a0, a3, a0
; RV32I-NEXT:    or a1, a5, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: shfl8_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zip8 a0, a0
; RV32IB-NEXT:    zip8 a1, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: shfl8_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zip8 a0, a0
; RV32IBP-NEXT:    zip8 a1, a1
; RV32IBP-NEXT:    ret
  %and = and i64 %a, -72056494543077121
  %shl = shl i64 %a, 8
  %and1 = and i64 %shl, 71776119077928960
  %shr = lshr i64 %a, 8
  %and2 = and i64 %shr, 280375465148160
  %or = or i64 %and2, %and
  %or3 = or i64 %and1, %or
  ret i64 %or3
}

define i32 @pack_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: pack_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -1
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    slli a1, a1, 16
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: pack_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    pack a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: pack_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    pack a0, a0, a1
; RV32IBP-NEXT:    ret
  %shl = and i32 %a, 65535
  %shl1 = shl i32 %b, 16
  %or = or i32 %shl1, %shl
  ret i32 %or
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the experimental-b
; extension introduce instructions suitable for this pattern.

define i64 @pack_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: pack_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    mv a1, a2
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: pack_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    mv a1, a2
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: pack_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    mv a1, a2
; RV32IBP-NEXT:    ret
  %shl = and i64 %a, 4294967295
  %shl1 = shl i64 %b, 32
  %or = or i64 %shl1, %shl
  ret i64 %or
}

define i32 @packu_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: packu_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    lui a2, 1048560
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: packu_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    packu a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: packu_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    packu a0, a0, a1
; RV32IBP-NEXT:    ret
  %shr = lshr i32 %a, 16
  %shr1 = and i32 %b, -65536
  %or = or i32 %shr1, %shr
  ret i32 %or
}

; As we are not matching directly i64 code patterns on RV32 some i64 patterns
; don't have yet any matching bit manipulation instructions on RV32.
; This test is presented here in case future expansions of the experimental-b
; extension introduce instructions suitable for this pattern.

define i64 @packu_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: packu_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    mv a1, a3
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: packu_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    mv a0, a1
; RV32IB-NEXT:    mv a1, a3
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: packu_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    mv a0, a1
; RV32IBP-NEXT:    mv a1, a3
; RV32IBP-NEXT:    ret
  %shr = lshr i64 %a, 32
  %shr1 = and i64 %b, -4294967296
  %or = or i64 %shr1, %shr
  ret i64 %or
}

define i32 @packh_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: packh_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    slli a1, a1, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: packh_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    packh a0, a0, a1
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: packh_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    packh a0, a0, a1
; RV32IBP-NEXT:    ret
  %and = and i32 %a, 255
  %and1 = shl i32 %b, 8
  %shl = and i32 %and1, 65280
  %or = or i32 %shl, %and
  ret i32 %or
}

define i64 @packh_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: packh_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 255
; RV32I-NEXT:    slli a1, a2, 8
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -256
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    mv a1, zero
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: packh_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    packh a0, a0, a2
; RV32IB-NEXT:    mv a1, zero
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: packh_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    packh a0, a0, a2
; RV32IBP-NEXT:    mv a1, zero
; RV32IBP-NEXT:    ret
  %and = and i64 %a, 255
  %and1 = shl i64 %b, 8
  %shl = and i64 %and1, 65280
  %or = or i64 %shl, %and
  ret i64 %or
}

define i32 @zexth_i32(i32 %a) nounwind {
; RV32I-LABEL: zexth_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: zexth_i32:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zext.h a0, a0
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: zexth_i32:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zext.h a0, a0
; RV32IBP-NEXT:    ret
  %and = and i32 %a, 65535
  ret i32 %and
}

define i64 @zexth_i64(i64 %a) nounwind {
; RV32I-LABEL: zexth_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    mv a1, zero
; RV32I-NEXT:    ret
;
; RV32IB-LABEL: zexth_i64:
; RV32IB:       # %bb.0:
; RV32IB-NEXT:    zext.h a0, a0
; RV32IB-NEXT:    mv a1, zero
; RV32IB-NEXT:    ret
;
; RV32IBP-LABEL: zexth_i64:
; RV32IBP:       # %bb.0:
; RV32IBP-NEXT:    zext.h a0, a0
; RV32IBP-NEXT:    mv a1, zero
; RV32IBP-NEXT:    ret
  %and = and i64 %a, 65535
  ret i64 %and
}
