; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx700 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx803 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9-NODL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx906 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX9-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1011 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1012 -verify-machineinstrs < %s | FileCheck -check-prefixes=GFX10-DL %s

define amdgpu_kernel void @idot4_acc32(<4 x i8> addrspace(1)* %src1,
; GFX7-LABEL: idot4_acc32:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX7-NEXT:    v_bfe_i32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v5, v0, 0, 8
; GFX7-NEXT:    v_bfe_i32 v6, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v1, v1, v5, s4
; GFX7-NEXT:    v_bfe_i32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_i32_i24 v1, v3, v6, v1
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 24, v2
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_i32_i24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_i32_i24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 8
; GFX8-NEXT:    v_bfe_i32 v4, v3, 8, 8
; GFX8-NEXT:    v_bfe_i32 v6, v3, 16, 8
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 8
; GFX8-NEXT:    v_bfe_i32 v5, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v1, v1, v2, s2
; GFX8-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX8-NEXT:    v_mad_i32_i24 v1, v4, v5, v1
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX8-NEXT:    v_mad_i32_i24 v1, v6, v7, v1
; GFX8-NEXT:    v_mad_i32_i24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v4, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v5, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v2, v3, s0, v4
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v5, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-DL-NEXT:    v_dot4_i32_i8 v0, v2, v3, s0
; GFX9-DL-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-DL-NEXT:    v_dot4_i32_i8 v1, v1, v2, s2
; GFX10-DL-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                       <4 x i8> addrspace(1)* %src2,
                                       i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i8>, <4 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i8>, <4 x i8> addrspace(1)* %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = sext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = sext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = sext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = sext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = sext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = sext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = sext i8 %v1e3 to i32
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = sext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %acc = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul1, %acc
  %add2 = add i32 %add1, %mul2
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4
  store i32 %add4, i32 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Currently, vector elements{0 and 3} get zero_extended from i16 to i32 which should
; be sign_extended directly to i32; prevents the pattern recognizer to recognize this pattern.
define amdgpu_kernel void @idot4_acc16(<4 x i8> addrspace(1)* %src1,
; GFX7-LABEL: idot4_acc16:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v8, off, s[0:3], 0
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX7-NEXT:    v_bfe_i32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v5, v0, 0, 8
; GFX7-NEXT:    v_bfe_i32 v6, v0, 8, 8
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX7-NEXT:    v_and_b32_e32 v5, s4, v5
; GFX7-NEXT:    v_bfe_i32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s4, v6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v8
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 24, v2
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s4, v4
; GFX7-NEXT:    v_and_b32_e32 v7, s4, v7
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    flat_load_ushort v1, v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 8, v4
; GFX8-NEXT:    v_bfe_i32 v7, v4, 0, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 24, v4
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 8, v0
; GFX8-NEXT:    v_bfe_i32 v8, v0, 0, 8
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_bfe_i32 v10, v10, 0, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v1, v7, v8, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX8-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX8-NEXT:    v_mad_u16 v1, v9, v10, v1
; GFX8-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX8-NEXT:    v_mad_u16 v1, v5, v6, v1
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v1
; GFX8-NEXT:    flat_store_short v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc16:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NODL-NEXT:    global_load_ushort v4, v1, s[2:3]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v9, 8, v3
; GFX9-NODL-NEXT:    v_bfe_i32 v6, v2, 0, 8
; GFX9-NODL-NEXT:    v_bfe_i32 v7, v3, 0, 8
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-NODL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX9-NODL-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v4, v6, v7, v4
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX9-NODL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX9-NODL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v4, v8, v9, v4
; GFX9-NODL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX9-NODL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v0, v5, v4
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v2, v3, v0
; GFX9-NODL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc16:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ushort v4, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 8, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v9, 8, v3
; GFX9-DL-NEXT:    v_bfe_i32 v6, v2, 0, 8
; GFX9-DL-NEXT:    v_bfe_i32 v7, v3, 0, 8
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-DL-NEXT:    v_bfe_i32 v8, v8, 0, 8
; GFX9-DL-NEXT:    v_bfe_i32 v9, v9, 0, 8
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v4, v6, v7, v4
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX9-DL-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX9-DL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX9-DL-NEXT:    v_mad_legacy_u16 v4, v8, v9, v4
; GFX9-DL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX9-DL-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v5, v4
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v2, v3, v0
; GFX9-DL-NEXT:    global_store_short v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc16:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v6, 8, v2
; GFX10-DL-NEXT:    v_bfe_i32 v4, v1, 0, 8
; GFX10-DL-NEXT:    v_bfe_i32 v10, v2, 0, 8
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v9, 16, v2
; GFX10-DL-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX10-DL-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v3, v4, v10, v3
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v1, 24, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX10-DL-NEXT:    v_bfe_i32 v4, v8, 0, 8
; GFX10-DL-NEXT:    v_bfe_i32 v10, v9, 0, 8
; GFX10-DL-NEXT:    v_mad_u16 v3, v5, v6, v3
; GFX10-DL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX10-DL-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX10-DL-NEXT:    v_mad_u16 v3, v4, v10, v3
; GFX10-DL-NEXT:    v_mad_u16 v1, v1, v2, v3
; GFX10-DL-NEXT:    global_store_short v0, v1, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                       <4 x i8> addrspace(1)* %src2,
                                       i16 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i8>, <4 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i8>, <4 x i8> addrspace(1)* %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = sext i8 %v1e0 to i16
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = sext i8 %v2e0 to i16
  %mul1 = mul nsw i16 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = sext i8 %v1e1 to i16
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = sext i8 %v2e1 to i16
  %mul2 = mul nsw i16 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = sext i8 %v1e2 to i16
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = sext i8 %v2e2 to i16
  %mul3 = mul nsw i16 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = sext i8 %v1e3 to i16
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = sext i8 %v2e3 to i16
  %mul4 = mul nsw i16 %cv1e3, %cv2e3

  %acc = load i16, i16 addrspace(1)* %dst, align 2
  %add1 = add i16 %mul1, %acc
  %add2 = add i16 %add1, %mul2
  %add3 = add i16 %add2, %mul3
  %add4 = add i16 %add3, %mul4
  store i16 %add4, i16 addrspace(1)* %dst, align 2
  ret void
}

define amdgpu_kernel void @idot4_acc8(<4 x i8> addrspace(1)* %src1,
; GFX7-LABEL: idot4_acc8:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ubyte v8, off, s[0:3], 0
; GFX7-NEXT:    s_movk_i32 s4, 0xff
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v2
; GFX7-NEXT:    v_bfe_u32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_and_b32_e32 v5, s4, v0
; GFX7-NEXT:    v_bfe_u32 v6, v0, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v5, v8
; GFX7-NEXT:    v_bfe_u32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_u32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_u32_u24 v1, v3, v6, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_byte v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc8:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_ubyte v5, v[2:3]
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 8, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 24, v4
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 8, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 24, v0
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v5
; GFX8-NEXT:    v_mad_u16 v0, v7, v8, v0
; GFX8-NEXT:    v_mad_u16 v0, v1, v6, v0
; GFX8-NEXT:    v_mad_u16 v0, v9, v10, v0
; GFX8-NEXT:    flat_store_byte v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc8:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-NODL-NEXT:    global_load_ubyte v4, v1, s[2:3]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 8, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v8, 24, v2
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v4
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v2, v6, v7, v2
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v0, v5, v2
; GFX9-NODL-NEXT:    v_mad_legacy_u16 v0, v8, v9, v0
; GFX9-NODL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc8:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX9-DL-NEXT:    global_load_ubyte v4, v1, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v0, 16, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 8, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v8, 24, v2
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v7, 8, v3
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v2, v3, v4
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX9-DL-NEXT:    v_mad_legacy_u16 v2, v6, v7, v2
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v9, 24, v3
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v0, v5, v2
; GFX9-DL-NEXT:    v_mad_legacy_u16 v0, v8, v9, v0
; GFX9-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc8:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v3, v0, s[6:7]
; GFX10-DL-NEXT:    global_load_ubyte v4, v1, s[2:3]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v11, 8, v2
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 8, v3
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_mad_u16 v4, v2, v3, v4
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 24, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 24, v3
; GFX10-DL-NEXT:    v_mad_u16 v0, v11, v5, v4
; GFX10-DL-NEXT:    v_mad_u16 v0, v6, v7, v0
; GFX10-DL-NEXT:    v_mad_u16 v0, v2, v3, v0
; GFX10-DL-NEXT:    global_store_byte v1, v0, s[2:3]
; GFX10-DL-NEXT:    s_endpgm
                                      <4 x i8> addrspace(1)* %src2,
                                      i8 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i8>, <4 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i8>, <4 x i8> addrspace(1)* %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %mul1 = mul i8 %v1e0, %v2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %mul2 = mul i8 %v1e1, %v2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %mul3 = mul i8 %v1e2, %v2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %mul4 = mul i8 %v1e3, %v2e3

  %acc = load i8, i8 addrspace(1)* %dst, align 2
  %add1 = add i8 %mul1, %acc
  %add2 = add i8 %add1, %mul2
  %add3 = add i8 %add2, %mul3
  %add4 = add nsw i8 %add3, %mul4
  store i8 %add4, i8 addrspace(1)* %dst, align 2
  ret void
}

define amdgpu_kernel void @idot4_multiuse_mul1(<4 x i8> addrspace(1)* %src1,
; GFX7-LABEL: idot4_multiuse_mul1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 0, 8
; GFX7-NEXT:    v_bfe_i32 v3, v2, 8, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v5, v0, 0, 8
; GFX7-NEXT:    v_bfe_i32 v6, v0, 8, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v8, v1, v5, s4
; GFX7-NEXT:    v_mad_i32_i24 v3, v3, v6, v8
; GFX7-NEXT:    v_bfe_i32 v4, v2, 16, 8
; GFX7-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX7-NEXT:    v_mad_i32_i24 v1, v1, v5, v3
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 24, v2
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX7-NEXT:    v_mad_i32_i24 v1, v4, v7, v1
; GFX7-NEXT:    v_mad_i32_i24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_multiuse_mul1:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_bfe_i32 v1, v3, 0, 8
; GFX8-NEXT:    v_bfe_i32 v4, v3, 8, 8
; GFX8-NEXT:    v_bfe_i32 v6, v3, 16, 8
; GFX8-NEXT:    v_ashrrev_i32_e32 v3, 24, v3
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_bfe_i32 v2, v0, 0, 8
; GFX8-NEXT:    v_bfe_i32 v5, v0, 8, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v8, v1, v2, s2
; GFX8-NEXT:    v_mad_i32_i24 v4, v4, v5, v8
; GFX8-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX8-NEXT:    v_mad_i32_i24 v1, v1, v2, v4
; GFX8-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX8-NEXT:    v_mad_i32_i24 v1, v6, v7, v1
; GFX8-NEXT:    v_mad_i32_i24 v2, v3, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_multiuse_mul1:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_bfe_i32 v3, v1, 0, 8
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_bfe_i32 v4, v2, 0, 8
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v5, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v6, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mul_i32_i24_e32 v2, v3, v4
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_mad_i32_i24 v3, v3, v4, s0
; GFX9-NODL-NEXT:    v_add3_u32 v2, v5, v3, v2
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_multiuse_mul1:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_bfe_i32 v3, v1, 0, 8
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_bfe_i32 v4, v2, 0, 8
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v5, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v6, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_mul_i32_i24_e32 v2, v3, v4
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_mad_i32_i24 v3, v3, v4, s0
; GFX9-DL-NEXT:    v_add3_u32 v2, v5, v3, v2
; GFX9-DL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_multiuse_mul1:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_bfe_i32 v0, v1, 0, 8
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_bfe_i32 v3, v2, 0, 8
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v7, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:BYTE_1
; GFX10-DL-NEXT:    v_mul_i32_i24_e32 v5, v0, v3
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_mad_i32_i24 v0, v0, v3, s2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    v_add3_u32 v0, v7, v0, v5
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v3, v1
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                               <4 x i8> addrspace(1)* %src2,
                                               i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i8>, <4 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i8>, <4 x i8> addrspace(1)* %gep2

  %v1e0 = extractelement <4 x i8> %vec1, i64 0
  %cv1e0 = sext i8 %v1e0 to i32
  %v2e0 = extractelement <4 x i8> %vec2, i64 0
  %cv2e0 = sext i8 %v2e0 to i32
  %mul1 = mul nuw nsw i32 %cv1e0, %cv2e0

  %v1e1 = extractelement <4 x i8> %vec1, i64 1
  %cv1e1 = sext i8 %v1e1 to i32
  %v2e1 = extractelement <4 x i8> %vec2, i64 1
  %cv2e1 = sext i8 %v2e1 to i32
  %mul2 = mul nuw nsw i32 %cv1e1, %cv2e1

  %v1e2 = extractelement <4 x i8> %vec1, i64 2
  %cv1e2 = sext i8 %v1e2 to i32
  %v2e2 = extractelement <4 x i8> %vec2, i64 2
  %cv2e2 = sext i8 %v2e2 to i32
  %mul3 = mul nuw nsw i32 %cv1e2, %cv2e2

  %v1e3 = extractelement <4 x i8> %vec1, i64 3
  %cv1e3 = sext i8 %v1e3 to i32
  %v2e3 = extractelement <4 x i8> %vec2, i64 3
  %cv2e3 = sext i8 %v2e3 to i32
  %mul4 = mul nuw nsw i32 %cv1e3, %cv2e3

  %acc = load i32, i32 addrspace(1)* %dst, align 4
  %add = add i32 %mul1, %acc
  %add1 = add i32 %mul2, %add
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul3
  %add4 = add i32 %add3, %mul4

  store i32 %add4, i32 addrspace(1)* %dst, align 4
  ret void
}

; TODO: Support this pattern.
define amdgpu_kernel void @idot4_acc32_vecMul(<4 x i8> addrspace(1)* %src1,
; GFX7-LABEL: idot4_acc32_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_load_dword s4, s[0:1], 0x0
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_ashrrev_i32_e32 v1, 24, v2
; GFX7-NEXT:    v_bfe_i32 v3, v2, 16, 8
; GFX7-NEXT:    v_bfe_i32 v4, v2, 8, 8
; GFX7-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_ashrrev_i32_e32 v5, 24, v0
; GFX7-NEXT:    v_bfe_i32 v6, v0, 16, 8
; GFX7-NEXT:    v_bfe_i32 v7, v0, 8, 8
; GFX7-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mad_i32_i24 v0, v2, v0, s4
; GFX7-NEXT:    v_mad_i32_i24 v0, v4, v7, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v3, v6, v0
; GFX7-NEXT:    v_mad_i32_i24 v0, v1, v5, v0
; GFX7-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc32_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v3, v[0:1]
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b16_e32 v1, 8, v3
; GFX8-NEXT:    v_ashrrev_i32_e32 v4, 24, v3
; GFX8-NEXT:    v_bfe_i32 v5, v3, 16, 8
; GFX8-NEXT:    v_bfe_i32 v3, v3, 0, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_lshrrev_b16_e32 v2, 8, v0
; GFX8-NEXT:    v_ashrrev_i32_e32 v6, 24, v0
; GFX8-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX8-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX8-NEXT:    v_bfe_i32 v2, v2, 0, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mad_i32_i24 v0, v3, v0, s2
; GFX8-NEXT:    v_mad_i32_i24 v0, v1, v2, v0
; GFX8-NEXT:    v_mad_i32_i24 v0, v5, v7, v0
; GFX8-NEXT:    v_mad_i32_i24 v2, v4, v6, v0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc32_vecMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b16_e32 v3, 8, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_lshrrev_b16_e32 v4, 8, v2
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v5, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v6, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-NODL-NEXT:    v_mul_i32_i24_sdwa v2, sext(v3), sext(v4) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    v_add3_u32 v2, v5, s0, v2
; GFX9-NODL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-NODL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc32_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    s_load_dword s0, s[2:3], 0x0
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b16_e32 v3, 8, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_lshrrev_b16_e32 v4, 8, v2
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v5, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v6, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX9-DL-NEXT:    v_mul_i32_i24_sdwa v2, sext(v3), sext(v4) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    v_add3_u32 v2, v5, s0, v2
; GFX9-DL-NEXT:    v_add3_u32 v1, v2, v6, v1
; GFX9-DL-NEXT:    global_store_dword v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc32_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    s_load_dword s2, s[0:1], 0x0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_lshrrev_b16_e64 v0, 8, v1
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_lshrrev_b16_e64 v3, 8, v2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v7, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v0, sext(v0), sext(v3) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:BYTE_0
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v3, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:BYTE_2
; GFX10-DL-NEXT:    v_mul_i32_i24_sdwa v1, sext(v1), sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:BYTE_3
; GFX10-DL-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    v_add3_u32 v0, v7, s2, v0
; GFX10-DL-NEXT:    v_add3_u32 v0, v0, v3, v1
; GFX10-DL-NEXT:    global_store_dword v2, v0, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                              <4 x i8> addrspace(1)* %src2,
                                              i32 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i8>, <4 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i8>, <4 x i8> addrspace(1)* %gep2

  %cvec1 = sext <4 x i8> %vec1 to <4 x i32>
  %cvec2 = sext <4 x i8> %vec2 to <4 x i32>

  %mul = mul <4 x i32> %cvec1, %cvec2
  %mul0 = extractelement <4 x i32> %mul, i64 0
  %mul1 = extractelement <4 x i32> %mul, i64 1
  %mul2 = extractelement <4 x i32> %mul, i64 2
  %mul3 = extractelement <4 x i32> %mul, i64 3

  %acc = load i32, i32 addrspace(1)* %dst, align 4
  %add1 = add i32 %mul0, %acc
  %add2 = add i32 %add1, %mul1
  %add3 = add i32 %add2, %mul2
  %add4 = add i32 %add3, %mul3

  store i32 %add4, i32 addrspace(1)* %dst, align 4
  ret void
}

define amdgpu_kernel void @idot4_acc16_vecMul(<4 x i8> addrspace(1)* %src1,
; GFX7-LABEL: idot4_acc16_vecMul:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x9
; GFX7-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0xd
; GFX7-NEXT:    s_mov_b32 s3, 0xf000
; GFX7-NEXT:    s_mov_b32 s10, 0
; GFX7-NEXT:    s_mov_b32 s11, s3
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b64 s[8:9], s[4:5]
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, 0
; GFX7-NEXT:    buffer_load_dword v2, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b64 s[8:9], s[6:7]
; GFX7-NEXT:    buffer_load_dword v0, v[0:1], s[8:11], 0 addr64
; GFX7-NEXT:    s_mov_b32 s2, -1
; GFX7-NEXT:    buffer_load_ushort v8, off, s[0:3], 0
; GFX7-NEXT:    s_mov_b32 s4, 0xffff
; GFX7-NEXT:    s_waitcnt vmcnt(2)
; GFX7-NEXT:    v_bfe_i32 v1, v2, 8, 8
; GFX7-NEXT:    v_bfe_i32 v3, v2, 0, 8
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v3
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_bfe_i32 v5, v0, 8, 8
; GFX7-NEXT:    v_bfe_i32 v6, v0, 0, 8
; GFX7-NEXT:    v_or_b32_e32 v1, v3, v1
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX7-NEXT:    v_and_b32_e32 v5, s4, v6
; GFX7-NEXT:    v_bfe_i32 v7, v0, 16, 8
; GFX7-NEXT:    v_or_b32_e32 v3, v5, v3
; GFX7-NEXT:    v_and_b32_e32 v6, s4, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v1, s4, v1
; GFX7-NEXT:    v_and_b32_e32 v3, s4, v3
; GFX7-NEXT:    v_bfe_i32 v4, v2, 16, 8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mad_u32_u24 v1, v1, v3, v8
; GFX7-NEXT:    v_ashrrev_i32_e32 v2, 24, v2
; GFX7-NEXT:    v_ashrrev_i32_e32 v0, 24, v0
; GFX7-NEXT:    v_and_b32_e32 v4, s4, v4
; GFX7-NEXT:    v_mad_u32_u24 v1, v5, v7, v1
; GFX7-NEXT:    v_and_b32_e32 v2, s4, v2
; GFX7-NEXT:    v_and_b32_e32 v0, s4, v0
; GFX7-NEXT:    v_mad_u32_u24 v1, v4, v6, v1
; GFX7-NEXT:    v_mad_u32_u24 v0, v2, v0, v1
; GFX7-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX7-NEXT:    s_endpgm
;
; GFX8-LABEL: idot4_acc16_vecMul:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s5
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    flat_load_dword v4, v[0:1]
; GFX8-NEXT:    v_add_u32_e32 v0, vcc, s6, v2
; GFX8-NEXT:    v_mov_b32_e32 v1, s7
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_load_dword v0, v[0:1]
; GFX8-NEXT:    flat_load_ushort v1, v[2:3]
; GFX8-NEXT:    s_waitcnt vmcnt(2)
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_ashrrev_i16_e32 v7, 8, v4
; GFX8-NEXT:    v_bfe_i32 v4, v4, 0, 8
; GFX8-NEXT:    v_ashrrev_i16_e32 v9, 8, v5
; GFX8-NEXT:    v_bfe_i32 v5, v5, 0, 8
; GFX8-NEXT:    s_waitcnt vmcnt(1)
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_ashrrev_i16_e32 v8, 8, v0
; GFX8-NEXT:    v_bfe_i32 v0, v0, 0, 8
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    v_mad_u16 v0, v4, v0, v1
; GFX8-NEXT:    v_ashrrev_i16_e32 v10, 8, v6
; GFX8-NEXT:    v_bfe_i32 v6, v6, 0, 8
; GFX8-NEXT:    v_mad_u16 v0, v7, v8, v0
; GFX8-NEXT:    v_mad_u16 v0, v5, v6, v0
; GFX8-NEXT:    v_mad_u16 v0, v9, v10, v0
; GFX8-NEXT:    flat_store_short v[2:3], v0
; GFX8-NEXT:    s_endpgm
;
; GFX9-NODL-LABEL: idot4_acc16_vecMul:
; GFX9-NODL:       ; %bb.0: ; %entry
; GFX9-NODL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-NODL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-NODL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NODL-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-NODL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NODL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NODL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-NODL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NODL-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NODL-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-NODL-NEXT:    v_ashrrev_i16_e32 v7, 8, v1
; GFX9-NODL-NEXT:    v_and_b32_sdwa v1, v4, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_ashrrev_i16_e32 v8, 8, v2
; GFX9-NODL-NEXT:    v_and_b32_sdwa v2, v4, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_lshl_or_b32 v2, v8, 16, v2
; GFX9-NODL-NEXT:    v_lshl_or_b32 v1, v7, 16, v1
; GFX9-NODL-NEXT:    v_ashrrev_i16_e32 v10, 8, v6
; GFX9-NODL-NEXT:    v_and_b32_sdwa v6, v4, sext(v6) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NODL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-NODL-NEXT:    v_ashrrev_i16_e32 v9, 8, v5
; GFX9-NODL-NEXT:    v_and_b32_sdwa v4, v4, sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NODL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NODL-NEXT:    v_add_u16_e32 v3, v1, v3
; GFX9-NODL-NEXT:    v_lshl_or_b32 v5, v10, 16, v6
; GFX9-NODL-NEXT:    v_lshl_or_b32 v4, v9, 16, v4
; GFX9-NODL-NEXT:    v_pk_mul_lo_u16 v2, v4, v5
; GFX9-NODL-NEXT:    v_add_u16_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NODL-NEXT:    v_add_u16_e32 v1, v1, v2
; GFX9-NODL-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NODL-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-NODL-NEXT:    s_endpgm
;
; GFX9-DL-LABEL: idot4_acc16_vecMul:
; GFX9-DL:       ; %bb.0: ; %entry
; GFX9-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX9-DL-NEXT:    s_load_dwordx2 s[2:3], s[0:1], 0x34
; GFX9-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-DL-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX9-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX9-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-DL-NEXT:    global_load_ushort v3, v0, s[2:3]
; GFX9-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v1
; GFX9-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX9-DL-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v7, 8, v1
; GFX9-DL-NEXT:    v_and_b32_sdwa v1, v4, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v8, 8, v2
; GFX9-DL-NEXT:    v_and_b32_sdwa v2, v4, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-DL-NEXT:    v_lshl_or_b32 v2, v8, 16, v2
; GFX9-DL-NEXT:    v_lshl_or_b32 v1, v7, 16, v1
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v10, 8, v6
; GFX9-DL-NEXT:    v_and_b32_sdwa v6, v4, sext(v6) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX9-DL-NEXT:    v_ashrrev_i16_e32 v9, 8, v5
; GFX9-DL-NEXT:    v_and_b32_sdwa v4, v4, sext(v5) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-DL-NEXT:    v_add_u16_e32 v3, v1, v3
; GFX9-DL-NEXT:    v_lshl_or_b32 v5, v10, 16, v6
; GFX9-DL-NEXT:    v_lshl_or_b32 v4, v9, 16, v4
; GFX9-DL-NEXT:    v_pk_mul_lo_u16 v2, v4, v5
; GFX9-DL-NEXT:    v_add_u16_sdwa v1, v3, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    v_add_u16_e32 v1, v1, v2
; GFX9-DL-NEXT:    v_add_u16_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-DL-NEXT:    global_store_short v0, v1, s[2:3]
; GFX9-DL-NEXT:    s_endpgm
;
; GFX10-DL-LABEL: idot4_acc16_vecMul:
; GFX10-DL:       ; %bb.0: ; %entry
; GFX10-DL-NEXT:    s_load_dwordx4 s[4:7], s[0:1], 0x24
; GFX10-DL-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-DL-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x34
; GFX10-DL-NEXT:    v_mov_b32_e32 v4, 0xffff
; GFX10-DL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-DL-NEXT:    s_clause 0x1
; GFX10-DL-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX10-DL-NEXT:    global_load_dword v2, v0, s[6:7]
; GFX10-DL-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-DL-NEXT:    global_load_ushort v3, v0, s[0:1]
; GFX10-DL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v5, 8, v1
; GFX10-DL-NEXT:    v_and_b32_sdwa v8, v4, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-DL-NEXT:    s_waitcnt vmcnt(1)
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v6, 8, v2
; GFX10-DL-NEXT:    v_and_b32_sdwa v7, v4, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX10-DL-NEXT:    v_lshl_or_b32 v5, v5, 16, v8
; GFX10-DL-NEXT:    v_lshl_or_b32 v6, v6, 16, v7
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v7, 8, v1
; GFX10-DL-NEXT:    v_and_b32_sdwa v1, v4, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-DL-NEXT:    v_ashrrev_i16_e64 v8, 8, v2
; GFX10-DL-NEXT:    v_and_b32_sdwa v2, v4, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v4, v5, v6
; GFX10-DL-NEXT:    v_lshl_or_b32 v1, v7, 16, v1
; GFX10-DL-NEXT:    v_lshl_or_b32 v2, v8, 16, v2
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX10-DL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-DL-NEXT:    v_add_nc_u16_e64 v3, v4, v3
; GFX10-DL-NEXT:    v_pk_mul_lo_u16 v1, v1, v2
; GFX10-DL-NEXT:    v_add_nc_u16_e64 v2, v3, v5
; GFX10-DL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX10-DL-NEXT:    v_add_nc_u16_e64 v1, v2, v1
; GFX10-DL-NEXT:    v_add_nc_u16_e64 v1, v1, v3
; GFX10-DL-NEXT:    global_store_short v0, v1, s[0:1]
; GFX10-DL-NEXT:    s_endpgm
                                              <4 x i8> addrspace(1)* %src2,
                                              i16 addrspace(1)* nocapture %dst) {
entry:
  %idx = call i32 @llvm.amdgcn.workitem.id.x()
  %gep1 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src1, i32 %idx
  %vec1 = load <4 x i8>, <4 x i8> addrspace(1)* %gep1
  %gep2 = getelementptr <4 x i8>, <4 x i8> addrspace(1)* %src2, i32 %idx
  %vec2 = load <4 x i8>, <4 x i8> addrspace(1)* %gep2

  %cvec1 = sext <4 x i8> %vec1 to <4 x i16>
  %cvec2 = sext <4 x i8> %vec2 to <4 x i16>

  %mul = mul <4 x i16> %cvec1, %cvec2
  %mul0 = extractelement <4 x i16> %mul, i64 0
  %mul1 = extractelement <4 x i16> %mul, i64 1
  %mul2 = extractelement <4 x i16> %mul, i64 2
  %mul3 = extractelement <4 x i16> %mul, i64 3

  %acc = load i16, i16 addrspace(1)* %dst, align 4
  %add1 = add i16 %mul0, %acc
  %add2 = add i16 %add1, %mul1
  %add3 = add i16 %add2, %mul2
  %add4 = add i16 %add3, %mul3

  store i16 %add4, i16 addrspace(1)* %dst, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
