; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=tahiti -verify-machineinstrs -simplify-mir -stop-after=instruction-select -o - %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii -verify-machineinstrs -simplify-mir -stop-after=instruction-select -o - %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji -verify-machineinstrs -simplify-mir -stop-after=instruction-select -o - %s | FileCheck -check-prefix=GFX8 %s

; FIXME: Merge with regbankselect, which mostly overlaps when all types supported.

; Natural mapping
define amdgpu_ps i32 @s_buffer_load_i32(<4 x i32> inreg %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_i32
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY5]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY5]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY5]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_glc(<4 x i32> inreg %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_i32_glc
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[COPY4]], 1 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY5]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_glc
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[COPY4]], 1 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY5]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_glc
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[COPY4]], 1 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY5]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 %soffset, i32 1)
  ret i32 %val
}

define amdgpu_ps <2 x i32> @s_buffer_load_v2i32(<4 x i32> inreg %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v2i32
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_BUFFER_LOAD_DWORDX2_SGPR:%[0-9]+]]:sreg_64_xexec = S_BUFFER_LOAD_DWORDX2_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 8, align 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX2_SGPR]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX2_SGPR]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY7]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY8]], implicit $exec
  ; GFX6:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1
  ; GFX7-LABEL: name: s_buffer_load_v2i32
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_BUFFER_LOAD_DWORDX2_SGPR:%[0-9]+]]:sreg_64_xexec = S_BUFFER_LOAD_DWORDX2_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 8, align 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX2_SGPR]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX2_SGPR]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY7]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY8]], implicit $exec
  ; GFX7:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1
  ; GFX8-LABEL: name: s_buffer_load_v2i32
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_BUFFER_LOAD_DWORDX2_SGPR:%[0-9]+]]:sreg_64_xexec = S_BUFFER_LOAD_DWORDX2_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 8, align 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX2_SGPR]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX2_SGPR]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY7]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY8]], implicit $exec
  ; GFX8:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1
  %val = call <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <2 x i32> %val
}

define amdgpu_ps <3 x i32> @s_buffer_load_v3i32(<4 x i32> inreg %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v3i32
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_BUFFER_LOAD_DWORDX4_SGPR:%[0-9]+]]:sgpr_128 = S_BUFFER_LOAD_DWORDX4_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 12, align 4)
  ; GFX6:   [[DEF:%[0-9]+]]:sgpr_128 = IMPLICIT_DEF
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_512 = REG_SEQUENCE [[S_BUFFER_LOAD_DWORDX4_SGPR]], %subreg.sub0_sub1_sub2_sub3, [[DEF]], %subreg.sub4_sub5_sub6_sub7, [[DEF]], %subreg.sub8_sub9_sub10_sub11
  ; GFX6:   [[COPY5:%[0-9]+]]:sgpr_512_with_sub0_sub1_sub2 = COPY [[REG_SEQUENCE1]]
  ; GFX6:   [[COPY6:%[0-9]+]]:sgpr_96 = COPY [[COPY5]].sub0_sub1_sub2
  ; GFX6:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub0
  ; GFX6:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub1
  ; GFX6:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub2
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY10]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY11]], implicit $exec
  ; GFX6:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY12]], implicit $exec
  ; GFX6:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2
  ; GFX7-LABEL: name: s_buffer_load_v3i32
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_BUFFER_LOAD_DWORDX4_SGPR:%[0-9]+]]:sgpr_128 = S_BUFFER_LOAD_DWORDX4_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 12, align 4)
  ; GFX7:   [[DEF:%[0-9]+]]:sgpr_128 = IMPLICIT_DEF
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_512 = REG_SEQUENCE [[S_BUFFER_LOAD_DWORDX4_SGPR]], %subreg.sub0_sub1_sub2_sub3, [[DEF]], %subreg.sub4_sub5_sub6_sub7, [[DEF]], %subreg.sub8_sub9_sub10_sub11
  ; GFX7:   [[COPY5:%[0-9]+]]:sgpr_512_with_sub0_sub1_sub2 = COPY [[REG_SEQUENCE1]]
  ; GFX7:   [[COPY6:%[0-9]+]]:sgpr_96 = COPY [[COPY5]].sub0_sub1_sub2
  ; GFX7:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub0
  ; GFX7:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub1
  ; GFX7:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub2
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY10]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY11]], implicit $exec
  ; GFX7:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY12]], implicit $exec
  ; GFX7:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2
  ; GFX8-LABEL: name: s_buffer_load_v3i32
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_BUFFER_LOAD_DWORDX4_SGPR:%[0-9]+]]:sgpr_128 = S_BUFFER_LOAD_DWORDX4_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 12, align 4)
  ; GFX8:   [[DEF:%[0-9]+]]:sgpr_128 = IMPLICIT_DEF
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_512 = REG_SEQUENCE [[S_BUFFER_LOAD_DWORDX4_SGPR]], %subreg.sub0_sub1_sub2_sub3, [[DEF]], %subreg.sub4_sub5_sub6_sub7, [[DEF]], %subreg.sub8_sub9_sub10_sub11
  ; GFX8:   [[COPY5:%[0-9]+]]:sgpr_512_with_sub0_sub1_sub2 = COPY [[REG_SEQUENCE1]]
  ; GFX8:   [[COPY6:%[0-9]+]]:sgpr_96 = COPY [[COPY5]].sub0_sub1_sub2
  ; GFX8:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub0
  ; GFX8:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub1
  ; GFX8:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[COPY6]].sub2
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY10]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY11]], implicit $exec
  ; GFX8:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY12]], implicit $exec
  ; GFX8:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2
  %val = call <3 x i32> @llvm.amdgcn.s.buffer.load.v3i32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <3 x i32> %val
}

define amdgpu_ps <8 x i32> @s_buffer_load_v8i32(<4 x i32> inreg %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v8i32
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_BUFFER_LOAD_DWORDX8_SGPR:%[0-9]+]]:sgpr_256 = S_BUFFER_LOAD_DWORDX8_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 32, align 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub7
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY13]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY14]], implicit $exec
  ; GFX6:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX6:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY15]], implicit $exec
  ; GFX6:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX6:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY16]], implicit $exec
  ; GFX6:   $sgpr3 = COPY [[V_READFIRSTLANE_B32_3]]
  ; GFX6:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX6:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY17]], implicit $exec
  ; GFX6:   $sgpr4 = COPY [[V_READFIRSTLANE_B32_4]]
  ; GFX6:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GFX6:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY18]], implicit $exec
  ; GFX6:   $sgpr5 = COPY [[V_READFIRSTLANE_B32_5]]
  ; GFX6:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; GFX6:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY19]], implicit $exec
  ; GFX6:   $sgpr6 = COPY [[V_READFIRSTLANE_B32_6]]
  ; GFX6:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; GFX6:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY20]], implicit $exec
  ; GFX6:   $sgpr7 = COPY [[V_READFIRSTLANE_B32_7]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $sgpr3, implicit $sgpr4, implicit $sgpr5, implicit $sgpr6, implicit $sgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8i32
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_BUFFER_LOAD_DWORDX8_SGPR:%[0-9]+]]:sgpr_256 = S_BUFFER_LOAD_DWORDX8_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 32, align 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub7
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY13]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY14]], implicit $exec
  ; GFX7:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX7:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY15]], implicit $exec
  ; GFX7:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX7:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY16]], implicit $exec
  ; GFX7:   $sgpr3 = COPY [[V_READFIRSTLANE_B32_3]]
  ; GFX7:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX7:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY17]], implicit $exec
  ; GFX7:   $sgpr4 = COPY [[V_READFIRSTLANE_B32_4]]
  ; GFX7:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GFX7:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY18]], implicit $exec
  ; GFX7:   $sgpr5 = COPY [[V_READFIRSTLANE_B32_5]]
  ; GFX7:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; GFX7:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY19]], implicit $exec
  ; GFX7:   $sgpr6 = COPY [[V_READFIRSTLANE_B32_6]]
  ; GFX7:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; GFX7:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY20]], implicit $exec
  ; GFX7:   $sgpr7 = COPY [[V_READFIRSTLANE_B32_7]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $sgpr3, implicit $sgpr4, implicit $sgpr5, implicit $sgpr6, implicit $sgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8i32
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_BUFFER_LOAD_DWORDX8_SGPR:%[0-9]+]]:sgpr_256 = S_BUFFER_LOAD_DWORDX8_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 32, align 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX8_SGPR]].sub7
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY13]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY14]], implicit $exec
  ; GFX8:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX8:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY15]], implicit $exec
  ; GFX8:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX8:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY16]], implicit $exec
  ; GFX8:   $sgpr3 = COPY [[V_READFIRSTLANE_B32_3]]
  ; GFX8:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX8:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY17]], implicit $exec
  ; GFX8:   $sgpr4 = COPY [[V_READFIRSTLANE_B32_4]]
  ; GFX8:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GFX8:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY18]], implicit $exec
  ; GFX8:   $sgpr5 = COPY [[V_READFIRSTLANE_B32_5]]
  ; GFX8:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; GFX8:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY19]], implicit $exec
  ; GFX8:   $sgpr6 = COPY [[V_READFIRSTLANE_B32_6]]
  ; GFX8:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; GFX8:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY20]], implicit $exec
  ; GFX8:   $sgpr7 = COPY [[V_READFIRSTLANE_B32_7]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $sgpr3, implicit $sgpr4, implicit $sgpr5, implicit $sgpr6, implicit $sgpr7
  %val = call <8 x i32> @llvm.amdgcn.s.buffer.load.v8i32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x i32> %val
}

define amdgpu_ps <16 x i32> @s_buffer_load_v16i32(<4 x i32> inreg %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v16i32
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_BUFFER_LOAD_DWORDX16_SGPR:%[0-9]+]]:sgpr_512 = S_BUFFER_LOAD_DWORDX16_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 64, align 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub7
  ; GFX6:   [[COPY13:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub8
  ; GFX6:   [[COPY14:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub9
  ; GFX6:   [[COPY15:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub10
  ; GFX6:   [[COPY16:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub11
  ; GFX6:   [[COPY17:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub12
  ; GFX6:   [[COPY18:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub13
  ; GFX6:   [[COPY19:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub14
  ; GFX6:   [[COPY20:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub15
  ; GFX6:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY21]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY22]], implicit $exec
  ; GFX6:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX6:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY23]], implicit $exec
  ; GFX6:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX6:   [[COPY24:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY24]], implicit $exec
  ; GFX6:   $sgpr3 = COPY [[V_READFIRSTLANE_B32_3]]
  ; GFX6:   [[COPY25:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX6:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY25]], implicit $exec
  ; GFX6:   $sgpr4 = COPY [[V_READFIRSTLANE_B32_4]]
  ; GFX6:   [[COPY26:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GFX6:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY26]], implicit $exec
  ; GFX6:   $sgpr5 = COPY [[V_READFIRSTLANE_B32_5]]
  ; GFX6:   [[COPY27:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; GFX6:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY27]], implicit $exec
  ; GFX6:   $sgpr6 = COPY [[V_READFIRSTLANE_B32_6]]
  ; GFX6:   [[COPY28:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; GFX6:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY28]], implicit $exec
  ; GFX6:   $sgpr7 = COPY [[V_READFIRSTLANE_B32_7]]
  ; GFX6:   [[COPY29:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; GFX6:   [[V_READFIRSTLANE_B32_8:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY29]], implicit $exec
  ; GFX6:   $sgpr8 = COPY [[V_READFIRSTLANE_B32_8]]
  ; GFX6:   [[COPY30:%[0-9]+]]:vgpr_32 = COPY [[COPY14]]
  ; GFX6:   [[V_READFIRSTLANE_B32_9:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY30]], implicit $exec
  ; GFX6:   $sgpr9 = COPY [[V_READFIRSTLANE_B32_9]]
  ; GFX6:   [[COPY31:%[0-9]+]]:vgpr_32 = COPY [[COPY15]]
  ; GFX6:   [[V_READFIRSTLANE_B32_10:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY31]], implicit $exec
  ; GFX6:   $sgpr10 = COPY [[V_READFIRSTLANE_B32_10]]
  ; GFX6:   [[COPY32:%[0-9]+]]:vgpr_32 = COPY [[COPY16]]
  ; GFX6:   [[V_READFIRSTLANE_B32_11:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY32]], implicit $exec
  ; GFX6:   $sgpr11 = COPY [[V_READFIRSTLANE_B32_11]]
  ; GFX6:   [[COPY33:%[0-9]+]]:vgpr_32 = COPY [[COPY17]]
  ; GFX6:   [[V_READFIRSTLANE_B32_12:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY33]], implicit $exec
  ; GFX6:   $sgpr12 = COPY [[V_READFIRSTLANE_B32_12]]
  ; GFX6:   [[COPY34:%[0-9]+]]:vgpr_32 = COPY [[COPY18]]
  ; GFX6:   [[V_READFIRSTLANE_B32_13:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY34]], implicit $exec
  ; GFX6:   $sgpr13 = COPY [[V_READFIRSTLANE_B32_13]]
  ; GFX6:   [[COPY35:%[0-9]+]]:vgpr_32 = COPY [[COPY19]]
  ; GFX6:   [[V_READFIRSTLANE_B32_14:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY35]], implicit $exec
  ; GFX6:   $sgpr14 = COPY [[V_READFIRSTLANE_B32_14]]
  ; GFX6:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY [[COPY20]]
  ; GFX6:   [[V_READFIRSTLANE_B32_15:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY36]], implicit $exec
  ; GFX6:   $sgpr15 = COPY [[V_READFIRSTLANE_B32_15]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $sgpr3, implicit $sgpr4, implicit $sgpr5, implicit $sgpr6, implicit $sgpr7, implicit $sgpr8, implicit $sgpr9, implicit $sgpr10, implicit $sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $sgpr15
  ; GFX7-LABEL: name: s_buffer_load_v16i32
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_BUFFER_LOAD_DWORDX16_SGPR:%[0-9]+]]:sgpr_512 = S_BUFFER_LOAD_DWORDX16_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 64, align 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub7
  ; GFX7:   [[COPY13:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub8
  ; GFX7:   [[COPY14:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub9
  ; GFX7:   [[COPY15:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub10
  ; GFX7:   [[COPY16:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub11
  ; GFX7:   [[COPY17:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub12
  ; GFX7:   [[COPY18:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub13
  ; GFX7:   [[COPY19:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub14
  ; GFX7:   [[COPY20:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub15
  ; GFX7:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY21]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY22]], implicit $exec
  ; GFX7:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX7:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY23]], implicit $exec
  ; GFX7:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX7:   [[COPY24:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY24]], implicit $exec
  ; GFX7:   $sgpr3 = COPY [[V_READFIRSTLANE_B32_3]]
  ; GFX7:   [[COPY25:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX7:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY25]], implicit $exec
  ; GFX7:   $sgpr4 = COPY [[V_READFIRSTLANE_B32_4]]
  ; GFX7:   [[COPY26:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GFX7:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY26]], implicit $exec
  ; GFX7:   $sgpr5 = COPY [[V_READFIRSTLANE_B32_5]]
  ; GFX7:   [[COPY27:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; GFX7:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY27]], implicit $exec
  ; GFX7:   $sgpr6 = COPY [[V_READFIRSTLANE_B32_6]]
  ; GFX7:   [[COPY28:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; GFX7:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY28]], implicit $exec
  ; GFX7:   $sgpr7 = COPY [[V_READFIRSTLANE_B32_7]]
  ; GFX7:   [[COPY29:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; GFX7:   [[V_READFIRSTLANE_B32_8:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY29]], implicit $exec
  ; GFX7:   $sgpr8 = COPY [[V_READFIRSTLANE_B32_8]]
  ; GFX7:   [[COPY30:%[0-9]+]]:vgpr_32 = COPY [[COPY14]]
  ; GFX7:   [[V_READFIRSTLANE_B32_9:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY30]], implicit $exec
  ; GFX7:   $sgpr9 = COPY [[V_READFIRSTLANE_B32_9]]
  ; GFX7:   [[COPY31:%[0-9]+]]:vgpr_32 = COPY [[COPY15]]
  ; GFX7:   [[V_READFIRSTLANE_B32_10:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY31]], implicit $exec
  ; GFX7:   $sgpr10 = COPY [[V_READFIRSTLANE_B32_10]]
  ; GFX7:   [[COPY32:%[0-9]+]]:vgpr_32 = COPY [[COPY16]]
  ; GFX7:   [[V_READFIRSTLANE_B32_11:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY32]], implicit $exec
  ; GFX7:   $sgpr11 = COPY [[V_READFIRSTLANE_B32_11]]
  ; GFX7:   [[COPY33:%[0-9]+]]:vgpr_32 = COPY [[COPY17]]
  ; GFX7:   [[V_READFIRSTLANE_B32_12:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY33]], implicit $exec
  ; GFX7:   $sgpr12 = COPY [[V_READFIRSTLANE_B32_12]]
  ; GFX7:   [[COPY34:%[0-9]+]]:vgpr_32 = COPY [[COPY18]]
  ; GFX7:   [[V_READFIRSTLANE_B32_13:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY34]], implicit $exec
  ; GFX7:   $sgpr13 = COPY [[V_READFIRSTLANE_B32_13]]
  ; GFX7:   [[COPY35:%[0-9]+]]:vgpr_32 = COPY [[COPY19]]
  ; GFX7:   [[V_READFIRSTLANE_B32_14:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY35]], implicit $exec
  ; GFX7:   $sgpr14 = COPY [[V_READFIRSTLANE_B32_14]]
  ; GFX7:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY [[COPY20]]
  ; GFX7:   [[V_READFIRSTLANE_B32_15:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY36]], implicit $exec
  ; GFX7:   $sgpr15 = COPY [[V_READFIRSTLANE_B32_15]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $sgpr3, implicit $sgpr4, implicit $sgpr5, implicit $sgpr6, implicit $sgpr7, implicit $sgpr8, implicit $sgpr9, implicit $sgpr10, implicit $sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $sgpr15
  ; GFX8-LABEL: name: s_buffer_load_v16i32
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_BUFFER_LOAD_DWORDX16_SGPR:%[0-9]+]]:sgpr_512 = S_BUFFER_LOAD_DWORDX16_SGPR [[REG_SEQUENCE]], [[COPY4]], 0 :: (dereferenceable invariant load 64, align 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub7
  ; GFX8:   [[COPY13:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub8
  ; GFX8:   [[COPY14:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub9
  ; GFX8:   [[COPY15:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub10
  ; GFX8:   [[COPY16:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub11
  ; GFX8:   [[COPY17:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub12
  ; GFX8:   [[COPY18:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub13
  ; GFX8:   [[COPY19:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub14
  ; GFX8:   [[COPY20:%[0-9]+]]:sreg_32 = COPY [[S_BUFFER_LOAD_DWORDX16_SGPR]].sub15
  ; GFX8:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY21]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY22]], implicit $exec
  ; GFX8:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GFX8:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY23]], implicit $exec
  ; GFX8:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GFX8:   [[COPY24:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY24]], implicit $exec
  ; GFX8:   $sgpr3 = COPY [[V_READFIRSTLANE_B32_3]]
  ; GFX8:   [[COPY25:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; GFX8:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY25]], implicit $exec
  ; GFX8:   $sgpr4 = COPY [[V_READFIRSTLANE_B32_4]]
  ; GFX8:   [[COPY26:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GFX8:   [[V_READFIRSTLANE_B32_5:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY26]], implicit $exec
  ; GFX8:   $sgpr5 = COPY [[V_READFIRSTLANE_B32_5]]
  ; GFX8:   [[COPY27:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; GFX8:   [[V_READFIRSTLANE_B32_6:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY27]], implicit $exec
  ; GFX8:   $sgpr6 = COPY [[V_READFIRSTLANE_B32_6]]
  ; GFX8:   [[COPY28:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; GFX8:   [[V_READFIRSTLANE_B32_7:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY28]], implicit $exec
  ; GFX8:   $sgpr7 = COPY [[V_READFIRSTLANE_B32_7]]
  ; GFX8:   [[COPY29:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; GFX8:   [[V_READFIRSTLANE_B32_8:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY29]], implicit $exec
  ; GFX8:   $sgpr8 = COPY [[V_READFIRSTLANE_B32_8]]
  ; GFX8:   [[COPY30:%[0-9]+]]:vgpr_32 = COPY [[COPY14]]
  ; GFX8:   [[V_READFIRSTLANE_B32_9:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY30]], implicit $exec
  ; GFX8:   $sgpr9 = COPY [[V_READFIRSTLANE_B32_9]]
  ; GFX8:   [[COPY31:%[0-9]+]]:vgpr_32 = COPY [[COPY15]]
  ; GFX8:   [[V_READFIRSTLANE_B32_10:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY31]], implicit $exec
  ; GFX8:   $sgpr10 = COPY [[V_READFIRSTLANE_B32_10]]
  ; GFX8:   [[COPY32:%[0-9]+]]:vgpr_32 = COPY [[COPY16]]
  ; GFX8:   [[V_READFIRSTLANE_B32_11:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY32]], implicit $exec
  ; GFX8:   $sgpr11 = COPY [[V_READFIRSTLANE_B32_11]]
  ; GFX8:   [[COPY33:%[0-9]+]]:vgpr_32 = COPY [[COPY17]]
  ; GFX8:   [[V_READFIRSTLANE_B32_12:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY33]], implicit $exec
  ; GFX8:   $sgpr12 = COPY [[V_READFIRSTLANE_B32_12]]
  ; GFX8:   [[COPY34:%[0-9]+]]:vgpr_32 = COPY [[COPY18]]
  ; GFX8:   [[V_READFIRSTLANE_B32_13:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY34]], implicit $exec
  ; GFX8:   $sgpr13 = COPY [[V_READFIRSTLANE_B32_13]]
  ; GFX8:   [[COPY35:%[0-9]+]]:vgpr_32 = COPY [[COPY19]]
  ; GFX8:   [[V_READFIRSTLANE_B32_14:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY35]], implicit $exec
  ; GFX8:   $sgpr14 = COPY [[V_READFIRSTLANE_B32_14]]
  ; GFX8:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY [[COPY20]]
  ; GFX8:   [[V_READFIRSTLANE_B32_15:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY36]], implicit $exec
  ; GFX8:   $sgpr15 = COPY [[V_READFIRSTLANE_B32_15]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $sgpr3, implicit $sgpr4, implicit $sgpr5, implicit $sgpr6, implicit $sgpr7, implicit $sgpr8, implicit $sgpr9, implicit $sgpr10, implicit $sgpr11, implicit $sgpr12, implicit $sgpr13, implicit $sgpr14, implicit $sgpr15
  %val = call <16 x i32> @llvm.amdgcn.s.buffer.load.v16i32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <16 x i32> %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_1(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_1
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_1
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_1
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 1, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_glc_4(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_glc_4
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1, 1 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_glc_4
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1, 1 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_glc_4
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 4, 1 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 4, i32 1)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_255(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_255
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 255
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_255
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 255
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_255
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 255, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 255, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_256(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_256
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 64, 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_256
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 64, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_256
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 256, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 256, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_1020(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_1020
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 255, 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_1020
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 255, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_1020
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1020, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 1020, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_1023(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_1023
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1023
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_1023
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1023
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_1023
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1023, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 1023, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_1024(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_1024
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_1024
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 256, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_1024
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1024, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 1024, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_1025(<4 x i32> inreg %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_1025
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1025
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_1025
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1025
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_1025
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 1025, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %val = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %rsrc, i32 1025, i32 0)
  ret i32 %val
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_neg1(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_neg1
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -1
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_neg1
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -1
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_neg1
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -1
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 -1, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_neg4(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_neg4
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -4
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_neg4
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 1073741823, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_neg4
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -4
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 -4, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_neg8(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_neg8
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -8
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_neg8
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 1073741822, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_neg8
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -8
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 -8, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_bit31(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_bit31
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -2147483648
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_bit31
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 536870912, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_bit31
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -2147483648
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 -2147483648, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_glc_bit30(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_glc_bit30
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1073741824
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 1 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_glc_bit30
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 268435456, 1 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_glc_bit30
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1073741824
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 1 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 1073741824, i32 1)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_bit29(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_bit29
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 536870912
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_bit29
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 134217728, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_bit29
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 536870912
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 536870912, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_bit21(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_bit21
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 2097152
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_bit21
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 524288, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_bit21
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 2097152
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 2097152, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_bit20(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_bit20
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1048576
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_bit20
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 262144, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_bit20
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1048576
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 1048576, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_neg_bit20(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_neg_bit20
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -1048576
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_neg_bit20
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 1073479680, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_neg_bit20
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -1048576
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32  -1048576, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_bit19(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_bit19
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 524288
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_bit19
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 131072, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_bit19
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_IMM:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM [[REG_SEQUENCE]], 524288, 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 524288, i32 0)
  ret i32 %load
}

define amdgpu_ps i32 @s_buffer_load_i32_offset_neg_bit19(<4 x i32> inreg %desc) {
  ; GFX6-LABEL: name: s_buffer_load_i32_offset_neg_bit19
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -524288
  ; GFX6:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX6:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX7-LABEL: name: s_buffer_load_i32_offset_neg_bit19
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_BUFFER_LOAD_DWORD_IMM_ci:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_IMM_ci [[REG_SEQUENCE]], 1073610752, 0 :: (dereferenceable invariant load 4)
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_IMM_ci]]
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX7:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $sgpr0
  ; GFX8-LABEL: name: s_buffer_load_i32_offset_neg_bit19
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 -524288
  ; GFX8:   [[S_BUFFER_LOAD_DWORD_SGPR:%[0-9]+]]:sreg_32_xm0_xexec = S_BUFFER_LOAD_DWORD_SGPR [[REG_SEQUENCE]], [[S_MOV_B32_]], 0 :: (dereferenceable invariant load 4)
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_BUFFER_LOAD_DWORD_SGPR]]
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32 = V_READFIRSTLANE_B32 [[COPY4]], implicit $exec
  ; GFX8:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $sgpr0
  %load = call i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32> %desc, i32 -524288, i32 0)
  ret i32 %load
}

; Check cases that need to be converted to MUBUF due to the offset being a VGPR.
define amdgpu_ps float @s_buffer_load_f32_vgpr_offset(<4 x i32> inreg %rsrc, i32 %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_offset
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_offset
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_offset
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

define amdgpu_ps <2 x float> @s_buffer_load_v2f32_vgpr_offset(<4 x i32> inreg %rsrc, i32 %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v2f32_vgpr_offset
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX2_OFFEN:%[0-9]+]]:vreg_64 = BUFFER_LOAD_DWORDX2_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 8, align 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX2_OFFEN]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX2_OFFEN]].sub1
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ; GFX7-LABEL: name: s_buffer_load_v2f32_vgpr_offset
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX2_OFFEN:%[0-9]+]]:vreg_64 = BUFFER_LOAD_DWORDX2_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 8, align 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX2_OFFEN]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX2_OFFEN]].sub1
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  ; GFX8-LABEL: name: s_buffer_load_v2f32_vgpr_offset
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX2_OFFEN:%[0-9]+]]:vreg_64 = BUFFER_LOAD_DWORDX2_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 8, align 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX2_OFFEN]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX2_OFFEN]].sub1
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1
  %val = call <2 x float> @llvm.amdgcn.s.buffer.load.v2f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <2 x float> %val
}

define amdgpu_ps <3 x float> @s_buffer_load_v3f32_vgpr_offset(<4 x i32> inreg %rsrc, i32 %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v3f32_vgpr_offset
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[DEF:%[0-9]+]]:sgpr_128 = IMPLICIT_DEF
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_128 = COPY [[DEF]]
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_128 = COPY [[DEF]]
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[COPY5]], %subreg.sub4_sub5_sub6_sub7, [[COPY6]], %subreg.sub8_sub9_sub10_sub11
  ; GFX6:   [[COPY7:%[0-9]+]]:vreg_96 = COPY [[REG_SEQUENCE1]].sub0_sub1_sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub0
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub1
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub2
  ; GFX6:   $vgpr0 = COPY [[COPY8]]
  ; GFX6:   $vgpr1 = COPY [[COPY9]]
  ; GFX6:   $vgpr2 = COPY [[COPY10]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2
  ; GFX7-LABEL: name: s_buffer_load_v3f32_vgpr_offset
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[DEF:%[0-9]+]]:sgpr_128 = IMPLICIT_DEF
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_128 = COPY [[DEF]]
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_128 = COPY [[DEF]]
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[COPY5]], %subreg.sub4_sub5_sub6_sub7, [[COPY6]], %subreg.sub8_sub9_sub10_sub11
  ; GFX7:   [[COPY7:%[0-9]+]]:vreg_96 = COPY [[REG_SEQUENCE1]].sub0_sub1_sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub0
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub1
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub2
  ; GFX7:   $vgpr0 = COPY [[COPY8]]
  ; GFX7:   $vgpr1 = COPY [[COPY9]]
  ; GFX7:   $vgpr2 = COPY [[COPY10]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2
  ; GFX8-LABEL: name: s_buffer_load_v3f32_vgpr_offset
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[DEF:%[0-9]+]]:sgpr_128 = IMPLICIT_DEF
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_128 = COPY [[DEF]]
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_128 = COPY [[DEF]]
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[COPY5]], %subreg.sub4_sub5_sub6_sub7, [[COPY6]], %subreg.sub8_sub9_sub10_sub11
  ; GFX8:   [[COPY7:%[0-9]+]]:vreg_96 = COPY [[REG_SEQUENCE1]].sub0_sub1_sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub0
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub1
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY7]].sub2
  ; GFX8:   $vgpr0 = COPY [[COPY8]]
  ; GFX8:   $vgpr1 = COPY [[COPY9]]
  ; GFX8:   $vgpr2 = COPY [[COPY10]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2
  %val = call <3 x float> @llvm.amdgcn.s.buffer.load.v3f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <3 x float> %val
}

define amdgpu_ps <4 x float> @s_buffer_load_v4f32_vgpr_offset(<4 x i32> inreg %rsrc, i32 %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v4f32_vgpr_offset
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub3
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX7-LABEL: name: s_buffer_load_v4f32_vgpr_offset
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub3
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  ; GFX8-LABEL: name: s_buffer_load_v4f32_vgpr_offset
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[BUFFER_LOAD_DWORDX4_OFFEN]].sub3
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3
  %val = call <4 x float> @llvm.amdgcn.s.buffer.load.v4f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <4 x float> %val
}

define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset(<4 x i32> inreg %rsrc, i32 %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   $vgpr4 = COPY [[COPY9]]
  ; GFX6:   $vgpr5 = COPY [[COPY10]]
  ; GFX6:   $vgpr6 = COPY [[COPY11]]
  ; GFX6:   $vgpr7 = COPY [[COPY12]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   $vgpr4 = COPY [[COPY9]]
  ; GFX7:   $vgpr5 = COPY [[COPY10]]
  ; GFX7:   $vgpr6 = COPY [[COPY11]]
  ; GFX7:   $vgpr7 = COPY [[COPY12]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   $vgpr4 = COPY [[COPY9]]
  ; GFX8:   $vgpr5 = COPY [[COPY10]]
  ; GFX8:   $vgpr6 = COPY [[COPY11]]
  ; GFX8:   $vgpr7 = COPY [[COPY12]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <16 x float> @s_buffer_load_v16f32_vgpr_offset(<4 x i32> inreg %rsrc, i32 %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_v16f32_vgpr_offset
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 32, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 48, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX6:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX6:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX6:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX6:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX6:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX6:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   $vgpr4 = COPY [[COPY9]]
  ; GFX6:   $vgpr5 = COPY [[COPY10]]
  ; GFX6:   $vgpr6 = COPY [[COPY11]]
  ; GFX6:   $vgpr7 = COPY [[COPY12]]
  ; GFX6:   $vgpr8 = COPY [[COPY13]]
  ; GFX6:   $vgpr9 = COPY [[COPY14]]
  ; GFX6:   $vgpr10 = COPY [[COPY15]]
  ; GFX6:   $vgpr11 = COPY [[COPY16]]
  ; GFX6:   $vgpr12 = COPY [[COPY17]]
  ; GFX6:   $vgpr13 = COPY [[COPY18]]
  ; GFX6:   $vgpr14 = COPY [[COPY19]]
  ; GFX6:   $vgpr15 = COPY [[COPY20]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GFX7-LABEL: name: s_buffer_load_v16f32_vgpr_offset
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 32, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 48, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX7:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX7:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX7:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX7:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX7:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX7:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   $vgpr4 = COPY [[COPY9]]
  ; GFX7:   $vgpr5 = COPY [[COPY10]]
  ; GFX7:   $vgpr6 = COPY [[COPY11]]
  ; GFX7:   $vgpr7 = COPY [[COPY12]]
  ; GFX7:   $vgpr8 = COPY [[COPY13]]
  ; GFX7:   $vgpr9 = COPY [[COPY14]]
  ; GFX7:   $vgpr10 = COPY [[COPY15]]
  ; GFX7:   $vgpr11 = COPY [[COPY16]]
  ; GFX7:   $vgpr12 = COPY [[COPY17]]
  ; GFX7:   $vgpr13 = COPY [[COPY18]]
  ; GFX7:   $vgpr14 = COPY [[COPY19]]
  ; GFX7:   $vgpr15 = COPY [[COPY20]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GFX8-LABEL: name: s_buffer_load_v16f32_vgpr_offset
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 32, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 48, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX8:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX8:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX8:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX8:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX8:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX8:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   $vgpr4 = COPY [[COPY9]]
  ; GFX8:   $vgpr5 = COPY [[COPY10]]
  ; GFX8:   $vgpr6 = COPY [[COPY11]]
  ; GFX8:   $vgpr7 = COPY [[COPY12]]
  ; GFX8:   $vgpr8 = COPY [[COPY13]]
  ; GFX8:   $vgpr9 = COPY [[COPY14]]
  ; GFX8:   $vgpr10 = COPY [[COPY15]]
  ; GFX8:   $vgpr11 = COPY [[COPY16]]
  ; GFX8:   $vgpr12 = COPY [[COPY17]]
  ; GFX8:   $vgpr13 = COPY [[COPY18]]
  ; GFX8:   $vgpr14 = COPY [[COPY19]]
  ; GFX8:   $vgpr15 = COPY [[COPY20]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  %val = call <16 x float> @llvm.amdgcn.s.buffer.load.v16f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <16 x float> %val
}

define amdgpu_ps float @s_buffer_load_f32_vgpr_offset_add_4092(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4092
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4092, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4092
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4092, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4092
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4092, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %soffset = add i32 %soffset.base, 4092
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

define amdgpu_ps float @s_buffer_load_f32_vgpr_offset_add_4095(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4095
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4095
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4095
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %soffset = add i32 %soffset.base, 4095
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

define amdgpu_ps float @s_buffer_load_f32_vgpr_offset_add_4096(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4096
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4096
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_offset_add_4096
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %soffset = add i32 %soffset.base, 4096
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

; Make sure the base offset is added to each split load.
define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset_add_4064(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset_add_4064
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   $vgpr4 = COPY [[COPY9]]
  ; GFX6:   $vgpr5 = COPY [[COPY10]]
  ; GFX6:   $vgpr6 = COPY [[COPY11]]
  ; GFX6:   $vgpr7 = COPY [[COPY12]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset_add_4064
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   $vgpr4 = COPY [[COPY9]]
  ; GFX7:   $vgpr5 = COPY [[COPY10]]
  ; GFX7:   $vgpr6 = COPY [[COPY11]]
  ; GFX7:   $vgpr7 = COPY [[COPY12]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset_add_4064
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   $vgpr4 = COPY [[COPY9]]
  ; GFX8:   $vgpr5 = COPY [[COPY10]]
  ; GFX8:   $vgpr6 = COPY [[COPY11]]
  ; GFX8:   $vgpr7 = COPY [[COPY12]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %soffset.base, 4064
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

; Make sure the maximum offset isn't exeeded when splitting this
define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset_add_4068(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset_add_4068
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4068
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   $vgpr4 = COPY [[COPY9]]
  ; GFX6:   $vgpr5 = COPY [[COPY10]]
  ; GFX6:   $vgpr6 = COPY [[COPY11]]
  ; GFX6:   $vgpr7 = COPY [[COPY12]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset_add_4068
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4068
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   $vgpr4 = COPY [[COPY9]]
  ; GFX7:   $vgpr5 = COPY [[COPY10]]
  ; GFX7:   $vgpr6 = COPY [[COPY11]]
  ; GFX7:   $vgpr7 = COPY [[COPY12]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset_add_4068
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   $vgpr4 = COPY [[COPY9]]
  ; GFX8:   $vgpr5 = COPY [[COPY10]]
  ; GFX8:   $vgpr6 = COPY [[COPY11]]
  ; GFX8:   $vgpr7 = COPY [[COPY12]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %soffset.base, 4068
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <16 x float> @s_buffer_load_v16f32_vgpr_offset_add_4032(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v16f32_vgpr_offset_add_4032
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4032, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4048, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX6:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX6:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX6:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX6:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX6:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX6:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   $vgpr4 = COPY [[COPY9]]
  ; GFX6:   $vgpr5 = COPY [[COPY10]]
  ; GFX6:   $vgpr6 = COPY [[COPY11]]
  ; GFX6:   $vgpr7 = COPY [[COPY12]]
  ; GFX6:   $vgpr8 = COPY [[COPY13]]
  ; GFX6:   $vgpr9 = COPY [[COPY14]]
  ; GFX6:   $vgpr10 = COPY [[COPY15]]
  ; GFX6:   $vgpr11 = COPY [[COPY16]]
  ; GFX6:   $vgpr12 = COPY [[COPY17]]
  ; GFX6:   $vgpr13 = COPY [[COPY18]]
  ; GFX6:   $vgpr14 = COPY [[COPY19]]
  ; GFX6:   $vgpr15 = COPY [[COPY20]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GFX7-LABEL: name: s_buffer_load_v16f32_vgpr_offset_add_4032
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4032, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4048, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX7:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX7:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX7:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX7:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX7:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX7:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   $vgpr4 = COPY [[COPY9]]
  ; GFX7:   $vgpr5 = COPY [[COPY10]]
  ; GFX7:   $vgpr6 = COPY [[COPY11]]
  ; GFX7:   $vgpr7 = COPY [[COPY12]]
  ; GFX7:   $vgpr8 = COPY [[COPY13]]
  ; GFX7:   $vgpr9 = COPY [[COPY14]]
  ; GFX7:   $vgpr10 = COPY [[COPY15]]
  ; GFX7:   $vgpr11 = COPY [[COPY16]]
  ; GFX7:   $vgpr12 = COPY [[COPY17]]
  ; GFX7:   $vgpr13 = COPY [[COPY18]]
  ; GFX7:   $vgpr14 = COPY [[COPY19]]
  ; GFX7:   $vgpr15 = COPY [[COPY20]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GFX8-LABEL: name: s_buffer_load_v16f32_vgpr_offset_add_4032
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4032, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4048, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX8:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX8:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX8:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX8:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX8:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX8:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   $vgpr4 = COPY [[COPY9]]
  ; GFX8:   $vgpr5 = COPY [[COPY10]]
  ; GFX8:   $vgpr6 = COPY [[COPY11]]
  ; GFX8:   $vgpr7 = COPY [[COPY12]]
  ; GFX8:   $vgpr8 = COPY [[COPY13]]
  ; GFX8:   $vgpr9 = COPY [[COPY14]]
  ; GFX8:   $vgpr10 = COPY [[COPY15]]
  ; GFX8:   $vgpr11 = COPY [[COPY16]]
  ; GFX8:   $vgpr12 = COPY [[COPY17]]
  ; GFX8:   $vgpr13 = COPY [[COPY18]]
  ; GFX8:   $vgpr14 = COPY [[COPY19]]
  ; GFX8:   $vgpr15 = COPY [[COPY20]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  %soffset = add i32 %soffset.base, 4032
  %val = call <16 x float> @llvm.amdgcn.s.buffer.load.v16f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <16 x float> %val
}

define amdgpu_ps <16 x float> @s_buffer_load_v16f32_vgpr_offset_add_4036(<4 x i32> inreg %rsrc, i32 %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v16f32_vgpr_offset_add_4036
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4036
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 32, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 48, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX6:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX6:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX6:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX6:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX6:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX6:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX6:   $vgpr0 = COPY [[COPY5]]
  ; GFX6:   $vgpr1 = COPY [[COPY6]]
  ; GFX6:   $vgpr2 = COPY [[COPY7]]
  ; GFX6:   $vgpr3 = COPY [[COPY8]]
  ; GFX6:   $vgpr4 = COPY [[COPY9]]
  ; GFX6:   $vgpr5 = COPY [[COPY10]]
  ; GFX6:   $vgpr6 = COPY [[COPY11]]
  ; GFX6:   $vgpr7 = COPY [[COPY12]]
  ; GFX6:   $vgpr8 = COPY [[COPY13]]
  ; GFX6:   $vgpr9 = COPY [[COPY14]]
  ; GFX6:   $vgpr10 = COPY [[COPY15]]
  ; GFX6:   $vgpr11 = COPY [[COPY16]]
  ; GFX6:   $vgpr12 = COPY [[COPY17]]
  ; GFX6:   $vgpr13 = COPY [[COPY18]]
  ; GFX6:   $vgpr14 = COPY [[COPY19]]
  ; GFX6:   $vgpr15 = COPY [[COPY20]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GFX7-LABEL: name: s_buffer_load_v16f32_vgpr_offset_add_4036
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4036
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 32, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 48, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX7:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX7:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX7:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX7:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX7:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX7:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX7:   $vgpr0 = COPY [[COPY5]]
  ; GFX7:   $vgpr1 = COPY [[COPY6]]
  ; GFX7:   $vgpr2 = COPY [[COPY7]]
  ; GFX7:   $vgpr3 = COPY [[COPY8]]
  ; GFX7:   $vgpr4 = COPY [[COPY9]]
  ; GFX7:   $vgpr5 = COPY [[COPY10]]
  ; GFX7:   $vgpr6 = COPY [[COPY11]]
  ; GFX7:   $vgpr7 = COPY [[COPY12]]
  ; GFX7:   $vgpr8 = COPY [[COPY13]]
  ; GFX7:   $vgpr9 = COPY [[COPY14]]
  ; GFX7:   $vgpr10 = COPY [[COPY15]]
  ; GFX7:   $vgpr11 = COPY [[COPY16]]
  ; GFX7:   $vgpr12 = COPY [[COPY17]]
  ; GFX7:   $vgpr13 = COPY [[COPY18]]
  ; GFX7:   $vgpr14 = COPY [[COPY19]]
  ; GFX7:   $vgpr15 = COPY [[COPY20]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GFX8-LABEL: name: s_buffer_load_v16f32_vgpr_offset_add_4036
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4032, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4048, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN2:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN3:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 48, align 4)
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_512 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7, [[BUFFER_LOAD_DWORDX4_OFFEN2]], %subreg.sub8_sub9_sub10_sub11, [[BUFFER_LOAD_DWORDX4_OFFEN3]], %subreg.sub12_sub13_sub14_sub15
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub2
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub3
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub4
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub5
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub6
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub7
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub8
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub9
  ; GFX8:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub10
  ; GFX8:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub11
  ; GFX8:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub12
  ; GFX8:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub13
  ; GFX8:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub14
  ; GFX8:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub15
  ; GFX8:   $vgpr0 = COPY [[COPY5]]
  ; GFX8:   $vgpr1 = COPY [[COPY6]]
  ; GFX8:   $vgpr2 = COPY [[COPY7]]
  ; GFX8:   $vgpr3 = COPY [[COPY8]]
  ; GFX8:   $vgpr4 = COPY [[COPY9]]
  ; GFX8:   $vgpr5 = COPY [[COPY10]]
  ; GFX8:   $vgpr6 = COPY [[COPY11]]
  ; GFX8:   $vgpr7 = COPY [[COPY12]]
  ; GFX8:   $vgpr8 = COPY [[COPY13]]
  ; GFX8:   $vgpr9 = COPY [[COPY14]]
  ; GFX8:   $vgpr10 = COPY [[COPY15]]
  ; GFX8:   $vgpr11 = COPY [[COPY16]]
  ; GFX8:   $vgpr12 = COPY [[COPY17]]
  ; GFX8:   $vgpr13 = COPY [[COPY18]]
  ; GFX8:   $vgpr14 = COPY [[COPY19]]
  ; GFX8:   $vgpr15 = COPY [[COPY20]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  %soffset = add i32 %soffset.base, 4036
  %val = call <16 x float> @llvm.amdgcn.s.buffer.load.v16f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <16 x float> %val
}

; Waterfall loop due to resource being VGPR
define amdgpu_ps float @s_buffer_load_f32_vgpr_rsrc(<4 x i32> %rsrc, i32 inreg %soffset) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_rsrc
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_rsrc
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_rsrc
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

; Use the offset inside the waterfall loop
define amdgpu_ps float @s_buffer_load_f32_vgpr_rsrc_soffset_add_4092(<4 x i32> %rsrc, i32 inreg %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_rsrc_soffset_add_4092
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4092, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_rsrc_soffset_add_4092
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4092, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_rsrc_soffset_add_4092
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4092, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %soffset = add i32 %soffset.base, 4092
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

; Scalar offset exceeds MUBUF limit, keep add out of the loop
define amdgpu_ps float @s_buffer_load_f32_vgpr_rsrc_soffset_add_4096(<4 x i32> %rsrc, i32 inreg %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_rsrc_soffset_add_4096
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX6:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX6:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_rsrc_soffset_add_4096
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX7:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX7:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_rsrc_soffset_add_4096
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX8:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX8:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %soffset = add i32 %soffset.base, 4096
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret float %val
}

; Waterfall loop, but constant offset
define amdgpu_ps float @s_buffer_load_f32_vgpr_rsrc_offset_4095(<4 x i32> %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_rsrc_offset_4095
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4 from unknown-address + 4095, align 1)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_rsrc_offset_4095
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4 from unknown-address + 4095, align 1)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_rsrc_offset_4095
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4 from unknown-address + 4095, align 1)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 4095, i32 0)
  ret float %val
}

; Waterfall loop, but constant offset
define amdgpu_ps float @s_buffer_load_f32_vgpr_rsrc_offset_4096(<4 x i32> %rsrc) {
  ; GFX6-LABEL: name: s_buffer_load_f32_vgpr_rsrc_offset_4096
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_MOV_B32_]]
  ; GFX6:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_vgpr_rsrc_offset_4096
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[S_MOV_B32_]]
  ; GFX7:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_vgpr_rsrc_offset_4096
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1
  ; GFX8:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFSET:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4095, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4 from unknown-address + 4096)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFSET]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 4096, i32 0)
  ret float %val
}

; Need a waterfall loop, but the offset is scalar.
; Make sure the base offset is added to each split load.
define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_rsrc_add_4064(<4 x i32> %rsrc, i32 inreg %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4064
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFSET:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFSET1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFSET]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFSET1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY7]]
  ; GFX6:   $vgpr1 = COPY [[COPY8]]
  ; GFX6:   $vgpr2 = COPY [[COPY9]]
  ; GFX6:   $vgpr3 = COPY [[COPY10]]
  ; GFX6:   $vgpr4 = COPY [[COPY11]]
  ; GFX6:   $vgpr5 = COPY [[COPY12]]
  ; GFX6:   $vgpr6 = COPY [[COPY13]]
  ; GFX6:   $vgpr7 = COPY [[COPY14]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4064
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFSET:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFSET1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFSET]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFSET1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY7]]
  ; GFX7:   $vgpr1 = COPY [[COPY8]]
  ; GFX7:   $vgpr2 = COPY [[COPY9]]
  ; GFX7:   $vgpr3 = COPY [[COPY10]]
  ; GFX7:   $vgpr4 = COPY [[COPY11]]
  ; GFX7:   $vgpr5 = COPY [[COPY12]]
  ; GFX7:   $vgpr6 = COPY [[COPY13]]
  ; GFX7:   $vgpr7 = COPY [[COPY14]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4064
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFSET:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFSET1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[COPY4]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFSET]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFSET1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY7]]
  ; GFX8:   $vgpr1 = COPY [[COPY8]]
  ; GFX8:   $vgpr2 = COPY [[COPY9]]
  ; GFX8:   $vgpr3 = COPY [[COPY10]]
  ; GFX8:   $vgpr4 = COPY [[COPY11]]
  ; GFX8:   $vgpr5 = COPY [[COPY12]]
  ; GFX8:   $vgpr6 = COPY [[COPY13]]
  ; GFX8:   $vgpr7 = COPY [[COPY14]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %soffset.base, 4064
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

; Need a waterfall loop, but the offset is scalar.
; Make sure the maximum offset isn't exeeded when splitting this
define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_rsrc_add_4068(<4 x i32> %rsrc, i32 inreg %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4068
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4068
  ; GFX6:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX6:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY8]]
  ; GFX6:   $vgpr1 = COPY [[COPY9]]
  ; GFX6:   $vgpr2 = COPY [[COPY10]]
  ; GFX6:   $vgpr3 = COPY [[COPY11]]
  ; GFX6:   $vgpr4 = COPY [[COPY12]]
  ; GFX6:   $vgpr5 = COPY [[COPY13]]
  ; GFX6:   $vgpr6 = COPY [[COPY14]]
  ; GFX6:   $vgpr7 = COPY [[COPY15]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4068
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4068
  ; GFX7:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX7:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY8]]
  ; GFX7:   $vgpr1 = COPY [[COPY9]]
  ; GFX7:   $vgpr2 = COPY [[COPY10]]
  ; GFX7:   $vgpr3 = COPY [[COPY11]]
  ; GFX7:   $vgpr4 = COPY [[COPY12]]
  ; GFX7:   $vgpr5 = COPY [[COPY13]]
  ; GFX7:   $vgpr6 = COPY [[COPY14]]
  ; GFX7:   $vgpr7 = COPY [[COPY15]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4068
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4068
  ; GFX8:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX8:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY8]]
  ; GFX8:   $vgpr1 = COPY [[COPY9]]
  ; GFX8:   $vgpr2 = COPY [[COPY10]]
  ; GFX8:   $vgpr3 = COPY [[COPY11]]
  ; GFX8:   $vgpr4 = COPY [[COPY12]]
  ; GFX8:   $vgpr5 = COPY [[COPY13]]
  ; GFX8:   $vgpr6 = COPY [[COPY14]]
  ; GFX8:   $vgpr7 = COPY [[COPY15]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %soffset.base, 4068
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_rsrc_add_4096(<4 x i32> %rsrc, i32 inreg %soffset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4096
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX6:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX6:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX6:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY8]]
  ; GFX6:   $vgpr1 = COPY [[COPY9]]
  ; GFX6:   $vgpr2 = COPY [[COPY10]]
  ; GFX6:   $vgpr3 = COPY [[COPY11]]
  ; GFX6:   $vgpr4 = COPY [[COPY12]]
  ; GFX6:   $vgpr5 = COPY [[COPY13]]
  ; GFX6:   $vgpr6 = COPY [[COPY14]]
  ; GFX6:   $vgpr7 = COPY [[COPY15]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4096
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX7:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX7:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX7:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY8]]
  ; GFX7:   $vgpr1 = COPY [[COPY9]]
  ; GFX7:   $vgpr2 = COPY [[COPY10]]
  ; GFX7:   $vgpr3 = COPY [[COPY11]]
  ; GFX7:   $vgpr4 = COPY [[COPY12]]
  ; GFX7:   $vgpr5 = COPY [[COPY13]]
  ; GFX7:   $vgpr6 = COPY [[COPY14]]
  ; GFX7:   $vgpr7 = COPY [[COPY15]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_rsrc_add_4096
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4096
  ; GFX8:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY4]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX8:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY [[S_ADD_I32_]]
  ; GFX8:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY7:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY6]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY7]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY5]], [[REG_SEQUENCE3]], [[S_MOV_B32_1]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY8]]
  ; GFX8:   $vgpr1 = COPY [[COPY9]]
  ; GFX8:   $vgpr2 = COPY [[COPY10]]
  ; GFX8:   $vgpr3 = COPY [[COPY11]]
  ; GFX8:   $vgpr4 = COPY [[COPY12]]
  ; GFX8:   $vgpr5 = COPY [[COPY13]]
  ; GFX8:   $vgpr6 = COPY [[COPY14]]
  ; GFX8:   $vgpr7 = COPY [[COPY15]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %soffset.base, 4096
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_5000(<4 x i32> %rsrc, i32 %offset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_5000
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 5000
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY7]]
  ; GFX6:   $vgpr1 = COPY [[COPY8]]
  ; GFX6:   $vgpr2 = COPY [[COPY9]]
  ; GFX6:   $vgpr3 = COPY [[COPY10]]
  ; GFX6:   $vgpr4 = COPY [[COPY11]]
  ; GFX6:   $vgpr5 = COPY [[COPY12]]
  ; GFX6:   $vgpr6 = COPY [[COPY13]]
  ; GFX6:   $vgpr7 = COPY [[COPY14]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_5000
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 5000
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY7]]
  ; GFX7:   $vgpr1 = COPY [[COPY8]]
  ; GFX7:   $vgpr2 = COPY [[COPY9]]
  ; GFX7:   $vgpr3 = COPY [[COPY10]]
  ; GFX7:   $vgpr4 = COPY [[COPY11]]
  ; GFX7:   $vgpr5 = COPY [[COPY12]]
  ; GFX7:   $vgpr6 = COPY [[COPY13]]
  ; GFX7:   $vgpr7 = COPY [[COPY14]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_5000
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4064
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 936, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 952, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY7]]
  ; GFX8:   $vgpr1 = COPY [[COPY8]]
  ; GFX8:   $vgpr2 = COPY [[COPY9]]
  ; GFX8:   $vgpr3 = COPY [[COPY10]]
  ; GFX8:   $vgpr4 = COPY [[COPY11]]
  ; GFX8:   $vgpr5 = COPY [[COPY12]]
  ; GFX8:   $vgpr6 = COPY [[COPY13]]
  ; GFX8:   $vgpr7 = COPY [[COPY14]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %offset.base, 5000
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4076(<4 x i32> %rsrc, i32 %offset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4076
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4076
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY7]]
  ; GFX6:   $vgpr1 = COPY [[COPY8]]
  ; GFX6:   $vgpr2 = COPY [[COPY9]]
  ; GFX6:   $vgpr3 = COPY [[COPY10]]
  ; GFX6:   $vgpr4 = COPY [[COPY11]]
  ; GFX6:   $vgpr5 = COPY [[COPY12]]
  ; GFX6:   $vgpr6 = COPY [[COPY13]]
  ; GFX6:   $vgpr7 = COPY [[COPY14]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4076
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4076
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY7]]
  ; GFX7:   $vgpr1 = COPY [[COPY8]]
  ; GFX7:   $vgpr2 = COPY [[COPY9]]
  ; GFX7:   $vgpr3 = COPY [[COPY10]]
  ; GFX7:   $vgpr4 = COPY [[COPY11]]
  ; GFX7:   $vgpr5 = COPY [[COPY12]]
  ; GFX7:   $vgpr6 = COPY [[COPY13]]
  ; GFX7:   $vgpr7 = COPY [[COPY14]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4076
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 12
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY7]]
  ; GFX8:   $vgpr1 = COPY [[COPY8]]
  ; GFX8:   $vgpr2 = COPY [[COPY9]]
  ; GFX8:   $vgpr3 = COPY [[COPY10]]
  ; GFX8:   $vgpr4 = COPY [[COPY11]]
  ; GFX8:   $vgpr5 = COPY [[COPY12]]
  ; GFX8:   $vgpr6 = COPY [[COPY13]]
  ; GFX8:   $vgpr7 = COPY [[COPY14]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %offset.base, 4076
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4080(<4 x i32> %rsrc, i32 %offset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4080
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4080
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY7]]
  ; GFX6:   $vgpr1 = COPY [[COPY8]]
  ; GFX6:   $vgpr2 = COPY [[COPY9]]
  ; GFX6:   $vgpr3 = COPY [[COPY10]]
  ; GFX6:   $vgpr4 = COPY [[COPY11]]
  ; GFX6:   $vgpr5 = COPY [[COPY12]]
  ; GFX6:   $vgpr6 = COPY [[COPY13]]
  ; GFX6:   $vgpr7 = COPY [[COPY14]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4080
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4080
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 16, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY7]]
  ; GFX7:   $vgpr1 = COPY [[COPY8]]
  ; GFX7:   $vgpr2 = COPY [[COPY9]]
  ; GFX7:   $vgpr3 = COPY [[COPY10]]
  ; GFX7:   $vgpr4 = COPY [[COPY11]]
  ; GFX7:   $vgpr5 = COPY [[COPY12]]
  ; GFX7:   $vgpr6 = COPY [[COPY13]]
  ; GFX7:   $vgpr7 = COPY [[COPY14]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_add_4080
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3, $vgpr4
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr4
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 16
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY5]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY6]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY6]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFEN1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFEN [[COPY4]], [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFEN]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFEN1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY7]]
  ; GFX8:   $vgpr1 = COPY [[COPY8]]
  ; GFX8:   $vgpr2 = COPY [[COPY9]]
  ; GFX8:   $vgpr3 = COPY [[COPY10]]
  ; GFX8:   $vgpr4 = COPY [[COPY11]]
  ; GFX8:   $vgpr5 = COPY [[COPY12]]
  ; GFX8:   $vgpr6 = COPY [[COPY13]]
  ; GFX8:   $vgpr7 = COPY [[COPY14]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %soffset = add i32 %offset.base, 4080
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 %soffset, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps <8 x float> @s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_offset_4064(<4 x i32> %rsrc, i32 %offset.base) {
  ; GFX6-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_offset_4064
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX6:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX6:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX6:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX6:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX6:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX6: bb.2:
  ; GFX6:   successors: %bb.3, %bb.2
  ; GFX6:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX6:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX6:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX6:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX6:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX6:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFSET:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 4064, align 4)
  ; GFX6:   [[BUFFER_LOAD_DWORDX4_OFFSET1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 4064, align 4)
  ; GFX6:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX6:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX6:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX6: bb.3:
  ; GFX6:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX6: bb.4:
  ; GFX6:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFSET]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFSET1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX6:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX6:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX6:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX6:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX6:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX6:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX6:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX6:   $vgpr0 = COPY [[COPY6]]
  ; GFX6:   $vgpr1 = COPY [[COPY7]]
  ; GFX6:   $vgpr2 = COPY [[COPY8]]
  ; GFX6:   $vgpr3 = COPY [[COPY9]]
  ; GFX6:   $vgpr4 = COPY [[COPY10]]
  ; GFX6:   $vgpr5 = COPY [[COPY11]]
  ; GFX6:   $vgpr6 = COPY [[COPY12]]
  ; GFX6:   $vgpr7 = COPY [[COPY13]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX7-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_offset_4064
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX7:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX7:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX7:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX7:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX7:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX7: bb.2:
  ; GFX7:   successors: %bb.3, %bb.2
  ; GFX7:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX7:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX7:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX7:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX7:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX7:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFSET:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 4064, align 4)
  ; GFX7:   [[BUFFER_LOAD_DWORDX4_OFFSET1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 4064, align 4)
  ; GFX7:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX7:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX7:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX7: bb.3:
  ; GFX7:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX7: bb.4:
  ; GFX7:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFSET]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFSET1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX7:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX7:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX7:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX7:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX7:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX7:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX7:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX7:   $vgpr0 = COPY [[COPY6]]
  ; GFX7:   $vgpr1 = COPY [[COPY7]]
  ; GFX7:   $vgpr2 = COPY [[COPY8]]
  ; GFX7:   $vgpr3 = COPY [[COPY9]]
  ; GFX7:   $vgpr4 = COPY [[COPY10]]
  ; GFX7:   $vgpr5 = COPY [[COPY11]]
  ; GFX7:   $vgpr6 = COPY [[COPY12]]
  ; GFX7:   $vgpr7 = COPY [[COPY13]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GFX8-LABEL: name: s_buffer_load_v8f32_vgpr_offset_vgpr_rsrc_offset_4064
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $vgpr0, $vgpr1, $vgpr2, $vgpr3
  ; GFX8:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr1
  ; GFX8:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr2
  ; GFX8:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr3
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub0_sub1
  ; GFX8:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]].sub2_sub3
  ; GFX8:   [[S_MOV_B64_term:%[0-9]+]]:sreg_64_xexec = S_MOV_B64_term $exec
  ; GFX8: bb.2:
  ; GFX8:   successors: %bb.3, %bb.2
  ; GFX8:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY4]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE1]], [[COPY4]], implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub0, implicit $exec
  ; GFX8:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY5]].sub1, implicit $exec
  ; GFX8:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64_xexec = REG_SEQUENCE [[V_READFIRSTLANE_B32_2]], %subreg.sub0, [[V_READFIRSTLANE_B32_3]], %subreg.sub1
  ; GFX8:   [[V_CMP_EQ_U64_e64_1:%[0-9]+]]:sreg_64_xexec = V_CMP_EQ_U64_e64 [[REG_SEQUENCE2]], [[COPY5]], implicit $exec
  ; GFX8:   [[S_AND_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_B64 [[V_CMP_EQ_U64_e64_1]], [[V_CMP_EQ_U64_e64_]], implicit-def $scc
  ; GFX8:   [[REG_SEQUENCE3:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[V_READFIRSTLANE_B32_]], %subreg.sub0, [[V_READFIRSTLANE_B32_1]], %subreg.sub1, [[V_READFIRSTLANE_B32_2]], %subreg.sub2, [[V_READFIRSTLANE_B32_3]], %subreg.sub3
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFSET:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4064, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 4064, align 4)
  ; GFX8:   [[BUFFER_LOAD_DWORDX4_OFFSET1:%[0-9]+]]:vreg_128 = BUFFER_LOAD_DWORDX4_OFFSET [[REG_SEQUENCE3]], [[S_MOV_B32_]], 4080, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 16 from unknown-address + 4064, align 4)
  ; GFX8:   [[S_AND_SAVEEXEC_B64_:%[0-9]+]]:sreg_64_xexec = S_AND_SAVEEXEC_B64 killed [[S_AND_B64_]], implicit-def $exec, implicit-def $scc, implicit $exec
  ; GFX8:   $exec = S_XOR_B64_term $exec, [[S_AND_SAVEEXEC_B64_]], implicit-def $scc
  ; GFX8:   S_CBRANCH_EXECNZ %bb.2, implicit $exec
  ; GFX8: bb.3:
  ; GFX8:   $exec = S_MOV_B64_term [[S_MOV_B64_term]]
  ; GFX8: bb.4:
  ; GFX8:   [[REG_SEQUENCE4:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[BUFFER_LOAD_DWORDX4_OFFSET]], %subreg.sub0_sub1_sub2_sub3, [[BUFFER_LOAD_DWORDX4_OFFSET1]], %subreg.sub4_sub5_sub6_sub7
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub0
  ; GFX8:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub1
  ; GFX8:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub2
  ; GFX8:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub3
  ; GFX8:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub4
  ; GFX8:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub5
  ; GFX8:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub6
  ; GFX8:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE4]].sub7
  ; GFX8:   $vgpr0 = COPY [[COPY6]]
  ; GFX8:   $vgpr1 = COPY [[COPY7]]
  ; GFX8:   $vgpr2 = COPY [[COPY8]]
  ; GFX8:   $vgpr3 = COPY [[COPY9]]
  ; GFX8:   $vgpr4 = COPY [[COPY10]]
  ; GFX8:   $vgpr5 = COPY [[COPY11]]
  ; GFX8:   $vgpr6 = COPY [[COPY12]]
  ; GFX8:   $vgpr7 = COPY [[COPY13]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  %val = call <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32> %rsrc, i32 4064, i32 0)
  ret <8 x float> %val
}

define amdgpu_ps float @s_buffer_load_f32_offset_add_vgpr_sgpr(<4 x i32> inreg %rsrc, i32 %offset.v, i32 inreg %offset.s) {
  ; GFX6-LABEL: name: s_buffer_load_f32_offset_add_vgpr_sgpr
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_offset_add_vgpr_sgpr
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_offset_add_vgpr_sgpr
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %offset = add i32 %offset.v, %offset.s
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %offset, i32 0)
  ret float %val
}

define amdgpu_ps float @s_buffer_load_f32_offset_add_sgpr_vgpr(<4 x i32> inreg %rsrc, i32 %offset.v, i32 inreg %offset.s) {
  ; GFX6-LABEL: name: s_buffer_load_f32_offset_add_sgpr_vgpr
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_offset_add_sgpr_vgpr
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_offset_add_sgpr_vgpr
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %offset = add i32 %offset.s, %offset.v
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %offset, i32 0)
  ret float %val
}

define amdgpu_ps float @s_buffer_load_f32_offset_add_vgpr_sgpr_imm(<4 x i32> inreg %rsrc, i32 %offset.v, i32 inreg %offset.s) {
  ; GFX6-LABEL: name: s_buffer_load_f32_offset_add_vgpr_sgpr_imm
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX6:   %9:vgpr_32, dead %17:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY4]], [[COPY6]], 0, implicit $exec
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %9, [[REG_SEQUENCE]], [[S_MOV_B32_]], 1024, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_offset_add_vgpr_sgpr_imm
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX7:   %9:vgpr_32, dead %17:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY4]], [[COPY6]], 0, implicit $exec
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %9, [[REG_SEQUENCE]], [[S_MOV_B32_]], 1024, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_offset_add_vgpr_sgpr_imm
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX8:   %9:vgpr_32, dead %17:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY4]], [[COPY6]], 0, implicit $exec
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %9, [[REG_SEQUENCE]], [[S_MOV_B32_]], 1024, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %offset.base = add i32 %offset.v, %offset.s
  %offset = add i32 %offset.base, 1024
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %offset, i32 0)
  ret float %val
}

define amdgpu_ps float @s_buffer_load_f32_offset_add_sgpr_vgpr_imm(<4 x i32> inreg %rsrc, i32 %offset.v, i32 inreg %offset.s) {
  ; GFX6-LABEL: name: s_buffer_load_f32_offset_add_sgpr_vgpr_imm
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX6:   %9:vgpr_32, dead %17:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY6]], [[COPY4]], 0, implicit $exec
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %9, [[REG_SEQUENCE]], [[S_MOV_B32_]], 1024, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_offset_add_sgpr_vgpr_imm
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX7:   %9:vgpr_32, dead %17:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY6]], [[COPY4]], 0, implicit $exec
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %9, [[REG_SEQUENCE]], [[S_MOV_B32_]], 1024, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_offset_add_sgpr_vgpr_imm
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GFX8:   %9:vgpr_32, dead %17:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY6]], [[COPY4]], 0, implicit $exec
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 0
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %9, [[REG_SEQUENCE]], [[S_MOV_B32_]], 1024, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %offset.base = add i32 %offset.s, %offset.v
  %offset = add i32 %offset.base, 1024
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %offset, i32 0)
  ret float %val
}

; TODO: Ideally this would be reassociated to fold.
define amdgpu_ps float @s_buffer_load_f32_offset_add_imm_sgpr_vgpr(<4 x i32> inreg %rsrc, i32 %offset.v, i32 inreg %offset.s) {
  ; GFX6-LABEL: name: s_buffer_load_f32_offset_add_imm_sgpr_vgpr
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX6:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY5]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_ADD_I32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_offset_add_imm_sgpr_vgpr
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX7:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY5]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_ADD_I32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_offset_add_imm_sgpr_vgpr
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX8:   [[S_ADD_I32_:%[0-9]+]]:sreg_32 = S_ADD_I32 [[COPY5]], [[S_MOV_B32_]], implicit-def $scc
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN [[COPY4]], [[REG_SEQUENCE]], [[S_ADD_I32_]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %offset.base = add i32 %offset.s, 1024
  %offset = add i32 %offset.base, %offset.v
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %offset, i32 0)
  ret float %val
}

define amdgpu_ps float @s_buffer_load_f32_offset_add_imm_vgpr_sgpr(<4 x i32> inreg %rsrc, i32 %offset.v, i32 inreg %offset.s) {
  ; GFX6-LABEL: name: s_buffer_load_f32_offset_add_imm_vgpr_sgpr
  ; GFX6: bb.1 (%ir-block.0):
  ; GFX6:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX6:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX6:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX6:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX6:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX6:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX6:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX6:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX6:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX6:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[S_MOV_B32_]]
  ; GFX6:   %10:vgpr_32, dead %16:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY4]], [[COPY6]], 0, implicit $exec
  ; GFX6:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %10, [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX6:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX6:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX7-LABEL: name: s_buffer_load_f32_offset_add_imm_vgpr_sgpr
  ; GFX7: bb.1 (%ir-block.0):
  ; GFX7:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX7:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX7:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX7:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX7:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX7:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX7:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX7:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX7:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX7:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[S_MOV_B32_]]
  ; GFX7:   %10:vgpr_32, dead %16:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY4]], [[COPY6]], 0, implicit $exec
  ; GFX7:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %10, [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX7:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX7:   SI_RETURN_TO_EPILOG implicit $vgpr0
  ; GFX8-LABEL: name: s_buffer_load_f32_offset_add_imm_vgpr_sgpr
  ; GFX8: bb.1 (%ir-block.0):
  ; GFX8:   liveins: $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr0
  ; GFX8:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GFX8:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GFX8:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GFX8:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GFX8:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1, [[COPY2]], %subreg.sub2, [[COPY3]], %subreg.sub3
  ; GFX8:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr0
  ; GFX8:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GFX8:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 1024
  ; GFX8:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY [[S_MOV_B32_]]
  ; GFX8:   %10:vgpr_32, dead %16:sreg_64_xexec = V_ADD_CO_U32_e64 [[COPY4]], [[COPY6]], 0, implicit $exec
  ; GFX8:   [[BUFFER_LOAD_DWORD_OFFEN:%[0-9]+]]:vgpr_32 = BUFFER_LOAD_DWORD_OFFEN %10, [[REG_SEQUENCE]], [[COPY5]], 0, 0, 0, 0, implicit $exec :: (dereferenceable invariant load 4)
  ; GFX8:   $vgpr0 = COPY [[BUFFER_LOAD_DWORD_OFFEN]]
  ; GFX8:   SI_RETURN_TO_EPILOG implicit $vgpr0
  %offset.base = add i32 %offset.v, 1024
  %offset = add i32 %offset.base, %offset.s
  %val = call float @llvm.amdgcn.s.buffer.load.f32(<4 x i32> %rsrc, i32 %offset, i32 0)
  ret float %val
}

declare i32 @llvm.amdgcn.s.buffer.load.i32(<4 x i32>, i32, i32 immarg)
declare <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32>, i32, i32 immarg)
declare <3 x i32> @llvm.amdgcn.s.buffer.load.v3i32(<4 x i32>, i32, i32 immarg)
declare <4 x i32> @llvm.amdgcn.s.buffer.load.v4i32(<4 x i32>, i32, i32 immarg)
declare <8 x i32> @llvm.amdgcn.s.buffer.load.v8i32(<4 x i32>, i32, i32 immarg)
declare <16 x i32> @llvm.amdgcn.s.buffer.load.v16i32(<4 x i32>, i32, i32 immarg)

declare float @llvm.amdgcn.s.buffer.load.f32(<4 x i32>, i32, i32      immarg)
declare <2 x float> @llvm.amdgcn.s.buffer.load.v2f32(<4 x i32>, i32, i32 immarg)
declare <3 x float> @llvm.amdgcn.s.buffer.load.v3f32(<4 x i32>, i32, i32 immarg)
declare <4 x float> @llvm.amdgcn.s.buffer.load.v4f32(<4 x i32>, i32, i32 immarg)
declare <8 x float> @llvm.amdgcn.s.buffer.load.v8f32(<4 x i32>, i32, i32 immarg)
declare <16 x float> @llvm.amdgcn.s.buffer.load.v16f32(<4 x i32>, i32, i32 immarg)

declare i96 @llvm.amdgcn.s.buffer.load.i96(<4 x i32>, i32, i32 immarg)
declare i256 @llvm.amdgcn.s.buffer.load.i256(<4 x i32>, i32, i32 immarg)
declare i512 @llvm.amdgcn.s.buffer.load.i512(<4 x i32>, i32, i32 immarg)

declare <16 x i16> @llvm.amdgcn.s.buffer.load.v16i16(<4 x i32>, i32, i32 immarg)
declare <32 x i16> @llvm.amdgcn.s.buffer.load.v32i16(<4 x i32>, i32, i32 immarg)

declare <4 x i64> @llvm.amdgcn.s.buffer.load.v4i64(<4 x i32>, i32, i32 immarg)
declare <8 x i64> @llvm.amdgcn.s.buffer.load.v8i64(<4 x i32>, i32, i32 immarg)

declare <4 x i8 addrspace(1)*> @llvm.amdgcn.s.buffer.load.v4p1i8(<4 x i32>, i32, i32 immarg)
declare <8 x i8 addrspace(1)*> @llvm.amdgcn.s.buffer.load.v8p1i8(<4 x i32>, i32, i32 immarg)
