// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: powerpc-registered-target
// RUN: %clang_cc1 -O2 -target-feature +altivec -target-feature +power8-vector \
// RUN:   -triple powerpc64le-unknown-unknown -emit-llvm %s -o - | FileCheck \
// RUN:   %s -check-prefix=CHECK-LE
// RUN: %clang_cc1 -O2 -target-feature +altivec -target-feature +power8-vector \
// RUN:   -triple powerpc64-aix-unknown -emit-llvm %s -o - | FileCheck \
// RUN:   %s -check-prefix=CHECK-AIX
#include <altivec.h>
// CHECK-LE-LABEL: @test_subc(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vsubcuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]]) #[[ATTR3:[0-9]+]]
// CHECK-LE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i128> [[TMP2]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP3]]
//
// CHECK-AIX-LABEL: @test_subc(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vsubcuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]]) #[[ATTR3:[0-9]+]]
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = bitcast <1 x i128> [[TMP2]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP3]]
//
vector unsigned char test_subc(vector unsigned char a, vector unsigned char b) {
  return vec_subc_u128(a, b);
}
// CHECK-LE-LABEL: @test_subec(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vsubecuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-LE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP4]]
//
// CHECK-AIX-LABEL: @test_subec(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vsubecuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-AIX-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP4]]
//
vector unsigned char test_subec(vector unsigned char a, vector unsigned char b,
                                vector unsigned char c) {
  return vec_subec_u128(a, b, c);
}
// CHECK-LE-LABEL: @test_sube(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vsubeuqm(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-LE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP4]]
//
// CHECK-AIX-LABEL: @test_sube(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vsubeuqm(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-AIX-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP4]]
//
vector unsigned char test_sube(vector unsigned char a, vector unsigned char b,
                               vector unsigned char c) {
  return vec_sube_u128(a, b, c);
}
// CHECK-LE-LABEL: @test_sub(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[VADDUQM_I_NEG:%.*]] = sub <1 x i128> [[TMP2]], [[TMP0]]
// CHECK-LE-NEXT:    [[VSUBUQM_I:%.*]] = sub <1 x i128> [[VADDUQM_I_NEG]], [[TMP1]]
// CHECK-LE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i128> [[VSUBUQM_I]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP3]]
//
// CHECK-AIX-LABEL: @test_sub(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[VADDUQM_I_NEG:%.*]] = sub <1 x i128> [[TMP2]], [[TMP0]]
// CHECK-AIX-NEXT:    [[VSUBUQM_I:%.*]] = sub <1 x i128> [[VADDUQM_I_NEG]], [[TMP1]]
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = bitcast <1 x i128> [[VSUBUQM_I]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP3]]
//
vector unsigned char test_sub(vector unsigned char a, vector unsigned char b,
                              vector unsigned char c) {
  return vec_sub_u128(a, vec_add_u128(b, c));
}
// CHECK-LE-LABEL: @test_addc(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vaddcuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]]) #[[ATTR3]]
// CHECK-LE-NEXT:    [[TMP3:%.*]] = bitcast <1 x i128> [[TMP2]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP3]]
//
// CHECK-AIX-LABEL: @test_addc(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vaddcuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]]) #[[ATTR3]]
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = bitcast <1 x i128> [[TMP2]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP3]]
//
vector unsigned char test_addc(vector unsigned char a, vector unsigned char b) {
  return vec_addc_u128(a, b);
}
// CHECK-LE-LABEL: @test_addec(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vaddecuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-LE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP4]]
//
// CHECK-AIX-LABEL: @test_addec(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vaddecuq(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-AIX-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP4]]
//
vector unsigned char test_addec(vector unsigned char a, vector unsigned char b,
                                vector unsigned char c) {
  return vec_addec_u128(a, b, c);
}
// CHECK-LE-LABEL: @test_adde(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vaddeuqm(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-LE-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP4]]
//
// CHECK-AIX-LABEL: @test_adde(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = bitcast <16 x i8> [[C:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP3:%.*]] = tail call <1 x i128> @llvm.ppc.altivec.vaddeuqm(<1 x i128> [[TMP0]], <1 x i128> [[TMP1]], <1 x i128> [[TMP2]]) #[[ATTR3]]
// CHECK-AIX-NEXT:    [[TMP4:%.*]] = bitcast <1 x i128> [[TMP3]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP4]]
//
vector unsigned char test_adde(vector unsigned char a, vector unsigned char b,
                               vector unsigned char c) {
  return vec_adde_u128(a, b, c);
}
// CHECK-LE-LABEL: @test_add(
// CHECK-LE-NEXT:  entry:
// CHECK-LE-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-LE-NEXT:    [[VADDUQM_I:%.*]] = add <1 x i128> [[TMP1]], [[TMP0]]
// CHECK-LE-NEXT:    [[TMP2:%.*]] = bitcast <1 x i128> [[VADDUQM_I]] to <16 x i8>
// CHECK-LE-NEXT:    ret <16 x i8> [[TMP2]]
//
// CHECK-AIX-LABEL: @test_add(
// CHECK-AIX-NEXT:  entry:
// CHECK-AIX-NEXT:    [[TMP0:%.*]] = bitcast <16 x i8> [[A:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[TMP1:%.*]] = bitcast <16 x i8> [[B:%.*]] to <1 x i128>
// CHECK-AIX-NEXT:    [[VADDUQM_I:%.*]] = add <1 x i128> [[TMP1]], [[TMP0]]
// CHECK-AIX-NEXT:    [[TMP2:%.*]] = bitcast <1 x i128> [[VADDUQM_I]] to <16 x i8>
// CHECK-AIX-NEXT:    ret <16 x i8> [[TMP2]]
//
vector unsigned char test_add(vector unsigned char a, vector unsigned char b) {
  return vec_add_u128(a, b);
}
