//===-- lldb-loongarch-register-enums.h -------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_LOONGARCH_REGISTER_ENUMS_H
#define LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_LOONGARCH_REGISTER_ENUMS_H

// LLDB register codes (e.g. RegisterKind == eRegisterKindLLDB)

// Internal codes for all loongarch registers.
enum {
  // The same order as user_regs_struct in <asm/ptrace.h>
  // note: these enum values are used as byte_offset
  gpr_first_loongarch = 0,
  gpr_r0_loongarch = gpr_first_loongarch,
  gpr_r1_loongarch,
  gpr_r2_loongarch,
  gpr_r3_loongarch,
  gpr_r4_loongarch,
  gpr_r5_loongarch,
  gpr_r6_loongarch,
  gpr_r7_loongarch,
  gpr_r8_loongarch,
  gpr_r9_loongarch,
  gpr_r10_loongarch,
  gpr_r11_loongarch,
  gpr_r12_loongarch,
  gpr_r13_loongarch,
  gpr_r14_loongarch,
  gpr_r15_loongarch,
  gpr_r16_loongarch,
  gpr_r17_loongarch,
  gpr_r18_loongarch,
  gpr_r19_loongarch,
  gpr_r20_loongarch,
  gpr_r21_loongarch,
  gpr_r22_loongarch,
  gpr_r23_loongarch,
  gpr_r24_loongarch,
  gpr_r25_loongarch,
  gpr_r26_loongarch,
  gpr_r27_loongarch,
  gpr_r28_loongarch,
  gpr_r29_loongarch,
  gpr_r30_loongarch,
  gpr_r31_loongarch,
  gpr_orig_a0_loongarch,
  gpr_pc_loongarch,
  gpr_badv_loongarch,
  gpr_reserved0_loongarch,
  gpr_reserved1_loongarch,
  gpr_reserved2_loongarch,
  gpr_reserved3_loongarch,
  gpr_reserved4_loongarch,
  gpr_reserved5_loongarch,
  gpr_reserved6_loongarch,
  gpr_reserved7_loongarch,
  gpr_reserved8_loongarch,
  gpr_reserved9_loongarch,
  gpr_last_loongarch = 44,

  gpr_zero_loongarch = gpr_r0_loongarch,
  gpr_ra_loongarch = gpr_r1_loongarch,
  gpr_tp_loongarch = gpr_r2_loongarch,
  gpr_sp_loongarch = gpr_r3_loongarch,
  gpr_a0_loongarch = gpr_r4_loongarch,
  gpr_a1_loongarch = gpr_r5_loongarch,
  gpr_a2_loongarch = gpr_r6_loongarch,
  gpr_a3_loongarch = gpr_r7_loongarch,
  gpr_a4_loongarch = gpr_r8_loongarch,
  gpr_a5_loongarch = gpr_r9_loongarch,
  gpr_a6_loongarch = gpr_r10_loongarch,
  gpr_a7_loongarch = gpr_r11_loongarch,
  gpr_t0_loongarch = gpr_r12_loongarch,
  gpr_t1_loongarch = gpr_r13_loongarch,
  gpr_t2_loongarch = gpr_r14_loongarch,
  gpr_t3_loongarch = gpr_r15_loongarch,
  gpr_t4_loongarch = gpr_r16_loongarch,
  gpr_t5_loongarch = gpr_r17_loongarch,
  gpr_t6_loongarch = gpr_r18_loongarch,
  gpr_t7_loongarch = gpr_r19_loongarch,
  gpr_t8_loongarch = gpr_r20_loongarch,
  gpr_fp_loongarch = gpr_r22_loongarch,
  gpr_s9_loongarch = gpr_r22_loongarch,
  gpr_s0_loongarch = gpr_r23_loongarch,
  gpr_s1_loongarch = gpr_r24_loongarch,
  gpr_s2_loongarch = gpr_r25_loongarch,
  gpr_s3_loongarch = gpr_r26_loongarch,
  gpr_s4_loongarch = gpr_r27_loongarch,
  gpr_s5_loongarch = gpr_r28_loongarch,
  gpr_s6_loongarch = gpr_r29_loongarch,
  gpr_s7_loongarch = gpr_r30_loongarch,
  gpr_s8_loongarch = gpr_r31_loongarch,

  fpr_first_loongarch = 45,
  fpr_f0_loongarch = fpr_first_loongarch,
  fpr_f1_loongarch,
  fpr_f2_loongarch,
  fpr_f3_loongarch,
  fpr_f4_loongarch,
  fpr_f5_loongarch,
  fpr_f6_loongarch,
  fpr_f7_loongarch,
  fpr_f8_loongarch,
  fpr_f9_loongarch,
  fpr_f10_loongarch,
  fpr_f11_loongarch,
  fpr_f12_loongarch,
  fpr_f13_loongarch,
  fpr_f14_loongarch,
  fpr_f15_loongarch,
  fpr_f16_loongarch,
  fpr_f17_loongarch,
  fpr_f18_loongarch,
  fpr_f19_loongarch,
  fpr_f20_loongarch,
  fpr_f21_loongarch,
  fpr_f22_loongarch,
  fpr_f23_loongarch,
  fpr_f24_loongarch,
  fpr_f25_loongarch,
  fpr_f26_loongarch,
  fpr_f27_loongarch,
  fpr_f28_loongarch,
  fpr_f29_loongarch,
  fpr_f30_loongarch,
  fpr_f31_loongarch,
  fpr_fcc0_loongarch,
  fpr_fcc1_loongarch,
  fpr_fcc2_loongarch,
  fpr_fcc3_loongarch,
  fpr_fcc4_loongarch,
  fpr_fcc5_loongarch,
  fpr_fcc6_loongarch,
  fpr_fcc7_loongarch,
  fpr_fcsr_loongarch,
  fpr_last_loongarch = fpr_fcsr_loongarch,

  fpr_fa0_loongarch = fpr_f0_loongarch,
  fpr_fa1_loongarch = fpr_f1_loongarch,
  fpr_fa2_loongarch = fpr_f2_loongarch,
  fpr_fa3_loongarch = fpr_f3_loongarch,
  fpr_fa4_loongarch = fpr_f4_loongarch,
  fpr_fa5_loongarch = fpr_f5_loongarch,
  fpr_fa6_loongarch = fpr_f6_loongarch,
  fpr_fa7_loongarch = fpr_f7_loongarch,
  fpr_ft0_loongarch = fpr_f8_loongarch,
  fpr_ft1_loongarch = fpr_f9_loongarch,
  fpr_ft2_loongarch = fpr_f10_loongarch,
  fpr_ft3_loongarch = fpr_f11_loongarch,
  fpr_ft4_loongarch = fpr_f12_loongarch,
  fpr_ft5_loongarch = fpr_f13_loongarch,
  fpr_ft6_loongarch = fpr_f14_loongarch,
  fpr_ft7_loongarch = fpr_f15_loongarch,
  fpr_ft8_loongarch = fpr_f16_loongarch,
  fpr_ft9_loongarch = fpr_f17_loongarch,
  fpr_ft10_loongarch = fpr_f18_loongarch,
  fpr_ft11_loongarch = fpr_f19_loongarch,
  fpr_ft12_loongarch = fpr_f20_loongarch,
  fpr_ft13_loongarch = fpr_f21_loongarch,
  fpr_ft14_loongarch = fpr_f22_loongarch,
  fpr_ft15_loongarch = fpr_f23_loongarch,
  fpr_fs0_loongarch = fpr_f24_loongarch,
  fpr_fs1_loongarch = fpr_f25_loongarch,
  fpr_fs2_loongarch = fpr_f26_loongarch,
  fpr_fs3_loongarch = fpr_f27_loongarch,
  fpr_fs4_loongarch = fpr_f28_loongarch,
  fpr_fs5_loongarch = fpr_f29_loongarch,
  fpr_fs6_loongarch = fpr_f30_loongarch,
  fpr_fs7_loongarch = fpr_f31_loongarch,

  k_num_registers_loongarch
};

#endif // LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_LOONGARCH_REGISTER_ENUMS_H
