# REQUIRES: x86,aarch64
## FIXME: The tests doesn't run on windows right now because of llvm-mc (can't produce triple=arm64-apple-macos11.0)
# UNSUPPORTED: system-windows

# RUN: llvm-mc -filetype=obj -triple=i386-apple-darwin %s -o %t.i386.o
# RUN: llvm-mc -filetype=obj -triple=x86_64-apple-darwin %s -o %t.x86_64.o
# RUN: llvm-mc -filetype=obj -triple=arm64-apple-macos11.0 %s -o %t.arm64.o

# RUN: llvm-lipo %t.i386.o %t.x86_64.o -create -o %t.fat.o
# RUN: %lld -o /dev/null %t.fat.o
# RUN: llvm-lipo %t.i386.o -create -o %t.noarch.o
# RUN: not %lld -o /dev/null %t.noarch.o 2>&1 | \
# RUN:    FileCheck %s -DFILE=%t.noarch.o
# CHECK: error: unable to find matching architecture in [[FILE]]

## Validates that we read the cpu-subtype correctly from a fat exec.
# RUN: %lld -o %t.x86_64.out %t.x86_64.o
# RUN: %lld -arch arm64 -o %t.arm64.out %t.arm64.o
# RUN: llvm-lipo %t.x86_64.out %t.arm64.out -create -o %t.fat.exec.out
# RUN: %lld -arch x86_64 %t.x86_64.o -bundle_loader %t.fat.exec.out -bundle -o %t.fat.bundle

## FIXME: Re-enable this test, which is failing on arm64, once we figured out why
## %t.fat.bundle is produced as an arm64.
# RUN llvm-otool -h %t.fat.bundle -f %t.fat.exec.out | FileCheck %s --check-prefix=CPU-SUB
# CPU-SUB: Fat headers
# CPU-SUB: nfat_arch 2
# CPU-SUB: architecture 0
# CPU-SUB-NEXT:    cputype 16777223
# CPU-SUB-NEXT:    cpusubtype 3
# CPU-SUB: architecture 1
# CPU-SUB-NEXT:    cputype 16777228
# CPU-SUB-NEXT:    cpusubtype 0

# CPU-SUB:            magic     cputype      cpusubtype   caps      filetype   ncmds sizeofcmds      flags
# CPU-SUB-NEXT:  0xfeedfacf     16777223              3  0x{{.+}}    {{.+}}  {{.+}}    {{.+}}      {{.+}}

.text
.global _main
_main:
  ret
