// RUN: %clang_cc1 -triple thumbv8.1m.main-none-eabi -target-feature +pacbti -fcxx-exceptions -fexceptions -emit-llvm %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-PACBTI
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-eabi -target-feature -pacbti -fcxx-exceptions -fexceptions -emit-llvm %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-NOPACBTI

// Check that functions generated by clang have the correct attributes

class Example {
public:
  Example();
  int fn();
};

// Initialization of var1 causes __cxx_global_var_init and __tls_init to be generated
thread_local Example var1;
extern thread_local Example var2;
extern void fn();

int testfn() noexcept {
  // Calling fn in a noexcept function causes __clang_call_terminate to be generated
  fn();
  // Use of var1 and var2 causes TLS wrapper functions to be generated
  return var1.fn() + var2.fn();
}

// CHECK: define {{.*}} @__cxx_global_var_init() [[ATTR1:#[0-9]+]]
// CHECK: define {{.*}} @__clang_call_terminate({{.*}}) [[ATTR2:#[0-9]+]]
// CHECK: define {{.*}} @_ZTW4var1() [[ATTR3:#[0-9]+]]
// CHECK: define {{.*}} @_ZTW4var2() [[ATTR3]]
// CHECK: define {{.*}} @__tls_init() [[ATTR1]]

// CHECK-PACBTI: attributes [[ATTR1]] = { {{.*}}"target-features"="+armv8.1-m.main,+pacbti,+thumb-mode"{{.*}} }
// CHECK-PACBTI: attributes [[ATTR2]] = { {{.*}}"target-features"="+armv8.1-m.main,+pacbti,+thumb-mode"{{.*}} }
// CHECK-PACBTI: attributes [[ATTR3]] = { {{.*}}"target-features"="+armv8.1-m.main,+pacbti,+thumb-mode"{{.*}} }

// CHECK-NOPACBTI: attributes [[ATTR1]] = { {{.*}}"target-features"="+armv8.1-m.main,+thumb-mode,-pacbti"{{.*}} }
// CHECK-NOPACBTI: attributes [[ATTR2]] = { {{.*}}"target-features"="+armv8.1-m.main,+thumb-mode,-pacbti"{{.*}} }
// CHECK-NOPACBTI: attributes [[ATTR3]] = { {{.*}}"target-features"="+armv8.1-m.main,+thumb-mode,-pacbti"{{.*}} }
