; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN: FileCheck %s --check-prefix=CHECK-P9

define dso_local <16 x i8> @testmrghb(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrghb:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vmrghb v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrghb:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vmrghb v2, v3, v2
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrghb2(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrghb2:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; CHECK-P8-NEXT:    lvx v4, 0, r3
; CHECK-P8-NEXT:    vperm v2, v3, v2, v4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrghb2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, .LCPI1_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI1_0@toc@l
; CHECK-P9-NEXT:    lxvx v4, 0, r3
; CHECK-P9-NEXT:    vperm v2, v3, v2, v4
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 24, i32 8, i32 25, i32 9, i32 26, i32 10, i32 27, i32 11, i32 28, i32 12, i32 29, i32 13, i32 30, i32 14, i32 31, i32 15>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrghh(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrghh:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vmrghh v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrghh:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vmrghh v2, v3, v2
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 8, i32 9, i32 24, i32 25, i32 10, i32 11, i32 26, i32 27, i32 12, i32 13, i32 28, i32 29, i32 14, i32 15, i32 30, i32 31>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrghh2(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrghh2:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI3_0@toc@l
; CHECK-P8-NEXT:    lvx v4, 0, r3
; CHECK-P8-NEXT:    vperm v2, v3, v2, v4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrghh2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, .LCPI3_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI3_0@toc@l
; CHECK-P9-NEXT:    lxvx v4, 0, r3
; CHECK-P9-NEXT:    vperm v2, v3, v2, v4
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 24, i32 25, i32 8, i32 9, i32 26, i32 27, i32 10, i32 11, i32 28, i32 29, i32 12, i32 13, i32 30, i32 31, i32 14, i32 15>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrglb(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglb:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vmrglb v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglb:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vmrglb v2, v3, v2
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrglb2(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglb2:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; CHECK-P8-NEXT:    lvx v4, 0, r3
; CHECK-P8-NEXT:    vperm v2, v3, v2, v4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglb2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, .LCPI5_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI5_0@toc@l
; CHECK-P9-NEXT:    lxvx v4, 0, r3
; CHECK-P9-NEXT:    vperm v2, v3, v2, v4
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 0, i32 17, i32 1, i32 18, i32 2, i32 19, i32 3, i32 20, i32 4, i32 21, i32 5, i32 22, i32 6, i32 23, i32 7>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrglh(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglh:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vmrglh v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglh:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vmrglh v2, v3, v2
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 16, i32 17, i32 2, i32 3, i32 18, i32 19, i32 4, i32 5, i32 20, i32 21, i32 6, i32 7, i32 22, i32 23>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrglh2(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglh2:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; CHECK-P8-NEXT:    lvx v4, 0, r3
; CHECK-P8-NEXT:    vperm v2, v3, v2, v4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglh2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, .LCPI7_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI7_0@toc@l
; CHECK-P9-NEXT:    lxvx v4, 0, r3
; CHECK-P9-NEXT:    vperm v2, v3, v2, v4
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 0, i32 1, i32 18, i32 19, i32 2, i32 3, i32 20, i32 21, i32 4, i32 5, i32 22, i32 23, i32 6, i32 7>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrghw(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrghw:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vmrghw v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrghw:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vmrghw v2, v3, v2
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 8, i32 9, i32 10, i32 11, i32 24, i32 25, i32 26, i32 27, i32 12, i32 13, i32 14, i32 15, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrghw2(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrghw2:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; CHECK-P8-NEXT:    lvx v4, 0, r3
; CHECK-P8-NEXT:    vperm v2, v3, v2, v4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrghw2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, .LCPI9_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI9_0@toc@l
; CHECK-P9-NEXT:    lxvx v4, 0, r3
; CHECK-P9-NEXT:    vperm v2, v3, v2, v4
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 24, i32 25, i32 26, i32 27, i32 8, i32 9, i32 10, i32 11, i32 28, i32 29, i32 30, i32 31, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrglw(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglw:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    vmrglw v2, v3, v2
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglw:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    vmrglw v2, v3, v2
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 4, i32 5, i32 6, i32 7, i32 20, i32 21, i32 22, i32 23>
  ret <16 x i8> %shuffle
}
define dso_local <16 x i8> @testmrglw2(<16 x i8> %a, <16 x i8> %b) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglw2:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, .LCPI11_0@toc@ha
; CHECK-P8-NEXT:    addi r3, r3, .LCPI11_0@toc@l
; CHECK-P8-NEXT:    lvx v4, 0, r3
; CHECK-P8-NEXT:    vperm v2, v3, v2, v4
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglw2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, .LCPI11_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI11_0@toc@l
; CHECK-P9-NEXT:    lxvx v4, 0, r3
; CHECK-P9-NEXT:    vperm v2, v3, v2, v4
; CHECK-P9-NEXT:    blr
entry:
  %shuffle = shufflevector <16 x i8> %a, <16 x i8> %b, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 0, i32 1, i32 2, i32 3, i32 20, i32 21, i32 22, i32 23, i32 4, i32 5, i32 6, i32 7>
  ret <16 x i8> %shuffle
}

define dso_local <8 x i16> @testmrglb3(<8 x i8>* nocapture readonly %a) local_unnamed_addr #0 {
; CHECK-P8-LABEL: testmrglb3:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    ld r3, 0(r3)
; CHECK-P8-NEXT:    addis r4, r2, .LCPI12_0@toc@ha
; CHECK-P8-NEXT:    xxlxor v4, v4, v4
; CHECK-P8-NEXT:    mtfprd f0, r3
; CHECK-P8-NEXT:    addi r3, r4, .LCPI12_0@toc@l
; CHECK-P8-NEXT:    lvx v3, 0, r3
; CHECK-P8-NEXT:    xxswapd v2, vs0
; CHECK-P8-NEXT:    vperm v2, v2, v4, v3
; CHECK-P8-NEXT:    blr
;
; CHECK-P9-LABEL: testmrglb3:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lfd f0, 0(r3)
; CHECK-P9-NEXT:    addis r3, r2, .LCPI12_0@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, .LCPI12_0@toc@l
; CHECK-P9-NEXT:    lxvx v3, 0, r3
; CHECK-P9-NEXT:    xxswapd v2, f0
; CHECK-P9-NEXT:    xxlxor v4, v4, v4
; CHECK-P9-NEXT:    vperm v2, v2, v4, v3
; CHECK-P9-NEXT:    blr
entry:
  %0 = load <8 x i8>, <8 x i8>* %a, align 8
  %1 = zext <8 x i8> %0 to <8 x i16>
  ret <8 x i16> %1
}

attributes #0 = { nounwind }
