// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// expected-no-diagnostics
#ifndef HEADER
#define HEADER
// Test host codegen.
// RUN: %clang_cc1 -DCK1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK2
// RUN: %clang_cc1 -DCK1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK4

// RUN: %clang_cc1 -DCK1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK6
// RUN: %clang_cc1 -DCK1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK7
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK8
#ifdef CK1

int a[100];

int teams_argument_global(int n) {
  int i;
  int te = n / 128;
  int th = 128;
  // discard n_addr and i


  #pragma omp target
  #pragma omp teams distribute simd num_teams(te), thread_limit(th) aligned(a) simdlen(16) linear(i)
  for(i = 0; i < n; i++) {
    a[i] = 0;
  }

  #pragma omp target
  {{{
  #pragma omp teams distribute simd safelen(32)
  for(int i = 0; i < n; i++) {
    a[i] = 0;
  }
  }}}

  // outlined target regions




  return a[0];
}


#endif // CK1

// Test host codegen.
// RUN: %clang_cc1 -DCK2 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK10
// RUN: %clang_cc1 -DCK2 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK11
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK12

// RUN: %clang_cc1 -DCK2 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK13
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK14
// RUN: %clang_cc1 -DCK2 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK15
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK16
#ifdef CK2

int teams_local_arg(void) {
  int n = 100;
  int a[n];

  #pragma omp target
  #pragma omp teams distribute simd
  for(int i = 0; i < n; i++) {
    a[i] = 0;
  }

  // outlined target region


  return a[0];
}
#endif // CK2

// Test host codegen.
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK17
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK18
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK19
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK20
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK21
// RUN: %clang_cc1 -DCK3 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK22
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK23
// RUN: %clang_cc1 -DCK3 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK24

// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK25
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK26
// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK27
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK28
// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK29
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK30
// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK31
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK32
#ifdef CK3


template <typename T, int X, long long Y>
struct SS{
  T a[X];
  float b;
  int foo(void) {

    #pragma omp target
#ifdef OMP5
    #pragma omp teams distribute simd if(b) nontemporal(a, b)
#else
    #pragma omp teams distribute simd
#endif // OMP5
    for(int i = 0; i < X; i++) {
      a[i] = (T)b;
    }

      // outlined target region


    return a[0];
  }
};

int teams_template_struct(void) {
  SS<int, 123, 456> V;
  return V.foo();

}
#endif // CK3

// Test host codegen.
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK33
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK34
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK35
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK36
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK37
// RUN: %clang_cc1 -DCK4 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK38
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK39
// RUN: %clang_cc1 -DCK4 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp -fopenmp-version=50 -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK40

// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK41
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK42
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK43
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK44
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK45
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK46
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK47
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -fopenmp-version=50 -DOMP5 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK48

#ifdef CK4

template <typename T, int n>
int tmain(T argc) {
  T a[n];
  int te = n/128;
  int th = 128;
#pragma omp target
#pragma omp teams distribute simd num_teams(te) thread_limit(th)
  for(int i = 0; i < n; i++) {
    a[i] = (T)0;
  }
  return 0;
}

int main (int argc, char **argv) {
  int n = 100;
  int a[n];
#pragma omp target
#ifdef OMP5
#pragma omp teams distribute simd if(simd:argc)
#else
#pragma omp teams distribute simd
#endif // OMP5
  for(int i = 0; i < n; i++) {
    a[i] = 0;
  }
  return tmain<int, 10>(argc);
}







// OMP5_50-DAG: !{!"llvm.loop.vectorize.enable", i1 false}
#endif // CK4
#endif

// CHECK1-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK1-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[N_CASTED7:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [2 x i8*], align 8
// CHECK1-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK1-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK1-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP1]], i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[CONV1]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[CONV2]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK1-NEXT:    store i32 [[TMP7]], i32* [[CONV3]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK1-NEXT:    store i64 [[TMP2]], i64* [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK1-NEXT:    store i64 [[TMP4]], i64* [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK1-NEXT:    store i64 [[TMP4]], i64* [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP22]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK1-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK1-NEXT:    store i64 [[TMP6]], i64* [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK1-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK1-NEXT:    store i64 [[TMP8]], i64* [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK1-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i64*
// CHECK1-NEXT:    store i64 [[TMP8]], i64* [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK1-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP36:%.*]] = load i32, i32* [[TE]], align 4
// CHECK1-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP38]], 0
// CHECK1-NEXT:    [[DIV5:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[DIV5]], 1
// CHECK1-NEXT:    store i32 [[SUB6]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP39]], 1
// CHECK1-NEXT:    [[TMP40:%.*]] = zext i32 [[ADD]] to i64
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP40]])
// CHECK1-NEXT:    [[TMP41:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP36]], i32 1)
// CHECK1-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP41]], 0
// CHECK1-NEXT:    br i1 [[TMP42]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30(i64 [[TMP2]], i64 [[TMP4]], [100 x i32]* @a, i64 [[TMP6]], i64 [[TMP8]]) #[[ATTR3:[0-9]+]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    [[TMP43:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    [[CONV8:%.*]] = bitcast i64* [[N_CASTED7]] to i32*
// CHECK1-NEXT:    store i32 [[TMP43]], i32* [[CONV8]], align 4
// CHECK1-NEXT:    [[TMP44:%.*]] = load i64, i64* [[N_CASTED7]], align 8
// CHECK1-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i64*
// CHECK1-NEXT:    store i64 [[TMP44]], i64* [[TMP46]], align 8
// CHECK1-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i64*
// CHECK1-NEXT:    store i64 [[TMP44]], i64* [[TMP48]], align 8
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK1-NEXT:    store i8* null, i8** [[TMP49]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP51]], align 8
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to [100 x i32]**
// CHECK1-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP53]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 1
// CHECK1-NEXT:    store i8* null, i8** [[TMP54]], align 8
// CHECK1-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK1-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK1-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK1-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK1-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK1-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK1-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK1-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK1-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD18]] to i64
// CHECK1-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP60]])
// CHECK1-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 2, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK1-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK1-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED19:%.*]], label [[OMP_OFFLOAD_CONT20:%.*]]
// CHECK1:       omp_offload.failed19:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36(i64 [[TMP44]], [100 x i32]* @a) #[[ATTR3]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT20]]
// CHECK1:       omp_offload.cont20:
// CHECK1-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK1-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30
// CHECK1-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK1-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV2:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK1-NEXT:    [[CONV3:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV2]], i32* [[CONV3]], [100 x i32]* [[TMP1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 [[IDXPROM]]
// CHECK1-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK1-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK1-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK1-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK1-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK1-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK1-NEXT:    store i32 [[ADD11]], i32* [[TMP0]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK1-SAME: (i64 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK1-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32* [[CONV]], [100 x i32]* [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK1:       omp.precond.then:
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK1-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I3]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP16]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i64 0, i64 [[IDXPROM]]
// CHECK1-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK1-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, i32* [[TMP18]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP19]])
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK1-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP22]], 0
// CHECK1-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK1-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK1-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK1-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK1:       omp.precond.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK2-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[I_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[N_CASTED7:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [2 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [2 x i8*], align 8
// CHECK2-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [2 x i8*], align 8
// CHECK2-NEXT:    [[_TMP12:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_13:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK2-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK2-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP1]], i32* [[CONV]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[CONV1]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[I_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[CONV2]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, i64* [[I_CASTED]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[CONV3:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK2-NEXT:    store i32 [[TMP7]], i32* [[CONV3]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK2-NEXT:    store i64 [[TMP2]], i64* [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK2-NEXT:    store i64 [[TMP2]], i64* [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK2-NEXT:    store i64 [[TMP4]], i64* [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK2-NEXT:    store i64 [[TMP4]], i64* [[TMP17]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP22]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK2-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK2-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i64*
// CHECK2-NEXT:    store i64 [[TMP6]], i64* [[TMP25]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i64*
// CHECK2-NEXT:    store i64 [[TMP6]], i64* [[TMP27]], align 8
// CHECK2-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK2-NEXT:    store i8* null, i8** [[TMP28]], align 8
// CHECK2-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK2-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i64*
// CHECK2-NEXT:    store i64 [[TMP8]], i64* [[TMP30]], align 8
// CHECK2-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK2-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i64*
// CHECK2-NEXT:    store i64 [[TMP8]], i64* [[TMP32]], align 8
// CHECK2-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK2-NEXT:    store i8* null, i8** [[TMP33]], align 8
// CHECK2-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP36:%.*]] = load i32, i32* [[TE]], align 4
// CHECK2-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP38]], 0
// CHECK2-NEXT:    [[DIV5:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[DIV5]], 1
// CHECK2-NEXT:    store i32 [[SUB6]], i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK2-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_4]], align 4
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP39]], 1
// CHECK2-NEXT:    [[TMP40:%.*]] = zext i32 [[ADD]] to i64
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP40]])
// CHECK2-NEXT:    [[TMP41:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP36]], i32 1)
// CHECK2-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP41]], 0
// CHECK2-NEXT:    br i1 [[TMP42]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK2:       omp_offload.failed:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30(i64 [[TMP2]], i64 [[TMP4]], [100 x i32]* @a, i64 [[TMP6]], i64 [[TMP8]]) #[[ATTR3:[0-9]+]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK2:       omp_offload.cont:
// CHECK2-NEXT:    [[TMP43:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    [[CONV8:%.*]] = bitcast i64* [[N_CASTED7]] to i32*
// CHECK2-NEXT:    store i32 [[TMP43]], i32* [[CONV8]], align 4
// CHECK2-NEXT:    [[TMP44:%.*]] = load i64, i64* [[N_CASTED7]], align 8
// CHECK2-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i64*
// CHECK2-NEXT:    store i64 [[TMP44]], i64* [[TMP46]], align 8
// CHECK2-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i64*
// CHECK2-NEXT:    store i64 [[TMP44]], i64* [[TMP48]], align 8
// CHECK2-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK2-NEXT:    store i8* null, i8** [[TMP49]], align 8
// CHECK2-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP51]], align 8
// CHECK2-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to [100 x i32]**
// CHECK2-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP53]], align 8
// CHECK2-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 1
// CHECK2-NEXT:    store i8* null, i8** [[TMP54]], align 8
// CHECK2-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK2-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_13]], align 4
// CHECK2-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK2-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK2-NEXT:    [[SUB17:%.*]] = sub nsw i32 [[DIV16]], 1
// CHECK2-NEXT:    store i32 [[SUB17]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK2-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK2-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK2-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD18]] to i64
// CHECK2-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP60]])
// CHECK2-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 2, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK2-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK2-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED19:%.*]], label [[OMP_OFFLOAD_CONT20:%.*]]
// CHECK2:       omp_offload.failed19:
// CHECK2-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36(i64 [[TMP44]], [100 x i32]* @a) #[[ATTR3]]
// CHECK2-NEXT:    br label [[OMP_OFFLOAD_CONT20]]
// CHECK2:       omp_offload.cont20:
// CHECK2-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK2-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30
// CHECK2-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i64 [[I:%.*]], i64 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK2-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[I]], i64* [[I_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK2-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[CONV2:%.*]] = bitcast i64* [[I_ADDR]] to i32*
// CHECK2-NEXT:    [[CONV3:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK2-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV2]], i32* [[CONV3]], [100 x i32]* [[TMP1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 8
// CHECK2-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i64 16) ]
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK2-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK2-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i64 0, i64 [[IDXPROM]]
// CHECK2-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK2-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK2-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK2-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK2-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK2-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK2-NEXT:    store i32 [[ADD11]], i32* [[TMP0]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK2-SAME: (i64 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK2-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32* [[CONV]], [100 x i32]* [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK2-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 8
// CHECK2-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK2-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK2:       omp.precond.then:
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK2-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK2-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK2:       cond.true:
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    br label [[COND_END:%.*]]
// CHECK2:       cond.false:
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    br label [[COND_END]]
// CHECK2:       cond.end:
// CHECK2-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK2-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK2-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK2:       omp.inner.for.cond:
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK2-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK2-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK2:       omp.inner.for.body:
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK2-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I3]], align 4
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP16]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i64 0, i64 [[IDXPROM]]
// CHECK2-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK2-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK2:       omp.body.continue:
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK2:       omp.inner.for.inc:
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK2-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK2:       omp.inner.for.end:
// CHECK2-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK2:       omp.loop.exit:
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, i32* [[TMP18]], align 4
// CHECK2-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP19]])
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK2-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK2-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK2:       .omp.final.then:
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP22]], 0
// CHECK2-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK2-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK2-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK2-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK2-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK2:       .omp.final.done:
// CHECK2-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK2:       omp.precond.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK2-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK2-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK3-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_CASTED4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [2 x i8*], align 4
// CHECK3-NEXT:    [[_TMP8:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK3-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK3-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], i32* [[TE_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[TH_CASTED]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[I_CASTED]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP7]], i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK3-NEXT:    store i32 [[TMP4]], i32* [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP20]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP22]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK3-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i32*
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[TMP27]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK3-NEXT:    store i8* null, i8** [[TMP28]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32*
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK3-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i32*
// CHECK3-NEXT:    store i32 [[TMP8]], i32* [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK3-NEXT:    store i8* null, i8** [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP36:%.*]] = load i32, i32* [[TE]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP38]], 0
// CHECK3-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK3-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP39]], 1
// CHECK3-NEXT:    [[TMP40:%.*]] = zext i32 [[ADD]] to i64
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP40]])
// CHECK3-NEXT:    [[TMP41:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP36]], i32 1)
// CHECK3-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP41]], 0
// CHECK3-NEXT:    br i1 [[TMP42]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30(i32 [[TMP2]], i32 [[TMP4]], [100 x i32]* @a, i32 [[TMP6]], i32 [[TMP8]]) #[[ATTR3:[0-9]+]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    [[TMP43:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP43]], i32* [[N_CASTED4]], align 4
// CHECK3-NEXT:    [[TMP44:%.*]] = load i32, i32* [[N_CASTED4]], align 4
// CHECK3-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i32*
// CHECK3-NEXT:    store i32 [[TMP44]], i32* [[TMP46]], align 4
// CHECK3-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32*
// CHECK3-NEXT:    store i32 [[TMP44]], i32* [[TMP48]], align 4
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 0
// CHECK3-NEXT:    store i8* null, i8** [[TMP49]], align 4
// CHECK3-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP51]], align 4
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to [100 x i32]**
// CHECK3-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP53]], align 4
// CHECK3-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 1
// CHECK3-NEXT:    store i8* null, i8** [[TMP54]], align 4
// CHECK3-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK3-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK3-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK3-NEXT:    [[DIV12:%.*]] = sdiv i32 [[SUB11]], 1
// CHECK3-NEXT:    [[SUB13:%.*]] = sub nsw i32 [[DIV12]], 1
// CHECK3-NEXT:    store i32 [[SUB13]], i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK3-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK3-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK3-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD14]] to i64
// CHECK3-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP60]])
// CHECK3-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 2, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK3-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK3-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK3:       omp_offload.failed15:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36(i32 [[TMP44]], [100 x i32]* @a) #[[ATTR3]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK3:       omp_offload.cont16:
// CHECK3-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK3-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30
// CHECK3-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK3-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], [100 x i32]* [[TMP1]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 0
// CHECK3-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK3-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 [[TMP17]]
// CHECK3-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK3-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK3-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK3-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK3-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK3-NEXT:    store i32 [[ADD11]], i32* [[TMP0]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK3-SAME: (i32 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], [100 x i32]* [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK3-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK3:       omp.precond.then:
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK3-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK3-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I3]], align 4
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i32 0, i32 [[TMP16]]
// CHECK3-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK3-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, i32* [[TMP18]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP19]])
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK3-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP22]], 0
// CHECK3-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK3-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK3-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK3-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK3:       omp.precond.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK4-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x i8*], align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_CASTED4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_BASEPTRS5:%.*]] = alloca [2 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_PTRS6:%.*]] = alloca [2 x i8*], align 4
// CHECK4-NEXT:    [[DOTOFFLOAD_MAPPERS7:%.*]] = alloca [2 x i8*], align 4
// CHECK4-NEXT:    [[_TMP8:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_10:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK4-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK4-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE]], align 4
// CHECK4-NEXT:    store i32 [[TMP1]], i32* [[TE_CASTED]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[TH_CASTED]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], i32* [[I_CASTED]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I_CASTED]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], i32* [[N_CASTED]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[TMP12]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK4-NEXT:    store i32 [[TMP4]], i32* [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK4-NEXT:    store i32 [[TMP4]], i32* [[TMP17]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP20]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP22]], align 4
// CHECK4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK4-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP25:%.*]] = bitcast i8** [[TMP24]] to i32*
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[TMP25]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32*
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[TMP27]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK4-NEXT:    store i8* null, i8** [[TMP28]], align 4
// CHECK4-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK4-NEXT:    [[TMP30:%.*]] = bitcast i8** [[TMP29]] to i32*
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[TMP30]], align 4
// CHECK4-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK4-NEXT:    [[TMP32:%.*]] = bitcast i8** [[TMP31]] to i32*
// CHECK4-NEXT:    store i32 [[TMP8]], i32* [[TMP32]], align 4
// CHECK4-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK4-NEXT:    store i8* null, i8** [[TMP33]], align 4
// CHECK4-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [5 x i8*], [5 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP36:%.*]] = load i32, i32* [[TE]], align 4
// CHECK4-NEXT:    [[TMP37:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP37]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP38:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP38]], 0
// CHECK4-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK4-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[TMP39:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP39]], 1
// CHECK4-NEXT:    [[TMP40:%.*]] = zext i32 [[ADD]] to i64
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP40]])
// CHECK4-NEXT:    [[TMP41:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30.region_id, i32 5, i8** [[TMP34]], i8** [[TMP35]], i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([5 x i64], [5 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 [[TMP36]], i32 1)
// CHECK4-NEXT:    [[TMP42:%.*]] = icmp ne i32 [[TMP41]], 0
// CHECK4-NEXT:    br i1 [[TMP42]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK4:       omp_offload.failed:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30(i32 [[TMP2]], i32 [[TMP4]], [100 x i32]* @a, i32 [[TMP6]], i32 [[TMP8]]) #[[ATTR3:[0-9]+]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK4:       omp_offload.cont:
// CHECK4-NEXT:    [[TMP43:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP43]], i32* [[N_CASTED4]], align 4
// CHECK4-NEXT:    [[TMP44:%.*]] = load i32, i32* [[N_CASTED4]], align 4
// CHECK4-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP46:%.*]] = bitcast i8** [[TMP45]] to i32*
// CHECK4-NEXT:    store i32 [[TMP44]], i32* [[TMP46]], align 4
// CHECK4-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP48:%.*]] = bitcast i8** [[TMP47]] to i32*
// CHECK4-NEXT:    store i32 [[TMP44]], i32* [[TMP48]], align 4
// CHECK4-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 0
// CHECK4-NEXT:    store i8* null, i8** [[TMP49]], align 4
// CHECK4-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP51:%.*]] = bitcast i8** [[TMP50]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP51]], align 4
// CHECK4-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP53:%.*]] = bitcast i8** [[TMP52]] to [100 x i32]**
// CHECK4-NEXT:    store [100 x i32]* @a, [100 x i32]** [[TMP53]], align 4
// CHECK4-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_MAPPERS7]], i32 0, i32 1
// CHECK4-NEXT:    store i8* null, i8** [[TMP54]], align 4
// CHECK4-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_BASEPTRS5]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [2 x i8*], [2 x i8*]* [[DOTOFFLOAD_PTRS6]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP57:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TMP57]], i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK4-NEXT:    [[TMP58:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_9]], align 4
// CHECK4-NEXT:    [[SUB11:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK4-NEXT:    [[DIV12:%.*]] = sdiv i32 [[SUB11]], 1
// CHECK4-NEXT:    [[SUB13:%.*]] = sub nsw i32 [[DIV12]], 1
// CHECK4-NEXT:    store i32 [[SUB13]], i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK4-NEXT:    [[TMP59:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_10]], align 4
// CHECK4-NEXT:    [[ADD14:%.*]] = add nsw i32 [[TMP59]], 1
// CHECK4-NEXT:    [[TMP60:%.*]] = zext i32 [[ADD14]] to i64
// CHECK4-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 [[TMP60]])
// CHECK4-NEXT:    [[TMP61:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36.region_id, i32 2, i8** [[TMP55]], i8** [[TMP56]], i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_sizes.2, i32 0, i32 0), i64* getelementptr inbounds ([2 x i64], [2 x i64]* @.offload_maptypes.3, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK4-NEXT:    [[TMP62:%.*]] = icmp ne i32 [[TMP61]], 0
// CHECK4-NEXT:    br i1 [[TMP62]], label [[OMP_OFFLOAD_FAILED15:%.*]], label [[OMP_OFFLOAD_CONT16:%.*]]
// CHECK4:       omp_offload.failed15:
// CHECK4-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36(i32 [[TMP44]], [100 x i32]* @a) #[[ATTR3]]
// CHECK4-NEXT:    br label [[OMP_OFFLOAD_CONT16]]
// CHECK4:       omp_offload.cont16:
// CHECK4-NEXT:    [[TMP63:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK4-NEXT:    ret i32 [[TMP63]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l30
// CHECK4-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]], i32 [[I:%.*]], i32 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK4-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[I]], i32* [[I_ADDR]], align 4
// CHECK4-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK4-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[I_ADDR]], i32* [[N_ADDR]], [100 x i32]* [[TMP1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[I:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[I_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[I]], i32** [[I_ADDR]], align 4
// CHECK4-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[I_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[I3]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    [[ARRAYDECAY:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 0
// CHECK4-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* [[ARRAYDECAY]], i32 16) ]
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK4-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK4-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP2]], i32 0, i32 [[TMP17]]
// CHECK4-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK4-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK4-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB8:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK4-NEXT:    [[DIV9:%.*]] = sdiv i32 [[SUB8]], 1
// CHECK4-NEXT:    [[MUL10:%.*]] = mul nsw i32 [[DIV9]], 1
// CHECK4-NEXT:    [[ADD11:%.*]] = add nsw i32 0, [[MUL10]]
// CHECK4-NEXT:    store i32 [[ADD11]], i32* [[TMP0]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z21teams_argument_globali_l36
// CHECK4-SAME: (i32 [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, [100 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), i32* [[N_ADDR]], [100 x i32]* [[TMP0]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK4-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], [100 x i32]* nonnull align 4 dereferenceable(400) [[A:%.*]]) #[[ATTR1]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca [100 x i32]*, align 4
// CHECK4-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK4-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    store [100 x i32]* [[A]], [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK4-NEXT:    [[TMP1:%.*]] = load [100 x i32]*, [100 x i32]** [[A_ADDR]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK4-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK4-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK4-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK4-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK4:       omp.precond.then:
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK4-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, i32* [[TMP6]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP7]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP8]], [[TMP9]]
// CHECK4-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK4:       cond.true:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK4-NEXT:    br label [[COND_END:%.*]]
// CHECK4:       cond.false:
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    br label [[COND_END]]
// CHECK4:       cond.end:
// CHECK4-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP10]], [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK4-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK4-NEXT:    store i32 [[TMP12]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK4:       omp.inner.for.cond:
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK4-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK4-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK4:       omp.inner.for.body:
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK4-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, i32* [[I3]], align 4
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* [[TMP1]], i32 0, i32 [[TMP16]]
// CHECK4-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4
// CHECK4-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK4:       omp.body.continue:
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK4:       omp.inner.for.inc:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP17]], 1
// CHECK4-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4
// CHECK4-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK4:       omp.inner.for.end:
// CHECK4-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK4:       omp.loop.exit:
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, i32* [[TMP18]], align 4
// CHECK4-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP19]])
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK4-NEXT:    br i1 [[TMP21]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK4:       .omp.final.then:
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK4-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP22]], 0
// CHECK4-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK4-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK4-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK4-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK4-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK4:       .omp.final.done:
// CHECK4-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK4:       omp.precond.end:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK4-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK4-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK5-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP13:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_15:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB19:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_UB20:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I21:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IV24:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK5-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK5-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK5-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK5-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK5-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK5-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[I4]], align 4
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK5-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK5:       simd.if.then:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK5-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), i64 16) ]
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4
// CHECK5-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK5-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I5]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP10]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM]]
// CHECK5-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK5-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK5-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK5-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK5-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK5-NEXT:    store i32 [[ADD12]], i32* [[I]], align 4
// CHECK5-NEXT:    br label [[SIMD_IF_END]]
// CHECK5:       simd.if.end:
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP13]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK5-NEXT:    [[SUB16:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK5-NEXT:    [[DIV17:%.*]] = sdiv i32 [[SUB16]], 1
// CHECK5-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[DIV17]], 1
// CHECK5-NEXT:    store i32 [[SUB18]], i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[DOTOMP_LB19]], align 4
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK5-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_UB20]], align 4
// CHECK5-NEXT:    store i32 0, i32* [[I21]], align 4
// CHECK5-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK5-NEXT:    [[CMP22:%.*]] = icmp slt i32 0, [[TMP16]]
// CHECK5-NEXT:    br i1 [[CMP22]], label [[SIMD_IF_THEN23:%.*]], label [[SIMD_IF_END41:%.*]]
// CHECK5:       simd.if.then23:
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB19]], align 4
// CHECK5-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV24]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK5:       omp.inner.for.cond26:
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB20]], align 4
// CHECK5-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK5-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END36:%.*]]
// CHECK5:       omp.inner.for.body28:
// CHECK5-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK5-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK5-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK5-NEXT:    store i32 [[ADD30]], i32* [[I25]], align 4
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I25]], align 4
// CHECK5-NEXT:    [[IDXPROM31:%.*]] = sext i32 [[TMP21]] to i64
// CHECK5-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM31]]
// CHECK5-NEXT:    store i32 0, i32* [[ARRAYIDX32]], align 4
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE33:%.*]]
// CHECK5:       omp.body.continue33:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC34:%.*]]
// CHECK5:       omp.inner.for.inc34:
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK5-NEXT:    [[ADD35:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK5-NEXT:    store i32 [[ADD35]], i32* [[DOTOMP_IV24]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK5:       omp.inner.for.end36:
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK5-NEXT:    [[SUB37:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK5-NEXT:    [[DIV38:%.*]] = sdiv i32 [[SUB37]], 1
// CHECK5-NEXT:    [[MUL39:%.*]] = mul nsw i32 [[DIV38]], 1
// CHECK5-NEXT:    [[ADD40:%.*]] = add nsw i32 0, [[MUL39]]
// CHECK5-NEXT:    store i32 [[ADD40]], i32* [[I25]], align 4
// CHECK5-NEXT:    br label [[SIMD_IF_END41]]
// CHECK5:       simd.if.end41:
// CHECK5-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK5-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK6-SAME: (i32 signext [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP13:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_15:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB19:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_UB20:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I21:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IV24:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK6-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK6-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK6-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK6-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK6-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK6-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK6-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[I4]], align 4
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK6-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK6:       simd.if.then:
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK6-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), i64 16) ]
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4
// CHECK6-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK6-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I5]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP10]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM]]
// CHECK6-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK6-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK6-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK6-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK6-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK6-NEXT:    store i32 [[ADD12]], i32* [[I]], align 4
// CHECK6-NEXT:    br label [[SIMD_IF_END]]
// CHECK6:       simd.if.end:
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP13]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK6-NEXT:    [[SUB16:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK6-NEXT:    [[DIV17:%.*]] = sdiv i32 [[SUB16]], 1
// CHECK6-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[DIV17]], 1
// CHECK6-NEXT:    store i32 [[SUB18]], i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[DOTOMP_LB19]], align 4
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK6-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_UB20]], align 4
// CHECK6-NEXT:    store i32 0, i32* [[I21]], align 4
// CHECK6-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK6-NEXT:    [[CMP22:%.*]] = icmp slt i32 0, [[TMP16]]
// CHECK6-NEXT:    br i1 [[CMP22]], label [[SIMD_IF_THEN23:%.*]], label [[SIMD_IF_END41:%.*]]
// CHECK6:       simd.if.then23:
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB19]], align 4
// CHECK6-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV24]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK6:       omp.inner.for.cond26:
// CHECK6-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK6-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB20]], align 4
// CHECK6-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK6-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END36:%.*]]
// CHECK6:       omp.inner.for.body28:
// CHECK6-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK6-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK6-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK6-NEXT:    store i32 [[ADD30]], i32* [[I25]], align 4
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I25]], align 4
// CHECK6-NEXT:    [[IDXPROM31:%.*]] = sext i32 [[TMP21]] to i64
// CHECK6-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i64 0, i64 [[IDXPROM31]]
// CHECK6-NEXT:    store i32 0, i32* [[ARRAYIDX32]], align 4
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE33:%.*]]
// CHECK6:       omp.body.continue33:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC34:%.*]]
// CHECK6:       omp.inner.for.inc34:
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK6-NEXT:    [[ADD35:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK6-NEXT:    store i32 [[ADD35]], i32* [[DOTOMP_IV24]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK6:       omp.inner.for.end36:
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK6-NEXT:    [[SUB37:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK6-NEXT:    [[DIV38:%.*]] = sdiv i32 [[SUB37]], 1
// CHECK6-NEXT:    [[MUL39:%.*]] = mul nsw i32 [[DIV38]], 1
// CHECK6-NEXT:    [[ADD40:%.*]] = add nsw i32 0, [[MUL39]]
// CHECK6-NEXT:    store i32 [[ADD40]], i32* [[I25]], align 4
// CHECK6-NEXT:    br label [[SIMD_IF_END41]]
// CHECK6:       simd.if.end41:
// CHECK6-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i64 0, i64 0), align 4
// CHECK6-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK7-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP13:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_15:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB19:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_UB20:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I21:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV24:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK7-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK7-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK7-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK7-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK7-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK7-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[I4]], align 4
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK7-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK7:       simd.if.then:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK7-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), i32 16) ]
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4
// CHECK7-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK7-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I5]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP10]]
// CHECK7-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK7-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK7-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK7-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK7-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK7-NEXT:    store i32 [[ADD12]], i32* [[I]], align 4
// CHECK7-NEXT:    br label [[SIMD_IF_END]]
// CHECK7:       simd.if.end:
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP13]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK7-NEXT:    [[SUB16:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK7-NEXT:    [[DIV17:%.*]] = sdiv i32 [[SUB16]], 1
// CHECK7-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[DIV17]], 1
// CHECK7-NEXT:    store i32 [[SUB18]], i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[DOTOMP_LB19]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK7-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_UB20]], align 4
// CHECK7-NEXT:    store i32 0, i32* [[I21]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK7-NEXT:    [[CMP22:%.*]] = icmp slt i32 0, [[TMP16]]
// CHECK7-NEXT:    br i1 [[CMP22]], label [[SIMD_IF_THEN23:%.*]], label [[SIMD_IF_END40:%.*]]
// CHECK7:       simd.if.then23:
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB19]], align 4
// CHECK7-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV24]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK7:       omp.inner.for.cond26:
// CHECK7-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB20]], align 4
// CHECK7-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK7-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK7:       omp.inner.for.body28:
// CHECK7-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK7-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK7-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK7-NEXT:    store i32 [[ADD30]], i32* [[I25]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I25]], align 4
// CHECK7-NEXT:    [[ARRAYIDX31:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP21]]
// CHECK7-NEXT:    store i32 0, i32* [[ARRAYIDX31]], align 4
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK7:       omp.body.continue32:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK7:       omp.inner.for.inc33:
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK7-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK7-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV24]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK7:       omp.inner.for.end35:
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK7-NEXT:    [[SUB36:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK7-NEXT:    [[DIV37:%.*]] = sdiv i32 [[SUB36]], 1
// CHECK7-NEXT:    [[MUL38:%.*]] = mul nsw i32 [[DIV37]], 1
// CHECK7-NEXT:    [[ADD39:%.*]] = add nsw i32 0, [[MUL38]]
// CHECK7-NEXT:    store i32 [[ADD39]], i32* [[I25]], align 4
// CHECK7-NEXT:    br label [[SIMD_IF_END40]]
// CHECK7:       simd.if.end40:
// CHECK7-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK7-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z21teams_argument_globali
// CHECK8-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTLINEAR_START:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I5:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I6:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP13:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_14:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_15:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB19:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB20:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I21:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IV24:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I25:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP0]], 128
// CHECK8-NEXT:    store i32 [[DIV]], i32* [[TE]], align 4
// CHECK8-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP1]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK8-NEXT:    [[DIV2:%.*]] = sdiv i32 [[SUB]], 1
// CHECK8-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV2]], 1
// CHECK8-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK8-NEXT:    store i32 [[TMP3]], i32* [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[I4]], align 4
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP4]]
// CHECK8-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK8:       simd.if.then:
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    call void @llvm.assume(i1 true) [ "align"(i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), i32 16) ]
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, i32* [[I]], align 4
// CHECK8-NEXT:    store i32 [[TMP6]], i32* [[DOTLINEAR_START]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK8-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], i32* [[I5]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I5]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP10]]
// CHECK8-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK8-NEXT:    store i32 [[ADD8]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    [[SUB9:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK8-NEXT:    [[DIV10:%.*]] = sdiv i32 [[SUB9]], 1
// CHECK8-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[DIV10]], 1
// CHECK8-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK8-NEXT:    store i32 [[ADD12]], i32* [[I]], align 4
// CHECK8-NEXT:    br label [[SIMD_IF_END]]
// CHECK8:       simd.if.end:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, i32* [[N_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP13]], i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK8-NEXT:    [[SUB16:%.*]] = sub nsw i32 [[TMP14]], 0
// CHECK8-NEXT:    [[DIV17:%.*]] = sdiv i32 [[SUB16]], 1
// CHECK8-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[DIV17]], 1
// CHECK8-NEXT:    store i32 [[SUB18]], i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[DOTOMP_LB19]], align 4
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_15]], align 4
// CHECK8-NEXT:    store i32 [[TMP15]], i32* [[DOTOMP_UB20]], align 4
// CHECK8-NEXT:    store i32 0, i32* [[I21]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK8-NEXT:    [[CMP22:%.*]] = icmp slt i32 0, [[TMP16]]
// CHECK8-NEXT:    br i1 [[CMP22]], label [[SIMD_IF_THEN23:%.*]], label [[SIMD_IF_END40:%.*]]
// CHECK8:       simd.if.then23:
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_LB19]], align 4
// CHECK8-NEXT:    store i32 [[TMP17]], i32* [[DOTOMP_IV24]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND26:%.*]]
// CHECK8:       omp.inner.for.cond26:
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_UB20]], align 4
// CHECK8-NEXT:    [[CMP27:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK8-NEXT:    br i1 [[CMP27]], label [[OMP_INNER_FOR_BODY28:%.*]], label [[OMP_INNER_FOR_END35:%.*]]
// CHECK8:       omp.inner.for.body28:
// CHECK8-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK8-NEXT:    [[MUL29:%.*]] = mul nsw i32 [[TMP20]], 1
// CHECK8-NEXT:    [[ADD30:%.*]] = add nsw i32 0, [[MUL29]]
// CHECK8-NEXT:    store i32 [[ADD30]], i32* [[I25]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, i32* [[I25]], align 4
// CHECK8-NEXT:    [[ARRAYIDX31:%.*]] = getelementptr inbounds [100 x i32], [100 x i32]* @a, i32 0, i32 [[TMP21]]
// CHECK8-NEXT:    store i32 0, i32* [[ARRAYIDX31]], align 4
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE32:%.*]]
// CHECK8:       omp.body.continue32:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC33:%.*]]
// CHECK8:       omp.inner.for.inc33:
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV24]], align 4
// CHECK8-NEXT:    [[ADD34:%.*]] = add nsw i32 [[TMP22]], 1
// CHECK8-NEXT:    store i32 [[ADD34]], i32* [[DOTOMP_IV24]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND26]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK8:       omp.inner.for.end35:
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_14]], align 4
// CHECK8-NEXT:    [[SUB36:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK8-NEXT:    [[DIV37:%.*]] = sdiv i32 [[SUB36]], 1
// CHECK8-NEXT:    [[MUL38:%.*]] = mul nsw i32 [[DIV37]], 1
// CHECK8-NEXT:    [[ADD39:%.*]] = add nsw i32 0, [[MUL38]]
// CHECK8-NEXT:    store i32 [[ADD39]], i32* [[I25]], align 4
// CHECK8-NEXT:    br label [[SIMD_IF_END40]]
// CHECK8:       simd.if.end40:
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, i32* getelementptr inbounds ([100 x i32], [100 x i32]* @a, i32 0, i32 0), align 4
// CHECK8-NEXT:    ret i32 [[TMP24]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK9-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK9-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK9-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK9-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK9-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK9-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK9-NEXT:    store i64 [[TMP4]], i64* [[TMP7]], align 8
// CHECK9-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK9-NEXT:    store i64 [[TMP4]], i64* [[TMP9]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK9-NEXT:    store i64 4, i64* [[TMP10]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK9-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK9-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP13]], align 8
// CHECK9-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK9-NEXT:    store i64 [[TMP1]], i64* [[TMP15]], align 8
// CHECK9-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK9-NEXT:    store i64 8, i64* [[TMP16]], align 8
// CHECK9-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK9-NEXT:    store i8* null, i8** [[TMP17]], align 8
// CHECK9-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK9-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 8
// CHECK9-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK9-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK9-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 8
// CHECK9-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK9-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK9-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK9-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK9-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK9-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK9-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK9-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK9-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK9:       omp_offload.failed:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75(i64 [[TMP4]], i64 [[TMP1]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK9:       omp_offload.cont:
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK9-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK9-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK9-NEXT:    ret i32 [[TMP33]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75
// CHECK9-SAME: (i64 [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK9-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK9-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK9-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK9-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK9-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK9-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK9-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK9-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK9-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK9:       omp.precond.then:
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK9-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK9-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK9-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK9:       cond.true:
// CHECK9-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK9-NEXT:    br label [[COND_END:%.*]]
// CHECK9:       cond.false:
// CHECK9-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    br label [[COND_END]]
// CHECK9:       cond.end:
// CHECK9-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK9-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK9-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK9:       omp.inner.for.cond:
// CHECK9-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK9-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK9:       omp.inner.for.body:
// CHECK9-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK9-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK9-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK9-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM]]
// CHECK9-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK9:       omp.body.continue:
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK9:       omp.inner.for.inc:
// CHECK9-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK9-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK9-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK9:       omp.inner.for.end:
// CHECK9-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK9:       omp.loop.exit:
// CHECK9-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK9-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK9-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK9-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK9-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK9:       .omp.final.then:
// CHECK9-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK9-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK9-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK9-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK9-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK9-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK9-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK9:       .omp.final.done:
// CHECK9-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK9:       omp.precond.end:
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK9-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK9-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK10-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK10-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK10-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK10-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK10-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK10-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK10-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK10-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK10-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK10-NEXT:    [[TMP5:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK10-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK10-NEXT:    store i64 [[TMP4]], i64* [[TMP7]], align 8
// CHECK10-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK10-NEXT:    store i64 [[TMP4]], i64* [[TMP9]], align 8
// CHECK10-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK10-NEXT:    store i64 4, i64* [[TMP10]], align 8
// CHECK10-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK10-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK10-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK10-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK10-NEXT:    store i64 [[TMP1]], i64* [[TMP13]], align 8
// CHECK10-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK10-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK10-NEXT:    store i64 [[TMP1]], i64* [[TMP15]], align 8
// CHECK10-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK10-NEXT:    store i64 8, i64* [[TMP16]], align 8
// CHECK10-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK10-NEXT:    store i8* null, i8** [[TMP17]], align 8
// CHECK10-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK10-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK10-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 8
// CHECK10-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK10-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK10-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 8
// CHECK10-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK10-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 8
// CHECK10-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK10-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK10-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK10-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK10-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK10-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK10-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK10-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK10-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK10-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK10-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK10-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK10:       omp_offload.failed:
// CHECK10-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75(i64 [[TMP4]], i64 [[TMP1]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK10-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK10:       omp_offload.cont:
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK10-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK10-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK10-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK10-NEXT:    ret i32 [[TMP33]]
//
//
// CHECK10-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75
// CHECK10-SAME: (i64 [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK10-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK10-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK10-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK10-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK10-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK10-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK10-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK10-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK10-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK10-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK10-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK10:       omp.precond.then:
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK10-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK10-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM]]
// CHECK10-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK10-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK10-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK10-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK10-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK10-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK10-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK10-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK10-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK10-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK10:       omp.precond.end:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK10-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK10-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK11-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK11-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK11-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP2]], i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK11-NEXT:    [[TMP5:%.*]] = sext i32 [[TMP4]] to i64
// CHECK11-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK11-NEXT:    store i32 [[TMP3]], i32* [[TMP7]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK11-NEXT:    store i32 [[TMP3]], i32* [[TMP9]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK11-NEXT:    store i64 4, i64* [[TMP10]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK11-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK11-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[TMP13]], align 4
// CHECK11-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK11-NEXT:    store i32 [[TMP0]], i32* [[TMP15]], align 4
// CHECK11-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK11-NEXT:    store i64 4, i64* [[TMP16]], align 4
// CHECK11-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK11-NEXT:    store i8* null, i8** [[TMP17]], align 4
// CHECK11-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK11-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK11-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK11-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK11-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK11-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK11-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK11-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK11-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK11-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK11-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK11-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK11:       omp_offload.failed:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75(i32 [[TMP3]], i32 [[TMP0]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK11:       omp_offload.cont:
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK11-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK11-NEXT:    ret i32 [[TMP33]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75
// CHECK11-SAME: (i32 [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK11-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK11-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK11-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK11-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK11-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK11-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK11-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK11:       omp.precond.then:
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK11-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK11-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK11-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK11:       cond.true:
// CHECK11-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK11-NEXT:    br label [[COND_END:%.*]]
// CHECK11:       cond.false:
// CHECK11-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    br label [[COND_END]]
// CHECK11:       cond.end:
// CHECK11-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK11-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK11-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK11:       omp.inner.for.cond:
// CHECK11-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK11-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK11:       omp.inner.for.body:
// CHECK11-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK11-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK11-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP17]]
// CHECK11-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK11:       omp.body.continue:
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK11:       omp.inner.for.inc:
// CHECK11-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK11-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK11-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK11:       omp.inner.for.end:
// CHECK11-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK11:       omp.loop.exit:
// CHECK11-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK11-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK11-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK11-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK11:       .omp.final.then:
// CHECK11-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK11-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK11-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK11-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK11-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK11-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK11-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK11:       .omp.final.done:
// CHECK11-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK11:       omp.precond.end:
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK11-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK11-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK12-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK12-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK12-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK12-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK12-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK12-NEXT:    store i32 [[TMP2]], i32* [[N_CASTED]], align 4
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK12-NEXT:    [[TMP5:%.*]] = sext i32 [[TMP4]] to i64
// CHECK12-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK12-NEXT:    store i32 [[TMP3]], i32* [[TMP7]], align 4
// CHECK12-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK12-NEXT:    store i32 [[TMP3]], i32* [[TMP9]], align 4
// CHECK12-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK12-NEXT:    store i64 4, i64* [[TMP10]], align 4
// CHECK12-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK12-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK12-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK12-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[TMP13]], align 4
// CHECK12-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK12-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK12-NEXT:    store i32 [[TMP0]], i32* [[TMP15]], align 4
// CHECK12-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK12-NEXT:    store i64 4, i64* [[TMP16]], align 4
// CHECK12-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK12-NEXT:    store i8* null, i8** [[TMP17]], align 4
// CHECK12-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK12-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK12-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 4
// CHECK12-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK12-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK12-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 4
// CHECK12-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK12-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 4
// CHECK12-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK12-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK12-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK12-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK12-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK12-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK12-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK12-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK12-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK12-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK12-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK12-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK12:       omp_offload.failed:
// CHECK12-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75(i32 [[TMP3]], i32 [[TMP0]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK12-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK12:       omp_offload.cont:
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK12-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK12-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK12-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK12-NEXT:    ret i32 [[TMP33]]
//
//
// CHECK12-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z15teams_local_argv_l75
// CHECK12-SAME: (i32 [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK12-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK12-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK12-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK12-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK12-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK12-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK12-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK12-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK12-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK12:       omp.precond.then:
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK12-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK12-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK12-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK12-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK12:       cond.true:
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK12-NEXT:    br label [[COND_END:%.*]]
// CHECK12:       cond.false:
// CHECK12-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    br label [[COND_END]]
// CHECK12:       cond.end:
// CHECK12-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK12-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK12-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP17]]
// CHECK12-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK12-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK12:       omp.loop.exit:
// CHECK12-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK12-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK12-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK12-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK12-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK12-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK12:       .omp.final.then:
// CHECK12-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK12-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK12-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK12-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK12-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK12-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK12-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK12:       .omp.final.done:
// CHECK12-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK12:       omp.precond.end:
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK12-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK12-NEXT:    ret void
//
//
// CHECK13-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK13-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK13-NEXT:  entry:
// CHECK13-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK13-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK13-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK13-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK13-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK13-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK13-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK13-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK13-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK13-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK13-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK13-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK13-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK13-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK13-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK13-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK13-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK13-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK13:       simd.if.then:
// CHECK13-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK13-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK13:       omp.inner.for.cond:
// CHECK13-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK13-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK13:       omp.inner.for.body:
// CHECK13-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK13-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK13-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK13-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK13-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK13:       omp.body.continue:
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK13:       omp.inner.for.inc:
// CHECK13-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK13-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK13-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK13:       omp.inner.for.end:
// CHECK13-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK13-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK13-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK13-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK13-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK13-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK13-NEXT:    br label [[SIMD_IF_END]]
// CHECK13:       simd.if.end:
// CHECK13-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK13-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARRAYIDX10]], align 4
// CHECK13-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK13-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK13-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK14-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK14-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK14-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK14-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK14-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK14-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK14-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK14-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK14-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK14-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK14-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK14-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK14-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK14-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK14-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK14-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK14:       simd.if.then:
// CHECK14-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK14-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK14-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK14-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK14-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK14-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK14-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK14-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK14-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK14-NEXT:    br label [[SIMD_IF_END]]
// CHECK14:       simd.if.end:
// CHECK14-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 0
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARRAYIDX10]], align 4
// CHECK14-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK14-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK14-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK15-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK15-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK15-NEXT:  entry:
// CHECK15-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK15-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK15-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK15-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK15-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK15-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK15-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK15-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK15-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK15-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK15-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK15-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK15-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK15-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK15-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK15-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK15:       simd.if.then:
// CHECK15-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK15-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK15:       omp.inner.for.cond:
// CHECK15-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK15-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK15:       omp.inner.for.body:
// CHECK15-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK15-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK15-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP10]]
// CHECK15-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK15:       omp.body.continue:
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK15:       omp.inner.for.inc:
// CHECK15-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK15-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK15-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK15:       omp.inner.for.end:
// CHECK15-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK15-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK15-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK15-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK15-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK15-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK15-NEXT:    br label [[SIMD_IF_END]]
// CHECK15:       simd.if.end:
// CHECK15-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK15-NEXT:    [[TMP13:%.*]] = load i32, i32* [[ARRAYIDX10]], align 4
// CHECK15-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK15-NEXT:    call void @llvm.stackrestore(i8* [[TMP14]])
// CHECK15-NEXT:    ret i32 [[TMP13]]
//
//
// CHECK16-LABEL: define {{[^@]+}}@_Z15teams_local_argv
// CHECK16-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK16-NEXT:  entry:
// CHECK16-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK16-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK16-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK16-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK16-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK16-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK16-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK16-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK16-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK16-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK16-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK16-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK16-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK16-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK16-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK16-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK16-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK16:       simd.if.then:
// CHECK16-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK16-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK16:       omp.inner.for.cond:
// CHECK16-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK16-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK16:       omp.inner.for.body:
// CHECK16-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK16-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK16-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP10]]
// CHECK16-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK16:       omp.body.continue:
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK16:       omp.inner.for.inc:
// CHECK16-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK16-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK16-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK16:       omp.inner.for.end:
// CHECK16-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK16-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK16-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK16-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK16-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK16-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK16-NEXT:    br label [[SIMD_IF_END]]
// CHECK16:       simd.if.end:
// CHECK16-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 0
// CHECK16-NEXT:    [[TMP13:%.*]] = load i32, i32* [[ARRAYIDX10]], align 4
// CHECK16-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK16-NEXT:    call void @llvm.stackrestore(i8* [[TMP14]])
// CHECK16-NEXT:    ret i32 [[TMP13]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK17-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK17-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK17-NEXT:    ret i32 [[CALL]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK17-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK17-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK17-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK17-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK17-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK17-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK17-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK17-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK17-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 8
// CHECK17-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK17-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 8
// CHECK17-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK17-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 8
// CHECK17-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store i8* null, i8** [[TMP12]], align 8
// CHECK17-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK17-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 8
// CHECK17-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK17-NEXT:    store float* [[B]], float** [[TMP16]], align 8
// CHECK17-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK17-NEXT:    store i64 4, i64* [[TMP17]], align 8
// CHECK17-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK17-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK17-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 8
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK17-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK17-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 8
// CHECK17-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK17-NEXT:    store i64 492, i64* [[TMP23]], align 8
// CHECK17-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK17-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK17-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK17-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK17-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK17-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK17-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i64 0, i64 0
// CHECK17-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK17-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK17-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK17-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK17-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK17-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK17-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK17-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK17-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK17:       cond.true:
// CHECK17-NEXT:    br label [[COND_END:%.*]]
// CHECK17:       cond.false:
// CHECK17-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    br label [[COND_END]]
// CHECK17:       cond.end:
// CHECK17-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK17-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK17-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK17-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK17:       omp.inner.for.cond:
// CHECK17-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK17-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK17:       omp.inner.for.body:
// CHECK17-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK17-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP9:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[CONV:%.*]] = fptosi float [[TMP9]] to i32
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP10]] to i64
// CHECK17-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK17-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK17:       omp.body.continue:
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK17:       omp.inner.for.inc:
// CHECK17-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK17-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK17-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK17:       omp.inner.for.end:
// CHECK17-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK17:       omp.loop.exit:
// CHECK17-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK17-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK17-NEXT:    br i1 [[TMP13]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK17:       .omp.final.then:
// CHECK17-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK17-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK17:       .omp.final.done:
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK17-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK17-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK18-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK18-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK18-NEXT:    ret i32 [[CALL]]
//
//
// CHECK18-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK18-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK18-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK18-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK18-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK18-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK18-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK18-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK18-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK18-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK18-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK18-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 8
// CHECK18-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK18-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 8
// CHECK18-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK18-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 8
// CHECK18-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK18-NEXT:    store i8* null, i8** [[TMP12]], align 8
// CHECK18-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK18-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK18-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 8
// CHECK18-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK18-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK18-NEXT:    store float* [[B]], float** [[TMP16]], align 8
// CHECK18-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK18-NEXT:    store i64 4, i64* [[TMP17]], align 8
// CHECK18-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK18-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK18-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK18-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK18-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 8
// CHECK18-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK18-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK18-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 8
// CHECK18-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK18-NEXT:    store i64 492, i64* [[TMP23]], align 8
// CHECK18-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK18-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK18-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK18-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK18-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK18-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK18-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK18:       omp_offload.failed:
// CHECK18-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK18-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK18:       omp_offload.cont:
// CHECK18-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i64 0, i64 0
// CHECK18-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK18-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK18-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK18-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]])
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK18-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK18-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK18-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK18-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK18-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK18-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK18-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK18-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK18-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK18-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK18:       cond.true:
// CHECK18-NEXT:    br label [[COND_END:%.*]]
// CHECK18:       cond.false:
// CHECK18-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    br label [[COND_END]]
// CHECK18:       cond.end:
// CHECK18-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK18-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK18-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK18-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK18:       omp.inner.for.cond:
// CHECK18-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK18-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK18:       omp.inner.for.body:
// CHECK18-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK18-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK18-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK18-NEXT:    [[TMP9:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[CONV:%.*]] = fptosi float [[TMP9]] to i32
// CHECK18-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK18-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP10]] to i64
// CHECK18-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK18-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK18:       omp.body.continue:
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK18:       omp.inner.for.inc:
// CHECK18-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK18-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK18-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK18:       omp.inner.for.end:
// CHECK18-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK18:       omp.loop.exit:
// CHECK18-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK18-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK18-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK18-NEXT:    br i1 [[TMP13]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK18:       .omp.final.then:
// CHECK18-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK18-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK18:       .omp.final.done:
// CHECK18-NEXT:    ret void
//
//
// CHECK18-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK18-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK18-NEXT:  entry:
// CHECK18-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK18-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK19-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK19-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK19-NEXT:    ret i32 [[CALL]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK19-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK19-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK19-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK19-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK19-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK19-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK19-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK19-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK19-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 4
// CHECK19-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK19-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK19-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 4
// CHECK19-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store i8* null, i8** [[TMP12]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK19-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK19-NEXT:    store float* [[B]], float** [[TMP16]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK19-NEXT:    store i64 4, i64* [[TMP17]], align 4
// CHECK19-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK19-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 4
// CHECK19-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK19-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK19-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 4
// CHECK19-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK19-NEXT:    store i64 492, i64* [[TMP23]], align 4
// CHECK19-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK19-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK19-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK19-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK19-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK19-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK19-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK19-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK19-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK19-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK19-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK19-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK19-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK19-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK19-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK19:       cond.true:
// CHECK19-NEXT:    br label [[COND_END:%.*]]
// CHECK19:       cond.false:
// CHECK19-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    br label [[COND_END]]
// CHECK19:       cond.end:
// CHECK19-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK19-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK19-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK19:       omp.inner.for.cond:
// CHECK19-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK19-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK19:       omp.inner.for.body:
// CHECK19-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK19-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP9:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[CONV:%.*]] = fptosi float [[TMP9]] to i32
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP10]]
// CHECK19-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK19:       omp.body.continue:
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK19:       omp.inner.for.inc:
// CHECK19-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK19-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK19-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK19:       omp.inner.for.end:
// CHECK19-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK19:       omp.loop.exit:
// CHECK19-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK19-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK19-NEXT:    br i1 [[TMP13]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK19:       .omp.final.then:
// CHECK19-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK19-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK19:       .omp.final.done:
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK19-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK19-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK20-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK20-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK20-NEXT:    ret i32 [[CALL]]
//
//
// CHECK20-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK20-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK20-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK20-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK20-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK20-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK20-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK20-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK20-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK20-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK20-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK20-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 4
// CHECK20-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK20-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 4
// CHECK20-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK20-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 4
// CHECK20-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK20-NEXT:    store i8* null, i8** [[TMP12]], align 4
// CHECK20-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK20-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK20-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 4
// CHECK20-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK20-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK20-NEXT:    store float* [[B]], float** [[TMP16]], align 4
// CHECK20-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK20-NEXT:    store i64 4, i64* [[TMP17]], align 4
// CHECK20-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK20-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK20-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK20-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK20-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 4
// CHECK20-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK20-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK20-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 4
// CHECK20-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK20-NEXT:    store i64 492, i64* [[TMP23]], align 4
// CHECK20-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK20-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK20-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK20-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK20-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK20-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK20-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK20:       omp_offload.failed:
// CHECK20-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK20-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK20:       omp_offload.cont:
// CHECK20-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK20-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK20-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK20-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]])
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK20-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]]) #[[ATTR1]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK20-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK20-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK20-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK20-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK20-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK20-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK20-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK20-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK20-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK20:       cond.true:
// CHECK20-NEXT:    br label [[COND_END:%.*]]
// CHECK20:       cond.false:
// CHECK20-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    br label [[COND_END]]
// CHECK20:       cond.end:
// CHECK20-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK20-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK20-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK20-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK20:       omp.inner.for.cond:
// CHECK20-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK20-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK20:       omp.inner.for.body:
// CHECK20-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK20-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK20-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK20-NEXT:    [[TMP9:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[CONV:%.*]] = fptosi float [[TMP9]] to i32
// CHECK20-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK20-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP10]]
// CHECK20-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK20:       omp.body.continue:
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK20:       omp.inner.for.inc:
// CHECK20-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK20-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK20-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK20:       omp.inner.for.end:
// CHECK20-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK20:       omp.loop.exit:
// CHECK20-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK20-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK20-NEXT:    [[TMP13:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK20-NEXT:    br i1 [[TMP13]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK20:       .omp.final.then:
// CHECK20-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK20-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK20:       .omp.final.done:
// CHECK20-NEXT:    ret void
//
//
// CHECK20-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK20-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK20-NEXT:  entry:
// CHECK20-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK20-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK21-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK21-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK21-NEXT:    ret i32 [[CALL]]
//
//
// CHECK21-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK21-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK21-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK21-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK21-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK21-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK21-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK21-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK21-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK21-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK21-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK21-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK21-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK21-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK21-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 8
// CHECK21-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK21-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 8
// CHECK21-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK21-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 8
// CHECK21-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK21-NEXT:    store i8* null, i8** [[TMP12]], align 8
// CHECK21-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK21-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK21-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 8
// CHECK21-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK21-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK21-NEXT:    store float* [[B]], float** [[TMP16]], align 8
// CHECK21-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK21-NEXT:    store i64 4, i64* [[TMP17]], align 8
// CHECK21-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK21-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK21-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK21-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK21-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 8
// CHECK21-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK21-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK21-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 8
// CHECK21-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK21-NEXT:    store i64 492, i64* [[TMP23]], align 8
// CHECK21-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK21-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK21-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK21-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK21-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK21-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK21-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK21:       omp_offload.failed:
// CHECK21-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK21-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK21:       omp_offload.cont:
// CHECK21-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i64 0, i64 0
// CHECK21-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK21-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK21-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK21-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK21-NEXT:    [[TMP1:%.*]] = load float, float* [[B]], align 4
// CHECK21-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP1]], 0.000000e+00
// CHECK21-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK21-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK21-NEXT:    [[TOBOOL1:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK21-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL1]] to i8
// CHECK21-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK21-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK21-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]], i64 [[TMP3]])
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK21-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]], i64 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK21-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK21-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK21-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK21-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK21-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK21-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK21-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK21-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK21-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK21-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK21-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK21-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK21:       cond.true:
// CHECK21-NEXT:    br label [[COND_END:%.*]]
// CHECK21:       cond.false:
// CHECK21-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    br label [[COND_END]]
// CHECK21:       cond.end:
// CHECK21-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK21-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK21-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK21-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK21-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK21:       omp_if.then:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK21:       omp.inner.for.cond:
// CHECK21-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK21-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK21:       omp.inner.for.body:
// CHECK21-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK21-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK21-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK21-NEXT:    [[TMP10:%.*]] = load float, float* [[B]], align 4, !nontemporal !5, !llvm.access.group !4
// CHECK21-NEXT:    [[CONV2:%.*]] = fptosi float [[TMP10]] to i32
// CHECK21-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK21-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK21-NEXT:    store i32 [[CONV2]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK21:       omp.body.continue:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK21:       omp.inner.for.inc:
// CHECK21-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK21-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK21:       omp.inner.for.end:
// CHECK21-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK21:       omp_if.else:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND4:%.*]]
// CHECK21:       omp.inner.for.cond4:
// CHECK21-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK21-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK21-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY6:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK21:       omp.inner.for.body6:
// CHECK21-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK21-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL7]]
// CHECK21-NEXT:    store i32 [[ADD8]], i32* [[I]], align 4
// CHECK21-NEXT:    [[B9:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK21-NEXT:    [[TMP16:%.*]] = load float, float* [[B9]], align 4
// CHECK21-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP16]] to i32
// CHECK21-NEXT:    [[A11:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK21-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4
// CHECK21-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP17]] to i64
// CHECK21-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A11]], i64 0, i64 [[IDXPROM12]]
// CHECK21-NEXT:    store i32 [[CONV10]], i32* [[ARRAYIDX13]], align 4
// CHECK21-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK21:       omp.body.continue14:
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK21:       omp.inner.for.inc15:
// CHECK21-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK21-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK21-NEXT:    br label [[OMP_INNER_FOR_COND4]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK21:       omp.inner.for.end17:
// CHECK21-NEXT:    br label [[OMP_IF_END]]
// CHECK21:       omp_if.end:
// CHECK21-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK21:       omp.loop.exit:
// CHECK21-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK21-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK21-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK21-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK21:       .omp.final.then:
// CHECK21-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK21-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK21:       .omp.final.done:
// CHECK21-NEXT:    ret void
//
//
// CHECK21-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK21-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK21-NEXT:  entry:
// CHECK21-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK21-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK22-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK22-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK22-NEXT:    ret i32 [[CALL]]
//
//
// CHECK22-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK22-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK22-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK22-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK22-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK22-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK22-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK22-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK22-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK22-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK22-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK22-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK22-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK22-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK22-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 8
// CHECK22-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK22-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 8
// CHECK22-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK22-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 8
// CHECK22-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK22-NEXT:    store i8* null, i8** [[TMP12]], align 8
// CHECK22-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK22-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK22-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 8
// CHECK22-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK22-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK22-NEXT:    store float* [[B]], float** [[TMP16]], align 8
// CHECK22-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK22-NEXT:    store i64 4, i64* [[TMP17]], align 8
// CHECK22-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK22-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK22-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK22-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK22-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 8
// CHECK22-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK22-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK22-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 8
// CHECK22-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK22-NEXT:    store i64 492, i64* [[TMP23]], align 8
// CHECK22-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK22-NEXT:    store i8* null, i8** [[TMP24]], align 8
// CHECK22-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK22-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK22-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK22-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK22-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK22:       omp_offload.failed:
// CHECK22-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK22-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK22:       omp_offload.cont:
// CHECK22-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK22-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i64 0, i64 0
// CHECK22-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK22-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK22-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK22-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK22-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK22-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK22-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK22-NEXT:    [[TMP1:%.*]] = load float, float* [[B]], align 4
// CHECK22-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP1]], 0.000000e+00
// CHECK22-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK22-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK22-NEXT:    [[TOBOOL1:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK22-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK22-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL1]] to i8
// CHECK22-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK22-NEXT:    [[TMP3:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK22-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]], i64 [[TMP3]])
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK22-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]], i64 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK22-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK22-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK22-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK22-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK22-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK22-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK22-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK22-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK22-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK22-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK22-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK22-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK22:       cond.true:
// CHECK22-NEXT:    br label [[COND_END:%.*]]
// CHECK22:       cond.false:
// CHECK22-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    br label [[COND_END]]
// CHECK22:       cond.end:
// CHECK22-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK22-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK22-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK22-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK22-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK22:       omp_if.then:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK22:       omp.inner.for.cond:
// CHECK22-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK22-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK22:       omp.inner.for.body:
// CHECK22-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK22-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK22-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK22-NEXT:    [[TMP10:%.*]] = load float, float* [[B]], align 4, !nontemporal !5, !llvm.access.group !4
// CHECK22-NEXT:    [[CONV2:%.*]] = fptosi float [[TMP10]] to i32
// CHECK22-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK22-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK22-NEXT:    store i32 [[CONV2]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK22:       omp.body.continue:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK22:       omp.inner.for.inc:
// CHECK22-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK22-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK22:       omp.inner.for.end:
// CHECK22-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK22:       omp_if.else:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND4:%.*]]
// CHECK22:       omp.inner.for.cond4:
// CHECK22-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK22-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK22-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY6:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK22:       omp.inner.for.body6:
// CHECK22-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK22-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL7]]
// CHECK22-NEXT:    store i32 [[ADD8]], i32* [[I]], align 4
// CHECK22-NEXT:    [[B9:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK22-NEXT:    [[TMP16:%.*]] = load float, float* [[B9]], align 4
// CHECK22-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP16]] to i32
// CHECK22-NEXT:    [[A11:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK22-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4
// CHECK22-NEXT:    [[IDXPROM12:%.*]] = sext i32 [[TMP17]] to i64
// CHECK22-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A11]], i64 0, i64 [[IDXPROM12]]
// CHECK22-NEXT:    store i32 [[CONV10]], i32* [[ARRAYIDX13]], align 4
// CHECK22-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK22:       omp.body.continue14:
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK22:       omp.inner.for.inc15:
// CHECK22-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK22-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK22-NEXT:    br label [[OMP_INNER_FOR_COND4]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK22:       omp.inner.for.end17:
// CHECK22-NEXT:    br label [[OMP_IF_END]]
// CHECK22:       omp_if.end:
// CHECK22-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK22:       omp.loop.exit:
// CHECK22-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK22-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK22-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK22-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK22:       .omp.final.then:
// CHECK22-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK22-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK22:       .omp.final.done:
// CHECK22-NEXT:    ret void
//
//
// CHECK22-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK22-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK22-NEXT:  entry:
// CHECK22-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK22-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK23-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK23-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK23-NEXT:    ret i32 [[CALL]]
//
//
// CHECK23-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK23-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK23-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK23-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK23-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK23-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK23-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK23-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK23-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK23-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK23-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK23-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK23-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK23-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK23-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 4
// CHECK23-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK23-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 4
// CHECK23-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK23-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 4
// CHECK23-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK23-NEXT:    store i8* null, i8** [[TMP12]], align 4
// CHECK23-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK23-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK23-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 4
// CHECK23-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK23-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK23-NEXT:    store float* [[B]], float** [[TMP16]], align 4
// CHECK23-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK23-NEXT:    store i64 4, i64* [[TMP17]], align 4
// CHECK23-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK23-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK23-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK23-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK23-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 4
// CHECK23-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK23-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK23-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 4
// CHECK23-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK23-NEXT:    store i64 492, i64* [[TMP23]], align 4
// CHECK23-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK23-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK23-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK23-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK23-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK23-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK23-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK23:       omp_offload.failed:
// CHECK23-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK23-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK23:       omp_offload.cont:
// CHECK23-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK23-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK23-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK23-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK23-NEXT:    [[TMP1:%.*]] = load float, float* [[B]], align 4
// CHECK23-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP1]], 0.000000e+00
// CHECK23-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK23-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK23-NEXT:    [[TOBOOL1:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK23-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL1]] to i8
// CHECK23-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK23-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]], i32 [[TMP3]])
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK23-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]], i32 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK23-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK23-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK23-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK23-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK23-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK23-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK23-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK23-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK23-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK23-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK23-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK23:       cond.true:
// CHECK23-NEXT:    br label [[COND_END:%.*]]
// CHECK23:       cond.false:
// CHECK23-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    br label [[COND_END]]
// CHECK23:       cond.end:
// CHECK23-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK23-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK23-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK23-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK23-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK23:       omp_if.then:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK23:       omp.inner.for.cond:
// CHECK23-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK23-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK23:       omp.inner.for.body:
// CHECK23-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK23-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK23-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK23-NEXT:    [[TMP10:%.*]] = load float, float* [[B]], align 4, !nontemporal !6, !llvm.access.group !5
// CHECK23-NEXT:    [[CONV2:%.*]] = fptosi float [[TMP10]] to i32
// CHECK23-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP11]]
// CHECK23-NEXT:    store i32 [[CONV2]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK23:       omp.body.continue:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK23:       omp.inner.for.inc:
// CHECK23-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK23-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK23:       omp.inner.for.end:
// CHECK23-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK23:       omp_if.else:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND4:%.*]]
// CHECK23:       omp.inner.for.cond4:
// CHECK23-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK23-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK23-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY6:%.*]], label [[OMP_INNER_FOR_END16:%.*]]
// CHECK23:       omp.inner.for.body6:
// CHECK23-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK23-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL7]]
// CHECK23-NEXT:    store i32 [[ADD8]], i32* [[I]], align 4
// CHECK23-NEXT:    [[B9:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK23-NEXT:    [[TMP16:%.*]] = load float, float* [[B9]], align 4
// CHECK23-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP16]] to i32
// CHECK23-NEXT:    [[A11:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK23-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4
// CHECK23-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A11]], i32 0, i32 [[TMP17]]
// CHECK23-NEXT:    store i32 [[CONV10]], i32* [[ARRAYIDX12]], align 4
// CHECK23-NEXT:    br label [[OMP_BODY_CONTINUE13:%.*]]
// CHECK23:       omp.body.continue13:
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_INC14:%.*]]
// CHECK23:       omp.inner.for.inc14:
// CHECK23-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK23-NEXT:    store i32 [[ADD15]], i32* [[DOTOMP_IV]], align 4
// CHECK23-NEXT:    br label [[OMP_INNER_FOR_COND4]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK23:       omp.inner.for.end16:
// CHECK23-NEXT:    br label [[OMP_IF_END]]
// CHECK23:       omp_if.end:
// CHECK23-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK23:       omp.loop.exit:
// CHECK23-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK23-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK23-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK23-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK23:       .omp.final.then:
// CHECK23-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK23-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK23:       .omp.final.done:
// CHECK23-NEXT:    ret void
//
//
// CHECK23-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK23-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK23-NEXT:  entry:
// CHECK23-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK23-NEXT:    ret void
//
//
// CHECK24-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK24-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK24-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK24-NEXT:    ret i32 [[CALL]]
//
//
// CHECK24-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK24-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK24-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK24-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK24-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK24-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK24-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK24-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP0:%.*]] = getelementptr float, float* [[B]], i32 1
// CHECK24-NEXT:    [[TMP1:%.*]] = bitcast [123 x i32]* [[A]] to i8*
// CHECK24-NEXT:    [[TMP2:%.*]] = bitcast float* [[TMP0]] to i8*
// CHECK24-NEXT:    [[TMP3:%.*]] = ptrtoint i8* [[TMP2]] to i64
// CHECK24-NEXT:    [[TMP4:%.*]] = ptrtoint i8* [[TMP1]] to i64
// CHECK24-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP3]], [[TMP4]]
// CHECK24-NEXT:    [[TMP6:%.*]] = sdiv exact i64 [[TMP5]], ptrtoint (i8* getelementptr (i8, i8* null, i32 1) to i64)
// CHECK24-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP8:%.*]] = bitcast i8** [[TMP7]] to %struct.SS**
// CHECK24-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP8]], align 4
// CHECK24-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to [123 x i32]**
// CHECK24-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP10]], align 4
// CHECK24-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK24-NEXT:    store i64 [[TMP6]], i64* [[TMP11]], align 4
// CHECK24-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK24-NEXT:    store i8* null, i8** [[TMP12]], align 4
// CHECK24-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK24-NEXT:    [[TMP14:%.*]] = bitcast i8** [[TMP13]] to %struct.SS**
// CHECK24-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP14]], align 4
// CHECK24-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK24-NEXT:    [[TMP16:%.*]] = bitcast i8** [[TMP15]] to float**
// CHECK24-NEXT:    store float* [[B]], float** [[TMP16]], align 4
// CHECK24-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK24-NEXT:    store i64 4, i64* [[TMP17]], align 4
// CHECK24-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK24-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK24-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK24-NEXT:    [[TMP20:%.*]] = bitcast i8** [[TMP19]] to %struct.SS**
// CHECK24-NEXT:    store %struct.SS* [[THIS1]], %struct.SS** [[TMP20]], align 4
// CHECK24-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK24-NEXT:    [[TMP22:%.*]] = bitcast i8** [[TMP21]] to [123 x i32]**
// CHECK24-NEXT:    store [123 x i32]* [[A]], [123 x i32]** [[TMP22]], align 4
// CHECK24-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK24-NEXT:    store i64 492, i64* [[TMP23]], align 4
// CHECK24-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK24-NEXT:    store i8* null, i8** [[TMP24]], align 4
// CHECK24-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK24-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 123)
// CHECK24-NEXT:    [[TMP28:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123.region_id, i32 3, i8** [[TMP25]], i8** [[TMP26]], i64* [[TMP27]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK24-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK24-NEXT:    br i1 [[TMP29]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK24:       omp_offload.failed:
// CHECK24-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123(%struct.SS* [[THIS1]]) #[[ATTR2:[0-9]+]]
// CHECK24-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK24:       omp_offload.cont:
// CHECK24-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK24-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A2]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP30:%.*]] = load i32, i32* [[ARRAYIDX]], align 4
// CHECK24-NEXT:    ret i32 [[TMP30]]
//
//
// CHECK24-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l123
// CHECK24-SAME: (%struct.SS* [[THIS:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK24-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK24-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK24-NEXT:    [[TMP1:%.*]] = load float, float* [[B]], align 4
// CHECK24-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP1]], 0.000000e+00
// CHECK24-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK24-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK24-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK24-NEXT:    [[TOBOOL1:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK24-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK24-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL1]] to i8
// CHECK24-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK24-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK24-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 2, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, %struct.SS*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), %struct.SS* [[TMP0]], i32 [[TMP3]])
// CHECK24-NEXT:    ret void
//
//
// CHECK24-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK24-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], %struct.SS* [[THIS:%.*]], i32 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK24-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK24-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK24-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK24-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK24-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK24-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK24-NEXT:    [[TMP0:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK24-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK24-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK24-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK24-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK24-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK24-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK24-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK24-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 122
// CHECK24-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK24:       cond.true:
// CHECK24-NEXT:    br label [[COND_END:%.*]]
// CHECK24:       cond.false:
// CHECK24-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    br label [[COND_END]]
// CHECK24:       cond.end:
// CHECK24-NEXT:    [[COND:%.*]] = phi i32 [ 122, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK24-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK24-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[TMP6:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK24-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP6]] to i1
// CHECK24-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK24:       omp_if.then:
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK24:       omp.inner.for.cond:
// CHECK24-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK24-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK24:       omp.inner.for.body:
// CHECK24-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK24-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK24-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK24-NEXT:    [[TMP10:%.*]] = load float, float* [[B]], align 4, !nontemporal !6, !llvm.access.group !5
// CHECK24-NEXT:    [[CONV2:%.*]] = fptosi float [[TMP10]] to i32
// CHECK24-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP11]]
// CHECK24-NEXT:    store i32 [[CONV2]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK24:       omp.body.continue:
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK24:       omp.inner.for.inc:
// CHECK24-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK24-NEXT:    store i32 [[ADD3]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK24:       omp.inner.for.end:
// CHECK24-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK24:       omp_if.else:
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND4:%.*]]
// CHECK24:       omp.inner.for.cond4:
// CHECK24-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK24-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK24-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY6:%.*]], label [[OMP_INNER_FOR_END16:%.*]]
// CHECK24:       omp.inner.for.body6:
// CHECK24-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[MUL7:%.*]] = mul nsw i32 [[TMP15]], 1
// CHECK24-NEXT:    [[ADD8:%.*]] = add nsw i32 0, [[MUL7]]
// CHECK24-NEXT:    store i32 [[ADD8]], i32* [[I]], align 4
// CHECK24-NEXT:    [[B9:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 1
// CHECK24-NEXT:    [[TMP16:%.*]] = load float, float* [[B9]], align 4
// CHECK24-NEXT:    [[CONV10:%.*]] = fptosi float [[TMP16]] to i32
// CHECK24-NEXT:    [[A11:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[TMP0]], i32 0, i32 0
// CHECK24-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I]], align 4
// CHECK24-NEXT:    [[ARRAYIDX12:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A11]], i32 0, i32 [[TMP17]]
// CHECK24-NEXT:    store i32 [[CONV10]], i32* [[ARRAYIDX12]], align 4
// CHECK24-NEXT:    br label [[OMP_BODY_CONTINUE13:%.*]]
// CHECK24:       omp.body.continue13:
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_INC14:%.*]]
// CHECK24:       omp.inner.for.inc14:
// CHECK24-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    [[ADD15:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK24-NEXT:    store i32 [[ADD15]], i32* [[DOTOMP_IV]], align 4
// CHECK24-NEXT:    br label [[OMP_INNER_FOR_COND4]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK24:       omp.inner.for.end16:
// CHECK24-NEXT:    br label [[OMP_IF_END]]
// CHECK24:       omp_if.end:
// CHECK24-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK24:       omp.loop.exit:
// CHECK24-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK24-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK24-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK24-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK24:       .omp.final.then:
// CHECK24-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK24-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK24:       .omp.final.done:
// CHECK24-NEXT:    ret void
//
//
// CHECK24-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK24-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK24-NEXT:  entry:
// CHECK24-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK24-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK25-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK25-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK25-NEXT:    ret i32 [[CALL]]
//
//
// CHECK25-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK25-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK25-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK25-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK25-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK25-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK25-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK25-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK25:       omp.inner.for.cond:
// CHECK25-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK25-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK25:       omp.inner.for.body:
// CHECK25-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK25-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK25-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK25-NEXT:    [[TMP4:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i32
// CHECK25-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK25-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK25-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK25-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK25:       omp.body.continue:
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK25:       omp.inner.for.inc:
// CHECK25-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK25-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK25-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK25:       omp.inner.for.end:
// CHECK25-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK25-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK25-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A3]], i64 0, i64 0
// CHECK25-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX4]], align 4
// CHECK25-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK26-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK26-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK26-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK26-NEXT:    ret i32 [[CALL]]
//
//
// CHECK26-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK26-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK26-NEXT:  entry:
// CHECK26-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK26-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK26-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK26-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK26-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK26-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK26-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK26:       omp.inner.for.cond:
// CHECK26-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK26-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK26:       omp.inner.for.body:
// CHECK26-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK26-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK26-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK26-NEXT:    [[TMP4:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i32
// CHECK26-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK26-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP5]] to i64
// CHECK26-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK26-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK26:       omp.body.continue:
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK26:       omp.inner.for.inc:
// CHECK26-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK26-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK26-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK26:       omp.inner.for.end:
// CHECK26-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK26-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK26-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A3]], i64 0, i64 0
// CHECK26-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX4]], align 4
// CHECK26-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK27-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK27-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK27-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK27-NEXT:    ret i32 [[CALL]]
//
//
// CHECK27-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK27-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK27-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK27-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK27-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK27-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK27:       omp.inner.for.cond:
// CHECK27-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK27-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK27:       omp.inner.for.body:
// CHECK27-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK27-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK27-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK27-NEXT:    [[TMP4:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i32
// CHECK27-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP5]]
// CHECK27-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK27:       omp.body.continue:
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK27:       omp.inner.for.inc:
// CHECK27-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK27-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK27-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK27:       omp.inner.for.end:
// CHECK27-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK27-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK27-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A3]], i32 0, i32 0
// CHECK27-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX4]], align 4
// CHECK27-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK28-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK28-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK28-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK28-NEXT:    ret i32 [[CALL]]
//
//
// CHECK28-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK28-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK28-NEXT:  entry:
// CHECK28-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK28-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK28-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK28-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK28-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK28-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK28-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK28:       omp.inner.for.cond:
// CHECK28-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK28-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK28:       omp.inner.for.body:
// CHECK28-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK28-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK28-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK28-NEXT:    [[TMP4:%.*]] = load float, float* [[B]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i32
// CHECK28-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP5:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP5]]
// CHECK28-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK28:       omp.body.continue:
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK28:       omp.inner.for.inc:
// CHECK28-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP6]], 1
// CHECK28-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK28-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK28:       omp.inner.for.end:
// CHECK28-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK28-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK28-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A3]], i32 0, i32 0
// CHECK28-NEXT:    [[TMP7:%.*]] = load i32, i32* [[ARRAYIDX4]], align 4
// CHECK28-NEXT:    ret i32 [[TMP7]]
//
//
// CHECK29-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK29-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK29-NEXT:  entry:
// CHECK29-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK29-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK29-NEXT:    ret i32 [[CALL]]
//
//
// CHECK29-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK29-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK29-NEXT:  entry:
// CHECK29-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK29-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK29-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK29-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK29-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK29-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK29-NEXT:    [[TMP0:%.*]] = load float, float* [[B]], align 4
// CHECK29-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP0]], 0.000000e+00
// CHECK29-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK29-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK29-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK29-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK29-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK29-NEXT:    store i32 [[TMP1]], i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK29-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK29-NEXT:    br i1 [[TOBOOL2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK29:       omp_if.then:
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK29:       omp.inner.for.cond:
// CHECK29-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP3]], [[TMP4]]
// CHECK29-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK29:       omp.inner.for.body:
// CHECK29-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP5]], 1
// CHECK29-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK29-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    [[B3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK29-NEXT:    [[TMP6:%.*]] = load float, float* [[B3]], align 4, !nontemporal !3, !llvm.access.group !2
// CHECK29-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i32
// CHECK29-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK29-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP7]] to i64
// CHECK29-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK29-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK29:       omp.body.continue:
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK29:       omp.inner.for.inc:
// CHECK29-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK29-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK29:       omp.inner.for.end:
// CHECK29-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK29:       omp_if.else:
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND5:%.*]]
// CHECK29:       omp.inner.for.cond5:
// CHECK29-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK29-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK29-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY7:%.*]], label [[OMP_INNER_FOR_END18:%.*]]
// CHECK29:       omp.inner.for.body7:
// CHECK29-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK29-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK29-NEXT:    store i32 [[ADD9]], i32* [[I]], align 4
// CHECK29-NEXT:    [[B10:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK29-NEXT:    [[TMP12:%.*]] = load float, float* [[B10]], align 4
// CHECK29-NEXT:    [[CONV11:%.*]] = fptosi float [[TMP12]] to i32
// CHECK29-NEXT:    [[A12:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK29-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK29-NEXT:    [[IDXPROM13:%.*]] = sext i32 [[TMP13]] to i64
// CHECK29-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A12]], i64 0, i64 [[IDXPROM13]]
// CHECK29-NEXT:    store i32 [[CONV11]], i32* [[ARRAYIDX14]], align 4
// CHECK29-NEXT:    br label [[OMP_BODY_CONTINUE15:%.*]]
// CHECK29:       omp.body.continue15:
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_INC16:%.*]]
// CHECK29:       omp.inner.for.inc16:
// CHECK29-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK29-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK29-NEXT:    br label [[OMP_INNER_FOR_COND5]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK29:       omp.inner.for.end18:
// CHECK29-NEXT:    br label [[OMP_IF_END]]
// CHECK29:       omp_if.end:
// CHECK29-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK29-NEXT:    [[A19:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK29-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A19]], i64 0, i64 0
// CHECK29-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX20]], align 4
// CHECK29-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK30-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK30-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK30-NEXT:  entry:
// CHECK30-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK30-NEXT:    [[CALL:%.*]] = call signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK30-NEXT:    ret i32 [[CALL]]
//
//
// CHECK30-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK30-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK30-NEXT:  entry:
// CHECK30-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 8
// CHECK30-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK30-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK30-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 8
// CHECK30-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 8
// CHECK30-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK30-NEXT:    [[TMP0:%.*]] = load float, float* [[B]], align 4
// CHECK30-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP0]], 0.000000e+00
// CHECK30-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK30-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK30-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK30-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK30-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK30-NEXT:    store i32 [[TMP1]], i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK30-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK30-NEXT:    br i1 [[TOBOOL2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK30:       omp_if.then:
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK30:       omp.inner.for.cond:
// CHECK30-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP3]], [[TMP4]]
// CHECK30-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK30:       omp.inner.for.body:
// CHECK30-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP5]], 1
// CHECK30-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK30-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    [[B3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK30-NEXT:    [[TMP6:%.*]] = load float, float* [[B3]], align 4, !nontemporal !3, !llvm.access.group !2
// CHECK30-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i32
// CHECK30-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK30-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP7]] to i64
// CHECK30-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK30-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK30:       omp.body.continue:
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK30:       omp.inner.for.inc:
// CHECK30-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK30-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK30:       omp.inner.for.end:
// CHECK30-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK30:       omp_if.else:
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND5:%.*]]
// CHECK30:       omp.inner.for.cond5:
// CHECK30-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK30-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK30-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY7:%.*]], label [[OMP_INNER_FOR_END18:%.*]]
// CHECK30:       omp.inner.for.body7:
// CHECK30-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK30-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK30-NEXT:    store i32 [[ADD9]], i32* [[I]], align 4
// CHECK30-NEXT:    [[B10:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK30-NEXT:    [[TMP12:%.*]] = load float, float* [[B10]], align 4
// CHECK30-NEXT:    [[CONV11:%.*]] = fptosi float [[TMP12]] to i32
// CHECK30-NEXT:    [[A12:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK30-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK30-NEXT:    [[IDXPROM13:%.*]] = sext i32 [[TMP13]] to i64
// CHECK30-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A12]], i64 0, i64 [[IDXPROM13]]
// CHECK30-NEXT:    store i32 [[CONV11]], i32* [[ARRAYIDX14]], align 4
// CHECK30-NEXT:    br label [[OMP_BODY_CONTINUE15:%.*]]
// CHECK30:       omp.body.continue15:
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_INC16:%.*]]
// CHECK30:       omp.inner.for.inc16:
// CHECK30-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK30-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK30-NEXT:    br label [[OMP_INNER_FOR_COND5]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK30:       omp.inner.for.end18:
// CHECK30-NEXT:    br label [[OMP_IF_END]]
// CHECK30:       omp_if.end:
// CHECK30-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK30-NEXT:    [[A19:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK30-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A19]], i64 0, i64 0
// CHECK30-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX20]], align 4
// CHECK30-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK31-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK31-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK31-NEXT:  entry:
// CHECK31-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK31-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK31-NEXT:    ret i32 [[CALL]]
//
//
// CHECK31-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK31-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK31-NEXT:  entry:
// CHECK31-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK31-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK31-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK31-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK31-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK31-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK31-NEXT:    [[TMP0:%.*]] = load float, float* [[B]], align 4
// CHECK31-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP0]], 0.000000e+00
// CHECK31-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK31-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK31-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK31-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK31-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK31-NEXT:    store i32 [[TMP1]], i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK31-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK31-NEXT:    br i1 [[TOBOOL2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK31:       omp_if.then:
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK31:       omp.inner.for.cond:
// CHECK31-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP3]], [[TMP4]]
// CHECK31-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK31:       omp.inner.for.body:
// CHECK31-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP5]], 1
// CHECK31-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK31-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    [[B3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK31-NEXT:    [[TMP6:%.*]] = load float, float* [[B3]], align 4, !nontemporal !4, !llvm.access.group !3
// CHECK31-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i32
// CHECK31-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK31-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP7]]
// CHECK31-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK31:       omp.body.continue:
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK31:       omp.inner.for.inc:
// CHECK31-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK31-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK31:       omp.inner.for.end:
// CHECK31-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK31:       omp_if.else:
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND5:%.*]]
// CHECK31:       omp.inner.for.cond5:
// CHECK31-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK31-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK31-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY7:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK31:       omp.inner.for.body7:
// CHECK31-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK31-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK31-NEXT:    store i32 [[ADD9]], i32* [[I]], align 4
// CHECK31-NEXT:    [[B10:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK31-NEXT:    [[TMP12:%.*]] = load float, float* [[B10]], align 4
// CHECK31-NEXT:    [[CONV11:%.*]] = fptosi float [[TMP12]] to i32
// CHECK31-NEXT:    [[A12:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK31-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK31-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A12]], i32 0, i32 [[TMP13]]
// CHECK31-NEXT:    store i32 [[CONV11]], i32* [[ARRAYIDX13]], align 4
// CHECK31-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK31:       omp.body.continue14:
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK31:       omp.inner.for.inc15:
// CHECK31-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK31-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK31-NEXT:    br label [[OMP_INNER_FOR_COND5]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK31:       omp.inner.for.end17:
// CHECK31-NEXT:    br label [[OMP_IF_END]]
// CHECK31:       omp_if.end:
// CHECK31-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK31-NEXT:    [[A18:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK31-NEXT:    [[ARRAYIDX19:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A18]], i32 0, i32 0
// CHECK31-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX19]], align 4
// CHECK31-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK32-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK32-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK32-NEXT:  entry:
// CHECK32-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK32-NEXT:    [[CALL:%.*]] = call i32 @_ZN2SSIiLi123ELx456EE3fooEv(%struct.SS* nonnull align 4 dereferenceable(496) [[V]])
// CHECK32-NEXT:    ret i32 [[CALL]]
//
//
// CHECK32-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK32-SAME: (%struct.SS* nonnull align 4 dereferenceable(496) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK32-NEXT:  entry:
// CHECK32-NEXT:    [[THIS_ADDR:%.*]] = alloca %struct.SS*, align 4
// CHECK32-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK32-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK32-NEXT:    store %struct.SS* [[THIS]], %struct.SS** [[THIS_ADDR]], align 4
// CHECK32-NEXT:    [[THIS1:%.*]] = load %struct.SS*, %struct.SS** [[THIS_ADDR]], align 4
// CHECK32-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK32-NEXT:    [[TMP0:%.*]] = load float, float* [[B]], align 4
// CHECK32-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[TMP0]], 0.000000e+00
// CHECK32-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK32-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK32-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK32-NEXT:    store i32 122, i32* [[DOTOMP_UB]], align 4
// CHECK32-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK32-NEXT:    store i32 [[TMP1]], i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[TMP2:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK32-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP2]] to i1
// CHECK32-NEXT:    br i1 [[TOBOOL2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK32:       omp_if.then:
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK32:       omp.inner.for.cond:
// CHECK32-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP3]], [[TMP4]]
// CHECK32-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK32:       omp.inner.for.body:
// CHECK32-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP5]], 1
// CHECK32-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK32-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    [[B3:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK32-NEXT:    [[TMP6:%.*]] = load float, float* [[B3]], align 4, !nontemporal !4, !llvm.access.group !3
// CHECK32-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i32
// CHECK32-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK32-NEXT:    [[TMP7:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A]], i32 0, i32 [[TMP7]]
// CHECK32-NEXT:    store i32 [[CONV]], i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK32:       omp.body.continue:
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK32:       omp.inner.for.inc:
// CHECK32-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK32-NEXT:    store i32 [[ADD4]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK32:       omp.inner.for.end:
// CHECK32-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK32:       omp_if.else:
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND5:%.*]]
// CHECK32:       omp.inner.for.cond5:
// CHECK32-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK32-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK32-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY7:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK32:       omp.inner.for.body7:
// CHECK32-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK32-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK32-NEXT:    store i32 [[ADD9]], i32* [[I]], align 4
// CHECK32-NEXT:    [[B10:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 1
// CHECK32-NEXT:    [[TMP12:%.*]] = load float, float* [[B10]], align 4
// CHECK32-NEXT:    [[CONV11:%.*]] = fptosi float [[TMP12]] to i32
// CHECK32-NEXT:    [[A12:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK32-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I]], align 4
// CHECK32-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A12]], i32 0, i32 [[TMP13]]
// CHECK32-NEXT:    store i32 [[CONV11]], i32* [[ARRAYIDX13]], align 4
// CHECK32-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK32:       omp.body.continue14:
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK32:       omp.inner.for.inc15:
// CHECK32-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK32-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK32-NEXT:    br label [[OMP_INNER_FOR_COND5]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK32:       omp.inner.for.end17:
// CHECK32-NEXT:    br label [[OMP_IF_END]]
// CHECK32:       omp_if.end:
// CHECK32-NEXT:    store i32 123, i32* [[I]], align 4
// CHECK32-NEXT:    [[A18:%.*]] = getelementptr inbounds [[STRUCT_SS]], %struct.SS* [[THIS1]], i32 0, i32 0
// CHECK32-NEXT:    [[ARRAYIDX19:%.*]] = getelementptr inbounds [123 x i32], [123 x i32]* [[A18]], i32 0, i32 0
// CHECK32-NEXT:    [[TMP15:%.*]] = load i32, i32* [[ARRAYIDX19]], align 4
// CHECK32-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK33-LABEL: define {{[^@]+}}@main
// CHECK33-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK33-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK33-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK33-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK33-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK33-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK33-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK33-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK33-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK33-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK33-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK33-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK33-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK33-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK33-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK33-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK33-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK33-NEXT:    [[TMP5:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK33-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK33-NEXT:    store i64 [[TMP4]], i64* [[TMP7]], align 8
// CHECK33-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK33-NEXT:    store i64 [[TMP4]], i64* [[TMP9]], align 8
// CHECK33-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK33-NEXT:    store i64 4, i64* [[TMP10]], align 8
// CHECK33-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK33-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK33-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK33-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK33-NEXT:    store i64 [[TMP1]], i64* [[TMP13]], align 8
// CHECK33-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK33-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK33-NEXT:    store i64 [[TMP1]], i64* [[TMP15]], align 8
// CHECK33-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK33-NEXT:    store i64 8, i64* [[TMP16]], align 8
// CHECK33-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK33-NEXT:    store i8* null, i8** [[TMP17]], align 8
// CHECK33-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK33-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK33-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 8
// CHECK33-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK33-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK33-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 8
// CHECK33-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK33-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 8
// CHECK33-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK33-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK33-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK33-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK33-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK33-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK33-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK33-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK33-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK33-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK33-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK33-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK33-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK33-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK33-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK33-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK33:       omp_offload.failed:
// CHECK33-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i64 [[TMP4]], i64 [[TMP1]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK33-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK33:       omp_offload.cont:
// CHECK33-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK33-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP33]])
// CHECK33-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK33-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK33-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK33-NEXT:    [[TMP35:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK33-NEXT:    ret i32 [[TMP35]]
//
//
// CHECK33-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK33-SAME: (i64 [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK33-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK33-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK33-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK33-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK33-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK33-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK33-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK33-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK33-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK33-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK33-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK33-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK33-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK33-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK33-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK33-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK33-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK33-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK33-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK33-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK33-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK33-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK33-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK33:       omp.precond.then:
// CHECK33-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK33-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK33-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK33-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK33-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK33-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK33-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK33-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK33-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK33:       cond.true:
// CHECK33-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK33-NEXT:    br label [[COND_END:%.*]]
// CHECK33:       cond.false:
// CHECK33-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    br label [[COND_END]]
// CHECK33:       cond.end:
// CHECK33-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK33-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK33-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK33-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK33:       omp.inner.for.cond:
// CHECK33-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK33-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK33:       omp.inner.for.body:
// CHECK33-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK33-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK33-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK33-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM]]
// CHECK33-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK33:       omp.body.continue:
// CHECK33-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK33:       omp.inner.for.inc:
// CHECK33-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK33-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK33-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK33:       omp.inner.for.end:
// CHECK33-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK33:       omp.loop.exit:
// CHECK33-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK33-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK33-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK33-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK33-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK33:       .omp.final.then:
// CHECK33-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK33-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK33-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK33-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK33-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK33-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK33-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK33:       .omp.final.done:
// CHECK33-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK33:       omp.precond.end:
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK33-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK33-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK33-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK33-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK33-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK33-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK33-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK33-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK33-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK33-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK33-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK33-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK33-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK33-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK33-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK33-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK33-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK33-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK33-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK33-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK33-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK33-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK33-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK33-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK33-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK33-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK33-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK33-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK33-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK33-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK33-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 8
// CHECK33-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK33-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK33-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 8
// CHECK33-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK33-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK33-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK33-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK33-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK33-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK33-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK33-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK33:       omp_offload.failed:
// CHECK33-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK33-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK33:       omp_offload.cont:
// CHECK33-NEXT:    ret i32 0
//
//
// CHECK33-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK33-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK33-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK33-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK33-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK33-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK33-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK33-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK33-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK33-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK33-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK33-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK33-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK33-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK33-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK33-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK33-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK33-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK33-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK33-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK33-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK33-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK33-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK33-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK33:       cond.true:
// CHECK33-NEXT:    br label [[COND_END:%.*]]
// CHECK33:       cond.false:
// CHECK33-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    br label [[COND_END]]
// CHECK33:       cond.end:
// CHECK33-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK33-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK33-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK33-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK33-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK33:       omp.inner.for.cond:
// CHECK33-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK33-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK33:       omp.inner.for.body:
// CHECK33-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK33-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK33-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK33-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK33-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK33:       omp.body.continue:
// CHECK33-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK33:       omp.inner.for.inc:
// CHECK33-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK33-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK33-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK33:       omp.inner.for.end:
// CHECK33-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK33:       omp.loop.exit:
// CHECK33-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK33-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK33-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK33-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK33:       .omp.final.then:
// CHECK33-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK33-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK33:       .omp.final.done:
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK33-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK33-NEXT:    ret void
//
//
// CHECK34-LABEL: define {{[^@]+}}@main
// CHECK34-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK34-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK34-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 8
// CHECK34-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK34-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK34-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK34-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK34-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK34-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK34-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK34-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK34-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK34-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK34-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK34-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK34-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK34-NEXT:    [[TMP4:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK34-NEXT:    [[TMP5:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK34-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK34-NEXT:    store i64 [[TMP4]], i64* [[TMP7]], align 8
// CHECK34-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK34-NEXT:    store i64 [[TMP4]], i64* [[TMP9]], align 8
// CHECK34-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK34-NEXT:    store i64 4, i64* [[TMP10]], align 8
// CHECK34-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK34-NEXT:    store i8* null, i8** [[TMP11]], align 8
// CHECK34-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK34-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i64*
// CHECK34-NEXT:    store i64 [[TMP1]], i64* [[TMP13]], align 8
// CHECK34-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK34-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK34-NEXT:    store i64 [[TMP1]], i64* [[TMP15]], align 8
// CHECK34-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK34-NEXT:    store i64 8, i64* [[TMP16]], align 8
// CHECK34-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK34-NEXT:    store i8* null, i8** [[TMP17]], align 8
// CHECK34-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK34-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK34-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 8
// CHECK34-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK34-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK34-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 8
// CHECK34-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK34-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 8
// CHECK34-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK34-NEXT:    store i8* null, i8** [[TMP23]], align 8
// CHECK34-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK34-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK34-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK34-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK34-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK34-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK34-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK34-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK34-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK34-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK34-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK34-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK34-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK34-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK34:       omp_offload.failed:
// CHECK34-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i64 [[TMP4]], i64 [[TMP1]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK34-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK34:       omp_offload.cont:
// CHECK34-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK34-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP33]])
// CHECK34-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK34-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK34-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK34-NEXT:    [[TMP35:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK34-NEXT:    ret i32 [[TMP35]]
//
//
// CHECK34-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK34-SAME: (i64 [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK34-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK34-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK34-NEXT:    [[CONV:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK34-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK34-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK34-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i64, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV]], i64 [[TMP0]], i32* [[TMP1]])
// CHECK34-NEXT:    ret void
//
//
// CHECK34-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK34-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK34-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK34-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK34-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK34-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK34-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK34-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK34-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK34-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK34-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK34-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK34-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK34-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK34-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK34-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK34-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK34-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK34-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK34-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK34:       omp.precond.then:
// CHECK34-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK34-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK34-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK34-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK34-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK34-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK34-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK34-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK34-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK34-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK34:       cond.true:
// CHECK34-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK34-NEXT:    br label [[COND_END:%.*]]
// CHECK34:       cond.false:
// CHECK34-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    br label [[COND_END]]
// CHECK34:       cond.end:
// CHECK34-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK34-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK34-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK34-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK34:       omp.inner.for.cond:
// CHECK34-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK34-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK34:       omp.inner.for.body:
// CHECK34-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK34-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK34-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK34-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM]]
// CHECK34-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK34:       omp.body.continue:
// CHECK34-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK34:       omp.inner.for.inc:
// CHECK34-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK34-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK34-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK34:       omp.inner.for.end:
// CHECK34-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK34:       omp.loop.exit:
// CHECK34-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK34-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK34-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK34-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK34-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK34-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK34:       .omp.final.then:
// CHECK34-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK34-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK34-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK34-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK34-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK34-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK34-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK34:       .omp.final.done:
// CHECK34-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK34:       omp.precond.end:
// CHECK34-NEXT:    ret void
//
//
// CHECK34-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK34-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK34-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK34-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK34-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK34-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK34-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK34-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK34-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK34-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK34-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK34-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK34-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK34-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK34-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK34-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK34-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK34-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK34-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK34-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK34-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK34-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK34-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK34-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK34-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK34-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK34-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK34-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK34-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK34-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK34-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK34-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 8
// CHECK34-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK34-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK34-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 8
// CHECK34-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK34-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK34-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK34-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK34-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK34-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK34-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK34-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK34:       omp_offload.failed:
// CHECK34-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK34-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK34:       omp_offload.cont:
// CHECK34-NEXT:    ret i32 0
//
//
// CHECK34-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK34-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK34-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK34-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK34-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK34-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK34-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK34-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK34-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK34-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK34-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK34-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK34-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK34-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK34-NEXT:    ret void
//
//
// CHECK34-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK34-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK34-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK34-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK34-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK34-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK34-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK34-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK34-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK34-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK34-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK34-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK34-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK34-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK34-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK34-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK34:       cond.true:
// CHECK34-NEXT:    br label [[COND_END:%.*]]
// CHECK34:       cond.false:
// CHECK34-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    br label [[COND_END]]
// CHECK34:       cond.end:
// CHECK34-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK34-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK34-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK34-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK34-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK34:       omp.inner.for.cond:
// CHECK34-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK34-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK34:       omp.inner.for.body:
// CHECK34-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK34-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK34-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK34-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK34-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK34:       omp.body.continue:
// CHECK34-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK34:       omp.inner.for.inc:
// CHECK34-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK34-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !11
// CHECK34-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK34:       omp.inner.for.end:
// CHECK34-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK34:       omp.loop.exit:
// CHECK34-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK34-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK34-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK34-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK34:       .omp.final.then:
// CHECK34-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK34-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK34:       .omp.final.done:
// CHECK34-NEXT:    ret void
//
//
// CHECK34-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK34-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK34-NEXT:  entry:
// CHECK34-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK34-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@main
// CHECK35-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK35-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK35-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK35-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK35-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK35-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK35-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK35-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK35-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK35-NEXT:    store i32 [[TMP2]], i32* [[N_CASTED]], align 4
// CHECK35-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK35-NEXT:    [[TMP4:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK35-NEXT:    [[TMP5:%.*]] = sext i32 [[TMP4]] to i64
// CHECK35-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK35-NEXT:    store i32 [[TMP3]], i32* [[TMP7]], align 4
// CHECK35-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK35-NEXT:    store i32 [[TMP3]], i32* [[TMP9]], align 4
// CHECK35-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK35-NEXT:    store i64 4, i64* [[TMP10]], align 4
// CHECK35-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK35-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK35-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK35-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK35-NEXT:    store i32 [[TMP0]], i32* [[TMP13]], align 4
// CHECK35-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK35-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK35-NEXT:    store i32 [[TMP0]], i32* [[TMP15]], align 4
// CHECK35-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK35-NEXT:    store i64 4, i64* [[TMP16]], align 4
// CHECK35-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK35-NEXT:    store i8* null, i8** [[TMP17]], align 4
// CHECK35-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK35-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK35-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 4
// CHECK35-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK35-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK35-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 4
// CHECK35-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK35-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 4
// CHECK35-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK35-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK35-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK35-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK35-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK35-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK35-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK35-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK35-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK35-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK35-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK35-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK35-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK35-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK35-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK35-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK35:       omp_offload.failed:
// CHECK35-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i32 [[TMP3]], i32 [[TMP0]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK35-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK35:       omp_offload.cont:
// CHECK35-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP33]])
// CHECK35-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK35-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK35-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK35-NEXT:    [[TMP35:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK35-NEXT:    ret i32 [[TMP35]]
//
//
// CHECK35-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK35-SAME: (i32 [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK35-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK35-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK35-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK35-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK35-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK35-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK35-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK35-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK35-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK35-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK35-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK35-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK35-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK35-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK35-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK35-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK35-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK35:       omp.precond.then:
// CHECK35-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK35-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK35-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK35-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK35-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK35-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK35-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK35-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK35-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK35:       cond.true:
// CHECK35-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK35-NEXT:    br label [[COND_END:%.*]]
// CHECK35:       cond.false:
// CHECK35-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    br label [[COND_END]]
// CHECK35:       cond.end:
// CHECK35-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK35-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK35-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK35-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK35:       omp.inner.for.cond:
// CHECK35-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK35-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK35:       omp.inner.for.body:
// CHECK35-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK35-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK35-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP17]]
// CHECK35-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK35:       omp.body.continue:
// CHECK35-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK35:       omp.inner.for.inc:
// CHECK35-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK35-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK35-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK35:       omp.inner.for.end:
// CHECK35-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK35:       omp.loop.exit:
// CHECK35-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK35-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK35-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK35-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK35-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK35:       .omp.final.then:
// CHECK35-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK35-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK35-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK35-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK35-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK35-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK35-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK35:       .omp.final.done:
// CHECK35-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK35:       omp.precond.end:
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK35-SAME: (i32 [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK35-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK35-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK35-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK35-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK35-NEXT:    store i32 [[TMP0]], i32* [[TE_CASTED]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK35-NEXT:    store i32 [[TMP2]], i32* [[TH_CASTED]], align 4
// CHECK35-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK35-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK35-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK35-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK35-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK35-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK35-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK35-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK35-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK35-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK35-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK35-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK35-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK35-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK35-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK35-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK35-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK35-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 4
// CHECK35-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK35-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK35-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 4
// CHECK35-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK35-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK35-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK35-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK35-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK35-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK35-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK35-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK35:       omp_offload.failed:
// CHECK35-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK35-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK35:       omp_offload.cont:
// CHECK35-NEXT:    ret i32 0
//
//
// CHECK35-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK35-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK35-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK35-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK35-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK35-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK35-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK35-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK35-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK35-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK35-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK35-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK35-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK35-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK35-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK35-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK35-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK35-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK35:       cond.true:
// CHECK35-NEXT:    br label [[COND_END:%.*]]
// CHECK35:       cond.false:
// CHECK35-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    br label [[COND_END]]
// CHECK35:       cond.end:
// CHECK35-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK35-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK35-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK35-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK35-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK35:       omp.inner.for.cond:
// CHECK35-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK35-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK35:       omp.inner.for.body:
// CHECK35-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK35-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK35-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 [[TMP9]]
// CHECK35-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK35:       omp.body.continue:
// CHECK35-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK35:       omp.inner.for.inc:
// CHECK35-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK35-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK35-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK35:       omp.inner.for.end:
// CHECK35-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK35:       omp.loop.exit:
// CHECK35-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK35-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK35-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK35-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK35:       .omp.final.then:
// CHECK35-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK35-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK35:       .omp.final.done:
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK35-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK35-NEXT:    ret void
//
//
// CHECK36-LABEL: define {{[^@]+}}@main
// CHECK36-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK36-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK36-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [3 x i64], align 4
// CHECK36-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK36-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK36-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK36-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK36-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK36-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK36-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK36-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK36-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK36-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK36-NEXT:    store i32 [[TMP2]], i32* [[N_CASTED]], align 4
// CHECK36-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK36-NEXT:    [[TMP4:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK36-NEXT:    [[TMP5:%.*]] = sext i32 [[TMP4]] to i64
// CHECK36-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK36-NEXT:    store i32 [[TMP3]], i32* [[TMP7]], align 4
// CHECK36-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK36-NEXT:    store i32 [[TMP3]], i32* [[TMP9]], align 4
// CHECK36-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK36-NEXT:    store i64 4, i64* [[TMP10]], align 4
// CHECK36-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK36-NEXT:    store i8* null, i8** [[TMP11]], align 4
// CHECK36-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK36-NEXT:    [[TMP13:%.*]] = bitcast i8** [[TMP12]] to i32*
// CHECK36-NEXT:    store i32 [[TMP0]], i32* [[TMP13]], align 4
// CHECK36-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK36-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK36-NEXT:    store i32 [[TMP0]], i32* [[TMP15]], align 4
// CHECK36-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK36-NEXT:    store i64 4, i64* [[TMP16]], align 4
// CHECK36-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK36-NEXT:    store i8* null, i8** [[TMP17]], align 4
// CHECK36-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK36-NEXT:    [[TMP19:%.*]] = bitcast i8** [[TMP18]] to i32**
// CHECK36-NEXT:    store i32* [[VLA]], i32** [[TMP19]], align 4
// CHECK36-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK36-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32**
// CHECK36-NEXT:    store i32* [[VLA]], i32** [[TMP21]], align 4
// CHECK36-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK36-NEXT:    store i64 [[TMP5]], i64* [[TMP22]], align 4
// CHECK36-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK36-NEXT:    store i8* null, i8** [[TMP23]], align 4
// CHECK36-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [3 x i64], [3 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP27:%.*]] = load i32, i32* [[N]], align 4
// CHECK36-NEXT:    store i32 [[TMP27]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK36-NEXT:    [[TMP28:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK36-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP28]], 0
// CHECK36-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK36-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK36-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK36-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK36-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP29]], 1
// CHECK36-NEXT:    [[TMP30:%.*]] = zext i32 [[ADD]] to i64
// CHECK36-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP30]])
// CHECK36-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 3, i8** [[TMP24]], i8** [[TMP25]], i64* [[TMP26]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK36-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK36-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK36:       omp_offload.failed:
// CHECK36-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i32 [[TMP3]], i32 [[TMP0]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK36-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK36:       omp_offload.cont:
// CHECK36-NEXT:    [[TMP33:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK36-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP33]])
// CHECK36-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK36-NEXT:    [[TMP34:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK36-NEXT:    call void @llvm.stackrestore(i8* [[TMP34]])
// CHECK36-NEXT:    [[TMP35:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK36-NEXT:    ret i32 [[TMP35]]
//
//
// CHECK36-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK36-SAME: (i32 [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK36-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK36-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK36-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK36-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK36-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 3, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32, i32*)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]])
// CHECK36-NEXT:    ret void
//
//
// CHECK36-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK36-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2]] {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK36-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK36-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK36-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK36-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK36-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK36-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK36-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK36-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK36-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK36-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK36-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK36-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK36-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK36-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK36-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK36-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK36-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK36-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK36:       omp.precond.then:
// CHECK36-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK36-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK36-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK36-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK36-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK36-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK36-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK36-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK36-NEXT:    [[CMP4:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK36-NEXT:    br i1 [[CMP4]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK36:       cond.true:
// CHECK36-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK36-NEXT:    br label [[COND_END:%.*]]
// CHECK36:       cond.false:
// CHECK36-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    br label [[COND_END]]
// CHECK36:       cond.end:
// CHECK36-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK36-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK36-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK36-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK36:       omp.inner.for.cond:
// CHECK36-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    [[CMP5:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK36-NEXT:    br i1 [[CMP5]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK36:       omp.inner.for.body:
// CHECK36-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK36-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK36-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP17]]
// CHECK36-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK36:       omp.body.continue:
// CHECK36-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK36:       omp.inner.for.inc:
// CHECK36-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK36-NEXT:    store i32 [[ADD6]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK36-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK36:       omp.inner.for.end:
// CHECK36-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK36:       omp.loop.exit:
// CHECK36-NEXT:    [[TMP19:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK36-NEXT:    [[TMP20:%.*]] = load i32, i32* [[TMP19]], align 4
// CHECK36-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP20]])
// CHECK36-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK36-NEXT:    [[TMP22:%.*]] = icmp ne i32 [[TMP21]], 0
// CHECK36-NEXT:    br i1 [[TMP22]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK36:       .omp.final.then:
// CHECK36-NEXT:    [[TMP23:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK36-NEXT:    [[SUB7:%.*]] = sub nsw i32 [[TMP23]], 0
// CHECK36-NEXT:    [[DIV8:%.*]] = sdiv i32 [[SUB7]], 1
// CHECK36-NEXT:    [[MUL9:%.*]] = mul nsw i32 [[DIV8]], 1
// CHECK36-NEXT:    [[ADD10:%.*]] = add nsw i32 0, [[MUL9]]
// CHECK36-NEXT:    store i32 [[ADD10]], i32* [[I3]], align 4
// CHECK36-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK36:       .omp.final.done:
// CHECK36-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK36:       omp.precond.end:
// CHECK36-NEXT:    ret void
//
//
// CHECK36-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK36-SAME: (i32 [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK36-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK36-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK36-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK36-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK36-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK36-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK36-NEXT:    store i32 [[TMP0]], i32* [[TE_CASTED]], align 4
// CHECK36-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK36-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK36-NEXT:    store i32 [[TMP2]], i32* [[TH_CASTED]], align 4
// CHECK36-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK36-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK36-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK36-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK36-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK36-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK36-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK36-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK36-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK36-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK36-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK36-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK36-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK36-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK36-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK36-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK36-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK36-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 4
// CHECK36-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK36-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK36-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 4
// CHECK36-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK36-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK36-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK36-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK36-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK36-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK36-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK36-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK36:       omp_offload.failed:
// CHECK36-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK36-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK36:       omp_offload.cont:
// CHECK36-NEXT:    ret i32 0
//
//
// CHECK36-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK36-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK36-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK36-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK36-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK36-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK36-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK36-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK36-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK36-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK36-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK36-NEXT:    ret void
//
//
// CHECK36-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK36-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK36-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK36-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK36-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK36-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK36-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK36-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK36-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK36-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK36-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK36-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK36-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK36-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK36-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK36-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK36:       cond.true:
// CHECK36-NEXT:    br label [[COND_END:%.*]]
// CHECK36:       cond.false:
// CHECK36-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    br label [[COND_END]]
// CHECK36:       cond.end:
// CHECK36-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK36-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK36-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK36-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK36-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK36:       omp.inner.for.cond:
// CHECK36-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK36-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK36:       omp.inner.for.body:
// CHECK36-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK36-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK36-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 [[TMP9]]
// CHECK36-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK36:       omp.body.continue:
// CHECK36-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK36:       omp.inner.for.inc:
// CHECK36-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK36-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !12
// CHECK36-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK36:       omp.inner.for.end:
// CHECK36-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK36:       omp.loop.exit:
// CHECK36-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK36-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK36-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK36-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK36:       .omp.final.then:
// CHECK36-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK36-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK36:       .omp.final.done:
// CHECK36-NEXT:    ret void
//
//
// CHECK36-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK36-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK36-NEXT:  entry:
// CHECK36-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK36-NEXT:    ret void
//
//
// CHECK37-LABEL: define {{[^@]+}}@main
// CHECK37-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK37-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK37-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[ARGC_CASTED:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 8
// CHECK37-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK37-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK37-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK37-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK37-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK37-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK37-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK37-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK37-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK37-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK37-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK37-NEXT:    [[CONV:%.*]] = bitcast i64* [[ARGC_CASTED]] to i32*
// CHECK37-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK37-NEXT:    [[TMP4:%.*]] = load i64, i64* [[ARGC_CASTED]], align 8
// CHECK37-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N]], align 4
// CHECK37-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK37-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK37-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK37-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK37-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK37-NEXT:    store i64 [[TMP4]], i64* [[TMP9]], align 8
// CHECK37-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK37-NEXT:    store i64 [[TMP4]], i64* [[TMP11]], align 8
// CHECK37-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK37-NEXT:    store i64 4, i64* [[TMP12]], align 8
// CHECK37-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK37-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK37-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK37-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK37-NEXT:    store i64 [[TMP6]], i64* [[TMP15]], align 8
// CHECK37-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK37-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK37-NEXT:    store i64 [[TMP6]], i64* [[TMP17]], align 8
// CHECK37-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK37-NEXT:    store i64 4, i64* [[TMP18]], align 8
// CHECK37-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK37-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK37-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK37-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK37-NEXT:    store i64 [[TMP1]], i64* [[TMP21]], align 8
// CHECK37-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK37-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK37-NEXT:    store i64 [[TMP1]], i64* [[TMP23]], align 8
// CHECK37-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK37-NEXT:    store i64 8, i64* [[TMP24]], align 8
// CHECK37-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK37-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK37-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK37-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32**
// CHECK37-NEXT:    store i32* [[VLA]], i32** [[TMP27]], align 8
// CHECK37-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK37-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32**
// CHECK37-NEXT:    store i32* [[VLA]], i32** [[TMP29]], align 8
// CHECK37-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK37-NEXT:    store i64 [[TMP7]], i64* [[TMP30]], align 8
// CHECK37-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK37-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK37-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK37-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK37-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK37-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK37-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK37-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK37-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK37-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK37-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK37-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK37-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK37-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK37-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK37-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK37:       omp_offload.failed:
// CHECK37-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP1]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK37-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK37:       omp_offload.cont:
// CHECK37-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK37-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP41]])
// CHECK37-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK37-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK37-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK37-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK37-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK37-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK37-SAME: (i64 [[ARGC:%.*]], i64 [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    [[ARGC_ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    store i64 [[ARGC]], i64* [[ARGC_ADDR]], align 8
// CHECK37-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK37-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK37-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK37-NEXT:    [[CONV:%.*]] = bitcast i64* [[ARGC_ADDR]] to i32*
// CHECK37-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK37-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK37-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK37-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK37-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK37-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK37-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK37-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK37-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP3]] to i1
// CHECK37-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK37-NEXT:    [[FROMBOOL4:%.*]] = zext i1 [[TOBOOL2]] to i8
// CHECK37-NEXT:    store i8 [[FROMBOOL4]], i8* [[CONV3]], align 1
// CHECK37-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK37-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i64, i32*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV1]], i64 [[TMP0]], i32* [[TMP1]], i64 [[TMP4]])
// CHECK37-NEXT:    ret void
//
//
// CHECK37-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK37-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i64 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK37-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK37-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK37-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK37-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK37-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK37-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK37-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK37-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK37-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK37-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK37-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK37-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK37-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK37-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK37-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK37-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK37-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK37-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK37-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK37-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK37:       omp.precond.then:
// CHECK37-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK37-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK37-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK37-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK37-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK37-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK37-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK37-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK37-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK37-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK37:       cond.true:
// CHECK37-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK37-NEXT:    br label [[COND_END:%.*]]
// CHECK37:       cond.false:
// CHECK37-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    br label [[COND_END]]
// CHECK37:       cond.end:
// CHECK37-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK37-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK37-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK37-NEXT:    [[TMP14:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK37-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP14]] to i1
// CHECK37-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK37:       omp_if.then:
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK37:       omp.inner.for.cond:
// CHECK37-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK37-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK37:       omp.inner.for.body:
// CHECK37-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK37-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK37-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP18]] to i64
// CHECK37-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM]]
// CHECK37-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK37:       omp.body.continue:
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK37:       omp.inner.for.inc:
// CHECK37-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK37-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK37:       omp.inner.for.end:
// CHECK37-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK37:       omp_if.else:
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK37:       omp.inner.for.cond8:
// CHECK37-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK37-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK37-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END18:%.*]]
// CHECK37:       omp.inner.for.body10:
// CHECK37-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK37-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK37-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK37-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK37-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK37-NEXT:    [[IDXPROM13:%.*]] = sext i32 [[TMP23]] to i64
// CHECK37-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM13]]
// CHECK37-NEXT:    store i32 0, i32* [[ARRAYIDX14]], align 4
// CHECK37-NEXT:    br label [[OMP_BODY_CONTINUE15:%.*]]
// CHECK37:       omp.body.continue15:
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_INC16:%.*]]
// CHECK37:       omp.inner.for.inc16:
// CHECK37-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK37-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK37-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK37:       omp.inner.for.end18:
// CHECK37-NEXT:    br label [[OMP_IF_END]]
// CHECK37:       omp_if.end:
// CHECK37-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK37:       omp.loop.exit:
// CHECK37-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK37-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK37-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK37-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK37-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK37-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK37:       .omp.final.then:
// CHECK37-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK37-NEXT:    [[SUB19:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK37-NEXT:    [[DIV20:%.*]] = sdiv i32 [[SUB19]], 1
// CHECK37-NEXT:    [[MUL21:%.*]] = mul nsw i32 [[DIV20]], 1
// CHECK37-NEXT:    [[ADD22:%.*]] = add nsw i32 0, [[MUL21]]
// CHECK37-NEXT:    store i32 [[ADD22]], i32* [[I4]], align 4
// CHECK37-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK37:       .omp.final.done:
// CHECK37-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK37:       omp.precond.end:
// CHECK37-NEXT:    ret void
//
//
// CHECK37-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK37-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK37-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK37-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK37-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK37-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK37-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK37-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK37-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK37-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK37-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK37-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK37-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK37-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK37-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK37-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK37-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK37-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK37-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK37-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK37-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK37-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK37-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK37-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK37-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK37-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK37-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK37-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK37-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK37-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK37-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK37-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 8
// CHECK37-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK37-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK37-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 8
// CHECK37-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK37-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK37-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK37-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK37-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK37-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK37-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK37-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK37:       omp_offload.failed:
// CHECK37-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK37-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK37:       omp_offload.cont:
// CHECK37-NEXT:    ret i32 0
//
//
// CHECK37-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK37-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK37-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK37-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK37-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK37-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK37-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK37-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK37-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK37-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK37-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK37-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK37-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK37-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK37-NEXT:    ret void
//
//
// CHECK37-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK37-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK37-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK37-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK37-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK37-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK37-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK37-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK37-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK37-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK37-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK37-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK37-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK37-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK37-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK37-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK37:       cond.true:
// CHECK37-NEXT:    br label [[COND_END:%.*]]
// CHECK37:       cond.false:
// CHECK37-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    br label [[COND_END]]
// CHECK37:       cond.end:
// CHECK37-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK37-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK37-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK37-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK37:       omp.inner.for.cond:
// CHECK37-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK37-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK37:       omp.inner.for.body:
// CHECK37-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK37-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK37-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK37-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK37-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK37:       omp.body.continue:
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK37:       omp.inner.for.inc:
// CHECK37-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK37-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK37-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK37:       omp.inner.for.end:
// CHECK37-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK37:       omp.loop.exit:
// CHECK37-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK37-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK37-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK37-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK37:       .omp.final.then:
// CHECK37-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK37-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK37:       .omp.final.done:
// CHECK37-NEXT:    ret void
//
//
// CHECK37-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK37-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK37-NEXT:  entry:
// CHECK37-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK37-NEXT:    ret void
//
//
// CHECK38-LABEL: define {{[^@]+}}@main
// CHECK38-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK38-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK38-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[ARGC_CASTED:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[N_CASTED:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 8
// CHECK38-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK38-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK38-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK38-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK38-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK38-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK38-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK38-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK38-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK38-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK38-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK38-NEXT:    [[CONV:%.*]] = bitcast i64* [[ARGC_CASTED]] to i32*
// CHECK38-NEXT:    store i32 [[TMP3]], i32* [[CONV]], align 4
// CHECK38-NEXT:    [[TMP4:%.*]] = load i64, i64* [[ARGC_CASTED]], align 8
// CHECK38-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N]], align 4
// CHECK38-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_CASTED]] to i32*
// CHECK38-NEXT:    store i32 [[TMP5]], i32* [[CONV1]], align 4
// CHECK38-NEXT:    [[TMP6:%.*]] = load i64, i64* [[N_CASTED]], align 8
// CHECK38-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP1]], 4
// CHECK38-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i64*
// CHECK38-NEXT:    store i64 [[TMP4]], i64* [[TMP9]], align 8
// CHECK38-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i64*
// CHECK38-NEXT:    store i64 [[TMP4]], i64* [[TMP11]], align 8
// CHECK38-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK38-NEXT:    store i64 4, i64* [[TMP12]], align 8
// CHECK38-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK38-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK38-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK38-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i64*
// CHECK38-NEXT:    store i64 [[TMP6]], i64* [[TMP15]], align 8
// CHECK38-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK38-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i64*
// CHECK38-NEXT:    store i64 [[TMP6]], i64* [[TMP17]], align 8
// CHECK38-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK38-NEXT:    store i64 4, i64* [[TMP18]], align 8
// CHECK38-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK38-NEXT:    store i8* null, i8** [[TMP19]], align 8
// CHECK38-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK38-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i64*
// CHECK38-NEXT:    store i64 [[TMP1]], i64* [[TMP21]], align 8
// CHECK38-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK38-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i64*
// CHECK38-NEXT:    store i64 [[TMP1]], i64* [[TMP23]], align 8
// CHECK38-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK38-NEXT:    store i64 8, i64* [[TMP24]], align 8
// CHECK38-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK38-NEXT:    store i8* null, i8** [[TMP25]], align 8
// CHECK38-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK38-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32**
// CHECK38-NEXT:    store i32* [[VLA]], i32** [[TMP27]], align 8
// CHECK38-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK38-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32**
// CHECK38-NEXT:    store i32* [[VLA]], i32** [[TMP29]], align 8
// CHECK38-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK38-NEXT:    store i64 [[TMP7]], i64* [[TMP30]], align 8
// CHECK38-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK38-NEXT:    store i8* null, i8** [[TMP31]], align 8
// CHECK38-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK38-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK38-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK38-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK38-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK38-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK38-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK38-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK38-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK38-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK38-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK38-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK38-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK38-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK38:       omp_offload.failed:
// CHECK38-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP1]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK38-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK38:       omp_offload.cont:
// CHECK38-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK38-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP41]])
// CHECK38-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK38-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK38-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK38-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK38-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK38-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK38-SAME: (i64 [[ARGC:%.*]], i64 [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    [[ARGC_ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[N_ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    store i64 [[ARGC]], i64* [[ARGC_ADDR]], align 8
// CHECK38-NEXT:    store i64 [[N]], i64* [[N_ADDR]], align 8
// CHECK38-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK38-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK38-NEXT:    [[CONV:%.*]] = bitcast i64* [[ARGC_ADDR]] to i32*
// CHECK38-NEXT:    [[CONV1:%.*]] = bitcast i64* [[N_ADDR]] to i32*
// CHECK38-NEXT:    [[TMP0:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK38-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK38-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK38-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK38-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK38-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK38-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK38-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP3]] to i1
// CHECK38-NEXT:    [[CONV3:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK38-NEXT:    [[FROMBOOL4:%.*]] = zext i1 [[TOBOOL2]] to i8
// CHECK38-NEXT:    store i8 [[FROMBOOL4]], i8* [[CONV3]], align 1
// CHECK38-NEXT:    [[TMP4:%.*]] = load i64, i64* [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK38-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i64, i32*, i64)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[CONV1]], i64 [[TMP0]], i32* [[TMP1]], i64 [[TMP4]])
// CHECK38-NEXT:    ret void
//
//
// CHECK38-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK38-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i64 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i64 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK38-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK38-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 8
// CHECK38-NEXT:    store i64 [[VLA]], i64* [[VLA_ADDR]], align 8
// CHECK38-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 8
// CHECK38-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], i64* [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK38-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 8
// CHECK38-NEXT:    [[TMP1:%.*]] = load i64, i64* [[VLA_ADDR]], align 8
// CHECK38-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 8
// CHECK38-NEXT:    [[CONV:%.*]] = bitcast i64* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK38-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK38-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK38-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK38-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK38-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK38-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK38-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK38-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK38-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK38-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK38-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK38:       omp.precond.then:
// CHECK38-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK38-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK38-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK38-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK38-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK38-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK38-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK38-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK38-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK38-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK38:       cond.true:
// CHECK38-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK38-NEXT:    br label [[COND_END:%.*]]
// CHECK38:       cond.false:
// CHECK38-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    br label [[COND_END]]
// CHECK38:       cond.end:
// CHECK38-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK38-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK38-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK38-NEXT:    [[TMP14:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK38-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP14]] to i1
// CHECK38-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK38:       omp_if.then:
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK38:       omp.inner.for.cond:
// CHECK38-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK38-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK38:       omp.inner.for.body:
// CHECK38-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK38-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK38-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP18]] to i64
// CHECK38-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM]]
// CHECK38-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK38:       omp.body.continue:
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK38:       omp.inner.for.inc:
// CHECK38-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK38-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !5
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK38:       omp.inner.for.end:
// CHECK38-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK38:       omp_if.else:
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK38:       omp.inner.for.cond8:
// CHECK38-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK38-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK38-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END18:%.*]]
// CHECK38:       omp.inner.for.body10:
// CHECK38-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK38-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK38-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK38-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK38-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK38-NEXT:    [[IDXPROM13:%.*]] = sext i32 [[TMP23]] to i64
// CHECK38-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i64 [[IDXPROM13]]
// CHECK38-NEXT:    store i32 0, i32* [[ARRAYIDX14]], align 4
// CHECK38-NEXT:    br label [[OMP_BODY_CONTINUE15:%.*]]
// CHECK38:       omp.body.continue15:
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_INC16:%.*]]
// CHECK38:       omp.inner.for.inc16:
// CHECK38-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK38-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK38-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK38:       omp.inner.for.end18:
// CHECK38-NEXT:    br label [[OMP_IF_END]]
// CHECK38:       omp_if.end:
// CHECK38-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK38:       omp.loop.exit:
// CHECK38-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK38-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK38-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK38-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK38-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK38-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK38:       .omp.final.then:
// CHECK38-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK38-NEXT:    [[SUB19:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK38-NEXT:    [[DIV20:%.*]] = sdiv i32 [[SUB19]], 1
// CHECK38-NEXT:    [[MUL21:%.*]] = mul nsw i32 [[DIV20]], 1
// CHECK38-NEXT:    [[ADD22:%.*]] = add nsw i32 0, [[MUL21]]
// CHECK38-NEXT:    store i32 [[ADD22]], i32* [[I4]], align 4
// CHECK38-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK38:       .omp.final.done:
// CHECK38-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK38:       omp.precond.end:
// CHECK38-NEXT:    ret void
//
//
// CHECK38-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK38-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK38-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[TE_CASTED:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[TH_CASTED:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 8
// CHECK38-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 8
// CHECK38-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK38-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK38-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK38-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK38-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_CASTED]] to i32*
// CHECK38-NEXT:    store i32 [[TMP0]], i32* [[CONV]], align 4
// CHECK38-NEXT:    [[TMP1:%.*]] = load i64, i64* [[TE_CASTED]], align 8
// CHECK38-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK38-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_CASTED]] to i32*
// CHECK38-NEXT:    store i32 [[TMP2]], i32* [[CONV1]], align 4
// CHECK38-NEXT:    [[TMP3:%.*]] = load i64, i64* [[TH_CASTED]], align 8
// CHECK38-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i64*
// CHECK38-NEXT:    store i64 [[TMP1]], i64* [[TMP5]], align 8
// CHECK38-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i64*
// CHECK38-NEXT:    store i64 [[TMP1]], i64* [[TMP7]], align 8
// CHECK38-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK38-NEXT:    store i8* null, i8** [[TMP8]], align 8
// CHECK38-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK38-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i64*
// CHECK38-NEXT:    store i64 [[TMP3]], i64* [[TMP10]], align 8
// CHECK38-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK38-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i64*
// CHECK38-NEXT:    store i64 [[TMP3]], i64* [[TMP12]], align 8
// CHECK38-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK38-NEXT:    store i8* null, i8** [[TMP13]], align 8
// CHECK38-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK38-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK38-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 8
// CHECK38-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK38-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK38-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 8
// CHECK38-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK38-NEXT:    store i8* null, i8** [[TMP18]], align 8
// CHECK38-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK38-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK38-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK38-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK38-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK38-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK38:       omp_offload.failed:
// CHECK38-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i64 [[TMP1]], i64 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK38-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK38:       omp_offload.cont:
// CHECK38-NEXT:    ret i32 0
//
//
// CHECK38-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK38-SAME: (i64 [[TE:%.*]], i64 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    [[TE_ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[TH_ADDR:%.*]] = alloca i64, align 8
// CHECK38-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK38-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK38-NEXT:    store i64 [[TE]], i64* [[TE_ADDR]], align 8
// CHECK38-NEXT:    store i64 [[TH]], i64* [[TH_ADDR]], align 8
// CHECK38-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK38-NEXT:    [[CONV:%.*]] = bitcast i64* [[TE_ADDR]] to i32*
// CHECK38-NEXT:    [[CONV1:%.*]] = bitcast i64* [[TH_ADDR]] to i32*
// CHECK38-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK38-NEXT:    [[TMP2:%.*]] = load i32, i32* [[CONV]], align 4
// CHECK38-NEXT:    [[TMP3:%.*]] = load i32, i32* [[CONV1]], align 4
// CHECK38-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK38-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK38-NEXT:    ret void
//
//
// CHECK38-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK38-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 8
// CHECK38-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 8
// CHECK38-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK38-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK38-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 8
// CHECK38-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 8
// CHECK38-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 8
// CHECK38-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK38-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK38-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK38-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK38-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK38-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK38-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK38-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK38:       cond.true:
// CHECK38-NEXT:    br label [[COND_END:%.*]]
// CHECK38:       cond.false:
// CHECK38-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    br label [[COND_END]]
// CHECK38:       cond.end:
// CHECK38-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK38-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK38-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK38-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK38:       omp.inner.for.cond:
// CHECK38-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK38-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK38:       omp.inner.for.body:
// CHECK38-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK38-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK38-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK38-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i64 0, i64 [[IDXPROM]]
// CHECK38-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK38:       omp.body.continue:
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK38:       omp.inner.for.inc:
// CHECK38-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK38-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !13
// CHECK38-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP14:![0-9]+]]
// CHECK38:       omp.inner.for.end:
// CHECK38-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK38:       omp.loop.exit:
// CHECK38-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK38-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK38-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK38-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK38:       .omp.final.then:
// CHECK38-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK38-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK38:       .omp.final.done:
// CHECK38-NEXT:    ret void
//
//
// CHECK38-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK38-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK38-NEXT:  entry:
// CHECK38-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK38-NEXT:    ret void
//
//
// CHECK39-LABEL: define {{[^@]+}}@main
// CHECK39-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK39-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK39-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[ARGC_CASTED:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 4
// CHECK39-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK39-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK39-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK39-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK39-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK39-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK39-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK39-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK39-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK39-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK39-NEXT:    store i32 [[TMP2]], i32* [[ARGC_CASTED]], align 4
// CHECK39-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARGC_CASTED]], align 4
// CHECK39-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK39-NEXT:    store i32 [[TMP4]], i32* [[N_CASTED]], align 4
// CHECK39-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK39-NEXT:    [[TMP6:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK39-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
// CHECK39-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK39-NEXT:    store i32 [[TMP3]], i32* [[TMP9]], align 4
// CHECK39-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK39-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK39-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK39-NEXT:    store i64 4, i64* [[TMP12]], align 4
// CHECK39-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK39-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK39-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK39-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK39-NEXT:    store i32 [[TMP5]], i32* [[TMP15]], align 4
// CHECK39-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK39-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK39-NEXT:    store i32 [[TMP5]], i32* [[TMP17]], align 4
// CHECK39-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK39-NEXT:    store i64 4, i64* [[TMP18]], align 4
// CHECK39-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK39-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK39-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK39-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK39-NEXT:    store i32 [[TMP0]], i32* [[TMP21]], align 4
// CHECK39-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK39-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK39-NEXT:    store i32 [[TMP0]], i32* [[TMP23]], align 4
// CHECK39-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK39-NEXT:    store i64 4, i64* [[TMP24]], align 4
// CHECK39-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK39-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK39-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK39-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32**
// CHECK39-NEXT:    store i32* [[VLA]], i32** [[TMP27]], align 4
// CHECK39-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK39-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32**
// CHECK39-NEXT:    store i32* [[VLA]], i32** [[TMP29]], align 4
// CHECK39-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK39-NEXT:    store i64 [[TMP7]], i64* [[TMP30]], align 4
// CHECK39-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK39-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK39-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK39-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK39-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK39-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK39-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK39-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK39-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK39-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK39-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK39-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK39-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK39-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK39-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK39-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK39:       omp_offload.failed:
// CHECK39-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i32 [[TMP3]], i32 [[TMP5]], i32 [[TMP0]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK39-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK39:       omp_offload.cont:
// CHECK39-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK39-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP41]])
// CHECK39-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK39-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK39-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK39-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK39-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK39-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK39-SAME: (i32 [[ARGC:%.*]], i32 [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK39-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK39-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK39-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK39-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK39-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK39-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK39-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK39-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK39-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK39-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK39-NEXT:    [[TOBOOL1:%.*]] = trunc i8 [[TMP3]] to i1
// CHECK39-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK39-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL1]] to i8
// CHECK39-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK39-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK39-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32, i32*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]], i32 [[TMP4]])
// CHECK39-NEXT:    ret void
//
//
// CHECK39-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK39-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK39-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK39-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK39-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK39-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK39-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK39-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK39-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK39-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK39-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK39-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK39-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK39-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK39-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK39-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK39-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK39-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK39-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK39-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK39-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK39-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK39:       omp.precond.then:
// CHECK39-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK39-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK39-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK39-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK39-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK39-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK39-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK39-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK39-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK39-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK39:       cond.true:
// CHECK39-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK39-NEXT:    br label [[COND_END:%.*]]
// CHECK39:       cond.false:
// CHECK39-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    br label [[COND_END]]
// CHECK39:       cond.end:
// CHECK39-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK39-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK39-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK39-NEXT:    [[TMP14:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK39-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP14]] to i1
// CHECK39-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK39:       omp_if.then:
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK39:       omp.inner.for.cond:
// CHECK39-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK39-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK39:       omp.inner.for.body:
// CHECK39-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK39-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK39-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP18]]
// CHECK39-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK39:       omp.body.continue:
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK39:       omp.inner.for.inc:
// CHECK39-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK39-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK39:       omp.inner.for.end:
// CHECK39-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK39:       omp_if.else:
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK39:       omp.inner.for.cond8:
// CHECK39-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK39-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK39-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK39:       omp.inner.for.body10:
// CHECK39-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK39-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK39-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK39-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK39-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK39-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP23]]
// CHECK39-NEXT:    store i32 0, i32* [[ARRAYIDX13]], align 4
// CHECK39-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK39:       omp.body.continue14:
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK39:       omp.inner.for.inc15:
// CHECK39-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK39-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK39-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK39:       omp.inner.for.end17:
// CHECK39-NEXT:    br label [[OMP_IF_END]]
// CHECK39:       omp_if.end:
// CHECK39-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK39:       omp.loop.exit:
// CHECK39-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK39-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK39-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK39-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK39-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK39-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK39:       .omp.final.then:
// CHECK39-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK39-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK39-NEXT:    [[DIV19:%.*]] = sdiv i32 [[SUB18]], 1
// CHECK39-NEXT:    [[MUL20:%.*]] = mul nsw i32 [[DIV19]], 1
// CHECK39-NEXT:    [[ADD21:%.*]] = add nsw i32 0, [[MUL20]]
// CHECK39-NEXT:    store i32 [[ADD21]], i32* [[I4]], align 4
// CHECK39-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK39:       .omp.final.done:
// CHECK39-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK39:       omp.precond.end:
// CHECK39-NEXT:    ret void
//
//
// CHECK39-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK39-SAME: (i32 [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK39-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK39-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK39-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK39-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK39-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK39-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK39-NEXT:    store i32 [[TMP0]], i32* [[TE_CASTED]], align 4
// CHECK39-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK39-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK39-NEXT:    store i32 [[TMP2]], i32* [[TH_CASTED]], align 4
// CHECK39-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK39-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK39-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK39-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK39-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK39-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK39-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK39-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK39-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK39-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK39-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK39-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK39-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK39-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK39-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK39-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK39-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK39-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 4
// CHECK39-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK39-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK39-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 4
// CHECK39-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK39-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK39-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK39-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK39-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK39-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK39-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK39-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK39:       omp_offload.failed:
// CHECK39-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK39-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK39:       omp_offload.cont:
// CHECK39-NEXT:    ret i32 0
//
//
// CHECK39-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK39-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK39-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK39-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK39-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK39-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK39-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK39-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK39-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK39-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK39-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK39-NEXT:    ret void
//
//
// CHECK39-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK39-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK39-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK39-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK39-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK39-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK39-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK39-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK39-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK39-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK39-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK39-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK39-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK39-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK39-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK39-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK39:       cond.true:
// CHECK39-NEXT:    br label [[COND_END:%.*]]
// CHECK39:       cond.false:
// CHECK39-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    br label [[COND_END]]
// CHECK39:       cond.end:
// CHECK39-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK39-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK39-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK39-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK39:       omp.inner.for.cond:
// CHECK39-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK39-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK39:       omp.inner.for.body:
// CHECK39-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK39-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK39-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 [[TMP9]]
// CHECK39-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK39:       omp.body.continue:
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK39:       omp.inner.for.inc:
// CHECK39-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK39-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK39-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK39:       omp.inner.for.end:
// CHECK39-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK39:       omp.loop.exit:
// CHECK39-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK39-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK39-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK39-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK39:       .omp.final.then:
// CHECK39-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK39-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK39:       .omp.final.done:
// CHECK39-NEXT:    ret void
//
//
// CHECK39-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK39-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK39-NEXT:  entry:
// CHECK39-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK39-NEXT:    ret void
//
//
// CHECK40-LABEL: define {{[^@]+}}@main
// CHECK40-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK40-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK40-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[ARGC_CASTED:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[N_CASTED:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x i8*], align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x i8*], align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_SIZES:%.*]] = alloca [4 x i64], align 4
// CHECK40-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK40-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK40-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK40-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK40-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK40-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK40-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK40-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK40-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK40-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK40-NEXT:    store i32 [[TMP2]], i32* [[ARGC_CASTED]], align 4
// CHECK40-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARGC_CASTED]], align 4
// CHECK40-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK40-NEXT:    store i32 [[TMP4]], i32* [[N_CASTED]], align 4
// CHECK40-NEXT:    [[TMP5:%.*]] = load i32, i32* [[N_CASTED]], align 4
// CHECK40-NEXT:    [[TMP6:%.*]] = mul nuw i32 [[TMP0]], 4
// CHECK40-NEXT:    [[TMP7:%.*]] = sext i32 [[TMP6]] to i64
// CHECK40-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP9:%.*]] = bitcast i8** [[TMP8]] to i32*
// CHECK40-NEXT:    store i32 [[TMP3]], i32* [[TMP9]], align 4
// CHECK40-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP11:%.*]] = bitcast i8** [[TMP10]] to i32*
// CHECK40-NEXT:    store i32 [[TMP3]], i32* [[TMP11]], align 4
// CHECK40-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK40-NEXT:    store i64 4, i64* [[TMP12]], align 4
// CHECK40-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK40-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK40-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK40-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to i32*
// CHECK40-NEXT:    store i32 [[TMP5]], i32* [[TMP15]], align 4
// CHECK40-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK40-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to i32*
// CHECK40-NEXT:    store i32 [[TMP5]], i32* [[TMP17]], align 4
// CHECK40-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 1
// CHECK40-NEXT:    store i64 4, i64* [[TMP18]], align 4
// CHECK40-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK40-NEXT:    store i8* null, i8** [[TMP19]], align 4
// CHECK40-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK40-NEXT:    [[TMP21:%.*]] = bitcast i8** [[TMP20]] to i32*
// CHECK40-NEXT:    store i32 [[TMP0]], i32* [[TMP21]], align 4
// CHECK40-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK40-NEXT:    [[TMP23:%.*]] = bitcast i8** [[TMP22]] to i32*
// CHECK40-NEXT:    store i32 [[TMP0]], i32* [[TMP23]], align 4
// CHECK40-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 2
// CHECK40-NEXT:    store i64 4, i64* [[TMP24]], align 4
// CHECK40-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK40-NEXT:    store i8* null, i8** [[TMP25]], align 4
// CHECK40-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK40-NEXT:    [[TMP27:%.*]] = bitcast i8** [[TMP26]] to i32**
// CHECK40-NEXT:    store i32* [[VLA]], i32** [[TMP27]], align 4
// CHECK40-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK40-NEXT:    [[TMP29:%.*]] = bitcast i8** [[TMP28]] to i32**
// CHECK40-NEXT:    store i32* [[VLA]], i32** [[TMP29]], align 4
// CHECK40-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 3
// CHECK40-NEXT:    store i64 [[TMP7]], i64* [[TMP30]], align 4
// CHECK40-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK40-NEXT:    store i8* null, i8** [[TMP31]], align 4
// CHECK40-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [4 x i8*], [4 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [4 x i64], [4 x i64]* [[DOTOFFLOAD_SIZES]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP35:%.*]] = load i32, i32* [[N]], align 4
// CHECK40-NEXT:    store i32 [[TMP35]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK40-NEXT:    [[TMP36:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK40-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP36]], 0
// CHECK40-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK40-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK40-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK40-NEXT:    [[TMP37:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK40-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP37]], 1
// CHECK40-NEXT:    [[TMP38:%.*]] = zext i32 [[ADD]] to i64
// CHECK40-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2:[0-9]+]], i64 -1, i64 [[TMP38]])
// CHECK40-NEXT:    [[TMP39:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192.region_id, i32 4, i8** [[TMP32]], i8** [[TMP33]], i64* [[TMP34]], i64* getelementptr inbounds ([4 x i64], [4 x i64]* @.offload_maptypes, i32 0, i32 0), i8** null, i8** null, i32 0, i32 1)
// CHECK40-NEXT:    [[TMP40:%.*]] = icmp ne i32 [[TMP39]], 0
// CHECK40-NEXT:    br i1 [[TMP40]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK40:       omp_offload.failed:
// CHECK40-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192(i32 [[TMP3]], i32 [[TMP5]], i32 [[TMP0]], i32* [[VLA]]) #[[ATTR3:[0-9]+]]
// CHECK40-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK40:       omp_offload.cont:
// CHECK40-NEXT:    [[TMP41:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK40-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP41]])
// CHECK40-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK40-NEXT:    [[TMP42:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK40-NEXT:    call void @llvm.stackrestore(i8* [[TMP42]])
// CHECK40-NEXT:    [[TMP43:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK40-NEXT:    ret i32 [[TMP43]]
//
//
// CHECK40-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l192
// CHECK40-SAME: (i32 [[ARGC:%.*]], i32 [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK40-NEXT:    store i32 [[N]], i32* [[N_ADDR]], align 4
// CHECK40-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK40-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK40-NEXT:    [[TMP0:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK40-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK40-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK40-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK40-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK40-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK40-NEXT:    [[TMP3:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK40-NEXT:    [[TOBOOL1:%.*]] = trunc i8 [[TMP3]] to i1
// CHECK40-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__CASTED]] to i8*
// CHECK40-NEXT:    [[FROMBOOL2:%.*]] = zext i1 [[TOBOOL1]] to i8
// CHECK40-NEXT:    store i8 [[FROMBOOL2]], i8* [[CONV]], align 1
// CHECK40-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK40-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 4, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, i32*, i32, i32*, i32)* @.omp_outlined. to void (i32*, i32*, ...)*), i32* [[N_ADDR]], i32 [[TMP0]], i32* [[TMP1]], i32 [[TMP4]])
// CHECK40-NEXT:    ret void
//
//
// CHECK40-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK40-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], i32* nonnull align 4 dereferenceable(4) [[N:%.*]], i32 [[VLA:%.*]], i32* nonnull align 4 dereferenceable(4) [[A:%.*]], i32 [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR2]] {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[N_ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[VLA_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[A_ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK40-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK40-NEXT:    store i32* [[N]], i32** [[N_ADDR]], align 4
// CHECK40-NEXT:    store i32 [[VLA]], i32* [[VLA_ADDR]], align 4
// CHECK40-NEXT:    store i32* [[A]], i32** [[A_ADDR]], align 4
// CHECK40-NEXT:    store i32 [[DOTCAPTURE_EXPR_]], i32* [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK40-NEXT:    [[TMP0:%.*]] = load i32*, i32** [[N_ADDR]], align 4
// CHECK40-NEXT:    [[TMP1:%.*]] = load i32, i32* [[VLA_ADDR]], align 4
// CHECK40-NEXT:    [[TMP2:%.*]] = load i32*, i32** [[A_ADDR]], align 4
// CHECK40-NEXT:    [[CONV:%.*]] = bitcast i32* [[DOTCAPTURE_EXPR__ADDR]] to i8*
// CHECK40-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TMP0]], align 4
// CHECK40-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK40-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK40-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK40-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK40-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK40-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK40-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK40-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK40-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK40-NEXT:    br i1 [[CMP]], label [[OMP_PRECOND_THEN:%.*]], label [[OMP_PRECOND_END:%.*]]
// CHECK40:       omp.precond.then:
// CHECK40-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK40-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK40-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK40-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK40-NEXT:    [[TMP7:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK40-NEXT:    [[TMP8:%.*]] = load i32, i32* [[TMP7]], align 4
// CHECK40-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1:[0-9]+]], i32 [[TMP8]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK40-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK40-NEXT:    [[CMP5:%.*]] = icmp sgt i32 [[TMP9]], [[TMP10]]
// CHECK40-NEXT:    br i1 [[CMP5]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK40:       cond.true:
// CHECK40-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK40-NEXT:    br label [[COND_END:%.*]]
// CHECK40:       cond.false:
// CHECK40-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    br label [[COND_END]]
// CHECK40:       cond.end:
// CHECK40-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP11]], [[COND_TRUE]] ], [ [[TMP12]], [[COND_FALSE]] ]
// CHECK40-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK40-NEXT:    store i32 [[TMP13]], i32* [[DOTOMP_IV]], align 4
// CHECK40-NEXT:    [[TMP14:%.*]] = load i8, i8* [[CONV]], align 1
// CHECK40-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP14]] to i1
// CHECK40-NEXT:    br i1 [[TOBOOL]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK40:       omp_if.then:
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK40:       omp.inner.for.cond:
// CHECK40-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK40-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK40:       omp.inner.for.body:
// CHECK40-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK40-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK40-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP18]]
// CHECK40-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK40:       omp.body.continue:
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK40:       omp.inner.for.inc:
// CHECK40-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK40-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK40:       omp.inner.for.end:
// CHECK40-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK40:       omp_if.else:
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK40:       omp.inner.for.cond8:
// CHECK40-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK40-NEXT:    [[TMP21:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP20]], [[TMP21]]
// CHECK40-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK40:       omp.inner.for.body10:
// CHECK40-NEXT:    [[TMP22:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK40-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP22]], 1
// CHECK40-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK40-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK40-NEXT:    [[TMP23:%.*]] = load i32, i32* [[I4]], align 4
// CHECK40-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, i32* [[TMP2]], i32 [[TMP23]]
// CHECK40-NEXT:    store i32 0, i32* [[ARRAYIDX13]], align 4
// CHECK40-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK40:       omp.body.continue14:
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK40:       omp.inner.for.inc15:
// CHECK40-NEXT:    [[TMP24:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK40-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP24]], 1
// CHECK40-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK40:       omp.inner.for.end17:
// CHECK40-NEXT:    br label [[OMP_IF_END]]
// CHECK40:       omp_if.end:
// CHECK40-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK40:       omp.loop.exit:
// CHECK40-NEXT:    [[TMP25:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK40-NEXT:    [[TMP26:%.*]] = load i32, i32* [[TMP25]], align 4
// CHECK40-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP26]])
// CHECK40-NEXT:    [[TMP27:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK40-NEXT:    [[TMP28:%.*]] = icmp ne i32 [[TMP27]], 0
// CHECK40-NEXT:    br i1 [[TMP28]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK40:       .omp.final.then:
// CHECK40-NEXT:    [[TMP29:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK40-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[TMP29]], 0
// CHECK40-NEXT:    [[DIV19:%.*]] = sdiv i32 [[SUB18]], 1
// CHECK40-NEXT:    [[MUL20:%.*]] = mul nsw i32 [[DIV19]], 1
// CHECK40-NEXT:    [[ADD21:%.*]] = add nsw i32 0, [[MUL20]]
// CHECK40-NEXT:    store i32 [[ADD21]], i32* [[I4]], align 4
// CHECK40-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK40:       .omp.final.done:
// CHECK40-NEXT:    br label [[OMP_PRECOND_END]]
// CHECK40:       omp.precond.end:
// CHECK40-NEXT:    ret void
//
//
// CHECK40-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK40-SAME: (i32 [[ARGC:%.*]]) #[[ATTR4:[0-9]+]] comdat {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK40-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[TE_CASTED:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[TH_CASTED:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x i8*], align 4
// CHECK40-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x i8*], align 4
// CHECK40-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK40-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK40-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK40-NEXT:    [[TMP0:%.*]] = load i32, i32* [[TE]], align 4
// CHECK40-NEXT:    store i32 [[TMP0]], i32* [[TE_CASTED]], align 4
// CHECK40-NEXT:    [[TMP1:%.*]] = load i32, i32* [[TE_CASTED]], align 4
// CHECK40-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TH]], align 4
// CHECK40-NEXT:    store i32 [[TMP2]], i32* [[TH_CASTED]], align 4
// CHECK40-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_CASTED]], align 4
// CHECK40-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP5:%.*]] = bitcast i8** [[TMP4]] to i32*
// CHECK40-NEXT:    store i32 [[TMP1]], i32* [[TMP5]], align 4
// CHECK40-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP7:%.*]] = bitcast i8** [[TMP6]] to i32*
// CHECK40-NEXT:    store i32 [[TMP1]], i32* [[TMP7]], align 4
// CHECK40-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK40-NEXT:    store i8* null, i8** [[TMP8]], align 4
// CHECK40-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK40-NEXT:    [[TMP10:%.*]] = bitcast i8** [[TMP9]] to i32*
// CHECK40-NEXT:    store i32 [[TMP3]], i32* [[TMP10]], align 4
// CHECK40-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK40-NEXT:    [[TMP12:%.*]] = bitcast i8** [[TMP11]] to i32*
// CHECK40-NEXT:    store i32 [[TMP3]], i32* [[TMP12]], align 4
// CHECK40-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK40-NEXT:    store i8* null, i8** [[TMP13]], align 4
// CHECK40-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK40-NEXT:    [[TMP15:%.*]] = bitcast i8** [[TMP14]] to [10 x i32]**
// CHECK40-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP15]], align 4
// CHECK40-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK40-NEXT:    [[TMP17:%.*]] = bitcast i8** [[TMP16]] to [10 x i32]**
// CHECK40-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[TMP17]], align 4
// CHECK40-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK40-NEXT:    store i8* null, i8** [[TMP18]], align 4
// CHECK40-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [3 x i8*], [3 x i8*]* [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK40-NEXT:    [[TMP21:%.*]] = load i32, i32* [[TE]], align 4
// CHECK40-NEXT:    call void @__kmpc_push_target_tripcount_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i64 10)
// CHECK40-NEXT:    [[TMP22:%.*]] = call i32 @__tgt_target_teams_mapper(%struct.ident_t* @[[GLOB2]], i64 -1, i8* @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181.region_id, i32 3, i8** [[TMP19]], i8** [[TMP20]], i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_sizes, i32 0, i32 0), i64* getelementptr inbounds ([3 x i64], [3 x i64]* @.offload_maptypes.2, i32 0, i32 0), i8** null, i8** null, i32 [[TMP21]], i32 1)
// CHECK40-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK40-NEXT:    br i1 [[TMP23]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK40:       omp_offload.failed:
// CHECK40-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181(i32 [[TMP1]], i32 [[TMP3]], [10 x i32]* [[A]]) #[[ATTR3]]
// CHECK40-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK40:       omp_offload.cont:
// CHECK40-NEXT:    ret i32 0
//
//
// CHECK40-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiLi10EEiT__l181
// CHECK40-SAME: (i32 [[TE:%.*]], i32 [[TH:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    [[TE_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[TH_ADDR:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK40-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(%struct.ident_t* @[[GLOB2]])
// CHECK40-NEXT:    store i32 [[TE]], i32* [[TE_ADDR]], align 4
// CHECK40-NEXT:    store i32 [[TH]], i32* [[TH_ADDR]], align 4
// CHECK40-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK40-NEXT:    [[TMP1:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK40-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TE_ADDR]], align 4
// CHECK40-NEXT:    [[TMP3:%.*]] = load i32, i32* [[TH_ADDR]], align 4
// CHECK40-NEXT:    call void @__kmpc_push_num_teams(%struct.ident_t* @[[GLOB2]], i32 [[TMP0]], i32 [[TMP2]], i32 [[TMP3]])
// CHECK40-NEXT:    call void (%struct.ident_t*, i32, void (i32*, i32*, ...)*, ...) @__kmpc_fork_teams(%struct.ident_t* @[[GLOB2]], i32 1, void (i32*, i32*, ...)* bitcast (void (i32*, i32*, [10 x i32]*)* @.omp_outlined..1 to void (i32*, i32*, ...)*), [10 x i32]* [[TMP1]])
// CHECK40-NEXT:    ret void
//
//
// CHECK40-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK40-SAME: (i32* noalias [[DOTGLOBAL_TID_:%.*]], i32* noalias [[DOTBOUND_TID_:%.*]], [10 x i32]* nonnull align 4 dereferenceable(40) [[A:%.*]]) #[[ATTR2]] {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca i32*, align 4
// CHECK40-NEXT:    [[A_ADDR:%.*]] = alloca [10 x i32]*, align 4
// CHECK40-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK40-NEXT:    store i32* [[DOTGLOBAL_TID_]], i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK40-NEXT:    store i32* [[DOTBOUND_TID_]], i32** [[DOTBOUND_TID__ADDR]], align 4
// CHECK40-NEXT:    store [10 x i32]* [[A]], [10 x i32]** [[A_ADDR]], align 4
// CHECK40-NEXT:    [[TMP0:%.*]] = load [10 x i32]*, [10 x i32]** [[A_ADDR]], align 4
// CHECK40-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK40-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    store i32 1, i32* [[DOTOMP_STRIDE]], align 4
// CHECK40-NEXT:    store i32 0, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK40-NEXT:    [[TMP1:%.*]] = load i32*, i32** [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK40-NEXT:    [[TMP2:%.*]] = load i32, i32* [[TMP1]], align 4
// CHECK40-NEXT:    call void @__kmpc_for_static_init_4(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]], i32 92, i32* [[DOTOMP_IS_LAST]], i32* [[DOTOMP_LB]], i32* [[DOTOMP_UB]], i32* [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK40-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP3]], 9
// CHECK40-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK40:       cond.true:
// CHECK40-NEXT:    br label [[COND_END:%.*]]
// CHECK40:       cond.false:
// CHECK40-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    br label [[COND_END]]
// CHECK40:       cond.end:
// CHECK40-NEXT:    [[COND:%.*]] = phi i32 [ 9, [[COND_TRUE]] ], [ [[TMP4]], [[COND_FALSE]] ]
// CHECK40-NEXT:    store i32 [[COND]], i32* [[DOTOMP_UB]], align 4
// CHECK40-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK40-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_IV]], align 4
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK40:       omp.inner.for.cond:
// CHECK40-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[TMP6]], [[TMP7]]
// CHECK40-NEXT:    br i1 [[CMP1]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK40:       omp.inner.for.body:
// CHECK40-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], 1
// CHECK40-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK40-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    [[TMP9:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[TMP0]], i32 0, i32 [[TMP9]]
// CHECK40-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK40:       omp.body.continue:
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK40:       omp.inner.for.inc:
// CHECK40-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP10]], 1
// CHECK40-NEXT:    store i32 [[ADD2]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !14
// CHECK40-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK40:       omp.inner.for.end:
// CHECK40-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK40:       omp.loop.exit:
// CHECK40-NEXT:    call void @__kmpc_for_static_fini(%struct.ident_t* @[[GLOB1]], i32 [[TMP2]])
// CHECK40-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IS_LAST]], align 4
// CHECK40-NEXT:    [[TMP12:%.*]] = icmp ne i32 [[TMP11]], 0
// CHECK40-NEXT:    br i1 [[TMP12]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK40:       .omp.final.then:
// CHECK40-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK40-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK40:       .omp.final.done:
// CHECK40-NEXT:    ret void
//
//
// CHECK40-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK40-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK40-NEXT:  entry:
// CHECK40-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK40-NEXT:    ret void
//
//
// CHECK41-LABEL: define {{[^@]+}}@main
// CHECK41-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK41-NEXT:  entry:
// CHECK41-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK41-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK41-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK41-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK41-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK41-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK41-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK41-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK41-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK41-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK41-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK41-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK41-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK41-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK41-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK41-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK41-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK41-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK41-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK41-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK41-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK41-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK41-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK41-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK41-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK41-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK41-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK41:       simd.if.then:
// CHECK41-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK41-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK41-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK41:       omp.inner.for.cond:
// CHECK41-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK41-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK41:       omp.inner.for.body:
// CHECK41-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK41-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK41-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK41-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK41-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK41:       omp.body.continue:
// CHECK41-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK41:       omp.inner.for.inc:
// CHECK41-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK41-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK41-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK41:       omp.inner.for.end:
// CHECK41-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK41-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK41-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK41-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK41-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK41-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK41-NEXT:    br label [[SIMD_IF_END]]
// CHECK41:       simd.if.end:
// CHECK41-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK41-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP14]])
// CHECK41-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK41-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK41-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK41-NEXT:    [[TMP16:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK41-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK41-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK41-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK41-NEXT:  entry:
// CHECK41-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK41-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK41-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK41-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK41-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK41-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK41-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK41-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK41-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK41-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK41:       omp.inner.for.cond:
// CHECK41-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK41-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK41:       omp.inner.for.body:
// CHECK41-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK41-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK41-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP4]] to i64
// CHECK41-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK41-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK41:       omp.body.continue:
// CHECK41-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK41:       omp.inner.for.inc:
// CHECK41-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK41-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK41-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK41:       omp.inner.for.end:
// CHECK41-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK41-NEXT:    ret i32 0
//
//
// CHECK42-LABEL: define {{[^@]+}}@main
// CHECK42-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK42-NEXT:  entry:
// CHECK42-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK42-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK42-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK42-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK42-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK42-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK42-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK42-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK42-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK42-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK42-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK42-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK42-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK42-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK42-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK42-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK42-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK42-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK42-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK42-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK42-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK42-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK42-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK42-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK42-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK42-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK42-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK42:       simd.if.then:
// CHECK42-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK42-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK42-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK42:       omp.inner.for.cond:
// CHECK42-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP8]], [[TMP9]]
// CHECK42-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK42:       omp.inner.for.body:
// CHECK42-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK42-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK42-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    [[TMP11:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP11]] to i64
// CHECK42-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK42-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK42:       omp.body.continue:
// CHECK42-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK42:       omp.inner.for.inc:
// CHECK42-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK42-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK42-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK42:       omp.inner.for.end:
// CHECK42-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK42-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP13]], 0
// CHECK42-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK42-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK42-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK42-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK42-NEXT:    br label [[SIMD_IF_END]]
// CHECK42:       simd.if.end:
// CHECK42-NEXT:    [[TMP14:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK42-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP14]])
// CHECK42-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK42-NEXT:    [[TMP15:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK42-NEXT:    call void @llvm.stackrestore(i8* [[TMP15]])
// CHECK42-NEXT:    [[TMP16:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK42-NEXT:    ret i32 [[TMP16]]
//
//
// CHECK42-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK42-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK42-NEXT:  entry:
// CHECK42-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK42-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK42-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK42-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK42-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK42-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK42-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK42-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK42-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK42-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK42:       omp.inner.for.cond:
// CHECK42-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK42-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK42:       omp.inner.for.body:
// CHECK42-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK42-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK42-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP4]] to i64
// CHECK42-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK42-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK42:       omp.body.continue:
// CHECK42-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK42:       omp.inner.for.inc:
// CHECK42-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK42-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !6
// CHECK42-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK42:       omp.inner.for.end:
// CHECK42-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK42-NEXT:    ret i32 0
//
//
// CHECK43-LABEL: define {{[^@]+}}@main
// CHECK43-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK43-NEXT:  entry:
// CHECK43-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK43-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK43-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK43-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK43-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK43-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK43-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK43-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK43-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK43-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK43-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK43-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK43-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK43-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK43-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK43-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK43-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK43-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK43-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK43-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK43-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK43-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK43-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK43-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK43-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK43:       simd.if.then:
// CHECK43-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK43-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK43-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK43:       omp.inner.for.cond:
// CHECK43-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK43-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK43:       omp.inner.for.body:
// CHECK43-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK43-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK43-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP10]]
// CHECK43-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK43:       omp.body.continue:
// CHECK43-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK43:       omp.inner.for.inc:
// CHECK43-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK43-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK43-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK43:       omp.inner.for.end:
// CHECK43-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK43-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK43-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK43-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK43-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK43-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK43-NEXT:    br label [[SIMD_IF_END]]
// CHECK43:       simd.if.end:
// CHECK43-NEXT:    [[TMP13:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK43-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP13]])
// CHECK43-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK43-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK43-NEXT:    call void @llvm.stackrestore(i8* [[TMP14]])
// CHECK43-NEXT:    [[TMP15:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK43-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK43-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK43-SAME: (i32 [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK43-NEXT:  entry:
// CHECK43-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK43-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK43-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK43-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK43-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK43-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK43-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK43-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK43-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK43-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK43:       omp.inner.for.cond:
// CHECK43-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK43-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK43:       omp.inner.for.body:
// CHECK43-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK43-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK43-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i32 0, i32 [[TMP4]]
// CHECK43-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK43:       omp.body.continue:
// CHECK43-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK43:       omp.inner.for.inc:
// CHECK43-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK43-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK43-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK43:       omp.inner.for.end:
// CHECK43-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK43-NEXT:    ret i32 0
//
//
// CHECK44-LABEL: define {{[^@]+}}@main
// CHECK44-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK44-NEXT:  entry:
// CHECK44-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK44-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK44-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[I3:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK44-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK44-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK44-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK44-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK44-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK44-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK44-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK44-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK44-NEXT:    [[TMP2:%.*]] = load i32, i32* [[N]], align 4
// CHECK44-NEXT:    store i32 [[TMP2]], i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK44-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK44-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP3]], 0
// CHECK44-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK44-NEXT:    [[SUB2:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK44-NEXT:    store i32 [[SUB2]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK44-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK44-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK44-NEXT:    store i32 [[TMP4]], i32* [[DOTOMP_UB]], align 4
// CHECK44-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK44-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK44-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK44-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK44:       simd.if.then:
// CHECK44-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK44-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_IV]], align 4
// CHECK44-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK44:       omp.inner.for.cond:
// CHECK44-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    [[CMP4:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK44-NEXT:    br i1 [[CMP4]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK44:       omp.inner.for.body:
// CHECK44-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK44-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK44-NEXT:    store i32 [[ADD]], i32* [[I3]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    [[TMP10:%.*]] = load i32, i32* [[I3]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP10]]
// CHECK44-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK44:       omp.body.continue:
// CHECK44-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK44:       omp.inner.for.inc:
// CHECK44-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK44-NEXT:    store i32 [[ADD5]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK44-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK44:       omp.inner.for.end:
// CHECK44-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_]], align 4
// CHECK44-NEXT:    [[SUB6:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK44-NEXT:    [[DIV7:%.*]] = sdiv i32 [[SUB6]], 1
// CHECK44-NEXT:    [[MUL8:%.*]] = mul nsw i32 [[DIV7]], 1
// CHECK44-NEXT:    [[ADD9:%.*]] = add nsw i32 0, [[MUL8]]
// CHECK44-NEXT:    store i32 [[ADD9]], i32* [[I3]], align 4
// CHECK44-NEXT:    br label [[SIMD_IF_END]]
// CHECK44:       simd.if.end:
// CHECK44-NEXT:    [[TMP13:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK44-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP13]])
// CHECK44-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK44-NEXT:    [[TMP14:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK44-NEXT:    call void @llvm.stackrestore(i8* [[TMP14]])
// CHECK44-NEXT:    [[TMP15:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK44-NEXT:    ret i32 [[TMP15]]
//
//
// CHECK44-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK44-SAME: (i32 [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK44-NEXT:  entry:
// CHECK44-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK44-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK44-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK44-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK44-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK44-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK44-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK44-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK44-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK44-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK44:       omp.inner.for.cond:
// CHECK44-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK44-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK44:       omp.inner.for.body:
// CHECK44-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK44-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK44-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i32 0, i32 [[TMP4]]
// CHECK44-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK44:       omp.body.continue:
// CHECK44-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK44:       omp.inner.for.inc:
// CHECK44-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK44-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !7
// CHECK44-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK44:       omp.inner.for.end:
// CHECK44-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK44-NEXT:    ret i32 0
//
//
// CHECK45-LABEL: define {{[^@]+}}@main
// CHECK45-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK45-NEXT:  entry:
// CHECK45-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK45-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK45-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK45-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK45-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK45-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK45-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK45-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK45-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK45-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK45-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK45-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK45-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK45-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK45-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK45-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK45-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK45-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK45-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK45-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK45-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK45-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK45-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK45-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK45-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK45-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK45-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK45-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK45-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK45-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK45-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK45-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK45:       simd.if.then:
// CHECK45-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK45-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK45-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK45-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK45-NEXT:    br i1 [[TOBOOL5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK45:       omp_if.then:
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK45:       omp.inner.for.cond:
// CHECK45-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK45-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK45:       omp.inner.for.body:
// CHECK45-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK45-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK45-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK45-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK45-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK45:       omp.body.continue:
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK45:       omp.inner.for.inc:
// CHECK45-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK45-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK45:       omp.inner.for.end:
// CHECK45-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK45:       omp_if.else:
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK45:       omp.inner.for.cond8:
// CHECK45-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK45-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK45-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK45-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END18:%.*]]
// CHECK45:       omp.inner.for.body10:
// CHECK45-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK45-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK45-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK45-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK45-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4
// CHECK45-NEXT:    [[IDXPROM13:%.*]] = sext i32 [[TMP18]] to i64
// CHECK45-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM13]]
// CHECK45-NEXT:    store i32 0, i32* [[ARRAYIDX14]], align 4
// CHECK45-NEXT:    br label [[OMP_BODY_CONTINUE15:%.*]]
// CHECK45:       omp.body.continue15:
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_INC16:%.*]]
// CHECK45:       omp.inner.for.inc16:
// CHECK45-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK45-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK45-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK45:       omp.inner.for.end18:
// CHECK45-NEXT:    br label [[OMP_IF_END]]
// CHECK45:       omp_if.end:
// CHECK45-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK45-NEXT:    [[SUB19:%.*]] = sub nsw i32 [[TMP20]], 0
// CHECK45-NEXT:    [[DIV20:%.*]] = sdiv i32 [[SUB19]], 1
// CHECK45-NEXT:    [[MUL21:%.*]] = mul nsw i32 [[DIV20]], 1
// CHECK45-NEXT:    [[ADD22:%.*]] = add nsw i32 0, [[MUL21]]
// CHECK45-NEXT:    store i32 [[ADD22]], i32* [[I4]], align 4
// CHECK45-NEXT:    br label [[SIMD_IF_END]]
// CHECK45:       simd.if.end:
// CHECK45-NEXT:    [[TMP21:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK45-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP21]])
// CHECK45-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK45-NEXT:    [[TMP22:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK45-NEXT:    call void @llvm.stackrestore(i8* [[TMP22]])
// CHECK45-NEXT:    [[TMP23:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK45-NEXT:    ret i32 [[TMP23]]
//
//
// CHECK45-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK45-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK45-NEXT:  entry:
// CHECK45-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK45-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK45-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK45-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK45-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK45-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK45-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK45-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK45-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK45:       omp.inner.for.cond:
// CHECK45-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK45-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK45:       omp.inner.for.body:
// CHECK45-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK45-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK45-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP4]] to i64
// CHECK45-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK45-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK45:       omp.body.continue:
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK45:       omp.inner.for.inc:
// CHECK45-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK45-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK45-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK45:       omp.inner.for.end:
// CHECK45-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK45-NEXT:    ret i32 0
//
//
// CHECK46-LABEL: define {{[^@]+}}@main
// CHECK46-SAME: (i32 signext [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK46-NEXT:  entry:
// CHECK46-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 8
// CHECK46-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 8
// CHECK46-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK46-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK46-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK46-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK46-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 8
// CHECK46-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK46-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK46-NEXT:    [[TMP1:%.*]] = zext i32 [[TMP0]] to i64
// CHECK46-NEXT:    [[TMP2:%.*]] = call i8* @llvm.stacksave()
// CHECK46-NEXT:    store i8* [[TMP2]], i8** [[SAVED_STACK]], align 8
// CHECK46-NEXT:    [[VLA:%.*]] = alloca i32, i64 [[TMP1]], align 4
// CHECK46-NEXT:    store i64 [[TMP1]], i64* [[__VLA_EXPR0]], align 8
// CHECK46-NEXT:    [[TMP3:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK46-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK46-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK46-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK46-NEXT:    [[TMP4:%.*]] = load i32, i32* [[N]], align 4
// CHECK46-NEXT:    store i32 [[TMP4]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK46-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK46-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP5]], 0
// CHECK46-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK46-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK46-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK46-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK46-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK46-NEXT:    store i32 [[TMP6]], i32* [[DOTOMP_UB]], align 4
// CHECK46-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK46-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK46-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP7]]
// CHECK46-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK46:       simd.if.then:
// CHECK46-NEXT:    [[TMP8:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK46-NEXT:    store i32 [[TMP8]], i32* [[DOTOMP_IV]], align 4
// CHECK46-NEXT:    [[TMP9:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK46-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK46-NEXT:    br i1 [[TOBOOL5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK46:       omp_if.then:
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK46:       omp.inner.for.cond:
// CHECK46-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP10]], [[TMP11]]
// CHECK46-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK46:       omp.inner.for.body:
// CHECK46-NEXT:    [[TMP12:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP12]], 1
// CHECK46-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK46-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    [[TMP13:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP13]] to i64
// CHECK46-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM]]
// CHECK46-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK46:       omp.body.continue:
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK46:       omp.inner.for.inc:
// CHECK46-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP14]], 1
// CHECK46-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !2
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK46:       omp.inner.for.end:
// CHECK46-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK46:       omp_if.else:
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK46:       omp.inner.for.cond8:
// CHECK46-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK46-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK46-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK46-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END18:%.*]]
// CHECK46:       omp.inner.for.body10:
// CHECK46-NEXT:    [[TMP17:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK46-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK46-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK46-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK46-NEXT:    [[TMP18:%.*]] = load i32, i32* [[I4]], align 4
// CHECK46-NEXT:    [[IDXPROM13:%.*]] = sext i32 [[TMP18]] to i64
// CHECK46-NEXT:    [[ARRAYIDX14:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i64 [[IDXPROM13]]
// CHECK46-NEXT:    store i32 0, i32* [[ARRAYIDX14]], align 4
// CHECK46-NEXT:    br label [[OMP_BODY_CONTINUE15:%.*]]
// CHECK46:       omp.body.continue15:
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_INC16:%.*]]
// CHECK46:       omp.inner.for.inc16:
// CHECK46-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK46-NEXT:    [[ADD17:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK46-NEXT:    store i32 [[ADD17]], i32* [[DOTOMP_IV]], align 4
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK46:       omp.inner.for.end18:
// CHECK46-NEXT:    br label [[OMP_IF_END]]
// CHECK46:       omp_if.end:
// CHECK46-NEXT:    [[TMP20:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK46-NEXT:    [[SUB19:%.*]] = sub nsw i32 [[TMP20]], 0
// CHECK46-NEXT:    [[DIV20:%.*]] = sdiv i32 [[SUB19]], 1
// CHECK46-NEXT:    [[MUL21:%.*]] = mul nsw i32 [[DIV20]], 1
// CHECK46-NEXT:    [[ADD22:%.*]] = add nsw i32 0, [[MUL21]]
// CHECK46-NEXT:    store i32 [[ADD22]], i32* [[I4]], align 4
// CHECK46-NEXT:    br label [[SIMD_IF_END]]
// CHECK46:       simd.if.end:
// CHECK46-NEXT:    [[TMP21:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK46-NEXT:    [[CALL:%.*]] = call signext i32 @_Z5tmainIiLi10EEiT_(i32 signext [[TMP21]])
// CHECK46-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK46-NEXT:    [[TMP22:%.*]] = load i8*, i8** [[SAVED_STACK]], align 8
// CHECK46-NEXT:    call void @llvm.stackrestore(i8* [[TMP22]])
// CHECK46-NEXT:    [[TMP23:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK46-NEXT:    ret i32 [[TMP23]]
//
//
// CHECK46-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK46-SAME: (i32 signext [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK46-NEXT:  entry:
// CHECK46-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK46-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK46-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK46-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK46-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK46-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK46-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK46-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK46-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK46:       omp.inner.for.cond:
// CHECK46-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK46-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK46:       omp.inner.for.body:
// CHECK46-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK46-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK46-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP4]] to i64
// CHECK46-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i64 0, i64 [[IDXPROM]]
// CHECK46-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK46:       omp.body.continue:
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK46:       omp.inner.for.inc:
// CHECK46-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK46-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !8
// CHECK46-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK46:       omp.inner.for.end:
// CHECK46-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK46-NEXT:    ret i32 0
//
//
// CHECK47-LABEL: define {{[^@]+}}@main
// CHECK47-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK47-NEXT:  entry:
// CHECK47-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK47-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK47-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK47-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK47-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK47-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK47-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK47-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK47-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK47-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK47-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK47-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK47-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK47-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK47-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK47-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK47-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK47-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK47-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK47-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK47-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK47-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK47-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK47-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK47-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK47-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK47-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK47-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK47-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK47-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK47:       simd.if.then:
// CHECK47-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK47-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK47-NEXT:    [[TMP8:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK47-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP8]] to i1
// CHECK47-NEXT:    br i1 [[TOBOOL5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK47:       omp_if.then:
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK47:       omp.inner.for.cond:
// CHECK47-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK47-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK47:       omp.inner.for.body:
// CHECK47-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK47-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK47-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP12]]
// CHECK47-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK47:       omp.body.continue:
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK47:       omp.inner.for.inc:
// CHECK47-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK47-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK47:       omp.inner.for.end:
// CHECK47-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK47:       omp_if.else:
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK47:       omp.inner.for.cond8:
// CHECK47-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK47-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK47-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK47-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK47:       omp.inner.for.body10:
// CHECK47-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK47-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK47-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK47-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK47-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I4]], align 4
// CHECK47-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP17]]
// CHECK47-NEXT:    store i32 0, i32* [[ARRAYIDX13]], align 4
// CHECK47-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK47:       omp.body.continue14:
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK47:       omp.inner.for.inc15:
// CHECK47-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK47-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK47-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK47:       omp.inner.for.end17:
// CHECK47-NEXT:    br label [[OMP_IF_END]]
// CHECK47:       omp_if.end:
// CHECK47-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK47-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[TMP19]], 0
// CHECK47-NEXT:    [[DIV19:%.*]] = sdiv i32 [[SUB18]], 1
// CHECK47-NEXT:    [[MUL20:%.*]] = mul nsw i32 [[DIV19]], 1
// CHECK47-NEXT:    [[ADD21:%.*]] = add nsw i32 0, [[MUL20]]
// CHECK47-NEXT:    store i32 [[ADD21]], i32* [[I4]], align 4
// CHECK47-NEXT:    br label [[SIMD_IF_END]]
// CHECK47:       simd.if.end:
// CHECK47-NEXT:    [[TMP20:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK47-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP20]])
// CHECK47-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK47-NEXT:    [[TMP21:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK47-NEXT:    call void @llvm.stackrestore(i8* [[TMP21]])
// CHECK47-NEXT:    [[TMP22:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK47-NEXT:    ret i32 [[TMP22]]
//
//
// CHECK47-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK47-SAME: (i32 [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK47-NEXT:  entry:
// CHECK47-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK47-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK47-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK47-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK47-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK47-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK47-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK47-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK47-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK47:       omp.inner.for.cond:
// CHECK47-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK47-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK47:       omp.inner.for.body:
// CHECK47-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK47-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK47-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i32 0, i32 [[TMP4]]
// CHECK47-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK47:       omp.body.continue:
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK47:       omp.inner.for.inc:
// CHECK47-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK47-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK47-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK47:       omp.inner.for.end:
// CHECK47-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK47-NEXT:    ret i32 0
//
//
// CHECK48-LABEL: define {{[^@]+}}@main
// CHECK48-SAME: (i32 [[ARGC:%.*]], i8** [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK48-NEXT:  entry:
// CHECK48-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[ARGV_ADDR:%.*]] = alloca i8**, align 4
// CHECK48-NEXT:    [[N:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[SAVED_STACK:%.*]] = alloca i8*, align 4
// CHECK48-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK48-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[I4:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    store i32 0, i32* [[RETVAL]], align 4
// CHECK48-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK48-NEXT:    store i8** [[ARGV]], i8*** [[ARGV_ADDR]], align 4
// CHECK48-NEXT:    store i32 100, i32* [[N]], align 4
// CHECK48-NEXT:    [[TMP0:%.*]] = load i32, i32* [[N]], align 4
// CHECK48-NEXT:    [[TMP1:%.*]] = call i8* @llvm.stacksave()
// CHECK48-NEXT:    store i8* [[TMP1]], i8** [[SAVED_STACK]], align 4
// CHECK48-NEXT:    [[VLA:%.*]] = alloca i32, i32 [[TMP0]], align 4
// CHECK48-NEXT:    store i32 [[TMP0]], i32* [[__VLA_EXPR0]], align 4
// CHECK48-NEXT:    [[TMP2:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK48-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK48-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK48-NEXT:    store i8 [[FROMBOOL]], i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK48-NEXT:    [[TMP3:%.*]] = load i32, i32* [[N]], align 4
// CHECK48-NEXT:    store i32 [[TMP3]], i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK48-NEXT:    [[TMP4:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK48-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP4]], 0
// CHECK48-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK48-NEXT:    [[SUB3:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK48-NEXT:    store i32 [[SUB3]], i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK48-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK48-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_2]], align 4
// CHECK48-NEXT:    store i32 [[TMP5]], i32* [[DOTOMP_UB]], align 4
// CHECK48-NEXT:    store i32 0, i32* [[I]], align 4
// CHECK48-NEXT:    [[TMP6:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK48-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP6]]
// CHECK48-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK48:       simd.if.then:
// CHECK48-NEXT:    [[TMP7:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK48-NEXT:    store i32 [[TMP7]], i32* [[DOTOMP_IV]], align 4
// CHECK48-NEXT:    [[TMP8:%.*]] = load i8, i8* [[DOTCAPTURE_EXPR_]], align 1
// CHECK48-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP8]] to i1
// CHECK48-NEXT:    br i1 [[TOBOOL5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK48:       omp_if.then:
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK48:       omp.inner.for.cond:
// CHECK48-NEXT:    [[TMP9:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    [[TMP10:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    [[CMP6:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK48-NEXT:    br i1 [[CMP6]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK48:       omp.inner.for.body:
// CHECK48-NEXT:    [[TMP11:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK48-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK48-NEXT:    store i32 [[ADD]], i32* [[I4]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    [[TMP12:%.*]] = load i32, i32* [[I4]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP12]]
// CHECK48-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK48:       omp.body.continue:
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK48:       omp.inner.for.inc:
// CHECK48-NEXT:    [[TMP13:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP13]], 1
// CHECK48-NEXT:    store i32 [[ADD7]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !3
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK48:       omp.inner.for.end:
// CHECK48-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK48:       omp_if.else:
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_COND8:%.*]]
// CHECK48:       omp.inner.for.cond8:
// CHECK48-NEXT:    [[TMP14:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK48-NEXT:    [[TMP15:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4
// CHECK48-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP14]], [[TMP15]]
// CHECK48-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY10:%.*]], label [[OMP_INNER_FOR_END17:%.*]]
// CHECK48:       omp.inner.for.body10:
// CHECK48-NEXT:    [[TMP16:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK48-NEXT:    [[MUL11:%.*]] = mul nsw i32 [[TMP16]], 1
// CHECK48-NEXT:    [[ADD12:%.*]] = add nsw i32 0, [[MUL11]]
// CHECK48-NEXT:    store i32 [[ADD12]], i32* [[I4]], align 4
// CHECK48-NEXT:    [[TMP17:%.*]] = load i32, i32* [[I4]], align 4
// CHECK48-NEXT:    [[ARRAYIDX13:%.*]] = getelementptr inbounds i32, i32* [[VLA]], i32 [[TMP17]]
// CHECK48-NEXT:    store i32 0, i32* [[ARRAYIDX13]], align 4
// CHECK48-NEXT:    br label [[OMP_BODY_CONTINUE14:%.*]]
// CHECK48:       omp.body.continue14:
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_INC15:%.*]]
// CHECK48:       omp.inner.for.inc15:
// CHECK48-NEXT:    [[TMP18:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4
// CHECK48-NEXT:    [[ADD16:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK48-NEXT:    store i32 [[ADD16]], i32* [[DOTOMP_IV]], align 4
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_COND8]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK48:       omp.inner.for.end17:
// CHECK48-NEXT:    br label [[OMP_IF_END]]
// CHECK48:       omp_if.end:
// CHECK48-NEXT:    [[TMP19:%.*]] = load i32, i32* [[DOTCAPTURE_EXPR_1]], align 4
// CHECK48-NEXT:    [[SUB18:%.*]] = sub nsw i32 [[TMP19]], 0
// CHECK48-NEXT:    [[DIV19:%.*]] = sdiv i32 [[SUB18]], 1
// CHECK48-NEXT:    [[MUL20:%.*]] = mul nsw i32 [[DIV19]], 1
// CHECK48-NEXT:    [[ADD21:%.*]] = add nsw i32 0, [[MUL20]]
// CHECK48-NEXT:    store i32 [[ADD21]], i32* [[I4]], align 4
// CHECK48-NEXT:    br label [[SIMD_IF_END]]
// CHECK48:       simd.if.end:
// CHECK48-NEXT:    [[TMP20:%.*]] = load i32, i32* [[ARGC_ADDR]], align 4
// CHECK48-NEXT:    [[CALL:%.*]] = call i32 @_Z5tmainIiLi10EEiT_(i32 [[TMP20]])
// CHECK48-NEXT:    store i32 [[CALL]], i32* [[RETVAL]], align 4
// CHECK48-NEXT:    [[TMP21:%.*]] = load i8*, i8** [[SAVED_STACK]], align 4
// CHECK48-NEXT:    call void @llvm.stackrestore(i8* [[TMP21]])
// CHECK48-NEXT:    [[TMP22:%.*]] = load i32, i32* [[RETVAL]], align 4
// CHECK48-NEXT:    ret i32 [[TMP22]]
//
//
// CHECK48-LABEL: define {{[^@]+}}@_Z5tmainIiLi10EEiT_
// CHECK48-SAME: (i32 [[ARGC:%.*]]) #[[ATTR2:[0-9]+]] comdat {
// CHECK48-NEXT:  entry:
// CHECK48-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[A:%.*]] = alloca [10 x i32], align 4
// CHECK48-NEXT:    [[TE:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[TH:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK48-NEXT:    store i32 [[ARGC]], i32* [[ARGC_ADDR]], align 4
// CHECK48-NEXT:    store i32 0, i32* [[TE]], align 4
// CHECK48-NEXT:    store i32 128, i32* [[TH]], align 4
// CHECK48-NEXT:    store i32 0, i32* [[DOTOMP_LB]], align 4
// CHECK48-NEXT:    store i32 9, i32* [[DOTOMP_UB]], align 4
// CHECK48-NEXT:    [[TMP0:%.*]] = load i32, i32* [[DOTOMP_LB]], align 4
// CHECK48-NEXT:    store i32 [[TMP0]], i32* [[DOTOMP_IV]], align 4
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK48:       omp.inner.for.cond:
// CHECK48-NEXT:    [[TMP1:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    [[TMP2:%.*]] = load i32, i32* [[DOTOMP_UB]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP1]], [[TMP2]]
// CHECK48-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK48:       omp.inner.for.body:
// CHECK48-NEXT:    [[TMP3:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP3]], 1
// CHECK48-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK48-NEXT:    store i32 [[ADD]], i32* [[I]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    [[TMP4:%.*]] = load i32, i32* [[I]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [10 x i32], [10 x i32]* [[A]], i32 0, i32 [[TMP4]]
// CHECK48-NEXT:    store i32 0, i32* [[ARRAYIDX]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK48:       omp.body.continue:
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK48:       omp.inner.for.inc:
// CHECK48-NEXT:    [[TMP5:%.*]] = load i32, i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK48-NEXT:    store i32 [[ADD1]], i32* [[DOTOMP_IV]], align 4, !llvm.access.group !9
// CHECK48-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK48:       omp.inner.for.end:
// CHECK48-NEXT:    store i32 10, i32* [[I]], align 4
// CHECK48-NEXT:    ret i32 0
//
