// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// expected-no-diagnostics
#ifndef HEADER
#define HEADER
// Test host codegen.
// RUN: %clang_cc1 -DCK1 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -DCK1 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK3

// RUN: %clang_cc1 -DCK1 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK1 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK1 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
#ifdef CK1

int Gbla;
long long Gblb;
int &Gblc = Gbla;

int teams_argument_global_local(int a){
  int comp = 1;

  int la = 23;
  float lc = 25.0;

  #pragma omp target
  #pragma omp teams
  {
    ++comp;
  }

  #pragma omp target
  {{{
    #pragma omp teams
    {
      ++comp;
    }
  }}}


  #pragma omp target
  #pragma omp teams num_teams(la)
  {
    ++comp;
  }


  #pragma omp target
  #pragma omp teams thread_limit(la)
  {
    ++comp;
  }




  #pragma omp target
  #pragma omp teams num_teams(Gbla+a) thread_limit(Gblb+(long long)lc)
  {
    ++comp;
  }




  #pragma omp target
  #pragma omp teams num_teams(Gblc+1) thread_limit(Gblc+2)
  {
    comp += Gblc;
  }

  return comp;
}

#endif // CK1

// Test host codegen.
// RUN: %clang_cc1 -DCK2 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK9
// RUN: %clang_cc1 -DCK2 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK11
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK11

// RUN: %clang_cc1 -DCK2 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK2 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK2 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
#ifdef CK2

template <typename T>
struct SS{
  T a;
  float b;
};

SS<int> Gbla;
SS<long long> Gblb;

int teams_template_arg(void) {
  int comp = 1;

  SS<int> la;
  SS<long long> lb;




  #pragma omp target
  #pragma omp teams num_teams(Gbla.a) thread_limit((long long)la.b)
  {
    ++comp;
  }




  #pragma omp target
  #pragma omp teams num_teams((long long)lb.b) thread_limit(Gblb.a)
  {
    ++comp;
  }
  return comp;
}
#endif // CK2

// Test host codegen.
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK17
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK17
// RUN: %clang_cc1 -DCK3 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK19
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK19

// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK3 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK3 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
#ifdef CK3


template <typename T, int X, long long Y>
struct SS{
  T a;
  float b;

  int foo(void) {
    int comp = 1;



    #pragma omp target
    #pragma omp teams num_teams(a) thread_limit(X)
    {
      ++comp;
    }



    #pragma omp target
    #pragma omp teams num_teams(Y) thread_limit((int)b+X)
    {
      ++comp;
    }
    return comp;
  }
};

int teams_template_struct(void) {
  SS<int, 123, 456> V;
  return V.foo();

}
#endif // CK3

// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK25
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK25
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -DCK4 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK27
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK27

// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -DCK4 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -DCK4 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

#ifdef CK4


template <typename T>
int tmain(T argc) {
#pragma omp target
#pragma omp teams
  argc = 0;
  return 0;
}

int main (int argc, char **argv) {
#pragma omp target
#pragma omp teams
  argc = 0;
  return tmain(argv);
}




#endif // CK4

// Test target codegen - host bc file has to be created first.
// RUN: %clang_cc1 -DCK5 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -DCK5 -verify -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --check-prefix=CHECK33
// RUN: %clang_cc1 -DCK5 -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -DCK5 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK33
// RUN: %clang_cc1 -DCK5 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -DCK5 -verify -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --check-prefix=CHECK35
// RUN: %clang_cc1 -DCK5 -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -DCK5 -fopenmp -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK35

// RUN: %clang_cc1 -DCK5 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm-bc %s -o %t-ppc-host.bc
// RUN: %clang_cc1 -DCK5 -verify -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK5 -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -o %t %s
// RUN: %clang_cc1 -DCK5 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK5 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm-bc %s -o %t-x86-host.bc
// RUN: %clang_cc1 -DCK5 -verify -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK5 -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -o %t %s
// RUN: %clang_cc1 -DCK5 -fopenmp-simd -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -fopenmp-is-device -fopenmp-host-ir-file-path %t-x86-host.bc -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"

// expected-no-diagnostics
#ifdef CK5


template <typename T>
int tmain(T argc) {
  int a = 10;
  int b = 5;
#pragma omp target
#pragma omp teams num_teams(a) thread_limit(b)
  {
  argc = 0;
  }
  return 0;
}

int main (int argc, char **argv) {
  int a = 20;
  int b = 5;
#pragma omp target
#pragma omp teams num_teams(a) thread_limit(b)
  {
  argc = 0;
  }
  return tmain(argv);
}



#endif // CK5

// Test host codegen.
// RUN: %clang_cc1 -DCK6 -verify -fopenmp -fopenmp-version=50 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK41
// RUN: %clang_cc1 -DCK6 -fopenmp -fopenmp-version=50 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK6 -fopenmp-version=50 -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK41
// RUN: %clang_cc1 -DCK6 -verify -fopenmp -fopenmp-version=50 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK43
// RUN: %clang_cc1 -DCK6 -fopenmp -fopenmp-version=50 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK6 -fopenmp -fopenmp-version=50 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK43

// RUN: %clang_cc1 -DCK6 -verify -fopenmp-version=50 -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK6 -fopenmp-simd -fopenmp-version=50 -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK6 -fopenmp-simd -fopenmp-version=50 -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK6 -verify -fopenmp-simd -fopenmp-version=50 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -DCK6 -fopenmp-simd -fopenmp-version=50 -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DCK6 -fopenmp-simd -fopenmp-version=50 -x c++ -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
#ifdef CK6

void foo() {
#pragma omp teams
  ;
}

#endif // CK6

#endif
// CHECK1-LABEL: define {{[^@]+}}@_Z27teams_argument_global_locali
// CHECK1-SAME: (i32 noundef signext [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[COMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[LA:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[LC:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[COMP_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK1-NEXT:    [[COMP_CASTED1:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS2:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS3:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS4:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[KERNEL_ARGS5:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK1-NEXT:    [[LA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_CASTED8:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[KERNEL_ARGS12:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK1-NEXT:    [[LA_CASTED15:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_CASTED16:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS17:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS18:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS19:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[KERNEL_ARGS20:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK1-NEXT:    [[GBLA_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GBLB_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_CASTED23:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS24:%.*]] = alloca [5 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS25:%.*]] = alloca [5 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS26:%.*]] = alloca [5 x ptr], align 8
// CHECK1-NEXT:    [[KERNEL_ARGS28:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[GBLC_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_CASTED31:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_BASEPTRS32:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_PTRS33:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[DOTOFFLOAD_MAPPERS34:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[_TMP35:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP37:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[KERNEL_ARGS39:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 23, ptr [[LA]], align 4
// CHECK1-NEXT:    store float 2.500000e+01, ptr [[LC]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[COMP_CASTED]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, ptr [[COMP_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP1]], ptr [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP1]], ptr [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK1-NEXT:    store i32 2, ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK1-NEXT:    store i32 1, ptr [[TMP8]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP5]], ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP6]], ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes, ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK1-NEXT:    store i64 0, ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK1-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP17]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK1-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP18]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK1-NEXT:    store i32 0, ptr [[TMP19]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 0, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l31.region_id, ptr [[KERNEL_ARGS]])
// CHECK1-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK1-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK1:       omp_offload.failed:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l31(i64 [[TMP1]]) #[[ATTR2:[0-9]+]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK1:       omp_offload.cont:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 [[TMP22]], ptr [[COMP_CASTED1]], align 4
// CHECK1-NEXT:    [[TMP23:%.*]] = load i64, ptr [[COMP_CASTED1]], align 8
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP23]], ptr [[TMP24]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP23]], ptr [[TMP25]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP26]], align 8
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 0
// CHECK1-NEXT:    store i32 2, ptr [[TMP29]], align 4
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 1
// CHECK1-NEXT:    store i32 1, ptr [[TMP30]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP27]], ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP28]], ptr [[TMP32]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.2, ptr [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.3, ptr [[TMP34]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP35]], align 8
// CHECK1-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP36]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP37]], align 8
// CHECK1-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 9
// CHECK1-NEXT:    store i64 0, ptr [[TMP38]], align 8
// CHECK1-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 10
// CHECK1-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP39]], align 4
// CHECK1-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 11
// CHECK1-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP40]], align 4
// CHECK1-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 12
// CHECK1-NEXT:    store i32 0, ptr [[TMP41]], align 4
// CHECK1-NEXT:    [[TMP42:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 0, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l37.region_id, ptr [[KERNEL_ARGS5]])
// CHECK1-NEXT:    [[TMP43:%.*]] = icmp ne i32 [[TMP42]], 0
// CHECK1-NEXT:    br i1 [[TMP43]], label [[OMP_OFFLOAD_FAILED6:%.*]], label [[OMP_OFFLOAD_CONT7:%.*]]
// CHECK1:       omp_offload.failed6:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l37(i64 [[TMP23]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT7]]
// CHECK1:       omp_offload.cont7:
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, ptr [[LA]], align 4
// CHECK1-NEXT:    store i32 [[TMP44]], ptr [[LA_CASTED]], align 4
// CHECK1-NEXT:    [[TMP45:%.*]] = load i64, ptr [[LA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP46:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 [[TMP46]], ptr [[COMP_CASTED8]], align 4
// CHECK1-NEXT:    [[TMP47:%.*]] = load i64, ptr [[COMP_CASTED8]], align 8
// CHECK1-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP45]], ptr [[TMP48]], align 8
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP45]], ptr [[TMP49]], align 8
// CHECK1-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP50]], align 8
// CHECK1-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP47]], ptr [[TMP51]], align 8
// CHECK1-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS10]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP47]], ptr [[TMP52]], align 8
// CHECK1-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS11]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP53]], align 8
// CHECK1-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP56:%.*]] = load i32, ptr [[LA]], align 4
// CHECK1-NEXT:    [[TMP57:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP56]], 0
// CHECK1-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 0
// CHECK1-NEXT:    store i32 2, ptr [[TMP58]], align 4
// CHECK1-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 1
// CHECK1-NEXT:    store i32 2, ptr [[TMP59]], align 4
// CHECK1-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP54]], ptr [[TMP60]], align 8
// CHECK1-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP55]], ptr [[TMP61]], align 8
// CHECK1-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.5, ptr [[TMP62]], align 8
// CHECK1-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.6, ptr [[TMP63]], align 8
// CHECK1-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP64]], align 8
// CHECK1-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP65]], align 8
// CHECK1-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP66]], align 8
// CHECK1-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 9
// CHECK1-NEXT:    store i64 0, ptr [[TMP67]], align 8
// CHECK1-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 10
// CHECK1-NEXT:    store [3 x i32] [[TMP57]], ptr [[TMP68]], align 4
// CHECK1-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 11
// CHECK1-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP69]], align 4
// CHECK1-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 12
// CHECK1-NEXT:    store i32 0, ptr [[TMP70]], align 4
// CHECK1-NEXT:    [[TMP71:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[TMP56]], i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l46.region_id, ptr [[KERNEL_ARGS12]])
// CHECK1-NEXT:    [[TMP72:%.*]] = icmp ne i32 [[TMP71]], 0
// CHECK1-NEXT:    br i1 [[TMP72]], label [[OMP_OFFLOAD_FAILED13:%.*]], label [[OMP_OFFLOAD_CONT14:%.*]]
// CHECK1:       omp_offload.failed13:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l46(i64 [[TMP45]], i64 [[TMP47]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT14]]
// CHECK1:       omp_offload.cont14:
// CHECK1-NEXT:    [[TMP73:%.*]] = load i32, ptr [[LA]], align 4
// CHECK1-NEXT:    store i32 [[TMP73]], ptr [[LA_CASTED15]], align 4
// CHECK1-NEXT:    [[TMP74:%.*]] = load i64, ptr [[LA_CASTED15]], align 8
// CHECK1-NEXT:    [[TMP75:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 [[TMP75]], ptr [[COMP_CASTED16]], align 4
// CHECK1-NEXT:    [[TMP76:%.*]] = load i64, ptr [[COMP_CASTED16]], align 8
// CHECK1-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP74]], ptr [[TMP77]], align 8
// CHECK1-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP74]], ptr [[TMP78]], align 8
// CHECK1-NEXT:    [[TMP79:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS19]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP79]], align 8
// CHECK1-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP76]], ptr [[TMP80]], align 8
// CHECK1-NEXT:    [[TMP81:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS18]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP76]], ptr [[TMP81]], align 8
// CHECK1-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS19]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP82]], align 8
// CHECK1-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP85:%.*]] = load i32, ptr [[LA]], align 4
// CHECK1-NEXT:    [[TMP86:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP85]], 0
// CHECK1-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 0
// CHECK1-NEXT:    store i32 2, ptr [[TMP87]], align 4
// CHECK1-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 1
// CHECK1-NEXT:    store i32 2, ptr [[TMP88]], align 4
// CHECK1-NEXT:    [[TMP89:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP83]], ptr [[TMP89]], align 8
// CHECK1-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP84]], ptr [[TMP90]], align 8
// CHECK1-NEXT:    [[TMP91:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.8, ptr [[TMP91]], align 8
// CHECK1-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.9, ptr [[TMP92]], align 8
// CHECK1-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP93]], align 8
// CHECK1-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP94]], align 8
// CHECK1-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP95]], align 8
// CHECK1-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 9
// CHECK1-NEXT:    store i64 0, ptr [[TMP96]], align 8
// CHECK1-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 10
// CHECK1-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP97]], align 4
// CHECK1-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 11
// CHECK1-NEXT:    store [3 x i32] [[TMP86]], ptr [[TMP98]], align 4
// CHECK1-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 12
// CHECK1-NEXT:    store i32 0, ptr [[TMP99]], align 4
// CHECK1-NEXT:    [[TMP100:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 0, i32 [[TMP85]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l53.region_id, ptr [[KERNEL_ARGS20]])
// CHECK1-NEXT:    [[TMP101:%.*]] = icmp ne i32 [[TMP100]], 0
// CHECK1-NEXT:    br i1 [[TMP101]], label [[OMP_OFFLOAD_FAILED21:%.*]], label [[OMP_OFFLOAD_CONT22:%.*]]
// CHECK1:       omp_offload.failed21:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l53(i64 [[TMP74]], i64 [[TMP76]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT22]]
// CHECK1:       omp_offload.cont22:
// CHECK1-NEXT:    [[TMP102:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    store i32 [[TMP102]], ptr [[GBLA_CASTED]], align 4
// CHECK1-NEXT:    [[TMP103:%.*]] = load i64, ptr [[GBLA_CASTED]], align 8
// CHECK1-NEXT:    [[TMP104:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP104]], ptr [[A_CASTED]], align 4
// CHECK1-NEXT:    [[TMP105:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP106:%.*]] = load i64, ptr @Gblb, align 8
// CHECK1-NEXT:    store i64 [[TMP106]], ptr [[GBLB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP107:%.*]] = load i64, ptr [[GBLB_CASTED]], align 8
// CHECK1-NEXT:    [[TMP108:%.*]] = load float, ptr [[LC]], align 4
// CHECK1-NEXT:    store float [[TMP108]], ptr [[LC_CASTED]], align 4
// CHECK1-NEXT:    [[TMP109:%.*]] = load i64, ptr [[LC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP110:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 [[TMP110]], ptr [[COMP_CASTED23]], align 4
// CHECK1-NEXT:    [[TMP111:%.*]] = load i64, ptr [[COMP_CASTED23]], align 8
// CHECK1-NEXT:    [[TMP112:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP103]], ptr [[TMP112]], align 8
// CHECK1-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP103]], ptr [[TMP113]], align 8
// CHECK1-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP114]], align 8
// CHECK1-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP105]], ptr [[TMP115]], align 8
// CHECK1-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP105]], ptr [[TMP116]], align 8
// CHECK1-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP117]], align 8
// CHECK1-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP107]], ptr [[TMP118]], align 8
// CHECK1-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 2
// CHECK1-NEXT:    store i64 [[TMP107]], ptr [[TMP119]], align 8
// CHECK1-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i64 0, i64 2
// CHECK1-NEXT:    store ptr null, ptr [[TMP120]], align 8
// CHECK1-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP109]], ptr [[TMP121]], align 8
// CHECK1-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 3
// CHECK1-NEXT:    store i64 [[TMP109]], ptr [[TMP122]], align 8
// CHECK1-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i64 0, i64 3
// CHECK1-NEXT:    store ptr null, ptr [[TMP123]], align 8
// CHECK1-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP111]], ptr [[TMP124]], align 8
// CHECK1-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 4
// CHECK1-NEXT:    store i64 [[TMP111]], ptr [[TMP125]], align 8
// CHECK1-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i64 0, i64 4
// CHECK1-NEXT:    store ptr null, ptr [[TMP126]], align 8
// CHECK1-NEXT:    [[TMP127:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP128:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP129:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    [[TMP130:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP129]], [[TMP130]]
// CHECK1-NEXT:    [[TMP131:%.*]] = load i64, ptr @Gblb, align 8
// CHECK1-NEXT:    [[TMP132:%.*]] = load float, ptr [[LC]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP132]] to i64
// CHECK1-NEXT:    [[ADD27:%.*]] = add nsw i64 [[TMP131]], [[CONV]]
// CHECK1-NEXT:    [[TMP133:%.*]] = trunc i64 [[ADD27]] to i32
// CHECK1-NEXT:    [[TMP134:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD]], 0
// CHECK1-NEXT:    [[TMP135:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP133]], 0
// CHECK1-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 0
// CHECK1-NEXT:    store i32 2, ptr [[TMP136]], align 4
// CHECK1-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 1
// CHECK1-NEXT:    store i32 5, ptr [[TMP137]], align 4
// CHECK1-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP127]], ptr [[TMP138]], align 8
// CHECK1-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP128]], ptr [[TMP139]], align 8
// CHECK1-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.11, ptr [[TMP140]], align 8
// CHECK1-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.12, ptr [[TMP141]], align 8
// CHECK1-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP142]], align 8
// CHECK1-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP143]], align 8
// CHECK1-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP144]], align 8
// CHECK1-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 9
// CHECK1-NEXT:    store i64 0, ptr [[TMP145]], align 8
// CHECK1-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 10
// CHECK1-NEXT:    store [3 x i32] [[TMP134]], ptr [[TMP146]], align 4
// CHECK1-NEXT:    [[TMP147:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 11
// CHECK1-NEXT:    store [3 x i32] [[TMP135]], ptr [[TMP147]], align 4
// CHECK1-NEXT:    [[TMP148:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 12
// CHECK1-NEXT:    store i32 0, ptr [[TMP148]], align 4
// CHECK1-NEXT:    [[TMP149:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[ADD]], i32 [[TMP133]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l62.region_id, ptr [[KERNEL_ARGS28]])
// CHECK1-NEXT:    [[TMP150:%.*]] = icmp ne i32 [[TMP149]], 0
// CHECK1-NEXT:    br i1 [[TMP150]], label [[OMP_OFFLOAD_FAILED29:%.*]], label [[OMP_OFFLOAD_CONT30:%.*]]
// CHECK1:       omp_offload.failed29:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l62(i64 [[TMP103]], i64 [[TMP105]], i64 [[TMP107]], i64 [[TMP109]], i64 [[TMP111]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT30]]
// CHECK1:       omp_offload.cont30:
// CHECK1-NEXT:    [[TMP151:%.*]] = load ptr, ptr @Gblc, align 8
// CHECK1-NEXT:    store ptr [[TMP151]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP152:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    store i32 [[TMP152]], ptr [[GBLC_CASTED]], align 4
// CHECK1-NEXT:    [[TMP153:%.*]] = load i64, ptr [[GBLC_CASTED]], align 8
// CHECK1-NEXT:    [[TMP154:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    store i32 [[TMP154]], ptr [[COMP_CASTED31]], align 4
// CHECK1-NEXT:    [[TMP155:%.*]] = load i64, ptr [[COMP_CASTED31]], align 8
// CHECK1-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS32]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP153]], ptr [[TMP156]], align 8
// CHECK1-NEXT:    [[TMP157:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS33]], i32 0, i32 0
// CHECK1-NEXT:    store i64 [[TMP153]], ptr [[TMP157]], align 8
// CHECK1-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS34]], i64 0, i64 0
// CHECK1-NEXT:    store ptr null, ptr [[TMP158]], align 8
// CHECK1-NEXT:    [[TMP159:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS32]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP155]], ptr [[TMP159]], align 8
// CHECK1-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS33]], i32 0, i32 1
// CHECK1-NEXT:    store i64 [[TMP155]], ptr [[TMP160]], align 8
// CHECK1-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS34]], i64 0, i64 1
// CHECK1-NEXT:    store ptr null, ptr [[TMP161]], align 8
// CHECK1-NEXT:    [[TMP162:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS32]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP163:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS33]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP164:%.*]] = load ptr, ptr @Gblc, align 8
// CHECK1-NEXT:    store ptr [[TMP164]], ptr [[_TMP35]], align 8
// CHECK1-NEXT:    [[TMP165:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    [[ADD36:%.*]] = add nsw i32 [[TMP165]], 1
// CHECK1-NEXT:    [[TMP166:%.*]] = load ptr, ptr @Gblc, align 8
// CHECK1-NEXT:    store ptr [[TMP166]], ptr [[_TMP37]], align 8
// CHECK1-NEXT:    [[TMP167:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    [[ADD38:%.*]] = add nsw i32 [[TMP167]], 2
// CHECK1-NEXT:    [[TMP168:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD36]], 0
// CHECK1-NEXT:    [[TMP169:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD38]], 0
// CHECK1-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 0
// CHECK1-NEXT:    store i32 2, ptr [[TMP170]], align 4
// CHECK1-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 1
// CHECK1-NEXT:    store i32 2, ptr [[TMP171]], align 4
// CHECK1-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP162]], ptr [[TMP172]], align 8
// CHECK1-NEXT:    [[TMP173:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[TMP163]], ptr [[TMP173]], align 8
// CHECK1-NEXT:    [[TMP174:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 4
// CHECK1-NEXT:    store ptr @.offload_sizes.14, ptr [[TMP174]], align 8
// CHECK1-NEXT:    [[TMP175:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 5
// CHECK1-NEXT:    store ptr @.offload_maptypes.15, ptr [[TMP175]], align 8
// CHECK1-NEXT:    [[TMP176:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 6
// CHECK1-NEXT:    store ptr null, ptr [[TMP176]], align 8
// CHECK1-NEXT:    [[TMP177:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 7
// CHECK1-NEXT:    store ptr null, ptr [[TMP177]], align 8
// CHECK1-NEXT:    [[TMP178:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 8
// CHECK1-NEXT:    store i64 0, ptr [[TMP178]], align 8
// CHECK1-NEXT:    [[TMP179:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 9
// CHECK1-NEXT:    store i64 0, ptr [[TMP179]], align 8
// CHECK1-NEXT:    [[TMP180:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 10
// CHECK1-NEXT:    store [3 x i32] [[TMP168]], ptr [[TMP180]], align 4
// CHECK1-NEXT:    [[TMP181:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 11
// CHECK1-NEXT:    store [3 x i32] [[TMP169]], ptr [[TMP181]], align 4
// CHECK1-NEXT:    [[TMP182:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 12
// CHECK1-NEXT:    store i32 0, ptr [[TMP182]], align 4
// CHECK1-NEXT:    [[TMP183:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[ADD36]], i32 [[ADD38]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l71.region_id, ptr [[KERNEL_ARGS39]])
// CHECK1-NEXT:    [[TMP184:%.*]] = icmp ne i32 [[TMP183]], 0
// CHECK1-NEXT:    br i1 [[TMP184]], label [[OMP_OFFLOAD_FAILED40:%.*]], label [[OMP_OFFLOAD_CONT41:%.*]]
// CHECK1:       omp_offload.failed40:
// CHECK1-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l71(i64 [[TMP153]], i64 [[TMP155]]) #[[ATTR2]]
// CHECK1-NEXT:    br label [[OMP_OFFLOAD_CONT41]]
// CHECK1:       omp_offload.cont41:
// CHECK1-NEXT:    [[TMP185:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK1-NEXT:    ret i32 [[TMP185]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l31
// CHECK1-SAME: (i64 noundef [[COMP:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[COMP_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l37
// CHECK1-SAME: (i64 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[COMP_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l46
// CHECK1-SAME: (i64 noundef [[LA:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[LA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[LA]], ptr [[LA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[LA_ADDR]], align 4
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP1]], i32 0)
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..4, ptr [[COMP_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l53
// CHECK1-SAME: (i64 noundef [[LA:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[LA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[LA]], ptr [[LA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[LA_ADDR]], align 4
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 0, i32 [[TMP1]])
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..7, ptr [[COMP_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l62
// CHECK1-SAME: (i64 noundef [[GBLA:%.*]], i64 noundef [[A:%.*]], i64 noundef [[GBLB:%.*]], i64 noundef [[LC:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[GBLA_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[GBLB_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[LC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[GBLA]], ptr [[GBLA_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[GBLB]], ptr [[GBLB_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[LC]], ptr [[LC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[GBLA_ADDR]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP2]]
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, ptr [[GBLB_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load float, ptr [[LC_ADDR]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i64
// CHECK1-NEXT:    [[ADD1:%.*]] = add nsw i64 [[TMP3]], [[CONV]]
// CHECK1-NEXT:    [[TMP5:%.*]] = trunc i64 [[ADD1]] to i32
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[ADD]], i32 [[TMP5]])
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..10, ptr [[COMP_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l71
// CHECK1-SAME: (i64 noundef [[GBLC:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[GBLC_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i64 [[GBLC]], ptr [[GBLC_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[GBLC_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP2]], 2
// CHECK1-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[ADD]], i32 [[ADD1]])
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 2, ptr @.omp_outlined..13, ptr [[COMP_ADDR]], ptr [[TMP3]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..13
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[GBLC:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[GBLC_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[GBLC]], ptr [[GBLC_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GBLC_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr @Gbla, align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP3]], [[TMP2]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[TMP0]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z27teams_argument_global_locali
// CHECK3-SAME: (i32 noundef [[A:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LA:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LC:%.*]] = alloca float, align 4
// CHECK3-NEXT:    [[COMP_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [1 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [1 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [1 x ptr], align 4
// CHECK3-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK3-NEXT:    [[COMP_CASTED1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS2:%.*]] = alloca [1 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS3:%.*]] = alloca [1 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS4:%.*]] = alloca [1 x ptr], align 4
// CHECK3-NEXT:    [[KERNEL_ARGS5:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK3-NEXT:    [[LA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_CASTED8:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS9:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS10:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS11:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[KERNEL_ARGS12:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK3-NEXT:    [[LA_CASTED15:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_CASTED16:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS17:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS18:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS19:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[KERNEL_ARGS20:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK3-NEXT:    [[GBLA_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[LC_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_CASTED23:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS24:%.*]] = alloca [5 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS25:%.*]] = alloca [5 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS26:%.*]] = alloca [5 x ptr], align 4
// CHECK3-NEXT:    [[KERNEL_ARGS28:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[GBLC_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_CASTED31:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_BASEPTRS32:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_PTRS33:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[DOTOFFLOAD_MAPPERS34:%.*]] = alloca [2 x ptr], align 4
// CHECK3-NEXT:    [[_TMP35:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[_TMP37:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[KERNEL_ARGS39:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 1, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 23, ptr [[LA]], align 4
// CHECK3-NEXT:    store float 2.500000e+01, ptr [[LC]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[COMP_CASTED]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[COMP_CASTED]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP1]], ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP1]], ptr [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK3-NEXT:    store i32 2, ptr [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK3-NEXT:    store i32 1, ptr [[TMP8]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP5]], ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP6]], ptr [[TMP10]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes, ptr [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes, ptr [[TMP12]], align 4
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP13]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP15]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK3-NEXT:    store i64 0, ptr [[TMP16]], align 8
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK3-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP17]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK3-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP18]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK3-NEXT:    store i32 0, ptr [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 0, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l31.region_id, ptr [[KERNEL_ARGS]])
// CHECK3-NEXT:    [[TMP21:%.*]] = icmp ne i32 [[TMP20]], 0
// CHECK3-NEXT:    br i1 [[TMP21]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK3:       omp_offload.failed:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l31(i32 [[TMP1]]) #[[ATTR2:[0-9]+]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK3:       omp_offload.cont:
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 [[TMP22]], ptr [[COMP_CASTED1]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[COMP_CASTED1]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP23]], ptr [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP23]], ptr [[TMP25]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP26]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 0
// CHECK3-NEXT:    store i32 2, ptr [[TMP29]], align 4
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 1
// CHECK3-NEXT:    store i32 1, ptr [[TMP30]], align 4
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP27]], ptr [[TMP31]], align 4
// CHECK3-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP28]], ptr [[TMP32]], align 4
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.2, ptr [[TMP33]], align 4
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.3, ptr [[TMP34]], align 4
// CHECK3-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP35]], align 4
// CHECK3-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP36]], align 4
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP37]], align 8
// CHECK3-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 9
// CHECK3-NEXT:    store i64 0, ptr [[TMP38]], align 8
// CHECK3-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 10
// CHECK3-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP39]], align 4
// CHECK3-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 11
// CHECK3-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP40]], align 4
// CHECK3-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS5]], i32 0, i32 12
// CHECK3-NEXT:    store i32 0, ptr [[TMP41]], align 4
// CHECK3-NEXT:    [[TMP42:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 0, i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l37.region_id, ptr [[KERNEL_ARGS5]])
// CHECK3-NEXT:    [[TMP43:%.*]] = icmp ne i32 [[TMP42]], 0
// CHECK3-NEXT:    br i1 [[TMP43]], label [[OMP_OFFLOAD_FAILED6:%.*]], label [[OMP_OFFLOAD_CONT7:%.*]]
// CHECK3:       omp_offload.failed6:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l37(i32 [[TMP23]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT7]]
// CHECK3:       omp_offload.cont7:
// CHECK3-NEXT:    [[TMP44:%.*]] = load i32, ptr [[LA]], align 4
// CHECK3-NEXT:    store i32 [[TMP44]], ptr [[LA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP45:%.*]] = load i32, ptr [[LA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP46:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 [[TMP46]], ptr [[COMP_CASTED8]], align 4
// CHECK3-NEXT:    [[TMP47:%.*]] = load i32, ptr [[COMP_CASTED8]], align 4
// CHECK3-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP45]], ptr [[TMP48]], align 4
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP45]], ptr [[TMP49]], align 4
// CHECK3-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS11]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP50]], align 4
// CHECK3-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP47]], ptr [[TMP51]], align 4
// CHECK3-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS10]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP47]], ptr [[TMP52]], align 4
// CHECK3-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS11]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP53]], align 4
// CHECK3-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS9]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS10]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP56:%.*]] = load i32, ptr [[LA]], align 4
// CHECK3-NEXT:    [[TMP57:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP56]], 0
// CHECK3-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 0
// CHECK3-NEXT:    store i32 2, ptr [[TMP58]], align 4
// CHECK3-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 1
// CHECK3-NEXT:    store i32 2, ptr [[TMP59]], align 4
// CHECK3-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP54]], ptr [[TMP60]], align 4
// CHECK3-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP55]], ptr [[TMP61]], align 4
// CHECK3-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.5, ptr [[TMP62]], align 4
// CHECK3-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.6, ptr [[TMP63]], align 4
// CHECK3-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP64]], align 4
// CHECK3-NEXT:    [[TMP65:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP65]], align 4
// CHECK3-NEXT:    [[TMP66:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP66]], align 8
// CHECK3-NEXT:    [[TMP67:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 9
// CHECK3-NEXT:    store i64 0, ptr [[TMP67]], align 8
// CHECK3-NEXT:    [[TMP68:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 10
// CHECK3-NEXT:    store [3 x i32] [[TMP57]], ptr [[TMP68]], align 4
// CHECK3-NEXT:    [[TMP69:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 11
// CHECK3-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP69]], align 4
// CHECK3-NEXT:    [[TMP70:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS12]], i32 0, i32 12
// CHECK3-NEXT:    store i32 0, ptr [[TMP70]], align 4
// CHECK3-NEXT:    [[TMP71:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[TMP56]], i32 0, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l46.region_id, ptr [[KERNEL_ARGS12]])
// CHECK3-NEXT:    [[TMP72:%.*]] = icmp ne i32 [[TMP71]], 0
// CHECK3-NEXT:    br i1 [[TMP72]], label [[OMP_OFFLOAD_FAILED13:%.*]], label [[OMP_OFFLOAD_CONT14:%.*]]
// CHECK3:       omp_offload.failed13:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l46(i32 [[TMP45]], i32 [[TMP47]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT14]]
// CHECK3:       omp_offload.cont14:
// CHECK3-NEXT:    [[TMP73:%.*]] = load i32, ptr [[LA]], align 4
// CHECK3-NEXT:    store i32 [[TMP73]], ptr [[LA_CASTED15]], align 4
// CHECK3-NEXT:    [[TMP74:%.*]] = load i32, ptr [[LA_CASTED15]], align 4
// CHECK3-NEXT:    [[TMP75:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 [[TMP75]], ptr [[COMP_CASTED16]], align 4
// CHECK3-NEXT:    [[TMP76:%.*]] = load i32, ptr [[COMP_CASTED16]], align 4
// CHECK3-NEXT:    [[TMP77:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP74]], ptr [[TMP77]], align 4
// CHECK3-NEXT:    [[TMP78:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP74]], ptr [[TMP78]], align 4
// CHECK3-NEXT:    [[TMP79:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP79]], align 4
// CHECK3-NEXT:    [[TMP80:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP76]], ptr [[TMP80]], align 4
// CHECK3-NEXT:    [[TMP81:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS18]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP76]], ptr [[TMP81]], align 4
// CHECK3-NEXT:    [[TMP82:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS19]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP82]], align 4
// CHECK3-NEXT:    [[TMP83:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS17]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP84:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS18]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP85:%.*]] = load i32, ptr [[LA]], align 4
// CHECK3-NEXT:    [[TMP86:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP85]], 0
// CHECK3-NEXT:    [[TMP87:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 0
// CHECK3-NEXT:    store i32 2, ptr [[TMP87]], align 4
// CHECK3-NEXT:    [[TMP88:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 1
// CHECK3-NEXT:    store i32 2, ptr [[TMP88]], align 4
// CHECK3-NEXT:    [[TMP89:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP83]], ptr [[TMP89]], align 4
// CHECK3-NEXT:    [[TMP90:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP84]], ptr [[TMP90]], align 4
// CHECK3-NEXT:    [[TMP91:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.8, ptr [[TMP91]], align 4
// CHECK3-NEXT:    [[TMP92:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.9, ptr [[TMP92]], align 4
// CHECK3-NEXT:    [[TMP93:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP93]], align 4
// CHECK3-NEXT:    [[TMP94:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP94]], align 4
// CHECK3-NEXT:    [[TMP95:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP95]], align 8
// CHECK3-NEXT:    [[TMP96:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 9
// CHECK3-NEXT:    store i64 0, ptr [[TMP96]], align 8
// CHECK3-NEXT:    [[TMP97:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 10
// CHECK3-NEXT:    store [3 x i32] zeroinitializer, ptr [[TMP97]], align 4
// CHECK3-NEXT:    [[TMP98:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 11
// CHECK3-NEXT:    store [3 x i32] [[TMP86]], ptr [[TMP98]], align 4
// CHECK3-NEXT:    [[TMP99:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS20]], i32 0, i32 12
// CHECK3-NEXT:    store i32 0, ptr [[TMP99]], align 4
// CHECK3-NEXT:    [[TMP100:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 0, i32 [[TMP85]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l53.region_id, ptr [[KERNEL_ARGS20]])
// CHECK3-NEXT:    [[TMP101:%.*]] = icmp ne i32 [[TMP100]], 0
// CHECK3-NEXT:    br i1 [[TMP101]], label [[OMP_OFFLOAD_FAILED21:%.*]], label [[OMP_OFFLOAD_CONT22:%.*]]
// CHECK3:       omp_offload.failed21:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l53(i32 [[TMP74]], i32 [[TMP76]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT22]]
// CHECK3:       omp_offload.cont22:
// CHECK3-NEXT:    [[TMP102:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    store i32 [[TMP102]], ptr [[GBLA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP103:%.*]] = load i32, ptr [[GBLA_CASTED]], align 4
// CHECK3-NEXT:    [[TMP104:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP104]], ptr [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP105:%.*]] = load i32, ptr [[A_CASTED]], align 4
// CHECK3-NEXT:    [[TMP106:%.*]] = load float, ptr [[LC]], align 4
// CHECK3-NEXT:    store float [[TMP106]], ptr [[LC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP107:%.*]] = load i32, ptr [[LC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP108:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 [[TMP108]], ptr [[COMP_CASTED23]], align 4
// CHECK3-NEXT:    [[TMP109:%.*]] = load i32, ptr [[COMP_CASTED23]], align 4
// CHECK3-NEXT:    [[TMP110:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP103]], ptr [[TMP110]], align 4
// CHECK3-NEXT:    [[TMP111:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP103]], ptr [[TMP111]], align 4
// CHECK3-NEXT:    [[TMP112:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP112]], align 4
// CHECK3-NEXT:    [[TMP113:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP105]], ptr [[TMP113]], align 4
// CHECK3-NEXT:    [[TMP114:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP105]], ptr [[TMP114]], align 4
// CHECK3-NEXT:    [[TMP115:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP115]], align 4
// CHECK3-NEXT:    [[TMP116:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 2
// CHECK3-NEXT:    store ptr @Gblb, ptr [[TMP116]], align 4
// CHECK3-NEXT:    [[TMP117:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 2
// CHECK3-NEXT:    store ptr @Gblb, ptr [[TMP117]], align 4
// CHECK3-NEXT:    [[TMP118:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i32 0, i32 2
// CHECK3-NEXT:    store ptr null, ptr [[TMP118]], align 4
// CHECK3-NEXT:    [[TMP119:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 3
// CHECK3-NEXT:    store i32 [[TMP107]], ptr [[TMP119]], align 4
// CHECK3-NEXT:    [[TMP120:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 3
// CHECK3-NEXT:    store i32 [[TMP107]], ptr [[TMP120]], align 4
// CHECK3-NEXT:    [[TMP121:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i32 0, i32 3
// CHECK3-NEXT:    store ptr null, ptr [[TMP121]], align 4
// CHECK3-NEXT:    [[TMP122:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP109]], ptr [[TMP122]], align 4
// CHECK3-NEXT:    [[TMP123:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP109]], ptr [[TMP123]], align 4
// CHECK3-NEXT:    [[TMP124:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS26]], i32 0, i32 4
// CHECK3-NEXT:    store ptr null, ptr [[TMP124]], align 4
// CHECK3-NEXT:    [[TMP125:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS24]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP126:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS25]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP127:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    [[TMP128:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP127]], [[TMP128]]
// CHECK3-NEXT:    [[TMP129:%.*]] = load i64, ptr @Gblb, align 8
// CHECK3-NEXT:    [[TMP130:%.*]] = load float, ptr [[LC]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = fptosi float [[TMP130]] to i64
// CHECK3-NEXT:    [[ADD27:%.*]] = add nsw i64 [[TMP129]], [[CONV]]
// CHECK3-NEXT:    [[TMP131:%.*]] = trunc i64 [[ADD27]] to i32
// CHECK3-NEXT:    [[TMP132:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD]], 0
// CHECK3-NEXT:    [[TMP133:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP131]], 0
// CHECK3-NEXT:    [[TMP134:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 0
// CHECK3-NEXT:    store i32 2, ptr [[TMP134]], align 4
// CHECK3-NEXT:    [[TMP135:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 1
// CHECK3-NEXT:    store i32 5, ptr [[TMP135]], align 4
// CHECK3-NEXT:    [[TMP136:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP125]], ptr [[TMP136]], align 4
// CHECK3-NEXT:    [[TMP137:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP126]], ptr [[TMP137]], align 4
// CHECK3-NEXT:    [[TMP138:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.11, ptr [[TMP138]], align 4
// CHECK3-NEXT:    [[TMP139:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.12, ptr [[TMP139]], align 4
// CHECK3-NEXT:    [[TMP140:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP140]], align 4
// CHECK3-NEXT:    [[TMP141:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP141]], align 4
// CHECK3-NEXT:    [[TMP142:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP142]], align 8
// CHECK3-NEXT:    [[TMP143:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 9
// CHECK3-NEXT:    store i64 0, ptr [[TMP143]], align 8
// CHECK3-NEXT:    [[TMP144:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 10
// CHECK3-NEXT:    store [3 x i32] [[TMP132]], ptr [[TMP144]], align 4
// CHECK3-NEXT:    [[TMP145:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 11
// CHECK3-NEXT:    store [3 x i32] [[TMP133]], ptr [[TMP145]], align 4
// CHECK3-NEXT:    [[TMP146:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS28]], i32 0, i32 12
// CHECK3-NEXT:    store i32 0, ptr [[TMP146]], align 4
// CHECK3-NEXT:    [[TMP147:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[ADD]], i32 [[TMP131]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l62.region_id, ptr [[KERNEL_ARGS28]])
// CHECK3-NEXT:    [[TMP148:%.*]] = icmp ne i32 [[TMP147]], 0
// CHECK3-NEXT:    br i1 [[TMP148]], label [[OMP_OFFLOAD_FAILED29:%.*]], label [[OMP_OFFLOAD_CONT30:%.*]]
// CHECK3:       omp_offload.failed29:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l62(i32 [[TMP103]], i32 [[TMP105]], ptr @Gblb, i32 [[TMP107]], i32 [[TMP109]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT30]]
// CHECK3:       omp_offload.cont30:
// CHECK3-NEXT:    [[TMP149:%.*]] = load ptr, ptr @Gblc, align 4
// CHECK3-NEXT:    store ptr [[TMP149]], ptr [[TMP]], align 4
// CHECK3-NEXT:    [[TMP150:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    store i32 [[TMP150]], ptr [[GBLC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP151:%.*]] = load i32, ptr [[GBLC_CASTED]], align 4
// CHECK3-NEXT:    [[TMP152:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    store i32 [[TMP152]], ptr [[COMP_CASTED31]], align 4
// CHECK3-NEXT:    [[TMP153:%.*]] = load i32, ptr [[COMP_CASTED31]], align 4
// CHECK3-NEXT:    [[TMP154:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS32]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP151]], ptr [[TMP154]], align 4
// CHECK3-NEXT:    [[TMP155:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS33]], i32 0, i32 0
// CHECK3-NEXT:    store i32 [[TMP151]], ptr [[TMP155]], align 4
// CHECK3-NEXT:    [[TMP156:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS34]], i32 0, i32 0
// CHECK3-NEXT:    store ptr null, ptr [[TMP156]], align 4
// CHECK3-NEXT:    [[TMP157:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS32]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP153]], ptr [[TMP157]], align 4
// CHECK3-NEXT:    [[TMP158:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS33]], i32 0, i32 1
// CHECK3-NEXT:    store i32 [[TMP153]], ptr [[TMP158]], align 4
// CHECK3-NEXT:    [[TMP159:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS34]], i32 0, i32 1
// CHECK3-NEXT:    store ptr null, ptr [[TMP159]], align 4
// CHECK3-NEXT:    [[TMP160:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS32]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP161:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS33]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP162:%.*]] = load ptr, ptr @Gblc, align 4
// CHECK3-NEXT:    store ptr [[TMP162]], ptr [[_TMP35]], align 4
// CHECK3-NEXT:    [[TMP163:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    [[ADD36:%.*]] = add nsw i32 [[TMP163]], 1
// CHECK3-NEXT:    [[TMP164:%.*]] = load ptr, ptr @Gblc, align 4
// CHECK3-NEXT:    store ptr [[TMP164]], ptr [[_TMP37]], align 4
// CHECK3-NEXT:    [[TMP165:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    [[ADD38:%.*]] = add nsw i32 [[TMP165]], 2
// CHECK3-NEXT:    [[TMP166:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD36]], 0
// CHECK3-NEXT:    [[TMP167:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD38]], 0
// CHECK3-NEXT:    [[TMP168:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 0
// CHECK3-NEXT:    store i32 2, ptr [[TMP168]], align 4
// CHECK3-NEXT:    [[TMP169:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 1
// CHECK3-NEXT:    store i32 2, ptr [[TMP169]], align 4
// CHECK3-NEXT:    [[TMP170:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP160]], ptr [[TMP170]], align 4
// CHECK3-NEXT:    [[TMP171:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[TMP161]], ptr [[TMP171]], align 4
// CHECK3-NEXT:    [[TMP172:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 4
// CHECK3-NEXT:    store ptr @.offload_sizes.14, ptr [[TMP172]], align 4
// CHECK3-NEXT:    [[TMP173:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 5
// CHECK3-NEXT:    store ptr @.offload_maptypes.15, ptr [[TMP173]], align 4
// CHECK3-NEXT:    [[TMP174:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 6
// CHECK3-NEXT:    store ptr null, ptr [[TMP174]], align 4
// CHECK3-NEXT:    [[TMP175:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 7
// CHECK3-NEXT:    store ptr null, ptr [[TMP175]], align 4
// CHECK3-NEXT:    [[TMP176:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 8
// CHECK3-NEXT:    store i64 0, ptr [[TMP176]], align 8
// CHECK3-NEXT:    [[TMP177:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 9
// CHECK3-NEXT:    store i64 0, ptr [[TMP177]], align 8
// CHECK3-NEXT:    [[TMP178:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 10
// CHECK3-NEXT:    store [3 x i32] [[TMP166]], ptr [[TMP178]], align 4
// CHECK3-NEXT:    [[TMP179:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 11
// CHECK3-NEXT:    store [3 x i32] [[TMP167]], ptr [[TMP179]], align 4
// CHECK3-NEXT:    [[TMP180:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS39]], i32 0, i32 12
// CHECK3-NEXT:    store i32 0, ptr [[TMP180]], align 4
// CHECK3-NEXT:    [[TMP181:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[ADD36]], i32 [[ADD38]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l71.region_id, ptr [[KERNEL_ARGS39]])
// CHECK3-NEXT:    [[TMP182:%.*]] = icmp ne i32 [[TMP181]], 0
// CHECK3-NEXT:    br i1 [[TMP182]], label [[OMP_OFFLOAD_FAILED40:%.*]], label [[OMP_OFFLOAD_CONT41:%.*]]
// CHECK3:       omp_offload.failed40:
// CHECK3-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l71(i32 [[TMP151]], i32 [[TMP153]]) #[[ATTR2]]
// CHECK3-NEXT:    br label [[OMP_OFFLOAD_CONT41]]
// CHECK3:       omp_offload.cont41:
// CHECK3-NEXT:    [[TMP183:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK3-NEXT:    ret i32 [[TMP183]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l31
// CHECK3-SAME: (i32 noundef [[COMP:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[COMP_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l37
// CHECK3-SAME: (i32 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[COMP_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l46
// CHECK3-SAME: (i32 noundef [[LA:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[LA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[LA]], ptr [[LA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[LA_ADDR]], align 4
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP1]], i32 0)
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..4, ptr [[COMP_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..4
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l53
// CHECK3-SAME: (i32 noundef [[LA:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[LA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[LA]], ptr [[LA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[LA_ADDR]], align 4
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 0, i32 [[TMP1]])
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..7, ptr [[COMP_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..7
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l62
// CHECK3-SAME: (i32 noundef [[GBLA:%.*]], i32 noundef [[A:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[GBLB:%.*]], i32 noundef [[LC:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[GBLA_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GBLB_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[LC_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[GBLB1:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[GBLA]], ptr [[GBLA_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GBLB]], ptr [[GBLB_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[LC]], ptr [[LC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GBLB_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 8
// CHECK3-NEXT:    store i64 [[TMP2]], ptr [[GBLB1]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, ptr [[GBLA_ADDR]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP3]], [[TMP4]]
// CHECK3-NEXT:    [[TMP5:%.*]] = load i64, ptr [[GBLB1]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load float, ptr [[LC_ADDR]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i64
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i64 [[TMP5]], [[CONV]]
// CHECK3-NEXT:    [[TMP7:%.*]] = trunc i64 [[ADD2]] to i32
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[ADD]], i32 [[TMP7]])
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..10, ptr [[COMP_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..10
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z27teams_argument_global_locali_l71
// CHECK3-SAME: (i32 noundef [[GBLC:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[GBLC_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK3-NEXT:    store i32 [[GBLC]], ptr [[GBLC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GBLC_ADDR]], ptr [[TMP]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    [[ADD1:%.*]] = add nsw i32 [[TMP2]], 2
// CHECK3-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[ADD]], i32 [[ADD1]])
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 2, ptr @.omp_outlined..13, ptr [[COMP_ADDR]], ptr [[TMP3]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..13
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[GBLC:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[GBLC_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[GBLC]], ptr [[GBLC_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GBLC_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr @Gbla, align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP3]], [[TMP2]]
// CHECK3-NEXT:    store i32 [[ADD]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@_Z18teams_template_argv
// CHECK9-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[COMP:%.*]] = alloca i32, align 4
// CHECK9-NEXT:    [[LA:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK9-NEXT:    [[LB:%.*]] = alloca [[STRUCT_SS_0:%.*]], align 8
// CHECK9-NEXT:    [[COMP_CASTED:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x ptr], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x ptr], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x ptr], align 8
// CHECK9-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK9-NEXT:    [[COMP_CASTED1:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_BASEPTRS2:%.*]] = alloca [3 x ptr], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_PTRS3:%.*]] = alloca [3 x ptr], align 8
// CHECK9-NEXT:    [[DOTOFFLOAD_MAPPERS4:%.*]] = alloca [3 x ptr], align 8
// CHECK9-NEXT:    [[KERNEL_ARGS7:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK9-NEXT:    store i32 1, ptr [[COMP]], align 4
// CHECK9-NEXT:    [[TMP0:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK9-NEXT:    store i32 [[TMP0]], ptr [[COMP_CASTED]], align 4
// CHECK9-NEXT:    [[TMP1:%.*]] = load i64, ptr [[COMP_CASTED]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    store ptr @Gbla, ptr [[TMP2]], align 8
// CHECK9-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    store ptr @Gbla, ptr [[TMP3]], align 8
// CHECK9-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK9-NEXT:    store ptr null, ptr [[TMP4]], align 8
// CHECK9-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK9-NEXT:    store ptr [[LA]], ptr [[TMP5]], align 8
// CHECK9-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK9-NEXT:    store ptr [[LA]], ptr [[TMP6]], align 8
// CHECK9-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK9-NEXT:    store ptr null, ptr [[TMP7]], align 8
// CHECK9-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK9-NEXT:    store i64 [[TMP1]], ptr [[TMP8]], align 8
// CHECK9-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK9-NEXT:    store i64 [[TMP1]], ptr [[TMP9]], align 8
// CHECK9-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK9-NEXT:    store ptr null, ptr [[TMP10]], align 8
// CHECK9-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP13:%.*]] = load i32, ptr @Gbla, align 4
// CHECK9-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[LA]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP14:%.*]] = load float, ptr [[B]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = fptosi float [[TMP14]] to i64
// CHECK9-NEXT:    [[TMP15:%.*]] = trunc i64 [[CONV]] to i32
// CHECK9-NEXT:    [[TMP16:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP13]], 0
// CHECK9-NEXT:    [[TMP17:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP15]], 0
// CHECK9-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK9-NEXT:    store i32 2, ptr [[TMP18]], align 4
// CHECK9-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK9-NEXT:    store i32 3, ptr [[TMP19]], align 4
// CHECK9-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK9-NEXT:    store ptr [[TMP11]], ptr [[TMP20]], align 8
// CHECK9-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK9-NEXT:    store ptr [[TMP12]], ptr [[TMP21]], align 8
// CHECK9-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK9-NEXT:    store ptr @.offload_sizes, ptr [[TMP22]], align 8
// CHECK9-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK9-NEXT:    store ptr @.offload_maptypes, ptr [[TMP23]], align 8
// CHECK9-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK9-NEXT:    store ptr null, ptr [[TMP24]], align 8
// CHECK9-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK9-NEXT:    store ptr null, ptr [[TMP25]], align 8
// CHECK9-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK9-NEXT:    store i64 0, ptr [[TMP26]], align 8
// CHECK9-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK9-NEXT:    store i64 0, ptr [[TMP27]], align 8
// CHECK9-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK9-NEXT:    store [3 x i32] [[TMP16]], ptr [[TMP28]], align 4
// CHECK9-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK9-NEXT:    store [3 x i32] [[TMP17]], ptr [[TMP29]], align 4
// CHECK9-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK9-NEXT:    store i32 0, ptr [[TMP30]], align 4
// CHECK9-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 [[TMP13]], i32 [[TMP15]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l116.region_id, ptr [[KERNEL_ARGS]])
// CHECK9-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK9-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK9:       omp_offload.failed:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l116(ptr @Gbla, ptr [[LA]], i64 [[TMP1]]) #[[ATTR2:[0-9]+]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK9:       omp_offload.cont:
// CHECK9-NEXT:    [[TMP33:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK9-NEXT:    store i32 [[TMP33]], ptr [[COMP_CASTED1]], align 4
// CHECK9-NEXT:    [[TMP34:%.*]] = load i64, ptr [[COMP_CASTED1]], align 8
// CHECK9-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK9-NEXT:    store ptr [[LB]], ptr [[TMP35]], align 8
// CHECK9-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK9-NEXT:    store ptr [[LB]], ptr [[TMP36]], align 8
// CHECK9-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i64 0, i64 0
// CHECK9-NEXT:    store ptr null, ptr [[TMP37]], align 8
// CHECK9-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 1
// CHECK9-NEXT:    store ptr @Gblb, ptr [[TMP38]], align 8
// CHECK9-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 1
// CHECK9-NEXT:    store ptr @Gblb, ptr [[TMP39]], align 8
// CHECK9-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i64 0, i64 1
// CHECK9-NEXT:    store ptr null, ptr [[TMP40]], align 8
// CHECK9-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 2
// CHECK9-NEXT:    store i64 [[TMP34]], ptr [[TMP41]], align 8
// CHECK9-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 2
// CHECK9-NEXT:    store i64 [[TMP34]], ptr [[TMP42]], align 8
// CHECK9-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i64 0, i64 2
// CHECK9-NEXT:    store ptr null, ptr [[TMP43]], align 8
// CHECK9-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK9-NEXT:    [[B5:%.*]] = getelementptr inbounds [[STRUCT_SS_0]], ptr [[LB]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP46:%.*]] = load float, ptr [[B5]], align 8
// CHECK9-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP46]] to i64
// CHECK9-NEXT:    [[TMP47:%.*]] = trunc i64 [[CONV6]] to i32
// CHECK9-NEXT:    [[TMP48:%.*]] = load i64, ptr @Gblb, align 8
// CHECK9-NEXT:    [[TMP49:%.*]] = trunc i64 [[TMP48]] to i32
// CHECK9-NEXT:    [[TMP50:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP47]], 0
// CHECK9-NEXT:    [[TMP51:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP49]], 0
// CHECK9-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 0
// CHECK9-NEXT:    store i32 2, ptr [[TMP52]], align 4
// CHECK9-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 1
// CHECK9-NEXT:    store i32 3, ptr [[TMP53]], align 4
// CHECK9-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 2
// CHECK9-NEXT:    store ptr [[TMP44]], ptr [[TMP54]], align 8
// CHECK9-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 3
// CHECK9-NEXT:    store ptr [[TMP45]], ptr [[TMP55]], align 8
// CHECK9-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 4
// CHECK9-NEXT:    store ptr @.offload_sizes.2, ptr [[TMP56]], align 8
// CHECK9-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 5
// CHECK9-NEXT:    store ptr @.offload_maptypes.3, ptr [[TMP57]], align 8
// CHECK9-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 6
// CHECK9-NEXT:    store ptr null, ptr [[TMP58]], align 8
// CHECK9-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 7
// CHECK9-NEXT:    store ptr null, ptr [[TMP59]], align 8
// CHECK9-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 8
// CHECK9-NEXT:    store i64 0, ptr [[TMP60]], align 8
// CHECK9-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 9
// CHECK9-NEXT:    store i64 0, ptr [[TMP61]], align 8
// CHECK9-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 10
// CHECK9-NEXT:    store [3 x i32] [[TMP50]], ptr [[TMP62]], align 4
// CHECK9-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 11
// CHECK9-NEXT:    store [3 x i32] [[TMP51]], ptr [[TMP63]], align 4
// CHECK9-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 12
// CHECK9-NEXT:    store i32 0, ptr [[TMP64]], align 4
// CHECK9-NEXT:    [[TMP65:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[TMP47]], i32 [[TMP49]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l125.region_id, ptr [[KERNEL_ARGS7]])
// CHECK9-NEXT:    [[TMP66:%.*]] = icmp ne i32 [[TMP65]], 0
// CHECK9-NEXT:    br i1 [[TMP66]], label [[OMP_OFFLOAD_FAILED8:%.*]], label [[OMP_OFFLOAD_CONT9:%.*]]
// CHECK9:       omp_offload.failed8:
// CHECK9-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l125(ptr [[LB]], ptr @Gblb, i64 [[TMP34]]) #[[ATTR2]]
// CHECK9-NEXT:    br label [[OMP_OFFLOAD_CONT9]]
// CHECK9:       omp_offload.cont9:
// CHECK9-NEXT:    [[TMP67:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK9-NEXT:    ret i32 [[TMP67]]
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l116
// CHECK9-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[GBLA:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[LA:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[GBLA_ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[LA_ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK9-NEXT:    store ptr [[GBLA]], ptr [[GBLA_ADDR]], align 8
// CHECK9-NEXT:    store ptr [[LA]], ptr [[LA_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GBLA_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[LA_ADDR]], align 8
// CHECK9-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A]], align 4
// CHECK9-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[TMP2]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP4:%.*]] = load float, ptr [[B]], align 4
// CHECK9-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i64
// CHECK9-NEXT:    [[TMP5:%.*]] = trunc i64 [[CONV]] to i32
// CHECK9-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP3]], i32 [[TMP5]])
// CHECK9-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[COMP_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK9-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK9-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK9-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l125
// CHECK9-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[LB:%.*]], ptr noundef nonnull align 8 dereferenceable(16) [[GBLB:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[LB_ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[GBLB_ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK9-NEXT:    store ptr [[LB]], ptr [[LB_ADDR]], align 8
// CHECK9-NEXT:    store ptr [[GBLB]], ptr [[GBLB_ADDR]], align 8
// CHECK9-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[LB_ADDR]], align 8
// CHECK9-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[GBLB_ADDR]], align 8
// CHECK9-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS_0:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK9-NEXT:    [[TMP3:%.*]] = load float, ptr [[B]], align 8
// CHECK9-NEXT:    [[CONV:%.*]] = fptosi float [[TMP3]] to i64
// CHECK9-NEXT:    [[TMP4:%.*]] = trunc i64 [[CONV]] to i32
// CHECK9-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS_0]], ptr [[TMP2]], i32 0, i32 0
// CHECK9-NEXT:    [[TMP5:%.*]] = load i64, ptr [[A]], align 8
// CHECK9-NEXT:    [[TMP6:%.*]] = trunc i64 [[TMP5]] to i32
// CHECK9-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP4]], i32 [[TMP6]])
// CHECK9-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[COMP_ADDR]])
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK9-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK9-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK9-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK9-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK9-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK9-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK9-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK9-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK9-NEXT:    ret void
//
//
// CHECK9-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK9-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK9-NEXT:  entry:
// CHECK9-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK9-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@_Z18teams_template_argv
// CHECK11-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[COMP:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[LA:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK11-NEXT:    [[LB:%.*]] = alloca [[STRUCT_SS_0:%.*]], align 4
// CHECK11-NEXT:    [[COMP_CASTED:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [3 x ptr], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [3 x ptr], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [3 x ptr], align 4
// CHECK11-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK11-NEXT:    [[COMP_CASTED1:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_BASEPTRS2:%.*]] = alloca [3 x ptr], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_PTRS3:%.*]] = alloca [3 x ptr], align 4
// CHECK11-NEXT:    [[DOTOFFLOAD_MAPPERS4:%.*]] = alloca [3 x ptr], align 4
// CHECK11-NEXT:    [[KERNEL_ARGS7:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK11-NEXT:    store i32 1, ptr [[COMP]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK11-NEXT:    store i32 [[TMP0]], ptr [[COMP_CASTED]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, ptr [[COMP_CASTED]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    store ptr @Gbla, ptr [[TMP2]], align 4
// CHECK11-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    store ptr @Gbla, ptr [[TMP3]], align 4
// CHECK11-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK11-NEXT:    store ptr null, ptr [[TMP4]], align 4
// CHECK11-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK11-NEXT:    store ptr [[LA]], ptr [[TMP5]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK11-NEXT:    store ptr [[LA]], ptr [[TMP6]], align 4
// CHECK11-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK11-NEXT:    store ptr null, ptr [[TMP7]], align 4
// CHECK11-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK11-NEXT:    store i32 [[TMP1]], ptr [[TMP8]], align 4
// CHECK11-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK11-NEXT:    store i32 [[TMP1]], ptr [[TMP9]], align 4
// CHECK11-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK11-NEXT:    store ptr null, ptr [[TMP10]], align 4
// CHECK11-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP13:%.*]] = load i32, ptr @Gbla, align 4
// CHECK11-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[LA]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP14:%.*]] = load float, ptr [[B]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = fptosi float [[TMP14]] to i64
// CHECK11-NEXT:    [[TMP15:%.*]] = trunc i64 [[CONV]] to i32
// CHECK11-NEXT:    [[TMP16:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP13]], 0
// CHECK11-NEXT:    [[TMP17:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP15]], 0
// CHECK11-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK11-NEXT:    store i32 2, ptr [[TMP18]], align 4
// CHECK11-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK11-NEXT:    store i32 3, ptr [[TMP19]], align 4
// CHECK11-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK11-NEXT:    store ptr [[TMP11]], ptr [[TMP20]], align 4
// CHECK11-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK11-NEXT:    store ptr [[TMP12]], ptr [[TMP21]], align 4
// CHECK11-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK11-NEXT:    store ptr @.offload_sizes, ptr [[TMP22]], align 4
// CHECK11-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK11-NEXT:    store ptr @.offload_maptypes, ptr [[TMP23]], align 4
// CHECK11-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK11-NEXT:    store ptr null, ptr [[TMP24]], align 4
// CHECK11-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK11-NEXT:    store ptr null, ptr [[TMP25]], align 4
// CHECK11-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK11-NEXT:    store i64 0, ptr [[TMP26]], align 8
// CHECK11-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK11-NEXT:    store i64 0, ptr [[TMP27]], align 8
// CHECK11-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK11-NEXT:    store [3 x i32] [[TMP16]], ptr [[TMP28]], align 4
// CHECK11-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK11-NEXT:    store [3 x i32] [[TMP17]], ptr [[TMP29]], align 4
// CHECK11-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK11-NEXT:    store i32 0, ptr [[TMP30]], align 4
// CHECK11-NEXT:    [[TMP31:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 [[TMP13]], i32 [[TMP15]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l116.region_id, ptr [[KERNEL_ARGS]])
// CHECK11-NEXT:    [[TMP32:%.*]] = icmp ne i32 [[TMP31]], 0
// CHECK11-NEXT:    br i1 [[TMP32]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK11:       omp_offload.failed:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l116(ptr @Gbla, ptr [[LA]], i32 [[TMP1]]) #[[ATTR2:[0-9]+]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK11:       omp_offload.cont:
// CHECK11-NEXT:    [[TMP33:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK11-NEXT:    store i32 [[TMP33]], ptr [[COMP_CASTED1]], align 4
// CHECK11-NEXT:    [[TMP34:%.*]] = load i32, ptr [[COMP_CASTED1]], align 4
// CHECK11-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK11-NEXT:    store ptr [[LB]], ptr [[TMP35]], align 4
// CHECK11-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK11-NEXT:    store ptr [[LB]], ptr [[TMP36]], align 4
// CHECK11-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i32 0, i32 0
// CHECK11-NEXT:    store ptr null, ptr [[TMP37]], align 4
// CHECK11-NEXT:    [[TMP38:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 1
// CHECK11-NEXT:    store ptr @Gblb, ptr [[TMP38]], align 4
// CHECK11-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 1
// CHECK11-NEXT:    store ptr @Gblb, ptr [[TMP39]], align 4
// CHECK11-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i32 0, i32 1
// CHECK11-NEXT:    store ptr null, ptr [[TMP40]], align 4
// CHECK11-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 2
// CHECK11-NEXT:    store i32 [[TMP34]], ptr [[TMP41]], align 4
// CHECK11-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 2
// CHECK11-NEXT:    store i32 [[TMP34]], ptr [[TMP42]], align 4
// CHECK11-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_MAPPERS4]], i32 0, i32 2
// CHECK11-NEXT:    store ptr null, ptr [[TMP43]], align 4
// CHECK11-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_BASEPTRS2]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOFFLOAD_PTRS3]], i32 0, i32 0
// CHECK11-NEXT:    [[B5:%.*]] = getelementptr inbounds [[STRUCT_SS_0]], ptr [[LB]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP46:%.*]] = load float, ptr [[B5]], align 4
// CHECK11-NEXT:    [[CONV6:%.*]] = fptosi float [[TMP46]] to i64
// CHECK11-NEXT:    [[TMP47:%.*]] = trunc i64 [[CONV6]] to i32
// CHECK11-NEXT:    [[TMP48:%.*]] = load i64, ptr @Gblb, align 4
// CHECK11-NEXT:    [[TMP49:%.*]] = trunc i64 [[TMP48]] to i32
// CHECK11-NEXT:    [[TMP50:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP47]], 0
// CHECK11-NEXT:    [[TMP51:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP49]], 0
// CHECK11-NEXT:    [[TMP52:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 0
// CHECK11-NEXT:    store i32 2, ptr [[TMP52]], align 4
// CHECK11-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 1
// CHECK11-NEXT:    store i32 3, ptr [[TMP53]], align 4
// CHECK11-NEXT:    [[TMP54:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 2
// CHECK11-NEXT:    store ptr [[TMP44]], ptr [[TMP54]], align 4
// CHECK11-NEXT:    [[TMP55:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 3
// CHECK11-NEXT:    store ptr [[TMP45]], ptr [[TMP55]], align 4
// CHECK11-NEXT:    [[TMP56:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 4
// CHECK11-NEXT:    store ptr @.offload_sizes.2, ptr [[TMP56]], align 4
// CHECK11-NEXT:    [[TMP57:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 5
// CHECK11-NEXT:    store ptr @.offload_maptypes.3, ptr [[TMP57]], align 4
// CHECK11-NEXT:    [[TMP58:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 6
// CHECK11-NEXT:    store ptr null, ptr [[TMP58]], align 4
// CHECK11-NEXT:    [[TMP59:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 7
// CHECK11-NEXT:    store ptr null, ptr [[TMP59]], align 4
// CHECK11-NEXT:    [[TMP60:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 8
// CHECK11-NEXT:    store i64 0, ptr [[TMP60]], align 8
// CHECK11-NEXT:    [[TMP61:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 9
// CHECK11-NEXT:    store i64 0, ptr [[TMP61]], align 8
// CHECK11-NEXT:    [[TMP62:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 10
// CHECK11-NEXT:    store [3 x i32] [[TMP50]], ptr [[TMP62]], align 4
// CHECK11-NEXT:    [[TMP63:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 11
// CHECK11-NEXT:    store [3 x i32] [[TMP51]], ptr [[TMP63]], align 4
// CHECK11-NEXT:    [[TMP64:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS7]], i32 0, i32 12
// CHECK11-NEXT:    store i32 0, ptr [[TMP64]], align 4
// CHECK11-NEXT:    [[TMP65:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 [[TMP47]], i32 [[TMP49]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l125.region_id, ptr [[KERNEL_ARGS7]])
// CHECK11-NEXT:    [[TMP66:%.*]] = icmp ne i32 [[TMP65]], 0
// CHECK11-NEXT:    br i1 [[TMP66]], label [[OMP_OFFLOAD_FAILED8:%.*]], label [[OMP_OFFLOAD_CONT9:%.*]]
// CHECK11:       omp_offload.failed8:
// CHECK11-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l125(ptr [[LB]], ptr @Gblb, i32 [[TMP34]]) #[[ATTR2]]
// CHECK11-NEXT:    br label [[OMP_OFFLOAD_CONT9]]
// CHECK11:       omp_offload.cont9:
// CHECK11-NEXT:    [[TMP67:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK11-NEXT:    ret i32 [[TMP67]]
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l116
// CHECK11-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[GBLA:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[LA:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[GBLA_ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[LA_ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK11-NEXT:    store ptr [[GBLA]], ptr [[GBLA_ADDR]], align 4
// CHECK11-NEXT:    store ptr [[LA]], ptr [[LA_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[GBLA_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[LA_ADDR]], align 4
// CHECK11-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP3:%.*]] = load i32, ptr [[A]], align 4
// CHECK11-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[TMP2]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP4:%.*]] = load float, ptr [[B]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = fptosi float [[TMP4]] to i64
// CHECK11-NEXT:    [[TMP5:%.*]] = trunc i64 [[CONV]] to i32
// CHECK11-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP3]], i32 [[TMP5]])
// CHECK11-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[COMP_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK11-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK11-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK11-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z18teams_template_argv_l125
// CHECK11-SAME: (ptr noundef nonnull align 4 dereferenceable(12) [[LB:%.*]], ptr noundef nonnull align 4 dereferenceable(12) [[GBLB:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[LB_ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[GBLB_ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK11-NEXT:    store ptr [[LB]], ptr [[LB_ADDR]], align 4
// CHECK11-NEXT:    store ptr [[GBLB]], ptr [[GBLB_ADDR]], align 4
// CHECK11-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[LB_ADDR]], align 4
// CHECK11-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[GBLB_ADDR]], align 4
// CHECK11-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS_0:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK11-NEXT:    [[TMP3:%.*]] = load float, ptr [[B]], align 4
// CHECK11-NEXT:    [[CONV:%.*]] = fptosi float [[TMP3]] to i64
// CHECK11-NEXT:    [[TMP4:%.*]] = trunc i64 [[CONV]] to i32
// CHECK11-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS_0]], ptr [[TMP2]], i32 0, i32 0
// CHECK11-NEXT:    [[TMP5:%.*]] = load i64, ptr [[A]], align 4
// CHECK11-NEXT:    [[TMP6:%.*]] = trunc i64 [[TMP5]] to i32
// CHECK11-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP4]], i32 [[TMP6]])
// CHECK11-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[COMP_ADDR]])
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK11-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK11-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK11-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK11-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK11-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK11-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK11-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK11-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK11-NEXT:    ret void
//
//
// CHECK11-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK11-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK11-NEXT:  entry:
// CHECK11-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK11-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK17-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK17-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_ZN2SSIiLi123ELx456EE3fooEv(ptr noundef nonnull align 4 dereferenceable(8) [[V]])
// CHECK17-NEXT:    ret i32 [[CALL]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK17-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[COMP:%.*]] = alloca i32, align 4
// CHECK17-NEXT:    [[COMP_CASTED:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x ptr], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x ptr], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x ptr], align 8
// CHECK17-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK17-NEXT:    [[COMP_CASTED3:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_BASEPTRS4:%.*]] = alloca [2 x ptr], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_PTRS5:%.*]] = alloca [2 x ptr], align 8
// CHECK17-NEXT:    [[DOTOFFLOAD_MAPPERS6:%.*]] = alloca [2 x ptr], align 8
// CHECK17-NEXT:    [[KERNEL_ARGS8:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK17-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i32 1, ptr [[COMP]], align 4
// CHECK17-NEXT:    [[TMP0:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK17-NEXT:    store i32 [[TMP0]], ptr [[COMP_CASTED]], align 4
// CHECK17-NEXT:    [[TMP1:%.*]] = load i64, ptr [[COMP_CASTED]], align 8
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    store ptr [[THIS1]], ptr [[TMP2]], align 8
// CHECK17-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    store ptr [[A]], ptr [[TMP3]], align 8
// CHECK17-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK17-NEXT:    store ptr null, ptr [[TMP4]], align 8
// CHECK17-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK17-NEXT:    store i64 [[TMP1]], ptr [[TMP5]], align 8
// CHECK17-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK17-NEXT:    store i64 [[TMP1]], ptr [[TMP6]], align 8
// CHECK17-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK17-NEXT:    store ptr null, ptr [[TMP7]], align 8
// CHECK17-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK17-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A2]], align 4
// CHECK17-NEXT:    [[TMP11:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP10]], 0
// CHECK17-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK17-NEXT:    store i32 2, ptr [[TMP12]], align 4
// CHECK17-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK17-NEXT:    store i32 2, ptr [[TMP13]], align 4
// CHECK17-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK17-NEXT:    store ptr [[TMP8]], ptr [[TMP14]], align 8
// CHECK17-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK17-NEXT:    store ptr [[TMP9]], ptr [[TMP15]], align 8
// CHECK17-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK17-NEXT:    store ptr @.offload_sizes, ptr [[TMP16]], align 8
// CHECK17-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK17-NEXT:    store ptr @.offload_maptypes, ptr [[TMP17]], align 8
// CHECK17-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK17-NEXT:    store ptr null, ptr [[TMP18]], align 8
// CHECK17-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK17-NEXT:    store ptr null, ptr [[TMP19]], align 8
// CHECK17-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK17-NEXT:    store i64 0, ptr [[TMP20]], align 8
// CHECK17-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK17-NEXT:    store i64 0, ptr [[TMP21]], align 8
// CHECK17-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK17-NEXT:    store [3 x i32] [[TMP11]], ptr [[TMP22]], align 4
// CHECK17-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK17-NEXT:    store [3 x i32] [i32 123, i32 0, i32 0], ptr [[TMP23]], align 4
// CHECK17-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK17-NEXT:    store i32 0, ptr [[TMP24]], align 4
// CHECK17-NEXT:    [[TMP25:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 [[TMP10]], i32 123, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l161.region_id, ptr [[KERNEL_ARGS]])
// CHECK17-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK17-NEXT:    br i1 [[TMP26]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK17:       omp_offload.failed:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l161(ptr [[THIS1]], i64 [[TMP1]]) #[[ATTR2:[0-9]+]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK17:       omp_offload.cont:
// CHECK17-NEXT:    [[TMP27:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK17-NEXT:    store i32 [[TMP27]], ptr [[COMP_CASTED3]], align 4
// CHECK17-NEXT:    [[TMP28:%.*]] = load i64, ptr [[COMP_CASTED3]], align 8
// CHECK17-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK17-NEXT:    store ptr [[THIS1]], ptr [[TMP29]], align 8
// CHECK17-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK17-NEXT:    store ptr [[B]], ptr [[TMP30]], align 8
// CHECK17-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS6]], i64 0, i64 0
// CHECK17-NEXT:    store ptr null, ptr [[TMP31]], align 8
// CHECK17-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 1
// CHECK17-NEXT:    store i64 [[TMP28]], ptr [[TMP32]], align 8
// CHECK17-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS5]], i32 0, i32 1
// CHECK17-NEXT:    store i64 [[TMP28]], ptr [[TMP33]], align 8
// CHECK17-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS6]], i64 0, i64 1
// CHECK17-NEXT:    store ptr null, ptr [[TMP34]], align 8
// CHECK17-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK17-NEXT:    [[B7:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP37:%.*]] = load float, ptr [[B7]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = fptosi float [[TMP37]] to i32
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 123
// CHECK17-NEXT:    [[TMP38:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD]], 0
// CHECK17-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 0
// CHECK17-NEXT:    store i32 2, ptr [[TMP39]], align 4
// CHECK17-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 1
// CHECK17-NEXT:    store i32 2, ptr [[TMP40]], align 4
// CHECK17-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 2
// CHECK17-NEXT:    store ptr [[TMP35]], ptr [[TMP41]], align 8
// CHECK17-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 3
// CHECK17-NEXT:    store ptr [[TMP36]], ptr [[TMP42]], align 8
// CHECK17-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 4
// CHECK17-NEXT:    store ptr @.offload_sizes.2, ptr [[TMP43]], align 8
// CHECK17-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 5
// CHECK17-NEXT:    store ptr @.offload_maptypes.3, ptr [[TMP44]], align 8
// CHECK17-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 6
// CHECK17-NEXT:    store ptr null, ptr [[TMP45]], align 8
// CHECK17-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 7
// CHECK17-NEXT:    store ptr null, ptr [[TMP46]], align 8
// CHECK17-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 8
// CHECK17-NEXT:    store i64 0, ptr [[TMP47]], align 8
// CHECK17-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 9
// CHECK17-NEXT:    store i64 0, ptr [[TMP48]], align 8
// CHECK17-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 10
// CHECK17-NEXT:    store [3 x i32] [i32 456, i32 0, i32 0], ptr [[TMP49]], align 4
// CHECK17-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 11
// CHECK17-NEXT:    store [3 x i32] [[TMP38]], ptr [[TMP50]], align 4
// CHECK17-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 12
// CHECK17-NEXT:    store i32 0, ptr [[TMP51]], align 4
// CHECK17-NEXT:    [[TMP52:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 456, i32 [[ADD]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l169.region_id, ptr [[KERNEL_ARGS8]])
// CHECK17-NEXT:    [[TMP53:%.*]] = icmp ne i32 [[TMP52]], 0
// CHECK17-NEXT:    br i1 [[TMP53]], label [[OMP_OFFLOAD_FAILED9:%.*]], label [[OMP_OFFLOAD_CONT10:%.*]]
// CHECK17:       omp_offload.failed9:
// CHECK17-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l169(ptr [[THIS1]], i64 [[TMP28]]) #[[ATTR2]]
// CHECK17-NEXT:    br label [[OMP_OFFLOAD_CONT10]]
// CHECK17:       omp_offload.cont10:
// CHECK17-NEXT:    [[TMP54:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK17-NEXT:    ret i32 [[TMP54]]
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l161
// CHECK17-SAME: (ptr noundef [[THIS:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK17-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK17-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK17-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP2]], i32 123)
// CHECK17-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[COMP_ADDR]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK17-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK17-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK17-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l169
// CHECK17-SAME: (ptr noundef [[THIS:%.*]], i64 noundef [[COMP:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[COMP_ADDR:%.*]] = alloca i64, align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK17-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK17-NEXT:    store i64 [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK17-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK17-NEXT:    [[TMP2:%.*]] = load float, ptr [[B]], align 4
// CHECK17-NEXT:    [[CONV:%.*]] = fptosi float [[TMP2]] to i32
// CHECK17-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 123
// CHECK17-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 456, i32 [[ADD]])
// CHECK17-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[COMP_ADDR]])
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK17-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 8
// CHECK17-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK17-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK17-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 8
// CHECK17-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 8
// CHECK17-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK17-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK17-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK17-NEXT:    ret void
//
//
// CHECK17-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK17-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK17-NEXT:  entry:
// CHECK17-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK17-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@_Z21teams_template_structv
// CHECK19-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[V:%.*]] = alloca [[STRUCT_SS:%.*]], align 4
// CHECK19-NEXT:    [[CALL:%.*]] = call noundef i32 @_ZN2SSIiLi123ELx456EE3fooEv(ptr noundef nonnull align 4 dereferenceable(8) [[V]])
// CHECK19-NEXT:    ret i32 [[CALL]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@_ZN2SSIiLi123ELx456EE3fooEv
// CHECK19-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[THIS:%.*]]) #[[ATTR0]] comdat align 2 {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[COMP:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[COMP_CASTED:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [2 x ptr], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [2 x ptr], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [2 x ptr], align 4
// CHECK19-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK19-NEXT:    [[COMP_CASTED3:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_BASEPTRS4:%.*]] = alloca [2 x ptr], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_PTRS5:%.*]] = alloca [2 x ptr], align 4
// CHECK19-NEXT:    [[DOTOFFLOAD_MAPPERS6:%.*]] = alloca [2 x ptr], align 4
// CHECK19-NEXT:    [[KERNEL_ARGS8:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS]], align 8
// CHECK19-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 1, ptr [[COMP]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK19-NEXT:    store i32 [[TMP0]], ptr [[COMP_CASTED]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, ptr [[COMP_CASTED]], align 4
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    store ptr [[THIS1]], ptr [[TMP2]], align 4
// CHECK19-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    store ptr [[A]], ptr [[TMP3]], align 4
// CHECK19-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK19-NEXT:    store ptr null, ptr [[TMP4]], align 4
// CHECK19-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK19-NEXT:    store i32 [[TMP1]], ptr [[TMP5]], align 4
// CHECK19-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK19-NEXT:    store i32 [[TMP1]], ptr [[TMP6]], align 4
// CHECK19-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK19-NEXT:    store ptr null, ptr [[TMP7]], align 4
// CHECK19-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK19-NEXT:    [[A2:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A2]], align 4
// CHECK19-NEXT:    [[TMP11:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[TMP10]], 0
// CHECK19-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK19-NEXT:    store i32 2, ptr [[TMP12]], align 4
// CHECK19-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK19-NEXT:    store i32 2, ptr [[TMP13]], align 4
// CHECK19-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK19-NEXT:    store ptr [[TMP8]], ptr [[TMP14]], align 4
// CHECK19-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK19-NEXT:    store ptr [[TMP9]], ptr [[TMP15]], align 4
// CHECK19-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK19-NEXT:    store ptr @.offload_sizes, ptr [[TMP16]], align 4
// CHECK19-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK19-NEXT:    store ptr @.offload_maptypes, ptr [[TMP17]], align 4
// CHECK19-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK19-NEXT:    store ptr null, ptr [[TMP18]], align 4
// CHECK19-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK19-NEXT:    store ptr null, ptr [[TMP19]], align 4
// CHECK19-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK19-NEXT:    store i64 0, ptr [[TMP20]], align 8
// CHECK19-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 9
// CHECK19-NEXT:    store i64 0, ptr [[TMP21]], align 8
// CHECK19-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 10
// CHECK19-NEXT:    store [3 x i32] [[TMP11]], ptr [[TMP22]], align 4
// CHECK19-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 11
// CHECK19-NEXT:    store [3 x i32] [i32 123, i32 0, i32 0], ptr [[TMP23]], align 4
// CHECK19-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 12
// CHECK19-NEXT:    store i32 0, ptr [[TMP24]], align 4
// CHECK19-NEXT:    [[TMP25:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1:[0-9]+]], i64 -1, i32 [[TMP10]], i32 123, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l161.region_id, ptr [[KERNEL_ARGS]])
// CHECK19-NEXT:    [[TMP26:%.*]] = icmp ne i32 [[TMP25]], 0
// CHECK19-NEXT:    br i1 [[TMP26]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK19:       omp_offload.failed:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l161(ptr [[THIS1]], i32 [[TMP1]]) #[[ATTR2:[0-9]+]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK19:       omp_offload.cont:
// CHECK19-NEXT:    [[TMP27:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK19-NEXT:    store i32 [[TMP27]], ptr [[COMP_CASTED3]], align 4
// CHECK19-NEXT:    [[TMP28:%.*]] = load i32, ptr [[COMP_CASTED3]], align 4
// CHECK19-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK19-NEXT:    store ptr [[THIS1]], ptr [[TMP29]], align 4
// CHECK19-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK19-NEXT:    store ptr [[B]], ptr [[TMP30]], align 4
// CHECK19-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 0
// CHECK19-NEXT:    store ptr null, ptr [[TMP31]], align 4
// CHECK19-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 1
// CHECK19-NEXT:    store i32 [[TMP28]], ptr [[TMP32]], align 4
// CHECK19-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS5]], i32 0, i32 1
// CHECK19-NEXT:    store i32 [[TMP28]], ptr [[TMP33]], align 4
// CHECK19-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_MAPPERS6]], i32 0, i32 1
// CHECK19-NEXT:    store ptr null, ptr [[TMP34]], align 4
// CHECK19-NEXT:    [[TMP35:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_BASEPTRS4]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOFFLOAD_PTRS5]], i32 0, i32 0
// CHECK19-NEXT:    [[B7:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP37:%.*]] = load float, ptr [[B7]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = fptosi float [[TMP37]] to i32
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 123
// CHECK19-NEXT:    [[TMP38:%.*]] = insertvalue [3 x i32] zeroinitializer, i32 [[ADD]], 0
// CHECK19-NEXT:    [[TMP39:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 0
// CHECK19-NEXT:    store i32 2, ptr [[TMP39]], align 4
// CHECK19-NEXT:    [[TMP40:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 1
// CHECK19-NEXT:    store i32 2, ptr [[TMP40]], align 4
// CHECK19-NEXT:    [[TMP41:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 2
// CHECK19-NEXT:    store ptr [[TMP35]], ptr [[TMP41]], align 4
// CHECK19-NEXT:    [[TMP42:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 3
// CHECK19-NEXT:    store ptr [[TMP36]], ptr [[TMP42]], align 4
// CHECK19-NEXT:    [[TMP43:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 4
// CHECK19-NEXT:    store ptr @.offload_sizes.2, ptr [[TMP43]], align 4
// CHECK19-NEXT:    [[TMP44:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 5
// CHECK19-NEXT:    store ptr @.offload_maptypes.3, ptr [[TMP44]], align 4
// CHECK19-NEXT:    [[TMP45:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 6
// CHECK19-NEXT:    store ptr null, ptr [[TMP45]], align 4
// CHECK19-NEXT:    [[TMP46:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 7
// CHECK19-NEXT:    store ptr null, ptr [[TMP46]], align 4
// CHECK19-NEXT:    [[TMP47:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 8
// CHECK19-NEXT:    store i64 0, ptr [[TMP47]], align 8
// CHECK19-NEXT:    [[TMP48:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 9
// CHECK19-NEXT:    store i64 0, ptr [[TMP48]], align 8
// CHECK19-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 10
// CHECK19-NEXT:    store [3 x i32] [i32 456, i32 0, i32 0], ptr [[TMP49]], align 4
// CHECK19-NEXT:    [[TMP50:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 11
// CHECK19-NEXT:    store [3 x i32] [[TMP38]], ptr [[TMP50]], align 4
// CHECK19-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS8]], i32 0, i32 12
// CHECK19-NEXT:    store i32 0, ptr [[TMP51]], align 4
// CHECK19-NEXT:    [[TMP52:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB1]], i64 -1, i32 456, i32 [[ADD]], ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l169.region_id, ptr [[KERNEL_ARGS8]])
// CHECK19-NEXT:    [[TMP53:%.*]] = icmp ne i32 [[TMP52]], 0
// CHECK19-NEXT:    br i1 [[TMP53]], label [[OMP_OFFLOAD_FAILED9:%.*]], label [[OMP_OFFLOAD_CONT10:%.*]]
// CHECK19:       omp_offload.failed9:
// CHECK19-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l169(ptr [[THIS1]], i32 [[TMP28]]) #[[ATTR2]]
// CHECK19-NEXT:    br label [[OMP_OFFLOAD_CONT10]]
// CHECK19:       omp_offload.cont10:
// CHECK19-NEXT:    [[TMP54:%.*]] = load i32, ptr [[COMP]], align 4
// CHECK19-NEXT:    ret i32 [[TMP54]]
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l161
// CHECK19-SAME: (ptr noundef [[THIS:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK19-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK19-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK19-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP2]], i32 123)
// CHECK19-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[COMP_ADDR]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK19-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK19-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK19-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__ZN2SSIiLi123ELx456EE3fooEv_l169
// CHECK19-SAME: (ptr noundef [[THIS:%.*]], i32 noundef [[COMP:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[COMP_ADDR:%.*]] = alloca i32, align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK19-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK19-NEXT:    store i32 [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK19-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[TMP1]], i32 0, i32 1
// CHECK19-NEXT:    [[TMP2:%.*]] = load float, ptr [[B]], align 4
// CHECK19-NEXT:    [[CONV:%.*]] = fptosi float [[TMP2]] to i32
// CHECK19-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], 123
// CHECK19-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 456, i32 [[ADD]])
// CHECK19-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[COMP_ADDR]])
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK19-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[COMP:%.*]]) #[[ATTR1]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    [[COMP_ADDR:%.*]] = alloca ptr, align 4
// CHECK19-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK19-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK19-NEXT:    store ptr [[COMP]], ptr [[COMP_ADDR]], align 4
// CHECK19-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[COMP_ADDR]], align 4
// CHECK19-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK19-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK19-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK19-NEXT:    ret void
//
//
// CHECK19-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK19-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK19-NEXT:  entry:
// CHECK19-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK19-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l216
// CHECK25-SAME: (i64 noundef [[ARGC:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[ARGC_ADDR:%.*]] = alloca i64, align 8
// CHECK25-NEXT:    store i64 [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK25-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1:[0-9]+]], i32 1, ptr @.omp_outlined., ptr [[ARGC_ADDR]])
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK25-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK25-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK25-NEXT:    store i32 0, ptr [[TMP0]], align 4
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIPPcEiT__l209
// CHECK25-SAME: (ptr noundef [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK25-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[ARGC_ADDR]])
// CHECK25-NEXT:    ret void
//
//
// CHECK25-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK25-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK25-NEXT:  entry:
// CHECK25-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK25-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK25-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK25-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK25-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK25-NEXT:    store ptr null, ptr [[TMP0]], align 8
// CHECK25-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l216
// CHECK27-SAME: (i32 noundef [[ARGC:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK27-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1:[0-9]+]], i32 1, ptr @.omp_outlined., ptr [[ARGC_ADDR]])
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK27-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK27-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    store i32 0, ptr [[TMP0]], align 4
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIPPcEiT__l209
// CHECK27-SAME: (ptr noundef [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[ARGC_ADDR]])
// CHECK27-NEXT:    ret void
//
//
// CHECK27-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK27-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK27-NEXT:  entry:
// CHECK27-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 4
// CHECK27-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK27-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK27-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 4
// CHECK27-NEXT:    store ptr null, ptr [[TMP0]], align 4
// CHECK27-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l265
// CHECK33-SAME: (i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[ARGC:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[ARGC_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK33-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK33-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK33-NEXT:    store i64 [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK33-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK33-NEXT:    [[TMP2:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK33-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK33-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[ARGC_ADDR]])
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK33-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK33-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK33-NEXT:    store i32 0, ptr [[TMP0]], align 4
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIPPcEiT__l254
// CHECK33-SAME: (i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], ptr noundef [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK33-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK33-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK33-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK33-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK33-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK33-NEXT:    [[TMP2:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK33-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK33-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[ARGC_ADDR]])
// CHECK33-NEXT:    ret void
//
//
// CHECK33-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK33-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK33-NEXT:  entry:
// CHECK33-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK33-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK33-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK33-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK33-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK33-NEXT:    store ptr null, ptr [[TMP0]], align 8
// CHECK33-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l265
// CHECK35-SAME: (i32 noundef [[A:%.*]], i32 noundef [[B:%.*]], i32 noundef [[ARGC:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK35-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK35-NEXT:    store i32 [[B]], ptr [[B_ADDR]], align 4
// CHECK35-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK35-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK35-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined., ptr [[ARGC_ADDR]])
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK35-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK35-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    store i32 0, ptr [[TMP0]], align 4
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIPPcEiT__l254
// CHECK35-SAME: (i32 noundef [[A:%.*]], i32 noundef [[B:%.*]], ptr noundef [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[B_ADDR:%.*]] = alloca i32, align 4
// CHECK35-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK35-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK35-NEXT:    store i32 [[B]], ptr [[B_ADDR]], align 4
// CHECK35-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    [[TMP1:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK35-NEXT:    [[TMP2:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK35-NEXT:    call void @__kmpc_push_num_teams(ptr @[[GLOB1]], i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// CHECK35-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1]], i32 1, ptr @.omp_outlined..1, ptr [[ARGC_ADDR]])
// CHECK35-NEXT:    ret void
//
//
// CHECK35-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK35-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]]) #[[ATTR0]] {
// CHECK35-NEXT:  entry:
// CHECK35-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 4
// CHECK35-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK35-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK35-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 4
// CHECK35-NEXT:    store ptr null, ptr [[TMP0]], align 4
// CHECK35-NEXT:    ret void
//
//
// CHECK41-LABEL: define {{[^@]+}}@_Z3foov
// CHECK41-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK41-NEXT:  entry:
// CHECK41-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1:[0-9]+]], i32 0, ptr @.omp_outlined.)
// CHECK41-NEXT:    ret void
//
//
// CHECK41-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK41-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK41-NEXT:  entry:
// CHECK41-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK41-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK41-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK41-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK41-NEXT:    ret void
//
//
// CHECK43-LABEL: define {{[^@]+}}@_Z3foov
// CHECK43-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK43-NEXT:  entry:
// CHECK43-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB1:[0-9]+]], i32 0, ptr @.omp_outlined.)
// CHECK43-NEXT:    ret void
//
//
// CHECK43-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK43-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK43-NEXT:  entry:
// CHECK43-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK43-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK43-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK43-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK43-NEXT:    ret void
//
