# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=arm -mcpu=cortex-m7 --timeline --iterations=1 < %s | FileCheck %s

add r1, r1, #1
# ReadAdvance: 0
add r1, r1, #2
# ReadAdvance: -1
vldr d0, [r1]

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      3
# CHECK-NEXT: Total Cycles:      7
# CHECK-NEXT: Total uOps:        3

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.43
# CHECK-NEXT: IPC:               0.43
# CHECK-NEXT: Block RThroughput: 1.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.50                        add.w	r1, r1, #1
# CHECK-NEXT:  1      1     0.50                        add.w	r1, r1, #2
# CHECK-NEXT:  1      3     1.00    *                   vldr	d0, [r1]

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - M7UnitALU
# CHECK-NEXT: [0.1] - M7UnitALU
# CHECK-NEXT: [1]   - M7UnitBranch
# CHECK-NEXT: [2.0] - M7UnitLoad
# CHECK-NEXT: [2.1] - M7UnitLoad
# CHECK-NEXT: [3]   - M7UnitMAC
# CHECK-NEXT: [4]   - M7UnitSIMD
# CHECK-NEXT: [5]   - M7UnitShift1
# CHECK-NEXT: [6]   - M7UnitShift2
# CHECK-NEXT: [7]   - M7UnitStore
# CHECK-NEXT: [8]   - M7UnitVFP
# CHECK-NEXT: [9.0] - M7UnitVPort
# CHECK-NEXT: [9.1] - M7UnitVPort

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2.0]  [2.1]  [3]    [4]    [5]    [6]    [7]    [8]    [9.0]  [9.1]
# CHECK-NEXT: 1.00   1.00    -      -     1.00    -      -      -      -      -      -      -     2.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2.0]  [2.1]  [3]    [4]    [5]    [6]    [7]    [8]    [9.0]  [9.1]  Instructions:
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -      -      -      -      -     add.w	r1, r1, #1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     add.w	r1, r1, #2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -     2.00   vldr	d0, [r1]

# CHECK:      Timeline view:
# CHECK-NEXT: Index     0123456

# CHECK:      [0,0]     DER  ..   add.w	r1, r1, #1
# CHECK-NEXT: [0,1]     .DER ..   add.w	r1, r1, #2
# CHECK-NEXT: [0,2]     .  DeER   vldr	d0, [r1]

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       add.w	r1, r1, #1
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       add.w	r1, r1, #2
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       vldr	d0, [r1]
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
