// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx900 -show-encoding %s | FileCheck %s --check-prefix=GFX9
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -show-encoding %s | FileCheck %s --check-prefix=GFX10

// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx900 %s 2>&1 | FileCheck %s -check-prefix=NOGFX9 --implicit-check-not=error:
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 %s 2>&1 | FileCheck %s -check-prefix=NOGFX10 --implicit-check-not=error:

//===----------------------------------------------------------------------===//
// Inline constants
//===----------------------------------------------------------------------===//

v_pk_add_f16 v1, 0, v2
// GFX9: v_pk_add_f16 v1, 0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x80,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x80,0x04,0x02,0x18]

v_pk_add_f16 v1, 0.0, v2
// GFX9: v_pk_add_f16 v1, 0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x80,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x80,0x04,0x02,0x18]

v_pk_add_f16 v1, v2, 0
// GFX9: v_pk_add_f16 v1, v2, 0 ; encoding: [0x01,0x40,0x8f,0xd3,0x02,0x01,0x01,0x18]
// GFX10: v_pk_add_f16 v1, v2, 0 ; encoding: [0x01,0x40,0x0f,0xcc,0x02,0x01,0x01,0x18]

v_pk_add_f16 v1, v2, 0.0
// GFX9: v_pk_add_f16 v1, v2, 0 ; encoding: [0x01,0x40,0x8f,0xd3,0x02,0x01,0x01,0x18]
// GFX10: v_pk_add_f16 v1, v2, 0 ; encoding: [0x01,0x40,0x0f,0xcc,0x02,0x01,0x01,0x18]

v_pk_add_f16 v1, 1.0, v2
// GFX9: v_pk_add_f16 v1, 1.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf2,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 1.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf2,0x04,0x02,0x18]

v_pk_add_f16 v1, -1.0, v2
// GFX9: v_pk_add_f16 v1, -1.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf3,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -1.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf3,0x04,0x02,0x18]

v_pk_add_f16 v1, -0.5, v2
// GFX9: v_pk_add_f16 v1, -0.5, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf1,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -0.5, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf1,0x04,0x02,0x18]

v_pk_add_f16 v1, 0.5, v2
// GFX9: v_pk_add_f16 v1, 0.5, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf0,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 0.5, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf0,0x04,0x02,0x18]

v_pk_add_f16 v1, 2.0, v2
// GFX9: v_pk_add_f16 v1, 2.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf4,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 2.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf4,0x04,0x02,0x18]

v_pk_add_f16 v1, -2.0, v2
// GFX9: v_pk_add_f16 v1, -2.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf5,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -2.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf5,0x04,0x02,0x18]

v_pk_add_f16 v1, 4.0, v2
// GFX9: v_pk_add_f16 v1, 4.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf6,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 4.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf6,0x04,0x02,0x18]

v_pk_add_f16 v1, -4.0, v2
// GFX9: v_pk_add_f16 v1, -4.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf7,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -4.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf7,0x04,0x02,0x18]

v_pk_add_f16 v1, 0.15915494, v2
// GFX9: v_pk_add_f16 v1, 0.15915494, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf8,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 0.15915494, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf8,0x04,0x02,0x18]

v_pk_add_f16 v1, -1, v2
// GFX9: v_pk_add_f16 v1, -1, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xc1,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -1, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xc1,0x04,0x02,0x18]

v_pk_add_f16 v1, -2, v2
// GFX9: v_pk_add_f16 v1, -2, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xc2,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -2, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xc2,0x04,0x02,0x18]

v_pk_add_f16 v1, -3, v2
// GFX9: v_pk_add_f16 v1, -3, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xc3,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -3, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xc3,0x04,0x02,0x18]

v_pk_add_f16 v1, -16, v2
// GFX9: v_pk_add_f16 v1, -16, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xd0,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -16, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xd0,0x04,0x02,0x18]

v_pk_add_f16 v1, 1, v2
// GFX9: v_pk_add_f16 v1, 1, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x81,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 1, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x81,0x04,0x02,0x18]

v_pk_add_f16 v1, 2, v2
// GFX9: v_pk_add_f16 v1, 2, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x82,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 2, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x82,0x04,0x02,0x18]

v_pk_add_f16 v1, 3, v2
// GFX9: v_pk_add_f16 v1, 3, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x83,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 3, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x83,0x04,0x02,0x18]

v_pk_add_f16 v1, 4, v2
// GFX9: v_pk_add_f16 v1, 4, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x84,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 4, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x84,0x04,0x02,0x18]

v_pk_add_f16 v1, 15, v2
// GFX9: v_pk_add_f16 v1, 15, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x8f,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 15, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x8f,0x04,0x02,0x18]

v_pk_add_f16 v1, 16, v2
// GFX9: v_pk_add_f16 v1, 16, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x90,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 16, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0x90,0x04,0x02,0x18]

v_pk_add_f16 v1, 63, v2
// GFX9: v_pk_add_f16 v1, 63, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xbf,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 63, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xbf,0x04,0x02,0x18]

v_pk_add_f16 v1, 64, v2
// GFX9: v_pk_add_f16 v1, 64, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xc0,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 64, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xc0,0x04,0x02,0x18]

v_pk_add_f16 v1, 0x0001, v2
// GFX9: v_pk_add_f16 v1, 1, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0x81,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 1, v2  ; encoding: [0x01,0x40,0x0f,0xcc,0x81,0x04,0x02,0x18]

v_pk_add_f16 v1, 0xffff, v2
// GFX9: v_pk_add_f16 v1, -1, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xc1,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -1, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xc1,0x04,0x02,0x18]

v_pk_add_f16 v1, 0x3c00, v2
// GFX9: v_pk_add_f16 v1, 1.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf2,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 1.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf2,0x04,0x02,0x18]

v_pk_add_f16 v1, 0xbc00, v2
// GFX9: v_pk_add_f16 v1, -1.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf3,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -1.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf3,0x04,0x02,0x18]

v_pk_add_f16 v1, 0x3800, v2
// GFX9: v_pk_add_f16 v1, 0.5, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf0,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 0.5, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf0,0x04,0x02,0x18]

v_pk_add_f16 v1, 0xb800, v2
// GFX9: v_pk_add_f16 v1, -0.5, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf1,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -0.5, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf1,0x04,0x02,0x18]

v_pk_add_f16 v1, 0x4000, v2
// GFX9: v_pk_add_f16 v1, 2.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf4,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 2.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf4,0x04,0x02,0x18]

v_pk_add_f16 v1, 0xc000, v2
// GFX9: v_pk_add_f16 v1, -2.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf5,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -2.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf5,0x04,0x02,0x18]

v_pk_add_f16 v1, 0x4400, v2
// GFX9: v_pk_add_f16 v1, 4.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf6,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 4.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf6,0x04,0x02,0x18]

v_pk_add_f16 v1, 0xc400, v2
// GFX9: v_pk_add_f16 v1, -4.0, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf7,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -4.0, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf7,0x04,0x02,0x18]

v_pk_add_f16 v1, 0x3118, v2
// GFX9: v_pk_add_f16 v1, 0.15915494, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xf8,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, 0.15915494, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xf8,0x04,0x02,0x18]

v_pk_add_f16 v1, 65535, v2
// GFX9: v_pk_add_f16 v1, -1, v2 ; encoding: [0x01,0x40,0x8f,0xd3,0xc1,0x04,0x02,0x18]
// GFX10: v_pk_add_f16 v1, -1, v2 ; encoding: [0x01,0x40,0x0f,0xcc,0xc1,0x04,0x02,0x18]

//===----------------------------------------------------------------------===//
// Integer literals
//===----------------------------------------------------------------------===//

v_pk_add_f16 v5, v1, 0x12345678
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_f16 v5, v1, 0x12345678 ; encoding: [0x05,0x40,0x0f,0xcc,0x01,0xff,0x01,0x18,0x78,0x56,0x34,0x12]

v_pk_add_f16 v5, 0x12345678, v2
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_f16 v5, 0x12345678, v2 ; encoding: [0x05,0x40,0x0f,0xcc,0xff,0x04,0x02,0x18,0x78,0x56,0x34,0x12]

v_pk_add_f16 v5, -256, v2
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_f16 v5, 0xffffff00, v2 ; encoding: [0x05,0x40,0x0f,0xcc,0xff,0x04,0x02,0x18,0x00,0xff,0xff,0xff]

v_pk_add_f16 v5, v1, 256
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_f16 v5, v1, 0x100      ; encoding: [0x05,0x40,0x0f,0xcc,0x01,0xff,0x01,0x18,0x00,0x01,0x00,0x00]

v_pk_add_u16 v5, v1, 0x12345678
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_u16 v5, v1, 0x12345678 ; encoding: [0x05,0x40,0x0a,0xcc,0x01,0xff,0x01,0x18,0x78,0x56,0x34,0x12]

v_pk_add_u16 v5, 0x12345678, v2
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_u16 v5, 0x12345678, v2 ; encoding: [0x05,0x40,0x0a,0xcc,0xff,0x04,0x02,0x18,0x78,0x56,0x34,0x12]

v_pk_add_u16 v5, -256, v2
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_u16 v5, 0xffffff00, v2 ; encoding: [0x05,0x40,0x0a,0xcc,0xff,0x04,0x02,0x18,0x00,0xff,0xff,0xff]

v_pk_add_u16 v5, v1, 256
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_u16 v5, v1, 0x100      ; encoding: [0x05,0x40,0x0a,0xcc,0x01,0xff,0x01,0x18,0x00,0x01,0x00,0x00]

v_pk_add_f16 v5, v1, 0x123456780
// NOGFX9: error: invalid operand for instruction
// NOGFX10: error: invalid operand for instruction

v_pk_add_u16 v5, v1, 0x123456780
// NOGFX9: error: invalid operand for instruction
// NOGFX10: error: invalid operand for instruction

v_pk_fma_f16 v5, 0xaf123456, v2, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_fma_f16 v5, 0xaf123456, v2, v3 ; encoding: [0x05,0x40,0x0e,0xcc,0xff,0x04,0x0e,0x1c,0x56,0x34,0x12,0xaf]

v_pk_fma_f16 v5, v1, 0xaf123456, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_fma_f16 v5, v1, 0xaf123456, v3 ; encoding: [0x05,0x40,0x0e,0xcc,0x01,0xff,0x0d,0x1c,0x56,0x34,0x12,0xaf]

v_pk_fma_f16 v5, v1, v2, 0xaf123456
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_fma_f16 v5, v1, v2, 0xaf123456 ; encoding: [0x05,0x40,0x0e,0xcc,0x01,0x05,0xfe,0x1b,0x56,0x34,0x12,0xaf]

v_pk_mad_i16 v5, 0xaf123456, v2, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_mad_i16 v5, 0xaf123456, v2, v3 ; encoding: [0x05,0x40,0x00,0xcc,0xff,0x04,0x0e,0x1c,0x56,0x34,0x12,0xaf]

v_pk_mad_i16 v5, v1, 0xaf123456, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_mad_i16 v5, v1, 0xaf123456, v3 ; encoding: [0x05,0x40,0x00,0xcc,0x01,0xff,0x0d,0x1c,0x56,0x34,0x12,0xaf]

v_pk_mad_i16 v5, v1, v2, 0xaf123456
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_mad_i16 v5, v1, v2, 0xaf123456 ; encoding: [0x05,0x40,0x00,0xcc,0x01,0x05,0xfe,0x1b,0x56,0x34,0x12,0xaf]

v_pk_ashrrev_i16 v5, 0x12345678, v2
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_ashrrev_i16 v5, 0x12345678, v2 ; encoding: [0x05,0x40,0x06,0xcc,0xff,0x04,0x02,0x18,0x78,0x56,0x34,0x12]

v_pk_ashrrev_i16 v5, v1, 0x12345678
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_ashrrev_i16 v5, v1, 0x12345678 ; encoding: [0x05,0x40,0x06,0xcc,0x01,0xff,0x01,0x18,0x78,0x56,0x34,0x12]

//===----------------------------------------------------------------------===//
// Floating-point literals (allowed if lossless conversion to f16 is possible)
//===----------------------------------------------------------------------===//

v_pk_add_f16 v5, v1, 0.1234
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_f16 v5, v1, 0x2fe6     ; encoding: [0x05,0x40,0x0f,0xcc,0x01,0xff,0x01,0x18,0xe6,0x2f,0x00,0x00]

v_pk_add_u16 v5, v1, 0.1234
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_add_u16 v5, v1, 0x2fe6     ; encoding: [0x05,0x40,0x0a,0xcc,0x01,0xff,0x01,0x18,0xe6,0x2f,0x00,0x00]

v_pk_fma_f16 v5, 0.1234, v2, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_fma_f16 v5, 0x2fe6, v2, v3 ; encoding: [0x05,0x40,0x0e,0xcc,0xff,0x04,0x0e,0x1c,0xe6,0x2f,0x00,0x00]

v_pk_fma_f16 v5, v1, 0.1234, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_fma_f16 v5, v1, 0x2fe6, v3 ; encoding: [0x05,0x40,0x0e,0xcc,0x01,0xff,0x0d,0x1c,0xe6,0x2f,0x00,0x00]

v_pk_fma_f16 v5, v1, v2, 0.1234
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_fma_f16 v5, v1, v2, 0x2fe6 ; encoding: [0x05,0x40,0x0e,0xcc,0x01,0x05,0xfe,0x1b,0xe6,0x2f,0x00,0x00]

v_pk_mad_i16 v5, 0.1234, v2, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_mad_i16 v5, 0x2fe6, v2, v3 ; encoding: [0x05,0x40,0x00,0xcc,0xff,0x04,0x0e,0x1c,0xe6,0x2f,0x00,0x00]

v_pk_mad_i16 v5, v1, 0.1234, v3
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_mad_i16 v5, v1, 0x2fe6, v3 ; encoding: [0x05,0x40,0x00,0xcc,0x01,0xff,0x0d,0x1c,0xe6,0x2f,0x00,0x00]

v_pk_mad_i16 v5, v1, v2, 0.1234
// NOGFX9: error: literal operands are not supported
// GFX10: v_pk_mad_i16 v5, v1, v2, 0x2fe6 ; encoding: [0x05,0x40,0x00,0xcc,0x01,0x05,0xfe,0x1b,0xe6,0x2f,0x00,0x00]

v_pk_add_f16 v5, v1, 123456.0
// NOGFX9: error: invalid operand for instruction
// NOGFX10: error: invalid operand for instruction

v_pk_add_u16 v5, v1, 123456.0
// NOGFX9: error: invalid operand for instruction
// NOGFX10: error: invalid operand for instruction

//===----------------------------------------------------------------------===//
// Packed VOP2
//===----------------------------------------------------------------------===//

// FIXME: v_pk_fmac_f16 cannot be promoted to VOP3 so '_e32' suffix is not valid
v_pk_fmac_f16 v5, 0x12345678, v2
// NOGFX9: error: instruction not supported on this GPU
// GFX10: v_pk_fmac_f16_e32 v5, 0x12345678, v2 ; encoding: [0xff,0x04,0x0a,0x78,0x78,0x56,0x34,0x12]
