; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2 | FileCheck %s --check-prefixes=AVX512VBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512VLBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2,+avx512vl | FileCheck %s --check-prefixes=AVX512VLVBMI2

declare <8 x i64> @llvm.fshl.v8i64(<8 x i64>, <8 x i64>, <8 x i64>)
declare <16 x i32> @llvm.fshl.v16i32(<16 x i32>, <16 x i32>, <16 x i32>)
declare <32 x i16> @llvm.fshl.v32i16(<32 x i16>, <32 x i16>, <32 x i16>)
declare <64 x i8> @llvm.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)

;
; Variable Shifts
;

define <8 x i64> @var_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512F-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllvq %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [63,63,63,63,63,63,63,63]
; AVX512VL-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VL-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllvq %zmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [63,63,63,63,63,63,63,63]
; AVX512BW-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvq %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [63,63,63,63,63,63,63,63]
; AVX512VLBW-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvq %zmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt)
  ret <8 x i64> %res
}

define <16 x i32> @var_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} zmm3 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX512F-NEXT:    vpandnd %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpandd %zmm3, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} zmm3 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX512VL-NEXT:    vpandnd %zmm3, %zmm2, %zmm4
; AVX512VL-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpandd %zmm3, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} zmm3 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX512BW-NEXT:    vpandnd %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpandd %zmm3, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} zmm3 = [31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31]
; AVX512VLBW-NEXT:    vpandnd %zmm3, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpandd %zmm3, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt)
  ret <16 x i32> %res
}

define <32 x i16> @var_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm6
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm6 = ymm6[0],zero,ymm6[1],zero,ymm6[2],zero,ymm6[3],zero,ymm6[4],zero,ymm6[5],zero,ymm6[6],zero,ymm6[7],zero,ymm6[8],zero,ymm6[9],zero,ymm6[10],zero,ymm6[11],zero,ymm6[12],zero,ymm6[13],zero,ymm6[14],zero,ymm6[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm5, %zmm6, %zmm5
; AVX512F-NEXT:    vpmovdw %zmm5, %ymm5
; AVX512F-NEXT:    vextracti64x4 $1, %zmm4, %ymm4
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm5, %zmm1
; AVX512F-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpsllvd %zmm3, %zmm4, %zmm3
; AVX512F-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm2
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm6
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm6 = ymm6[0],zero,ymm6[1],zero,ymm6[2],zero,ymm6[3],zero,ymm6[4],zero,ymm6[5],zero,ymm6[6],zero,ymm6[7],zero,ymm6[8],zero,ymm6[9],zero,ymm6[10],zero,ymm6[11],zero,ymm6[12],zero,ymm6[13],zero,ymm6[14],zero,ymm6[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm5, %zmm6, %zmm5
; AVX512VL-NEXT:    vpmovdw %zmm5, %ymm5
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm4, %ymm4
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm5, %zmm1
; AVX512VL-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm3, %zmm4, %zmm3
; AVX512VL-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm2
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm2 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm3, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VLBW-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt)
  ret <32 x i16> %res
}

define <64 x i8> @var_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $4, %ymm3, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpandnq %zmm7, %zmm2, %zmm8
; AVX512F-NEXT:    vextracti64x4 $1, %zmm8, %ymm9
; AVX512F-NEXT:    vpsllw $5, %ymm9, %ymm9
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $2, %ymm3, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm10 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512F-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm3, %ymm5
; AVX512F-NEXT:    vpand %ymm4, %ymm5, %ymm5
; AVX512F-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpsllw $5, %ymm8, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $2, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm4, %ymm5, %ymm4
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpsllw $4, %ymm3, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpandq %zmm7, %zmm2, %zmm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm6
; AVX512F-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpsllw $2, %ymm3, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm3, %ymm3, %ymm4
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512F-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $2, %ymm0, %ymm4
; AVX512F-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; AVX512F-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm3, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $4, %ymm3, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vmovdqa64 {{.*#+}} zmm7 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VL-NEXT:    vpandnq %zmm7, %zmm2, %zmm8
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm8, %ymm9
; AVX512VL-NEXT:    vpsllw $5, %ymm9, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $2, %ymm3, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm10 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512VL-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm4, %ymm5, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm8, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $2, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm4, %ymm5, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512VL-NEXT:    vpsllw $4, %ymm3, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm5 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpandq %zmm7, %zmm2, %zmm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm6
; AVX512VL-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw $2, %ymm3, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $2, %ymm0, %ymm4
; AVX512VL-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512BW-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512BW-NEXT:    vpsllw $5, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512BW-NEXT:    vpandq %zmm5, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw $4, %zmm1, %zmm6
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512BW-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsrlw $2, %zmm1, %zmm6
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm6
; AVX512BW-NEXT:    vpandq %zmm5, %zmm6, %zmm5
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm1 {%k1}
; AVX512BW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllw $5, %zmm2, %zmm2
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm3
; AVX512BW-NEXT:    vpmovb2m %zmm3, %k1
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k2
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k2}
; AVX512BW-NEXT:    vpsllw $2, %zmm0, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VBMI2-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VBMI2-NEXT:    vpsllw $5, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VBMI2-NEXT:    vpandq %zmm5, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm6
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpsrlw $2, %zmm1, %zmm6
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm6
; AVX512VBMI2-NEXT:    vpandq %zmm5, %zmm6, %zmm5
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm5, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpsllw $5, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm3
; AVX512VBMI2-NEXT:    vpmovb2m %zmm3, %k1
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k2
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k2}
; AVX512VBMI2-NEXT:    vpsllw $2, %zmm0, %zmm2
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VLBW-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpsllw $5, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VLBW-NEXT:    vpandq %zmm5, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm1, %zmm6
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512VLBW-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpsrlw $2, %zmm1, %zmm6
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm6
; AVX512VLBW-NEXT:    vpandq %zmm5, %zmm6, %zmm5
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm5, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllw $5, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm3
; AVX512VLBW-NEXT:    vpmovb2m %zmm3, %k1
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k2
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k2}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VLVBMI2-NEXT:    vpandnq %zmm3, %zmm2, %zmm4
; AVX512VLVBMI2-NEXT:    vpsllw $5, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VLVBMI2-NEXT:    vpandq %zmm5, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm6
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpsrlw $2, %zmm1, %zmm6
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm6, %zmm6
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm6, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm6
; AVX512VLVBMI2-NEXT:    vpandq %zmm5, %zmm6, %zmm5
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm5, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpandq %zmm3, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpsllw $5, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm3
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm3, %k1
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k2
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k2}
; AVX512VLVBMI2-NEXT:    vpsllw $2, %zmm0, %zmm2
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm2, %zmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt)
  ret <64 x i8> %res
}

;
; Uniform Variable Shifts
;

define <8 x i64> @splatvar_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = [63,63]
; AVX512F-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512F-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512F-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpsllq %xmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = [63,63]
; AVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512VL-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsllq %xmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [63,63]
; AVX512BW-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512BW-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpsllq %xmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm3 = [63,63]
; AVX512VLBW-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512VLBW-NEXT:    vpsrlq $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsllq %xmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <8 x i64> %amt, <8 x i64> undef, <8 x i32> zeroinitializer
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %splat)
  ret <8 x i64> %res
}

define <16 x i32> @splatvar_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512F-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512F-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512F-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero
; AVX512F-NEXT:    vpslld %xmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VL-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero
; AVX512VL-NEXT:    vpslld %xmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512BW-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512BW-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero
; AVX512BW-NEXT:    vpslld %xmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512VLBW-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VLBW-NEXT:    vpsrld $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero
; AVX512VLBW-NEXT:    vpslld %xmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <16 x i32> %amt, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %splat)
  ret <16 x i32> %res
}

define <32 x i16> @splatvar_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm5
; AVX512F-NEXT:    vpsrlw $1, %ymm5, %ymm5
; AVX512F-NEXT:    vpsrlw %xmm4, %ymm5, %ymm5
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm5, %zmm1, %zmm1
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; AVX512F-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm5
; AVX512VL-NEXT:    vpsrlw $1, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsrlw %xmm4, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw %xmm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm5, %zmm1, %zmm1
; AVX512VL-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512VL-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15]
; AVX512BW-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm2, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm3 = [15,15,15,15,15,15,15,15]
; AVX512VLBW-NEXT:    vpandn %xmm3, %xmm2, %xmm4
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <32 x i16> %amt, <32 x i16> undef, <32 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %splat)
  ret <32 x i16> %res
}

define <64 x i8> @splatvar_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm5 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpandn %xmm5, %xmm2, %xmm6
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,zero,zero,zero,zero,xmm6[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpsrlw %xmm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw %xmm6, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512F-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; AVX512F-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpsllw %xmm2, %xmm3, %xmm2
; AVX512F-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512F-NEXT:    vpandq %zmm2, %zmm0, %zmm2
; AVX512F-NEXT:    vpsrlw %xmm6, %xmm3, %xmm0
; AVX512F-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512F-NEXT:    vpbroadcastb %xmm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512F-NEXT:    vpternlogq $234, %zmm2, %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm3, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm5 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VL-NEXT:    vpandn %xmm5, %xmm2, %xmm6
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm6 = xmm6[0],zero,zero,zero,zero,zero,zero,zero,xmm6[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw %xmm6, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm1, %zmm1
; AVX512VL-NEXT:    vpand %xmm5, %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512VL-NEXT:    vpsllw %xmm2, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512VL-NEXT:    vpcmpeqd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpsllw %xmm2, %xmm3, %xmm2
; AVX512VL-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm2, %zmm2
; AVX512VL-NEXT:    vpandq %zmm2, %zmm0, %zmm2
; AVX512VL-NEXT:    vpsrlw %xmm6, %xmm3, %xmm0
; AVX512VL-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512VL-NEXT:    vpbroadcastb %xmm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; AVX512VL-NEXT:    vpternlogq $234, %zmm2, %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512BW-NEXT:    vpsllw %xmm4, %xmm5, %xmm4
; AVX512BW-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512BW-NEXT:    vpandq %zmm4, %zmm0, %zmm4
; AVX512BW-NEXT:    vpandn %xmm3, %xmm2, %xmm0
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw %xmm0, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw %xmm0, %xmm5, %xmm0
; AVX512BW-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512BW-NEXT:    vpbroadcastb %xmm0, %zmm0
; AVX512BW-NEXT:    vpternlogq $236, %zmm1, %zmm4, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VBMI2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VBMI2-NEXT:    vpsllw %xmm4, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VBMI2-NEXT:    vpsllw %xmm4, %xmm5, %xmm4
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VBMI2-NEXT:    vpandq %zmm4, %zmm0, %zmm4
; AVX512VBMI2-NEXT:    vpandn %xmm3, %xmm2, %xmm0
; AVX512VBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw %xmm0, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw %xmm0, %xmm5, %xmm0
; AVX512VBMI2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm0, %zmm0
; AVX512VBMI2-NEXT:    vpternlogq $236, %zmm1, %zmm4, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VLBW-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm4, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLBW-NEXT:    vpsllw %xmm4, %xmm5, %xmm4
; AVX512VLBW-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VLBW-NEXT:    vpandq %zmm4, %zmm0, %zmm4
; AVX512VLBW-NEXT:    vpandn %xmm3, %xmm2, %xmm0
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw %xmm0, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw %xmm0, %xmm5, %xmm0
; AVX512VLBW-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpbroadcastb %xmm0, %zmm0
; AVX512VLBW-NEXT:    vpternlogq $236, %zmm1, %zmm4, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vmovdqa {{.*#+}} xmm3 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VLVBMI2-NEXT:    vpand %xmm3, %xmm2, %xmm4
; AVX512VLVBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLVBMI2-NEXT:    vpsllw %xmm4, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLVBMI2-NEXT:    vpsllw %xmm4, %xmm5, %xmm4
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpandq %zmm4, %zmm0, %zmm4
; AVX512VLVBMI2-NEXT:    vpandn %xmm3, %xmm2, %xmm0
; AVX512VLVBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLVBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm0, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm0, %xmm5, %xmm0
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %xmm0, %xmm0
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm0, %zmm0
; AVX512VLVBMI2-NEXT:    vpternlogq $236, %zmm1, %zmm4, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %splat)
  ret <64 x i8> %res
}

;
; Constant Shifts
;

define <8 x i64> @constant_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvq {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvq {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> <i64 4, i64 14, i64 50, i64 60, i64 4, i64 14, i64 50, i64 60>)
  ret <8 x i64> %res
}

define <16 x i32> @constant_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvd {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvd {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>)
  ret <16 x i32> %res
}

define <32 x i16> @constant_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = <2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768,u>
; AVX512F-NEXT:    vpmulhuw %ymm3, %ymm2, %ymm4
; AVX512F-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1,2,3,4,5,6],ymm2[7],ymm4[8,9,10,11,12,13,14],ymm2[15]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmulhuw %ymm3, %ymm1, %ymm3
; AVX512F-NEXT:    vpblendw {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5,6],ymm1[7],ymm3[8,9,10,11,12,13,14],ymm1[15]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX512F-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = <2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768,u>
; AVX512VL-NEXT:    vpmulhuw %ymm3, %ymm2, %ymm4
; AVX512VL-NEXT:    vpblendw {{.*#+}} ymm2 = ymm4[0,1,2,3,4,5,6],ymm2[7],ymm4[8,9,10,11,12,13,14],ymm2[15]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmulhuw %ymm3, %ymm1, %ymm3
; AVX512VL-NEXT:    vpblendw {{.*#+}} ymm1 = ymm3[0,1,2,3,4,5,6],ymm1[7],ymm3[8,9,10,11,12,13,14],ymm1[15]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm1 = ymm3[0,1,2,3],ymm1[4,5,6,7]
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768]
; AVX512VL-NEXT:    vpmullw %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvw {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvw {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>)
  ret <32 x i16> %res
}

define <64 x i8> @constant_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm2, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512F-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $2, %ymm2, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm7
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; AVX512F-NEXT:    vpaddb %ymm7, %ymm7, %ymm8
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm3
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsllw $2, %ymm0, %ymm3
; AVX512F-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm7, %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb %ymm0, %ymm0, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm8, %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm3 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm2[8],ymm4[8],ymm2[9],ymm4[9],ymm2[10],ymm4[10],ymm2[11],ymm4[11],ymm2[12],ymm4[12],ymm2[13],ymm4[13],ymm2[14],ymm4[14],ymm2[15],ymm4[15],ymm2[24],ymm4[24],ymm2[25],ymm4[25],ymm2[26],ymm4[26],ymm2[27],ymm4[27],ymm2[28],ymm4[28],ymm2[29],ymm4[29],ymm2[30],ymm4[30],ymm2[31],ymm4[31]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [2,256,128,64,32,16,8,4,2,256,128,64,32,16,8,4]
; AVX512F-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[1],ymm4[1],ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[4],ymm4[4],ymm2[5],ymm4[5],ymm2[6],ymm4[6],ymm2[7],ymm4[7],ymm2[16],ymm4[16],ymm2[17],ymm4[17],ymm2[18],ymm4[18],ymm2[19],ymm4[19],ymm2[20],ymm4[20],ymm2[21],ymm4[21],ymm2[22],ymm4[22],ymm2[23],ymm4[23]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; AVX512F-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm7, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512F-NEXT:    vpackuswb %ymm5, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm4[8],ymm1[9],ymm4[9],ymm1[10],ymm4[10],ymm1[11],ymm4[11],ymm1[12],ymm4[12],ymm1[13],ymm4[13],ymm1[14],ymm4[14],ymm1[15],ymm4[15],ymm1[24],ymm4[24],ymm1[25],ymm4[25],ymm1[26],ymm4[26],ymm1[27],ymm4[27],ymm1[28],ymm4[28],ymm1[29],ymm4[29],ymm1[30],ymm4[30],ymm1[31],ymm4[31]
; AVX512F-NEXT:    vpmullw %ymm6, %ymm3, %ymm3
; AVX512F-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[1],ymm4[1],ymm1[2],ymm4[2],ymm1[3],ymm4[3],ymm1[4],ymm4[4],ymm1[5],ymm4[5],ymm1[6],ymm4[6],ymm1[7],ymm4[7],ymm1[16],ymm4[16],ymm1[17],ymm4[17],ymm1[18],ymm4[18],ymm1[19],ymm4[19],ymm1[20],ymm4[20],ymm1[21],ymm4[21],ymm1[22],ymm4[22],ymm1[23],ymm4[23]
; AVX512F-NEXT:    vpmullw %ymm7, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm2, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm5 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VL-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $2, %ymm2, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpaddb %ymm2, %ymm2, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm8
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsllw $2, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddb %ymm0, %ymm0, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm8, %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512VL-NEXT:    vpsrlw $1, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm3 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm2[8],ymm4[8],ymm2[9],ymm4[9],ymm2[10],ymm4[10],ymm2[11],ymm4[11],ymm2[12],ymm4[12],ymm2[13],ymm4[13],ymm2[14],ymm4[14],ymm2[15],ymm4[15],ymm2[24],ymm4[24],ymm2[25],ymm4[25],ymm2[26],ymm4[26],ymm2[27],ymm4[27],ymm2[28],ymm4[28],ymm2[29],ymm4[29],ymm2[30],ymm4[30],ymm2[31],ymm4[31]
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [2,256,128,64,32,16,8,4,2,256,128,64,32,16,8,4]
; AVX512VL-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm4[0],ymm2[1],ymm4[1],ymm2[2],ymm4[2],ymm2[3],ymm4[3],ymm2[4],ymm4[4],ymm2[5],ymm4[5],ymm2[6],ymm4[6],ymm2[7],ymm4[7],ymm2[16],ymm4[16],ymm2[17],ymm4[17],ymm2[18],ymm4[18],ymm2[19],ymm4[19],ymm2[20],ymm4[20],ymm2[21],ymm4[21],ymm2[22],ymm4[22],ymm2[23],ymm4[23]
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm7 = [2,4,8,16,32,64,128,256,2,4,8,16,32,64,128,256]
; AVX512VL-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm7, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpackuswb %ymm5, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm4[8],ymm1[9],ymm4[9],ymm1[10],ymm4[10],ymm1[11],ymm4[11],ymm1[12],ymm4[12],ymm1[13],ymm4[13],ymm1[14],ymm4[14],ymm1[15],ymm4[15],ymm1[24],ymm4[24],ymm1[25],ymm4[25],ymm1[26],ymm4[26],ymm1[27],ymm4[27],ymm1[28],ymm4[28],ymm1[29],ymm4[29],ymm1[30],ymm4[30],ymm1[31],ymm4[31]
; AVX512VL-NEXT:    vpmullw %ymm6, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsrlw $8, %ymm3, %ymm3
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm4[0],ymm1[1],ymm4[1],ymm1[2],ymm4[2],ymm1[3],ymm4[3],ymm1[4],ymm4[4],ymm1[5],ymm4[5],ymm1[6],ymm4[6],ymm1[7],ymm4[7],ymm1[16],ymm4[16],ymm1[17],ymm4[17],ymm1[18],ymm4[18],ymm1[19],ymm4[19],ymm1[20],ymm4[20],ymm1[21],ymm4[21],ymm1[22],ymm4[22],ymm1[23],ymm4[23]
; AVX512VL-NEXT:    vpmullw %ymm7, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vpsllw $2, %zmm0, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512BW-NEXT:    vpackuswb %zmm3, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VBMI2-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $2, %zmm0, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512VBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512VBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpackuswb %zmm3, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLBW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpackuswb %zmm3, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLVBMI2-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $2, %zmm0, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpaddb %zmm0, %zmm0, %zmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpunpckhbw {{.*#+}} zmm3 = zmm1[8],zmm2[8],zmm1[9],zmm2[9],zmm1[10],zmm2[10],zmm1[11],zmm2[11],zmm1[12],zmm2[12],zmm1[13],zmm2[13],zmm1[14],zmm2[14],zmm1[15],zmm2[15],zmm1[24],zmm2[24],zmm1[25],zmm2[25],zmm1[26],zmm2[26],zmm1[27],zmm2[27],zmm1[28],zmm2[28],zmm1[29],zmm2[29],zmm1[30],zmm2[30],zmm1[31],zmm2[31],zmm1[40],zmm2[40],zmm1[41],zmm2[41],zmm1[42],zmm2[42],zmm1[43],zmm2[43],zmm1[44],zmm2[44],zmm1[45],zmm2[45],zmm1[46],zmm2[46],zmm1[47],zmm2[47],zmm1[56],zmm2[56],zmm1[57],zmm2[57],zmm1[58],zmm2[58],zmm1[59],zmm2[59],zmm1[60],zmm2[60],zmm1[61],zmm2[61],zmm1[62],zmm2[62],zmm1[63],zmm2[63]
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0],zmm2[0],zmm1[1],zmm2[1],zmm1[2],zmm2[2],zmm1[3],zmm2[3],zmm1[4],zmm2[4],zmm1[5],zmm2[5],zmm1[6],zmm2[6],zmm1[7],zmm2[7],zmm1[16],zmm2[16],zmm1[17],zmm2[17],zmm1[18],zmm2[18],zmm1[19],zmm2[19],zmm1[20],zmm2[20],zmm1[21],zmm2[21],zmm1[22],zmm2[22],zmm1[23],zmm2[23],zmm1[32],zmm2[32],zmm1[33],zmm2[33],zmm1[34],zmm2[34],zmm1[35],zmm2[35],zmm1[36],zmm2[36],zmm1[37],zmm2[37],zmm1[38],zmm2[38],zmm1[39],zmm2[39],zmm1[48],zmm2[48],zmm1[49],zmm2[49],zmm1[50],zmm2[50],zmm1[51],zmm2[51],zmm1[52],zmm2[52],zmm1[53],zmm2[53],zmm1[54],zmm2[54],zmm1[55],zmm2[55]
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpackuswb %zmm3, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

;
; Uniform Constant Shifts
;

define <8 x i64> @splatconstant_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512F-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldq $14, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldq $14, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> <i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14>)
  ret <8 x i64> %res
}

define <16 x i32> @splatconstant_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512F-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512VL-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512BW-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldd $4, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldd $4, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>)
  ret <16 x i32> %res
}

define <32 x i16> @splatconstant_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlw $9, %ymm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512F-NEXT:    vpsrlw $9, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512F-NEXT:    vpsllw $7, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlw $9, %ymm1, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $9, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm2, %zmm1
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlw $9, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldw $7, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlw $9, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldw $7, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>)
  ret <32 x i16> %res
}

define <64 x i8> @splatconstant_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm2
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm0
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512BW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VLBW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <64 x i8> %res
}
