; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -stop-after=finalize-isel < %s | FileCheck %s

; This test makes sure we match FrameIndex into the base address.
; Done as a MIR test because eliminateFrameIndex will likely turn it
; back into an addi.

declare void @llvm.riscv.vse.nxv1i64(
  <vscale x 1 x i64>,
  <vscale x 1 x i64>*,
  i64);

define i64 @test(<vscale x 1 x i64> %0) nounwind {
  ; CHECK-LABEL: name: test
  ; CHECK: bb.0.entry:
  ; CHECK:   liveins: $v8
  ; CHECK:   [[COPY:%[0-9]+]]:vr = COPY $v8
  ; CHECK:   [[ADDI:%[0-9]+]]:gpr = ADDI $x0, 1
  ; CHECK:   dead %3:gpr = PseudoVSETIVLI 1, 88, implicit-def $vl, implicit-def $vtype
  ; CHECK:   PseudoVSE64_V_M1 [[COPY]], %stack.0.a, $noreg, -1, implicit $vl, implicit $vtype
  ; CHECK:   [[LD:%[0-9]+]]:gpr = LD %stack.0.a, 0 :: (dereferenceable load 8 from %ir.a)
  ; CHECK:   $x10 = COPY [[LD]]
  ; CHECK:   PseudoRET implicit $x10
entry:
  %a = alloca i64
  %b = bitcast i64* %a to <vscale x 1 x i64>*
  call void @llvm.riscv.vse.nxv1i64(
    <vscale x 1 x i64> %0,
    <vscale x 1 x i64>* %b,
    i64 1)
  %c = load i64, i64* %a
  ret i64 %c
}
