; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs  < %s 2>%t | FileCheck --check-prefix=CHECK --check-prefix=CHECK-SELDAG  %s
; RUN: llc -verify-machineinstrs -O0 < %s 2>%t | FileCheck --check-prefix=CHECK --check-prefix=CHECK-FASTISEL %s

; RUN: FileCheck --check-prefix=WARN --allow-empty %s <%t

; If this check fails please read test/CodeGen/AArch64/README for instructions on how to resolve it.
; WARN-NOT: warning


target triple = "aarch64-unknown-linux-gnu"

;
; VECTOR_REVERSE
;

define <16 x i8> @reverse_v16i8(<16 x i8> %a) #0 {
; CHECK-LABEL: .LCPI0_0:
; CHECK:        .byte   15                      // 0xf
; CHECK-NEXT:   .byte   14                      // 0xe
; CHECK-NEXT:   .byte   13                      // 0xd
; CHECK-NEXT:   .byte   12                      // 0xc
; CHECK-NEXT:   .byte   11                      // 0xb
; CHECK-NEXT:   .byte   10                      // 0xa
; CHECK-NEXT:   .byte   9                       // 0x9
; CHECK-NEXT:   .byte   8                       // 0x8
; CHECK-NEXT:   .byte   7                       // 0x7
; CHECK-NEXT:   .byte   6                       // 0x6
; CHECK-NEXT:   .byte   5                       // 0x5
; CHECK-NEXT:   .byte   4                       // 0x4
; CHECK-NEXT:   .byte   3                       // 0x3
; CHECK-NEXT:   .byte   2                       // 0x2
; CHECK-NEXT:   .byte   1                       // 0x1
; CHECK-NEXT:   .byte   0                       // 0x0
; CHECK-LABEL: reverse_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-NEXT:    ret

  %res = call <16 x i8> @llvm.experimental.vector.reverse.v16i8(<16 x i8> %a)
  ret <16 x i8> %res
}

define <8 x i16> @reverse_v8i16(<8 x i16> %a) #0 {
; CHECK-LABEL: .LCPI1_0:
; CHECK:        .byte   14                      // 0xe
; CHECK-NEXT:   .byte   15                      // 0xf
; CHECK-NEXT:   .byte   12                      // 0xc
; CHECK-NEXT:   .byte   13                      // 0xd
; CHECK-NEXT:   .byte   10                      // 0xa
; CHECK-NEXT:   .byte   11                      // 0xb
; CHECK-NEXT:   .byte   8                       // 0x8
; CHECK-NEXT:   .byte   9                       // 0x9
; CHECK-NEXT:   .byte   6                       // 0x6
; CHECK-NEXT:   .byte   7                       // 0x7
; CHECK-NEXT:   .byte   4                       // 0x4
; CHECK-NEXT:   .byte   5                       // 0x5
; CHECK-NEXT:   .byte   2                       // 0x2
; CHECK-NEXT:   .byte   3                       // 0x3
; CHECK-NEXT:   .byte   0                       // 0x0
; CHECK-NEXT:   .byte   1                       // 0x1
; CHECK-LABEL: reverse_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI1_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI1_0]
; CHECK-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-NEXT:    ret

  %res = call <8 x i16> @llvm.experimental.vector.reverse.v8i16(<8 x i16> %a)
  ret <8 x i16> %res
}

define <4 x i32> @reverse_v4i32(<4 x i32> %a) #0 {
; CHECK-LABEL: reverse_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev64 v0.4s, v0.4s
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    ret

  %res = call <4 x i32> @llvm.experimental.vector.reverse.v4i32(<4 x i32> %a)
  ret <4 x i32> %res
}

define <2 x i64> @reverse_v2i64(<2 x i64> %a) #0 {
; CHECK-LABEL: reverse_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    ret

  %res = call <2 x i64> @llvm.experimental.vector.reverse.v2i64(<2 x i64> %a)
  ret <2 x i64> %res
}

define <8 x half> @reverse_v8f16(<8 x half> %a) #0 {
; CHECK-LABEL: .LCPI4_0:
; CHECK:        .byte   14                      // 0xe
; CHECK-NEXT:   .byte   15                      // 0xf
; CHECK-NEXT:   .byte   12                      // 0xc
; CHECK-NEXT:   .byte   13                      // 0xd
; CHECK-NEXT:   .byte   10                      // 0xa
; CHECK-NEXT:   .byte   11                      // 0xb
; CHECK-NEXT:   .byte   8                       // 0x8
; CHECK-NEXT:   .byte   9                       // 0x9
; CHECK-NEXT:   .byte   6                       // 0x6
; CHECK-NEXT:   .byte   7                       // 0x7
; CHECK-NEXT:   .byte   4                       // 0x4
; CHECK-NEXT:   .byte   5                       // 0x5
; CHECK-NEXT:   .byte   2                       // 0x2
; CHECK-NEXT:   .byte   3                       // 0x3
; CHECK-NEXT:   .byte   0                       // 0x0
; CHECK-NEXT:   .byte   1                       // 0x1
; CHECK-LABEL: reverse_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI4_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI4_0]
; CHECK-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-NEXT:    ret

  %res = call <8 x half> @llvm.experimental.vector.reverse.v8f16(<8 x half> %a)
  ret <8 x half> %res
}

define <4 x float> @reverse_v4f32(<4 x float> %a) #0 {
; CHECK-LABEL: reverse_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev64 v0.4s, v0.4s
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    ret

  %res = call <4 x float> @llvm.experimental.vector.reverse.v4f32(<4 x float> %a)
  ret <4 x float> %res
}

define <2 x double> @reverse_v2f64(<2 x double> %a) #0 {
; CHECK-LABEL: reverse_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    ret

  %res = call <2 x double> @llvm.experimental.vector.reverse.v2f64(<2 x double> %a)
  ret <2 x double> %res
}

; Verify promote type legalisation works as expected.
define <2 x i8> @reverse_v2i8(<2 x i8> %a) #0 {
; CHECK-LABEL: reverse_v2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev64 v0.2s, v0.2s
; CHECK-NEXT:    ret

  %res = call <2 x i8> @llvm.experimental.vector.reverse.v2i8(<2 x i8> %a)
  ret <2 x i8> %res
}

; Verify splitvec type legalisation works as expected.
define <8 x i32> @reverse_v8i32(<8 x i32> %a) #0 {
; CHECK-LABEL: reverse_v8i32:
; CHECK-SELDAG:       // %bb.0:
; CHECK-SELDAG-NEXT:    rev64 v1.4s, v1.4s
; CHECK-SELDAG-NEXT:    rev64 v2.4s, v0.4s
; CHECK-SELDAG-NEXT:    ext v0.16b, v1.16b, v1.16b, #8
; CHECK-SELDAG-NEXT:    ext v1.16b, v2.16b, v2.16b, #8
; CHECK-SELDAG-NEXT:    ret
; CHECK-FASTISEL:       // %bb.0:
; CHECK-FASTISEL-NEXT:    sub    sp, sp, #16
; CHECK-FASTISEL-NEXT:    str    q1, [sp]
; CHECK-FASTISEL-NEXT:    mov    v1.16b, v0.16b
; CHECK-FASTISEL-NEXT:    ldr    q0, [sp]
; CHECK-FASTISEL-NEXT:    rev64    v0.4s, v0.4s
; CHECK-FASTISEL-NEXT:    ext    v0.16b, v0.16b, v0.16b, #8
; CHECK-FASTISEL-NEXT:    rev64    v1.4s, v1.4s
; CHECK-FASTISEL-NEXT:    ext    v1.16b, v1.16b, v1.16b, #8
; CHECK-FASTISEL-NEXT:    add    sp, sp, #16
; CHECK-FASTISEL-NEXT:    ret

  %res = call <8 x i32> @llvm.experimental.vector.reverse.v8i32(<8 x i32> %a)
  ret <8 x i32> %res
}

; Verify splitvec type legalisation works as expected.
define <16 x float> @reverse_v16f32(<16 x float> %a) #0 {
; CHECK-LABEL: reverse_v16f32:
; CHECK-SELDAG:       // %bb.0:
; CHECK-SELDAG-NEXT:    rev64 v3.4s, v3.4s
; CHECK-SELDAG-NEXT:    rev64 v2.4s, v2.4s
; CHECK-SELDAG-NEXT:    rev64 v4.4s, v1.4s
; CHECK-SELDAG-NEXT:    rev64 v5.4s, v0.4s
; CHECK-SELDAG-NEXT:    ext v0.16b, v3.16b, v3.16b, #8
; CHECK-SELDAG-NEXT:    ext v1.16b, v2.16b, v2.16b, #8
; CHECK-SELDAG-NEXT:    ext v2.16b, v4.16b, v4.16b, #8
; CHECK-SELDAG-NEXT:    ext v3.16b, v5.16b, v5.16b, #8
; CHECK-SELDAG-NEXT:    ret
; CHECK-FASTISEL:       // %bb.0:
; CHECK-FASTISEL-NEXT:    sub    sp, sp, #32
; CHECK-FASTISEL-NEXT:    str    q3, [sp, #16]
; CHECK-FASTISEL-NEXT:    str    q2, [sp]
; CHECK-FASTISEL-NEXT:    mov    v2.16b, v1.16b
; CHECK-FASTISEL-NEXT:    ldr    q1, [sp]
; CHECK-FASTISEL-NEXT:    mov    v3.16b, v0.16b
; CHECK-FASTISEL-NEXT:    ldr    q0, [sp, #16]
; CHECK-FASTISEL-NEXT:    rev64    v0.4s, v0.4s
; CHECK-FASTISEL-NEXT:    ext    v0.16b, v0.16b, v0.16b, #8
; CHECK-FASTISEL-NEXT:    rev64    v1.4s, v1.4s
; CHECK-FASTISEL-NEXT:    ext    v1.16b, v1.16b, v1.16b, #8
; CHECK-FASTISEL-NEXT:    rev64    v2.4s, v2.4s
; CHECK-FASTISEL-NEXT:    ext    v2.16b, v2.16b, v2.16b, #8
; CHECK-FASTISEL-NEXT:    rev64    v3.4s, v3.4s
; CHECK-FASTISEL-NEXT:    ext    v3.16b, v3.16b, v3.16b, #8
; CHECK-FASTISEL-NEXT:    add    sp, sp, #32
; CHECK-FASTISEL-NEXT:    ret

  %res = call <16 x float> @llvm.experimental.vector.reverse.v16f32(<16 x float> %a)
  ret <16 x float> %res
}


declare <2 x i8> @llvm.experimental.vector.reverse.v2i8(<2 x i8>)
declare <16 x i8> @llvm.experimental.vector.reverse.v16i8(<16 x i8>)
declare <8 x i16> @llvm.experimental.vector.reverse.v8i16(<8 x i16>)
declare <4 x i32> @llvm.experimental.vector.reverse.v4i32(<4 x i32>)
declare <8 x i32> @llvm.experimental.vector.reverse.v8i32(<8 x i32>)
declare <2 x i64> @llvm.experimental.vector.reverse.v2i64(<2 x i64>)
declare <8 x half> @llvm.experimental.vector.reverse.v8f16(<8 x half>)
declare <4 x float> @llvm.experimental.vector.reverse.v4f32(<4 x float>)
declare <16 x float> @llvm.experimental.vector.reverse.v16f32(<16 x float>)
declare <2 x double> @llvm.experimental.vector.reverse.v2f64(<2 x double>)

attributes #0 = { nounwind "target-features"="+neon" }
