//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// UNSUPPORTED: no-exceptions

// Compilers emit warnings about exceptions of type 'Child' being caught by
// an earlier handler of type 'Base'. Congrats, you've just diagnosed the
// behavior under test.
// ADDITIONAL_COMPILE_FLAGS: -Wno-exceptions

// The fix for PR17222 made it in the dylib for macOS 10.10
// XFAIL: stdlib=apple-libc++ && target={{.+}}-apple-macosx10.9

#include <cassert>
#include <stdint.h>

#if __cplusplus < 201103L
#define DISABLE_NULLPTR_TESTS
#endif

struct  A {};
A a;
const A ca = A();

void test1 ()
{
    try
    {
        throw &a;
        assert(false);
    }
    catch ( const A* )
    {
    }
    catch ( A *)
    {
        assert (false);
    }
}

void test2 ()
{
    try
     {
        throw &a;
        assert(false);
    }
    catch ( A* )
    {
    }
    catch ( const A *)
    {
         assert (false);
    }
}

void test3 ()
{
    try
    {
        throw &ca;
        assert(false);
    }
    catch ( const A* )
    {
    }
    catch ( A *)
    {
        assert (false);
    }
}

void test4 ()
{
    try
    {
        throw &ca;
        assert(false);
    }
    catch ( A *)
    {
        assert (false);
    }
    catch ( const A* )
    {
    }
}

struct base1 {int x;};
struct base2 {int x;};
struct derived : base1, base2 {};

void test5 ()
{
    try
    {
        throw (derived*)0;
        assert(false);
    }
    catch (base2 *p) {
        assert (p == 0);
    }
    catch (...)
    {
        assert (false);
    }
}

void test6 ()
{
#if !defined(DISABLE_NULLPTR_TESTS)
    try
    {
        throw nullptr;
        assert(false);
    }
    catch (base2 *p) {
        assert (p == nullptr);
    }
    catch (...)
    {
        assert (false);
    }
#endif
}

void test7 ()
{
    try
    {
        throw (derived*)12;
        assert(false);
    }
    catch (base2 *p) {
        assert ((uintptr_t)p == 12+sizeof(base1));
    }
    catch (...)
    {
        assert (false);
    }
}


struct vBase {};
struct vDerived : virtual public vBase {};

void test8 ()
{
    vDerived derived;
    try
    {
        throw &derived;
        assert(false);
    }
    catch (vBase *p) {
        assert(p != 0);
    }
    catch (...)
    {
        assert (false);
    }
}

void test9 ()
{
#if !defined(DISABLE_NULLPTR_TESTS)
    try
    {
        throw nullptr;
        assert(false);
    }
    catch (vBase *p) {
        assert(p == 0);
    }
    catch (...)
    {
        assert (false);
    }
#endif
}

void test10 ()
{
    try
    {
        throw (vDerived*)0;
        assert(false);
    }
    catch (vBase *p) {
        assert(p == 0);
    }
    catch (...)
    {
        assert (false);
    }
}

int main(int, char**)
{
    test1();
    test2();
    test3();
    test4();
    test5();
    test6();
    test7();
    test8();
    test9();
    test10();

    return 0;
}
