//===-- Implementation header for posix_spawn -------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIBC_SRC_SPAWN_POSIX_SPAWN_H
#define LLVM_LIBC_SRC_SPAWN_POSIX_SPAWN_H

#include <spawn.h>

namespace LIBC_NAMESPACE {

int posix_spawn(pid_t *__restrict pid, const char *__restrict path,
                const posix_spawn_file_actions_t *file_actions,
                const posix_spawnattr_t *__restrict attr,
                char *const *__restrict argv, char *const *__restrict envp);

} // namespace LIBC_NAMESPACE

#endif // LLVM_LIBC_SRC_SPAWN_POSIX_SPAWN_H
