; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+movdiri -mattr=+movdir64b | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i386-unknown-unknown -mattr=+movdiri -mattr=+movdir64b | FileCheck %s --check-prefix=X32

define void @test_movdiri(i8* %p, i32 %v) {
; X64-LABEL: test_movdiri:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movdiri %esi, (%rdi)
; X64-NEXT:    retq
;
; X32-LABEL: test_movdiri:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movdiri %eax, (%ecx)
; X32-NEXT:    retl
entry:
  call void @llvm.x86.directstore32(i8* %p, i32 %v)
  ret void
}

declare void @llvm.x86.directstore32(i8*, i32)

define void @test_movdir64b(i8* %dst, i8* %src) {
; X64-LABEL: test_movdir64b:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movdir64b (%rsi), %rdi
; X64-NEXT:    retq
;
; X32-LABEL: test_movdir64b:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movdir64b (%eax), %ecx
; X32-NEXT:    retl
entry:
  call void @llvm.x86.movdir64b(i8* %dst, i8* %src)
  ret void
}

declare void @llvm.x86.movdir64b(i8*, i8*)
