//===-- RegisterContextPOSIXCore_powerpc.h ----------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#ifndef liblldb_RegisterContextCorePOSIX_powerpc_h_
#define liblldb_RegisterContextCorePOSIX_powerpc_h_

// C Includes
// C++ Includes
// Other libraries and framework includes
// Project includes
#include "Plugins/Process/Utility/RegisterContextPOSIX_powerpc.h"
#include "lldb/Utility/DataExtractor.h"

class RegisterContextCorePOSIX_powerpc : public RegisterContextPOSIX_powerpc {
public:
  RegisterContextCorePOSIX_powerpc(
      lldb_private::Thread &thread,
      lldb_private::RegisterInfoInterface *register_info,
      const lldb_private::DataExtractor &gpregset,
      const lldb_private::DataExtractor &fpregset,
      const lldb_private::DataExtractor &vregset);

  ~RegisterContextCorePOSIX_powerpc() override;

  bool ReadRegister(const lldb_private::RegisterInfo *reg_info,
                    lldb_private::RegisterValue &value) override;

  bool WriteRegister(const lldb_private::RegisterInfo *reg_info,
                     const lldb_private::RegisterValue &value) override;

  bool ReadAllRegisterValues(lldb::DataBufferSP &data_sp) override;

  bool WriteAllRegisterValues(const lldb::DataBufferSP &data_sp) override;

  bool HardwareSingleStep(bool enable) override;

protected:
  bool ReadGPR() override;

  bool ReadFPR() override;

  bool ReadVMX() override;

  bool WriteGPR() override;

  bool WriteFPR() override;

  bool WriteVMX() override;

private:
  lldb::DataBufferSP m_gpr_buffer;
  lldb::DataBufferSP m_fpr_buffer;
  lldb::DataBufferSP m_vec_buffer;
  lldb_private::DataExtractor m_gpr;
  lldb_private::DataExtractor m_fpr;
  lldb_private::DataExtractor m_vec;
};

#endif // liblldb_RegisterContextCorePOSIX_powerpc_h_
