//=-- clang-modernize/Utility.h - Utility functions and macros---*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#ifndef CLANG_MODERNIZE_UNITTESTS_UTILITY_H
#define CLANG_MODERNIZE_UNITTESTS_UTILITY_H

// FIXME: copied from unittests/Support/Path.cpp
#define ASSERT_NO_ERROR(x)                                                     \
  if (llvm::error_code ASSERT_NO_ERROR_ec = x) {                               \
    llvm::SmallString<128> MessageStorage;                                     \
    llvm::raw_svector_ostream Message(MessageStorage);                         \
    Message << #x ": did not return errc::success.\n"                          \
            << "error number: " << ASSERT_NO_ERROR_ec.value() << "\n"          \
            << "error message: " << ASSERT_NO_ERROR_ec.message() << "\n";      \
    GTEST_FATAL_FAILURE_(MessageStorage.c_str());                              \
  } else {                                                                     \
  }

#endif // CLANG_MODERNIZE_UNITTESTS_UTILITY_H
