/* rep_hash:  Looks for duplicate files based on hashes.  Utilizes the output
   of the findhash command.

   Copyright (C) 2004-2007 by Brian Lindholm.
   This file is part of the littleutils utility set.

   The rep_hash utility is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 3, or (at your option) any later
   version.

   The rep_hash utility is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   the littleutils.  If not, see <https://www.gnu.org/licenses/>. */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef LINE_MAX
#define LINE_MAX 8192
#endif


static int
parse_three (char *line, char *field1, char *field2, char *field3)
{
  char *ptr;
  int i, n, rc;

  i = 0;
  rc = 0;
  ptr = strtok (line, "\t\n");
  while (ptr != NULL)
    {
      i++;
      switch (i)
        {
        case 1:
          n = (int) strlen (ptr);
          if (n > LINE_MAX - 1) n = LINE_MAX - 1;
          strncpy (field1, ptr, (size_t) n);
          field1[n] = (char) '\0';
          rc += 1;
          break;
        case 2:
          n = (int) strlen (ptr);
          if (n > LINE_MAX - 1) n = LINE_MAX - 1;
          strncpy (field2, ptr, (size_t) n);
          field2[n] = (char) '\0';
          rc += 2;
          break;
        case 3:
          n = (int) strlen (ptr);
          if (n > LINE_MAX - 1) n = LINE_MAX - 1;
          strncpy (field3, ptr, (size_t) n);
          field3[n] = (char) '\0';
          rc += 4;
          break;
        default:
          rc = 0;
        }
      ptr = strtok (NULL, "\t\n");
    }
  if (rc == 7)
    return (0);
  else
    return (1);
}


int
main (int argc, char *argv[])
{
  /* declare variables */

  FILE *infile;
  char *status, line[LINE_MAX];
  char item01[LINE_MAX], item02[LINE_MAX], item03[LINE_MAX];
  char item11[LINE_MAX], item12[LINE_MAX], item13[LINE_MAX];
  int rc = 0;

  /* open file or standard input */

  if (argc == 1)
    infile = stdin;
  else if ((infile = fopen (argv[1], "r")) == NULL)
    {
      fprintf (stderr, "rep_hash error: can't open %s!\n", argv[1]);
      return (1);
    }

  /* read in first two lines */

  status = fgets (line, LINE_MAX, infile);
  if ((status != NULL) && ((int) strlen (line) > 1) && (line[0] != '#'))
    rc = parse_three (line, item01, item02, item03);
  else
    rc = 1;
  if ((!feof (infile)) && (rc == 0))
    {
      status = fgets (line, LINE_MAX, infile);
      if ((status != NULL) && ((int) strlen (line) > 1) && (line[0] != '#'))
        rc = parse_three (line, item11, item12, item13);
      else
        rc = 1;
    }

  /* loop through file, comparing successive pairs of lines */

  while ((!feof (infile)) && (rc == 0))
    {
      if ((strncmp (item02, item12, LINE_MAX) == 0) &&
        (strncmp (item03, item13, LINE_MAX) == 0))
          fprintf (stdout, "%s\t%s\n", item01, item11);
      strncpy (item01, item11, LINE_MAX);
      strncpy (item02, item12, LINE_MAX);
      strncpy (item03, item13, LINE_MAX);
      status = fgets (line, LINE_MAX, infile);
      if ((status != NULL) && ((int) strlen (line) > 1) && (line[0] != '#'))
        rc = parse_three (line, item11, item12, item13);
      else
        rc = 1;
    }
  if ((rc == 0) && (strncmp(item02, item12, LINE_MAX) == 0) &&
    (strncmp (item03, item13, LINE_MAX) == 0))
      fprintf (stdout, "%s\t%s\n", item01, item11);

  /* close file */

  if (argc > 1)
    (void) fclose (infile);

  /* return proper exit code */

  if (rc == 3)
    return (0);
  else
    return (1);
}
