;;;; This file is part of LilyPond, the GNU music typesetter.
;;;;
;;;; Copyright (C) 2000--2023 Han-Wen Nienhuys <hanwen@xs4all.nl>
;;;; Jan Nieuwenhuizen <janneke@gnu.org>
;;;;
;;;; LilyPond is free software: you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or
;;;; (at your option) any later version.
;;;;
;;;; LilyPond is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with LilyPond.  If not, see <http://www.gnu.org/licenses/>.

;;; File entry point for generated documentation
;;; Running LilyPond on this file generates the documentation

;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;; TODO : make modules of these!
;;;;;;;;;;;;;;;;

;; todo: naming: grob vs. layout property

(use-modules (lily accreg) (ice-9 session))

;; TODO: Use the paper variable data not only for documentation but also to
;; check types of (built-in) variables during lookup.
(ly:load "define-paper-variables")

(for-each ly:load '("documentation-lib"
                    "lily-sort"
                    "document-functions"
                    "document-translation"
                    "document-music"
                    "document-type-predicates"
                    "document-identifiers"
                    "document-context-mods"
                    "document-backend"
                    "document-markup"
                    "document-paper-variables"
                    "document-outside-staff-priorities"
                    "document-paper-sizes"
                    "document-colors"
                    "hyphenate-internal-words"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;(display
;; (markup-doc-string)
;; (open-output-file "markup-commands.tely"))

(display
 ;; ugly hack to remove the @node... @appendixsec... portion
 (substring
  (call-with-output-string
   (lambda (port)
     (dump-node (markup-doc-node) port 2)))
  ;; magic number to remove the initial part.  63 comes from:
  ;; "\nnode Text markup commands\n@appendixsec Text markup commands\n\n\n\n"
  ;; which is generated by (dump-node...) in documentation-lib.scm
  63
  )
 (open-output-file "markup-commands.tely" #:encoding "UTF-8"))

(display
 (markup-list-doc-string)
 (open-output-file "markup-list-commands.tely" #:encoding "UTF-8"))

(display
 type-predicates-doc-string
 (open-output-file "type-predicates.tely" #:encoding "UTF-8"))

(display
 (identifiers-doc-string)
 (open-output-file "identifiers.tely" #:encoding "UTF-8"))

(display
 context-mods-doc-string
 (open-output-file "context-mod-identifiers.tely" #:encoding "UTF-8"))

(display
 outside-staff-priorities-doc-string
 (open-output-file "outside-staff-priorities.tely" #:encoding "UTF-8"))

(display
 paper-sizes-doc-string
 (open-output-file "paper-sizes.tely" #:encoding "UTF-8"))

(display
 ;; ugly hack to remove the @node... @appendixsec... portion
 (substring
  (call-with-output-string
   (lambda (port)
     (dump-node (paper-variables-doc-node) port 2)))
  ;; magic number to remove the initial part.  54 comes from:
  ;; "\nnode Paper variables\n@appendixsec Paper variables\n\n\n\n"
  ;; which is generated by (dump-node...) in documentation-lib.scm
  54
  )
 (open-output-file "paper-variables.tely" #:encoding "UTF-8"))

(display
 standard-colors-doc-string
 (open-output-file "standard-colors.tely" #:encoding "UTF-8"))
(display
 x11-unnumbered-colors-doc-string
 (open-output-file "x11-unnumbered-colors.tely" #:encoding "UTF-8"))
(display
 x11-colorN-doc-string
 (open-output-file "x11-colorN.tely" #:encoding "UTF-8"))
(display
 x11-grayN-doc-string
 (open-output-file "x11-grayN.tely" #:encoding "UTF-8"))
(display
 css-colors-doc-string
 (open-output-file "css-colors.tely" #:encoding "UTF-8"))
(display
 universal-colors-doc-string
 (open-output-file "universal-colors.tely" #:encoding "UTF-8"))

(display
 hyphenation-rules-string
 (open-output-file "hyphenation.itexi" #:encoding "UTF-8"))

(define file-name "internals")
(define outname (string-append file-name ".texi"))

(define out-port (open-output-file outname #:encoding "UTF-8"))

(writing-wip outname)

;; lilypond-main is compiled if the first arg is eq? 'files
(define bytecode-warning
  (if (eq? 'files
           (cadar
            (procedure-arguments
             (@ (lily) lilypond-main))))
      ""
      "

@cartouche

This copy of the Internals Reference identifies function
parameters (@pxref{Scheme functions}) only by positional names:
@var{a}, @var{b}, @var{c}, @enddots{}

For meaningful parameter names, generate bytecode before
generating the documentation.

@end cartouche

"))

(display
 (string-append
  "\\input texinfo @c -*-texinfo-*-\n"
  "@settitle LilyPond Internals Reference\n"
  "@documentencoding UTF-8\n"
  "@documentlanguage en\n"
  "@afourpaper\n"

  "@macro manualIntro
This manual is a technical reference for all internal elements used
by LilyPond and all Scheme functions it provides.  This information can
be used to create tweaks and extensions, from simple output settings
to advanced Scheme programming.
@end macro

@macro bytecodeWarning"
  bytecode-warning
  "
@end macro

@c `Internals Reference' was born 2000-10-21 with this commit:
@c patch::: 1.3.96.jcn9
@c author: Jan Nieuwenhuizen
@c commit: 8ecd09ad7514d57630fb611d38c161f3c3c708db
@c   file: scm/generate-documentation.scm

@macro copyrightDeclare
Copyright @copyright{} 2000--2023 by the authors
@end macro

@dircategory LilyPond -- the music typesetter
@direntry
* Internals: (lilypond-internals).    Tweaking reference.
@end direntry

@include en/macros.itexi
@iftex
@tableindent=@itemindent
@end iftex

@c   ***** Title page *****

@ifnottex")
 out-port)

(define top-node
  (make <texi-node>
    #:name "LilyPond -- Internals Reference"
    #:text
    (string-append "

@cartouche
@manualIntro{}
@end cartouche

@bytecodeWarning

@end ifnottex

@finalout

@titlepage
@title LilyPond
@subtitle The music typesetter
@titlefont{Internals Reference}
@author The LilyPond development team

@vskip 40pt

@cartouche
@manualIntro{}
@end cartouche

@vskip 10pt

@bytecodeWarning

@vskip 10pt

@docMain{}

@vskip 0pt plus 1filll

@copyrightDeclare

@quotation
Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1
or any later version published by the Free Software Foundation;
with no Invariant Sections.
@end quotation

For LilyPond version @version{}
@end titlepage

@ifnottex

@docMain
@end ifnottex

@contents

@ifhtml
@ifclear bigpage
This document is also available as a
@uref{../internals.pdf,PDF} and as
@uref{../internals-big-page.html,one big page}.
@end ifclear
@ifset bigpage
This document is also available as a
@uref{internals.pdf,PDF} and as a
@uref{internals/index.html,HTML indexed multiple pages}.
@end ifset
@end ifhtml")

    #:children
    (list
     (music-doc-node)
     (translation-doc-node)
     (backend-doc-node)
     (all-functions-doc)
     (make <texi-node>
       #:appendix #t
       #:name "Indices"
       #:text "
@node Concept index
@appendixsec Concept index

@printindex cp

@node Function index
@appendixsec Function index

@printindex fn

\n@bye"))))

(dump-node top-node out-port 0)
(newline (current-error-port))
