#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
function(ax_packaging_deb)
  find_program(DEBBUILD dpkg-buildpackage)
  if (DEBBUILD)
    set(DEBSOURCEPKGORIG ${PACKAGE}_$(VERSION).orig.tar)
    set(DEBSOURCEPKG ${DEBSOURCEPKGORIG}.gz)
    set(DEBSOURCEDIR ${PACKAGE}-${VERSION})
    set(TAR_DIR_NAME "${PROJECT_NAME}-${${PROJECT_NAME}_VERSION}")
    set(TAR_NAME "${TAR_DIR_NAME}.tar.gz")
    set(DEBPKGTESTDIR "${CMAKE_CURRENT_BINARY_DIR}/tdebian")
    add_custom_target(deb
		      COMMAND ${CMAKE_COMMAND} -E echo "Building Debian  package..."
		      COMMAND ${CMAKE_COMMAND} -E make_directory ${DEBPKGTESTDIR}
		      COMMAND ${CMAKE_COMMAND} -E chdir ${DEBPKGTESTDIR} tar xfz "${CMAKE_CURRENT_BINARY_DIR}/${TAR_NAME}"
		      COMMAND ${CMAKE_COMMAND} -E chdir "${DEBPKGTESTDIR}/${TAR_DIR_NAME}" ${DEBBUILD} -rfakeroot -D -us -uc -b
		      )
    add_dependencies(deb dist)
  else (DEBBUILD)
    add_custom_target(deb
		      COMMAND ${CMAKE_COMMAND} -E echo "This platform does not support building of debian packages")
  endif(DEBBUILD)
endfunction(ax_packaging_deb)