.\" zip_name_locate.mdoc \-- get index of file by name
.\" Copyright (C) 2003-2012 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_NAME_LOCATE 3 "July 21, 2012" NiH
.SH "NAME"
zip_name_locate \- get index of file by name
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
zip_int64_t
zip_name_locate(struct zip *archive, const char *fname, zip_flags_t flags);
.SH "DESCRIPTION"
The
zip_name_locate
function returns the index of the file named
\fBfname\fR
in
\fBarchive.\fR
If
\fBarchive\fR
does not contain a file with that name, \-1 is returned.
The
.Fa flags
are specified by
.I or'ing
the following values, or 0 for none of them.
.RS
.TP 15
\fBZIP_FL_NOCASE\fR
Ignore case distinctions.
(Will only work well if the file names are ASCII.)
.TP 15
\fBZIP_FL_NODIR\fR
Ignore directory part of file name in archive.
.TP 15
\fBZIP_FL_ENC_RAW\fR
Compare against the unmodified names as it is in the ZIP archive.
.TP 15
\fBZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the name in the ZIP archive and convert it
to UTF-8, if necessary, before comparing.
.TP 15
\fBZIP_FL_ENC_STRICT\fR
Follow the ZIP specification and expect CP-437 encoded names in
the ZIP archive (except if they are explicitly marked as UTF-8).
Convert it to UTF-8 before comparing.
.RE
.I Note:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
zip_name_locate
returns the index of the file named
\fBfname\fR
or \-1, if
\fBarchive\fR
does not contain an entry of that name.
.SH "ERRORS"
zip_name_locate
fails if:
.RS
.TP 4
[ZIP_ER_NOENT]
No entry of the name
\fBfname\fR
is found in the archive.
.TP 4
[ZIP_ER_INVAL]
One of the arguments is invalid.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_get_name(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
