#include <xdkwrl/script.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfimage.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>
#include <xdkwrl/fieldtypes/mfcolor.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfint32.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/mfrotation.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/mftime.h>
#include <xdkwrl/fieldtypes/mfvec2f.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>

#include <stdexcept>

using namespace std;
using namespace wrl;

template<class T>
static
const string&
ithKey(const map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::const_iterator fter = m.begin();
  advance(fter,i);
  return fter->first;
}
template<class T>
static
T*
ithValue(map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::iterator fter = m.begin();
  advance(fter,i);
  return &fter->second;
}
template<class T>
static
const T*
ithValue(const map<std::string,T>& m,unsigned int i)
{
  typename map<std::string,T>::const_iterator fter = m.begin();
  advance(fter,i);
  return &fter->second;
}
//************************************************************
// Implentation of Script
//************************************************************
/*! \class wrl::Script
 * \ingroup basetypes
 *
 */
Script::Script(const char* name)
  : DeclaredNode(name)
{
  directOutput = false;
  mustEvaluate = false;
}
Node::FieldHandle
Script::field(const std::string& n)
{
  if(n==std::string("url"))
  {
    return Node::field(n,mfString,(void*) &url);
  }
  if(n==std::string("directOutput"))
  {
    return Node::field(n,sfBool,(void*) &directOutput);
  }
  if(n==std::string("mustEvaluate"))
  {
    return Node::field(n,sfBool,(void*) &mustEvaluate);
  }
  return DeclaredNode::field(n);  
}
unsigned int
Script::nbFields() const
{
  return 3+DeclaredNode::nbFields();
}
Node::FieldHandle
Script::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("url",mfString,&url);
  case 1: return Node::field("directOutput",sfBool,&directOutput);
  case 2: return Node::field("mustEvaluate",sfBool,&mustEvaluate);
  }
  return DeclaredNode::field(n-3);
}
Node* 
Script::duplicate() const
{
  Script* n = new Script(name());
  n->url = url;
  n->directOutput = directOutput;
  n->mustEvaluate = mustEvaluate;
  
  n->sfBoolMap_     = sfBoolMap_;    
  n->sfColorMap_    = sfColorMap_;   
  n->sfFloatMap_    = sfFloatMap_;   
  n->sfImageMap_    = sfImageMap_;   
  n->sfInt32Map_    = sfInt32Map_;   
  n->sfNodeMap_     = sfNodeMap_;    
  n->sfRotationMap_ = sfRotationMap_;        
  n->sfStringMap_   = sfStringMap_;  
  n->sfTimeMap_     = sfTimeMap_;    
  n->sfVec2fMap_    = sfVec2fMap_;   
  n->sfVec3fMap_    = sfVec3fMap_;   
  n->mfColorMap_    = mfColorMap_;   
  n->mfFloatMap_    = mfFloatMap_;   
  n->mfInt32Map_    = mfInt32Map_;   
  n->mfNodeMap_     = mfNodeMap_;    
  n->mfRotationMap_ = mfRotationMap_; 
  n->mfStringMap_   = mfStringMap_   ;
  n->mfTimeMap_     = mfTimeMap_;     
  n->mfVec2fMap_    = mfVec2fMap_;   
  n->mfVec3fMap_    = mfVec3fMap_;
  return n;
}
Node* 
Script::duplicate(std::map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  return nodeMap[this] = duplicate();
}
bool
Script::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool directOutputDV_(false);
  static const SFBool mustEvaluateDV_(false);
  switch (i)
  {
  case 1: return directOutput == directOutputDV_;
  case 2: return mustEvaluate == mustEvaluateDV_;
  }
  // TODO: check that there can be a default value for declared fields.
  return false;
}
bool
Script::isDeclaredField(const string& n) const
{
  if ((n==std::string("url")) ||
      (n==std::string("directOutput")) ||
      (n==std::string("mustEvaluate")))
  {
    return false;
  }
  return DeclaredNode::isDeclaredField(n);
}
bool
Script::isDeclaredField(unsigned int i) const
{  
  return i<3?false:DeclaredNode::isDeclaredField(i-3);
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../include/xdkwrl/")
// End:
