#ifndef INC_vrml97parser_hpp_
#define INC_vrml97parser_hpp_

#include <antlr/config.hpp>
/* $ANTLR 2.7.7 (20070104): "vrml97.g" -> "vrml97parser.hpp"$ */
#include <antlr/TokenStream.hpp>
#include <antlr/TokenBuffer.hpp>
#include "vrml97parserTokenTypes.hpp"
#include <antlr/LLkParser.hpp>

#line 2 "vrml97.g"

#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfcolor.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfimage.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>
#include <xdkwrl/fieldtypes/mfcolor.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfint32.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/mfrotation.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/mftime.h>
#include <xdkwrl/fieldtypes/mfvec2f.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>
#include <xdkwrl/proto.h>
#include <xdkwrl/script.h>
#include <iostream>
#include <string>
#include <stack>
#include <map>

#line 41 "vrml97parser.hpp"
class CUSTOM_API vrml97parser : public ANTLR_USE_NAMESPACE(antlr)LLkParser, public vrml97parserTokenTypes
{
#line 228 "vrml97.g"

    public:
    void setVerbose(bool b) { verbose_ = b; }
    bool verbose() const { return verbose_; }
    template <class O>
    O getParsedNodes(O o) const
        {
            if (mfNodeBufferStack.empty())
                {
                    return o;
                }
            for (wrl::MFNode::const_iterator
                     iter = mfNodeBufferStack.top().begin();
                 iter != mfNodeBufferStack.top().end();++iter)
                {
                    *o++ = *iter;
                }
            return o;
        }
    template <class O>
    O getParsedProtos(O o) const
        {
            for (std::deque<wrl::ProtoDeclaration*>::const_iterator
                     iter = protos.begin();
                 iter != protos.end();++iter)
                {
                    *o++ = *iter;
                }
            return o;
        }
    template <class O>
    O getParsedExternProtos(O o) const
        {
            for (std::deque<wrl::ExternProtoDeclaration*>::const_iterator
                     iter = externProtos.begin();
                 iter != externProtos.end();++iter)
                {
                    *o++ = *iter;
                }
            return o;
        }
    public:
    inline bool sfboolParsed()     { return currentHandle().fieldTypeId() == wrl::sfBool; }
    inline bool sfcolorParsed()    { return currentHandle().fieldTypeId() == wrl::sfColor; }
    inline bool sffloatParsed()    { return currentHandle().fieldTypeId() == wrl::sfFloat; }
    inline bool sfimageParsed()    { return currentHandle().fieldTypeId() == wrl::sfImage; }
    inline bool sfint32Parsed()    { return currentHandle().fieldTypeId() == wrl::sfInt32; }
    inline bool sfnodeParsed()     { return currentHandle().fieldTypeId() == wrl::sfNode; }
    inline bool sfrotationParsed() { return currentHandle().fieldTypeId() == wrl::sfRotation; }
    inline bool sfstringParsed()   { return currentHandle().fieldTypeId() == wrl::sfString; }
    inline bool sftimeParsed()     { return currentHandle().fieldTypeId() == wrl::sfTime; }
    inline bool sfvec2fParsed()    { return currentHandle().fieldTypeId() == wrl::sfVec2f; }
    inline bool sfvec3fParsed()    { return currentHandle().fieldTypeId() == wrl::sfVec3f; }
    inline bool mfcolorParsed()    { return currentHandle().fieldTypeId() == wrl::mfColor; }
    inline bool mffloatParsed()    { return currentHandle().fieldTypeId() == wrl::mfFloat; }
    inline bool mfint32Parsed()    { return currentHandle().fieldTypeId() == wrl::mfInt32; }
    inline bool mfnodeParsed()     { return currentHandle().fieldTypeId() == wrl::mfNode; }
    inline bool mfrotationParsed() { return currentHandle().fieldTypeId() == wrl::mfRotation; }
    inline bool mfstringParsed()   { return currentHandle().fieldTypeId() == wrl::mfString; }
    inline bool mfvec2fParsed()    { return currentHandle().fieldTypeId() == wrl::mfVec2f; }
    inline bool mfvec3fParsed()    { return currentHandle().fieldTypeId() == wrl::mfVec3f; }
    wrl::MFColor    mfColorBuffer;
    wrl::MFFloat    mfFloatBuffer;
    wrl::MFInt32    mfInt32Buffer;
    wrl::MFNode     mfNodeBuffer;
    wrl::MFRotation mfRotationBuffer;
    wrl::MFString   mfStringBuffer;
    wrl::MFVec2f    mfVec2fBuffer;
    wrl::MFVec3f    mfVec3fBuffer;
    // We must do a special case for node list because we might have
    // recursion so we must use a stack. See mfnodeValue rule and
    // nodeStatement for explanations.
    std::stack<wrl::MFNode> mfNodeBufferStack;
    // For the same reason we must have a stack of node handle
    std::stack<wrl::Node::FieldHandle> handleStack;
    // And a proto stack
    std::stack<wrl::ProtoDeclaration*> protoStack;
    // And a script stack
    std::stack<wrl::Script*> scriptStack;    
    // We define some function to simplify access to this current elements.
    inline wrl::Node* currentNode() { return mfNodeBufferStack.top().back(); }
    inline wrl::Node::FieldHandle& currentHandle() { return handleStack.top(); }
    inline size_t depth() { return mfNodeBufferStack.size(); }
    // This stores nodes for DEF/USE statements
    std::map<std::string,wrl::Node*> definedNodes;    
    // This stores proto definitions
    std::map<std::string,wrl::ProtoDeclaration*> declaredProtos;    
    std::deque<wrl::ProtoDeclaration*> protos;    
    std::deque<wrl::ExternProtoDeclaration*> externProtos;    
    // This function is on important piece: it uses standard nodes
    // knowledge and proto definitions to parse nodes.
    wrl::Node* nodeFromTypeId(const std::string& t);
    // We also need a stack to know wether we parse a PROTO or a Script
    std::stack<int> modeStack_;
    private:
    bool verbose_;
#line 45 "vrml97parser.hpp"
public:
	void initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory );
protected:
	vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k);
public:
	vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf);
protected:
	vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k);
public:
	vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer);
	vrml97parser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state);
	int getNumTokens() const
	{
		return vrml97parser::NUM_TOKENS;
	}
	const char* getTokenName( int type ) const
	{
		if( type > getNumTokens() ) return 0;
		return vrml97parser::tokenNames[type];
	}
	const char* const* getTokenNames() const
	{
		return vrml97parser::tokenNames;
	}
	public: void parseScene();
	public: void statements();
	public: void statement();
	public: void nodeStatement();
	public: void protoStatement();
	public: void routeStatement();
	public: void node();
	public: std::string  nodeNameId();
	public: void rootNodeStatement();
	public: void proto();
	public: void externproto();
	public: void protoStatements();
	public: std::string  nodeTypeId();
	public: void interfaceDeclarations();
	public: void protoBody();
	public: void interfaceDeclaration();
	public: void restrictedInterfaceDeclaration();
	public: wrl::FieldTypeId  fieldType();
	public: std::string  eventInId();
	public: std::string  eventOutId();
	public: std::string  fieldId();
	public: void fieldValue();
	public: void externInterfaceDeclarations();
	public: void mfstringValue();
	public: void externInterfaceDeclaration();
	public: void nodeBody();
	public: void scriptBody();
	public: void nodeBodyElement();
	public: void scriptBodyElement();
	public: wrl::SFBool  sfboolValue();
	public: wrl::SFColor  sfcolorValue();
	public: wrl::SFFloat  sffloatValue();
	public: wrl::SFImage  sfimageValue();
	public: wrl::SFInt32  sfint32Value();
	public: wrl::SFNode  sfnodeValue();
	public: wrl::SFRotation  sfrotationValue();
	public: wrl::SFString  sfstringValue();
	public: wrl::SFTime  sftimeValue();
	public: wrl::SFVec2f  sfvec2fValue();
	public: wrl::SFVec3f  sfvec3fValue();
	public: void mfcolorValue();
	public: void mffloatValue();
	public: void mfint32Value();
	public: void mfnodeValue();
	public: void mfrotationValue();
	public: void mfvec2fValue();
	public: void mfvec3fValue();
	public: float  floatv();
	public: int  int32();
	public: std::string  stringv();
public:
	ANTLR_USE_NAMESPACE(antlr)RefAST getAST()
	{
		return returnAST;
	}
	
protected:
	ANTLR_USE_NAMESPACE(antlr)RefAST returnAST;
private:
	static const char* tokenNames[];
#ifndef NO_STATIC_CONSTS
	static const int NUM_TOKENS = 60;
#else
	enum {
		NUM_TOKENS = 60
	};
#endif
	
	static const unsigned long _tokenSet_0_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_0;
	static const unsigned long _tokenSet_1_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_1;
	static const unsigned long _tokenSet_2_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_2;
	static const unsigned long _tokenSet_3_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_3;
	static const unsigned long _tokenSet_4_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_4;
	static const unsigned long _tokenSet_5_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_5;
	static const unsigned long _tokenSet_6_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_6;
	static const unsigned long _tokenSet_7_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_7;
	static const unsigned long _tokenSet_8_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_8;
	static const unsigned long _tokenSet_9_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_9;
	static const unsigned long _tokenSet_10_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_10;
	static const unsigned long _tokenSet_11_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_11;
	static const unsigned long _tokenSet_12_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_12;
	static const unsigned long _tokenSet_13_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_13;
	static const unsigned long _tokenSet_14_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_14;
	static const unsigned long _tokenSet_15_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_15;
	static const unsigned long _tokenSet_16_data_[];
	static const ANTLR_USE_NAMESPACE(antlr)BitSet _tokenSet_16;
};

#endif /*INC_vrml97parser_hpp_*/
