/* $ANTLR 2.7.7 (20070104): "vrml97.g" -> "vrml97parser.cpp"$ */
#include "vrml97parser.hpp"
#include <antlr/NoViableAltException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/ASTFactory.hpp>
#line 42 "vrml97.g"

#include <xdkwrl/nodes/anchor.h>
#include <xdkwrl/nodes/appearance.h>
#include <xdkwrl/nodes/audioclip.h>
#include <xdkwrl/nodes/background.h>
#include <xdkwrl/nodes/billboard.h>
#include <xdkwrl/nodes/box.h>
#include <xdkwrl/nodes/collision.h>
#include <xdkwrl/nodes/color.h>
#include <xdkwrl/nodes/colorinterpolator.h>
#include <xdkwrl/nodes/cone.h>
#include <xdkwrl/nodes/contour2d.h>
#include <xdkwrl/nodes/coordinatedeformer.h>
#include <xdkwrl/nodes/coordinate.h>
#include <xdkwrl/nodes/coordinateinterpolator.h>
#include <xdkwrl/nodes/cylinder.h>
#include <xdkwrl/nodes/cylindersensor.h>
#include <xdkwrl/nodes/directionallight.h>
#include <xdkwrl/nodes/elevationgrid.h>
#include <xdkwrl/nodes/extrusion.h>
#include <xdkwrl/nodes/fog.h>
#include <xdkwrl/nodes/fontstyle.h>
#include <xdkwrl/nodes/geocoordinate.h>
#include <xdkwrl/nodes/geoelevationgrid.h>
#include <xdkwrl/nodes/geolocation.h>
#include <xdkwrl/nodes/geolod.h>
#include <xdkwrl/nodes/geometadata.h>
#include <xdkwrl/nodes/geoorigin.h>
#include <xdkwrl/nodes/geopositioninterpolator.h>
#include <xdkwrl/nodes/geotouchsensor.h>
#include <xdkwrl/nodes/geoviewpoint.h>
#include <xdkwrl/nodes/group.h>
#include <xdkwrl/nodes/imagetexture.h>
#include <xdkwrl/nodes/indexedfaceset.h>
#include <xdkwrl/nodes/indexedlineset.h>
#include <xdkwrl/nodes/inline.h>
#include <xdkwrl/nodes/inlineloadcontrol.h>
#include <xdkwrl/nodes/lod.h>
#include <xdkwrl/nodes/material.h>
#include <xdkwrl/nodes/movietexture.h>
#include <xdkwrl/nodes/navigationinfo.h>
#include <xdkwrl/nodes/normal.h>
#include <xdkwrl/nodes/normalinterpolator.h>
#include <xdkwrl/nodes/nurbscurve2d.h>
#include <xdkwrl/nodes/nurbscurve.h>
#include <xdkwrl/nodes/nurbsgroup.h>
#include <xdkwrl/nodes/nurbspositioninterpolator.h>
#include <xdkwrl/nodes/nurbssurface.h>
#include <xdkwrl/nodes/nurbstexturesurface.h>
#include <xdkwrl/nodes/orientationinterpolator.h>
#include <xdkwrl/nodes/pixeltexture.h>
#include <xdkwrl/nodes/planesensor.h>
#include <xdkwrl/nodes/pointlight.h>
#include <xdkwrl/nodes/pointset.h>
#include <xdkwrl/nodes/polyline2d.h>
#include <xdkwrl/nodes/positioninterpolator.h>
#include <xdkwrl/nodes/proximitysensor.h>
#include <xdkwrl/nodes/scalarinterpolator.h>
#include <xdkwrl/nodes/shape.h>
#include <xdkwrl/nodes/sound.h>
#include <xdkwrl/nodes/sphere.h>
#include <xdkwrl/nodes/spheresensor.h>
#include <xdkwrl/nodes/spotlight.h>
#include <xdkwrl/nodes/switch.h>
#include <xdkwrl/nodes/text.h>
#include <xdkwrl/nodes/texturecoordinate.h>
#include <xdkwrl/nodes/texturetransform.h>
#include <xdkwrl/nodes/timesensor.h>
#include <xdkwrl/nodes/touchsensor.h>
#include <xdkwrl/nodes/transform.h>
#include <xdkwrl/nodes/trimmedsurface.h>
#include <xdkwrl/nodes/viewpoint.h>
#include <xdkwrl/nodes/visibilitysensor.h>
#include <xdkwrl/nodes/worldinfo.h>

#include <stack>
#include <sstream>
#include <map>

using namespace std;
using namespace wrl;

static int PROTO_MODE = 0;
static int SCRIPT_MODE = 1;

/*! \class vrml97lexer
* \ingroup parser
*/
/*! \class vrml97parser
* \ingroup parser
*/
Node* vrml97parser::nodeFromTypeId(const string& t)
{
if (t==string("Anchor")) return new Anchor;
if (t==string("Appearance")) return new Appearance;
if (t==string("AudioClip")) return new AudioClip;
if (t==string("Background")) return new Background;
if (t==string("Billboard")) return new Billboard;
if (t==string("Box")) return new Box;
if (t==string("Collision")) return new Collision;
if (t==string("Color")) return new Color;
if (t==string("ColorInterpolator")) return new ColorInterpolator;
if (t==string("Cone")) return new Cone;
if (t==string("Contour2D")) return new Contour2D;
if (t==string("Coordinate")) return new Coordinate;
if (t==string("CoordinateDeformer")) return new CoordinateDeformer;
if (t==string("CoordinateInterpolator")) return new CoordinateInterpolator;
if (t==string("Cylinder")) return new Cylinder;
if (t==string("CylinderSensor")) return new CylinderSensor;
if (t==string("DirectionalLight")) return new DirectionalLight;
if (t==string("ElevationGrid")) return new ElevationGrid;
if (t==string("Extrusion")) return new Extrusion;
if (t==string("Fog")) return new Fog;
if (t==string("FontStyle")) return new FontStyle;
if (t==string("GeoCoordinate")) return new GeoCoordinate;
if (t==string("GeoElevationGrid")) return new GeoElevationGrid;
if (t==string("GeoLocation")) return new GeoLocation;
if (t==string("GeoLOD")) return new GeoLOD;
if (t==string("GeoMetadata")) return new GeoMetadata;
if (t==string("GeoOrigin")) return new GeoOrigin;
if (t==string("GeoPositionInterpolator")) return new GeoPositionInterpolator;
if (t==string("GeoTouchSensor")) return new GeoTouchSensor;
if (t==string("GeoViewpoint")) return new GeoViewpoint;
if (t==string("Group")) return new Group;
if (t==string("ImageTexture")) return new ImageTexture;
if (t==string("IndexedFaceSet")) return new IndexedFaceSet;
if (t==string("IndexedLineSet")) return new IndexedLineSet;
if (t==string("Inline")) return new Inline;
if (t==string("InlineLoadControl")) return new InlineLoadControl;
if (t==string("LOD")) return new LOD;
if (t==string("Material")) return new Material;
if (t==string("MovieTexture")) return new MovieTexture;
if (t==string("NavigationInfo")) return new NavigationInfo;
if (t==string("Normal")) return new Normal;
if (t==string("NormalInterpolator")) return new NormalInterpolator;
if (t==string("NurbsCurve2D")) return new NurbsCurve2D;
if (t==string("NurbsCurve")) return new NurbsCurve;
if (t==string("NurbsGroup")) return new NurbsGroup;
if (t==string("NurbsPositionInterpolator")) return new NurbsPositionInterpolator;
if (t==string("NurbsSurface")) return new NurbsSurface;
if (t==string("NurbsTextureSurface")) return new NurbsTextureSurface;
if (t==string("OrientationInterpolator")) return new OrientationInterpolator;
if (t==string("PixelTexture")) return new PixelTexture;
if (t==string("PlaneSensor")) return new PlaneSensor;
if (t==string("PointLight")) return new PointLight;
if (t==string("PointSet")) return new PointSet;
if (t==string("Polyline2D")) return new Polyline2D;
if (t==string("PositionInterpolator")) return new PositionInterpolator;
if (t==string("ProximitySensor")) return new ProximitySensor;
if (t==string("ScalarInterpolator")) return new ScalarInterpolator;
// The script node is not recognized here but in script rule
if (t==string("Shape")) return new Shape;
if (t==string("Sound")) return new Sound;
if (t==string("Sphere")) return new Sphere;
if (t==string("SphereSensor")) return new SphereSensor;
if (t==string("SpotLight")) return new SpotLight;
if (t==string("Switch")) return new Switch;
if (t==string("Text")) return new Text;
if (t==string("TextureCoordinate")) return new TextureCoordinate;
if (t==string("TextureTransform")) return new TextureTransform;
if (t==string("TimeSensor")) return new TimeSensor;
if (t==string("TouchSensor")) return new TouchSensor;
if (t==string("Transform")) return new Transform;
if (t==string("TrimmedSurface")) return new TrimmedSurface;
if (t==string("Viewpoint")) return new Viewpoint;
if (t==string("VisibilitySensor")) return new VisibilitySensor;
if (t==string("WorldInfo")) return new WorldInfo;
// Now it is time to check for protos
map<string,ProtoDeclaration*>::const_iterator fter =
declaredProtos.find(t);
if (fter != declaredProtos.end())
{
return new ProtoInstance(fter->second);
}
return NULL;
}

#line 185 "vrml97parser.cpp"
vrml97parser::vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,k)
{
}

vrml97parser::vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,5)
{
}

vrml97parser::vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,k)
{
}

vrml97parser::vrml97parser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,5)
{
}

vrml97parser::vrml97parser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(state,5)
{
}

void vrml97parser::parseScene() {
#line 328 "vrml97.g"
	
	// We must ensure that there is somewhere where to put the created
	// nodes.
	if (mfNodeBufferStack.empty())
	{
	mfNodeBufferStack.push(MFNode());
	}
	// We think defined nodes are valid only per parsing of a
	// scene. Thus we clean it here. Same thing for protos.
	definedNodes.clear();
	declaredProtos.clear();
	protos.clear();
	externProtos.clear();
	
#line 227 "vrml97parser.cpp"
	
	match(HEADER);
	statements();
}

void vrml97parser::statements() {
	
	{ // ( ... )*
	for (;;) {
		if ((_tokenSet_0.member(LA(1)))) {
			statement();
		}
		else {
			goto _loop4;
		}
		
	}
	_loop4:;
	} // ( ... )*
}

void vrml97parser::statement() {
	
	switch ( LA(1)) {
	case LITERAL_DEF:
	case LITERAL_USE:
	case LITERAL_Script:
	case Id:
	{
		nodeStatement();
		break;
	}
	case LITERAL_PROTO:
	case LITERAL_EXTERNPROTO:
	{
		protoStatement();
		break;
	}
	case LITERAL_ROUTE:
	{
		routeStatement();
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::nodeStatement() {
#line 368 "vrml97.g"
	
	string n0,n1;
	
#line 283 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_Script:
	case Id:
	{
		node();
		break;
	}
	case LITERAL_DEF:
	{
		match(LITERAL_DEF);
		n0=nodeNameId();
		node();
#line 374 "vrml97.g"
		
		currentNode()->setName(n0.c_str());
		definedNodes[n0] = currentNode();
		
#line 302 "vrml97parser.cpp"
		break;
	}
	case LITERAL_USE:
	{
		match(LITERAL_USE);
		n1=nodeNameId();
#line 379 "vrml97.g"
		
		// Search if n1 is defined
		map<string,Node*>::const_iterator fter = definedNodes.find(n1);
		if (fter == definedNodes.end())
		{
		ostringstream s;
		s<<"Undefined node "<<n1<<ends;
		int l = LT(1)->getLine();
		int c = LT(1)->getColumn();
		throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);                
		}
		mfNodeBufferStack.top().push_back(SFNode(fter->second));
		
#line 323 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::protoStatement() {
	
	switch ( LA(1)) {
	case LITERAL_PROTO:
	{
		proto();
		break;
	}
	case LITERAL_EXTERNPROTO:
	{
		externproto();
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::routeStatement() {
#line 731 "vrml97.g"
	
	string no;
	string eo;
	string ni;
	string ei;
	
#line 361 "vrml97parser.cpp"
	
	match(LITERAL_ROUTE);
	no=nodeNameId();
	match(DOT);
	eo=eventOutId();
	match(LITERAL_TO);
	ni=nodeNameId();
	match(DOT);
	ei=eventInId();
}

void vrml97parser::node() {
#line 751 "vrml97.g"
	
	string t;
	
#line 378 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case Id:
	{
		t=nodeTypeId();
#line 756 "vrml97.g"
		
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+node ["<<t<<"]"<<endl;
		}
		Node* node = nodeFromTypeId(t);
		if (node == NULL)
		{
		ostringstream s;
		s<<"Unknown typeId ["<<t<<"]"<<ends;
		int l = LT(1)->getLine();
		int c = LT(1)->getColumn();
		throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);
		}
		mfNodeBufferStack.top().push_back(SFNode(node));
		
#line 402 "vrml97parser.cpp"
		match(LBRACE);
		nodeBody();
		match(RBRACE);
#line 774 "vrml97.g"
		
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(2*depth(),' ')<<"-node ["
		<<currentNode()->typeName()<<"]"<<endl;
		}
		
#line 414 "vrml97parser.cpp"
		break;
	}
	case LITERAL_Script:
	{
		match(LITERAL_Script);
#line 782 "vrml97.g"
		
		Script* node = new Script;
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+script"<<endl;
		}
		mfNodeBufferStack.top().push_back(SFNode(node));
		scriptStack.push(node);
		modeStack_.push(SCRIPT_MODE);
		
#line 432 "vrml97parser.cpp"
		match(LBRACE);
		scriptBody();
		match(RBRACE);
#line 796 "vrml97.g"
		
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(2*depth(),' ')<<"-script"
		<<endl;
		}
		scriptStack.pop();
		modeStack_.pop();
		
#line 446 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

std::string  vrml97parser::nodeNameId() {
#line 954 "vrml97.g"
	std::string s;
#line 459 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	i = LT(1);
	match(Id);
#line 955 "vrml97.g"
	s = i->getText();
#line 466 "vrml97parser.cpp"
	return s;
}

void vrml97parser::rootNodeStatement() {
#line 393 "vrml97.g"
	
	string n;
	
#line 475 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_Script:
	case Id:
	{
		node();
		break;
	}
	case LITERAL_DEF:
	{
		match(LITERAL_DEF);
		n=nodeNameId();
		node();
#line 399 "vrml97.g"
		
		definedNodes[n] = currentNode();            
		
#line 493 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::proto() {
#line 410 "vrml97.g"
	
	string n;
	
#line 508 "vrml97parser.cpp"
	
	match(LITERAL_PROTO);
	n=nodeTypeId();
#line 416 "vrml97.g"
	
	if (verbose_)
	{
	cout<<"xdkwrl:"<<string(depth()*2,' ')
	<<"+PROTO ["<<n<<"]"<<endl;
	}
	ProtoDeclaration* p = new ProtoDeclaration(n.c_str());
	protoStack.push(p);
	modeStack_.push(PROTO_MODE);
	protos.push_back(p);
	
#line 524 "vrml97parser.cpp"
	match(LBRACKET);
#line 428 "vrml97.g"
	
	// Now we are going to read interfaceDeclarations, which
	// means reading rule fieldValue. Therefore we need to
	// place on the mnNodeBuffer the proto
	mfNodeBufferStack.top().push_back(SFNode(protoStack.top()));
	
#line 533 "vrml97parser.cpp"
	interfaceDeclarations();
#line 435 "vrml97.g"
	
	// After that, we can remove it safely
	mfNodeBufferStack.top().pop_back();
	
#line 540 "vrml97parser.cpp"
	match(RBRACKET);
	match(LBRACE);
#line 441 "vrml97.g"
	
	// Now since proto is like a root of a hierarchy of nodes,
	// we must push on the node buffer stack a buffer to read
	// these nodes in proto body
	mfNodeBufferStack.push(MFNode());            
	
#line 550 "vrml97parser.cpp"
	protoBody();
#line 448 "vrml97.g"
	
	// Nodes read in the buffer stack are PROTO children
	// nodes. They are assigned to the proto node and can be
	// safely forgotten now.
	protoStack.top()->setNodes(mfNodeBufferStack.top());
	mfNodeBufferStack.pop();
	declaredProtos[protoStack.top()->typeName()] = protoStack.top();
	protoStack.pop();
	modeStack_.pop();
	
#line 563 "vrml97parser.cpp"
	match(RBRACE);
}

void vrml97parser::externproto() {
#line 601 "vrml97.g"
	
	string n;
	ExternProtoDeclaration* p;
	
#line 573 "vrml97parser.cpp"
	
	match(LITERAL_EXTERNPROTO);
	n=nodeTypeId();
#line 608 "vrml97.g"
	
	if (verbose_)
	{
	cout<<"xdkwrl:"<<string(depth()*2,' ')
	<<"+EXTERNPROTO ["<<n<<"]"<<endl;
	}
	p = new ExternProtoDeclaration(n.c_str());
	protoStack.push(p);
	modeStack_.push(PROTO_MODE);
	externProtos.push_back(p);
	
#line 589 "vrml97parser.cpp"
	match(LBRACKET);
#line 620 "vrml97.g"
	
	// Now we are going to read interfaceDeclarations, which
	// means reading rule fieldValue. Therefore we need to
	// place on the mnNodeBuffer the proto
	mfNodeBufferStack.top().push_back(SFNode(protoStack.top()));
	
#line 598 "vrml97parser.cpp"
	externInterfaceDeclarations();
#line 627 "vrml97.g"
	
	// After that, we can remove it safely
	mfNodeBufferStack.top().pop_back();
	
#line 605 "vrml97parser.cpp"
	match(RBRACKET);
	mfstringValue();
#line 633 "vrml97.g"
	
	p->urls = mfStringBuffer;
	// RQ: the included file has to be parsed using
	// ExternProtoDeclaration class function getExternalDeclaration
	if (p->getExternalDeclaration())
	{
	if (verbose_)
	{
	cout<<"xdkwrl:"<<string(depth()*2,' ')
	<<"+EXTERNPROTO external declaration parsed"
	<<endl;
	}                    
	}
	else
	{
	if (verbose_)
	{
	cout<<"xdkwrl:"<<string(depth()*2,' ')
	<<"+EXTERNPROTO external declaration"
	<<" not parsed"<<endl;
	}                    
	}                
	declaredProtos[protoStack.top()->typeName()] = protoStack.top();
	protoStack.pop();
	modeStack_.pop();
	
#line 635 "vrml97parser.cpp"
}

void vrml97parser::protoStatements() {
	
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == LITERAL_PROTO || LA(1) == LITERAL_EXTERNPROTO)) {
			protoStatement();
		}
		else {
			goto _loop11;
		}
		
	}
	_loop11:;
	} // ( ... )*
}

std::string  vrml97parser::nodeTypeId() {
#line 957 "vrml97.g"
	std::string s;
#line 657 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	i = LT(1);
	match(Id);
#line 958 "vrml97.g"
	s = i->getText();
#line 664 "vrml97parser.cpp"
	return s;
}

void vrml97parser::interfaceDeclarations() {
	
	{ // ( ... )*
	for (;;) {
		if (((LA(1) >= LITERAL_eventIn && LA(1) <= LITERAL_exposedField))) {
			interfaceDeclaration();
		}
		else {
			goto _loop16;
		}
		
	}
	_loop16:;
	} // ( ... )*
}

void vrml97parser::protoBody() {
	
	protoStatements();
	rootNodeStatement();
	statements();
}

void vrml97parser::interfaceDeclaration() {
#line 560 "vrml97.g"
	
	string f;
	FieldTypeId t;
	
#line 697 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_eventIn:
	case LITERAL_eventOut:
	case LITERAL_field:
	{
		restrictedInterfaceDeclaration();
		break;
	}
	case LITERAL_exposedField:
	{
		match(LITERAL_exposedField);
		t=fieldType();
		f=fieldId();
#line 567 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		handleStack.push(p->declareExposedField(t,f));
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+PROTO "<<p->typeName()
		<<" declares exposedField "
		<<handleStack.top().fieldTypeName()<<" "<<f<<endl;
		}
		}
		else if (modeStack_.top() == SCRIPT_MODE)
		{
		Script* s = scriptStack.top();            
		handleStack.push(s->declareExposedField(t,f));
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+Script "
		<<" declares exposedField "
		<<handleStack.top().fieldTypeName()<<" "<<f<<endl;
		}
		}            
		
#line 739 "vrml97parser.cpp"
		fieldValue();
#line 594 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		handleStack.pop();
		}
		
#line 748 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::restrictedInterfaceDeclaration() {
#line 467 "vrml97.g"
	
	string ei;
	string eo;
	string f;
	FieldTypeId t;
	
#line 766 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_eventIn:
	{
		match(LITERAL_eventIn);
		t=fieldType();
		ei=eventInId();
#line 475 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		p->declareEventIn(t,ei); 
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+PROTO "<<p->typeName()
		<<" declares eventIn "
		<<ei<<endl;
		}
		}
		else if (modeStack_.top() == SCRIPT_MODE)
		{
		Script* s = scriptStack.top();            
		s->declareEventIn(t,ei); 
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+Script "
		<<" declares eventIn "
		<<ei<<endl;
		}
		}
		
#line 801 "vrml97parser.cpp"
		break;
	}
	case LITERAL_eventOut:
	{
		match(LITERAL_eventOut);
		t=fieldType();
		eo=eventOutId();
#line 502 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		p->declareEventOut(t,eo); 
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+PROTO "<<p->typeName()
		<<" declares eventOut "
		<<eo<<endl;
		}
		}
		else if (modeStack_.top() == SCRIPT_MODE)
		{
		Script* s = scriptStack.top();            
		s->declareEventOut(t,eo); 
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+Script "
		<<" declares eventOut "
		<<eo<<endl;
		}
		}
		
#line 836 "vrml97parser.cpp"
		break;
	}
	case LITERAL_field:
	{
		match(LITERAL_field);
		t=fieldType();
		f=fieldId();
#line 529 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		handleStack.push(p->declareField(t,f));
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+PROTO "<<p->typeName()
		<<" declares field "
		<<handleStack.top().fieldTypeName()<<" "<<f<<endl;
		}
		}
		else if (modeStack_.top() == SCRIPT_MODE)
		{
		Script* s = scriptStack.top();            
		handleStack.push(s->declareField(t,f));
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+Script "
		<<" declares field "
		<<handleStack.top().fieldTypeName()<<" "<<f<<endl;
		}
		}            
		
#line 871 "vrml97parser.cpp"
		fieldValue();
#line 556 "vrml97.g"
		
		handleStack.pop();
		
#line 877 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

wrl::FieldTypeId  vrml97parser::fieldType() {
#line 973 "vrml97.g"
	wrl::FieldTypeId t;
#line 890 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_MFColor:
	{
		match(LITERAL_MFColor);
#line 974 "vrml97.g"
		return mfColor;
#line 898 "vrml97parser.cpp"
		break;
	}
	case LITERAL_MFFloat:
	{
		match(LITERAL_MFFloat);
#line 975 "vrml97.g"
		return mfFloat;
#line 906 "vrml97parser.cpp"
		break;
	}
	case 25:
	{
		match(25);
#line 976 "vrml97.g"
		return mfInt32;
#line 914 "vrml97parser.cpp"
		break;
	}
	case LITERAL_MFNode:
	{
		match(LITERAL_MFNode);
#line 977 "vrml97.g"
		return mfNode;
#line 922 "vrml97parser.cpp"
		break;
	}
	case LITERAL_MFRotation:
	{
		match(LITERAL_MFRotation);
#line 978 "vrml97.g"
		return mfRotation;
#line 930 "vrml97parser.cpp"
		break;
	}
	case LITERAL_MFString:
	{
		match(LITERAL_MFString);
#line 979 "vrml97.g"
		return mfString;
#line 938 "vrml97parser.cpp"
		break;
	}
	case LITERAL_MFTime:
	{
		match(LITERAL_MFTime);
#line 980 "vrml97.g"
		return mfTime;
#line 946 "vrml97parser.cpp"
		break;
	}
	case 30:
	{
		match(30);
#line 981 "vrml97.g"
		return mfVec2f;
#line 954 "vrml97parser.cpp"
		break;
	}
	case 31:
	{
		match(31);
#line 982 "vrml97.g"
		return mfVec3f;
#line 962 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFBool:
	{
		match(LITERAL_SFBool);
#line 983 "vrml97.g"
		return sfBool;
#line 970 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFColor:
	{
		match(LITERAL_SFColor);
#line 984 "vrml97.g"
		return sfColor;
#line 978 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFFloat:
	{
		match(LITERAL_SFFloat);
#line 985 "vrml97.g"
		return sfFloat;
#line 986 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFImage:
	{
		match(LITERAL_SFImage);
#line 986 "vrml97.g"
		return sfImage;
#line 994 "vrml97parser.cpp"
		break;
	}
	case 36:
	{
		match(36);
#line 987 "vrml97.g"
		return sfInt32;
#line 1002 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFNode:
	{
		match(LITERAL_SFNode);
#line 988 "vrml97.g"
		return sfNode;
#line 1010 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFRotation:
	{
		match(LITERAL_SFRotation);
#line 989 "vrml97.g"
		return sfRotation;
#line 1018 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFString:
	{
		match(LITERAL_SFString);
#line 990 "vrml97.g"
		return sfString;
#line 1026 "vrml97parser.cpp"
		break;
	}
	case LITERAL_SFTime:
	{
		match(LITERAL_SFTime);
#line 991 "vrml97.g"
		return sfTime;
#line 1034 "vrml97parser.cpp"
		break;
	}
	case 41:
	{
		match(41);
#line 992 "vrml97.g"
		return sfVec2f;
#line 1042 "vrml97parser.cpp"
		break;
	}
	case 42:
	{
		match(42);
#line 993 "vrml97.g"
		return sfVec3f;
#line 1050 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	return t;
}

std::string  vrml97parser::eventInId() {
#line 963 "vrml97.g"
	std::string s;
#line 1064 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	i = LT(1);
	match(Id);
#line 964 "vrml97.g"
	s = i->getText();
#line 1071 "vrml97parser.cpp"
	return s;
}

std::string  vrml97parser::eventOutId() {
#line 966 "vrml97.g"
	std::string s;
#line 1078 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	i = LT(1);
	match(Id);
#line 967 "vrml97.g"
	s = i->getText();
#line 1085 "vrml97parser.cpp"
	return s;
}

std::string  vrml97parser::fieldId() {
#line 960 "vrml97.g"
	std::string s;
#line 1092 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	i = LT(1);
	match(Id);
#line 961 "vrml97.g"
	s = i->getText();
#line 1099 "vrml97parser.cpp"
	return s;
}

void vrml97parser::fieldValue() {
#line 995 "vrml97.g"
	
	SFBool     vSFBool;
	SFColor    vSFColor;
	SFFloat    vSFFloat;
	SFImage    vSFImage;
	SFInt32    vSFInt32;
	SFNode     vSFNode;
	SFRotation vSFRotation;
	SFString   vSFString;
	SFTime     vSFTime;
	SFVec2f    vSFVec2f;
	SFVec3f    vSFVec3f;
	
	
#line 1119 "vrml97parser.cpp"
	
	if (((LA(1) == LITERAL_TRUE || LA(1) == LITERAL_FALSE))&&(sfboolParsed())) {
		vSFBool=sfboolValue();
#line 1010 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFBool);
#line 1125 "vrml97parser.cpp"
	}
	else if (((LA(1) == FLOAT || LA(1) == INT) && (LA(2) == FLOAT || LA(2) == INT) && (LA(3) == FLOAT || LA(3) == INT) && (_tokenSet_1.member(LA(4))) && (_tokenSet_2.member(LA(5))))&&(sfcolorParsed())) {
		vSFColor=sfcolorValue();
#line 1011 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFColor);
#line 1131 "vrml97parser.cpp"
	}
	else if (((LA(1) == FLOAT || LA(1) == INT) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(sffloatParsed())) {
		vSFFloat=sffloatValue();
#line 1012 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFFloat);
#line 1137 "vrml97parser.cpp"
	}
	else if (((LA(1) == INT) && (LA(2) == INT) && (LA(3) == INT) && (_tokenSet_4.member(LA(4))) && (_tokenSet_2.member(LA(5))))&&(sfimageParsed())) {
		vSFImage=sfimageValue();
#line 1013 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFImage);
#line 1143 "vrml97parser.cpp"
	}
	else if (((LA(1) == INT) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(sfint32Parsed())) {
		vSFInt32=sfint32Value();
#line 1014 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFInt32);
#line 1149 "vrml97parser.cpp"
	}
	else if (((_tokenSet_5.member(LA(1))) && (_tokenSet_6.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(sfnodeParsed())) {
		vSFNode=sfnodeValue();
#line 1015 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFNode);
#line 1155 "vrml97parser.cpp"
	}
	else if (((LA(1) == FLOAT || LA(1) == INT) && (LA(2) == FLOAT || LA(2) == INT) && (LA(3) == FLOAT || LA(3) == INT) && (LA(4) == FLOAT || LA(4) == INT) && (_tokenSet_1.member(LA(5))))&&(sfrotationParsed())) {
		vSFRotation=sfrotationValue();
#line 1016 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFRotation);
#line 1161 "vrml97parser.cpp"
	}
	else if (((LA(1) == STRING) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(sfstringParsed())) {
		vSFString=sfstringValue();
#line 1017 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFString);
#line 1167 "vrml97parser.cpp"
	}
	else if (((LA(1) == FLOAT || LA(1) == INT) && (_tokenSet_1.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(sftimeParsed())) {
		vSFTime=sftimeValue();
#line 1018 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFTime);
#line 1173 "vrml97parser.cpp"
	}
	else if (((LA(1) == FLOAT || LA(1) == INT) && (LA(2) == FLOAT || LA(2) == INT) && (_tokenSet_1.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(sfvec2fParsed())) {
		vSFVec2f=sfvec2fValue();
#line 1019 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFVec2f);
#line 1179 "vrml97parser.cpp"
	}
	else if (((LA(1) == FLOAT || LA(1) == INT) && (LA(2) == FLOAT || LA(2) == INT) && (LA(3) == FLOAT || LA(3) == INT) && (_tokenSet_1.member(LA(4))) && (_tokenSet_2.member(LA(5))))&&(sfvec3fParsed())) {
		vSFVec3f=sfvec3fValue();
#line 1020 "vrml97.g"
		currentNode()->setField(currentHandle(),vSFVec3f);
#line 1185 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == FLOAT || LA(1) == INT) && (LA(2) == RBRACKET || LA(2) == FLOAT || LA(2) == INT) && (_tokenSet_7.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfcolorParsed())) {
		mfcolorValue();
#line 1021 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfColorBuffer);
#line 1191 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == FLOAT || LA(1) == INT) && (_tokenSet_7.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mffloatParsed())) {
		mffloatValue();
#line 1022 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfFloatBuffer);
#line 1197 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == INT) && (_tokenSet_4.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfint32Parsed())) {
		mfint32Value();
#line 1023 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfInt32Buffer);
#line 1203 "vrml97parser.cpp"
	}
	else if (((_tokenSet_8.member(LA(1))) && (_tokenSet_9.member(LA(2))) && (_tokenSet_10.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfnodeParsed())) {
		mfnodeValue();
#line 1025 "vrml97.g"
		
		currentNode()->swapField(currentHandle(),mfNodeBuffer);
		
#line 1211 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == FLOAT || LA(1) == INT) && (LA(2) == RBRACKET || LA(2) == FLOAT || LA(2) == INT) && (_tokenSet_7.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfrotationParsed())) {
		mfrotationValue();
#line 1028 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfRotationBuffer);
#line 1217 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == STRING) && (_tokenSet_11.member(LA(2))) && (_tokenSet_2.member(LA(3))) && (_tokenSet_3.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfstringParsed())) {
		mfstringValue();
#line 1029 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfStringBuffer);
#line 1223 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == FLOAT || LA(1) == INT) && (LA(2) == RBRACKET || LA(2) == FLOAT || LA(2) == INT) && (_tokenSet_7.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfvec2fParsed())) {
		mfvec2fValue();
#line 1030 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfVec2fBuffer);
#line 1229 "vrml97parser.cpp"
	}
	else if (((LA(1) == LBRACKET || LA(1) == FLOAT || LA(1) == INT) && (LA(2) == RBRACKET || LA(2) == FLOAT || LA(2) == INT) && (_tokenSet_7.member(LA(3))) && (_tokenSet_2.member(LA(4))) && (_tokenSet_3.member(LA(5))))&&(mfvec3fParsed())) {
		mfvec3fValue();
#line 1031 "vrml97.g"
		currentNode()->swapField(currentHandle(),mfVec3fBuffer);
#line 1235 "vrml97parser.cpp"
	}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	
}

void vrml97parser::externInterfaceDeclarations() {
	
	{ // ( ... )+
	int _cnt22=0;
	for (;;) {
		if (((LA(1) >= LITERAL_eventIn && LA(1) <= LITERAL_exposedField))) {
			externInterfaceDeclaration();
		}
		else {
			if ( _cnt22>=1 ) { goto _loop22; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());}
		}
		
		_cnt22++;
	}
	_loop22:;
	}  // ( ... )+
}

void vrml97parser::mfstringValue() {
#line 1172 "vrml97.g"
	
	SFString v;
	mfStringBuffer.clear();
	
#line 1267 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case STRING:
	{
		v=sfstringValue();
#line 1178 "vrml97.g"
		mfStringBuffer.push_back(v);
#line 1275 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == STRING)) {
				v=sfstringValue();
#line 1179 "vrml97.g"
				mfStringBuffer.push_back(v);
#line 1287 "vrml97parser.cpp"
			}
			else {
				goto _loop72;
			}
			
		}
		_loop72:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::externInterfaceDeclaration() {
#line 663 "vrml97.g"
	
	string ei;
	string eo;
	string f;
	FieldTypeId t;
	
#line 1314 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_eventIn:
	{
		match(LITERAL_eventIn);
		t=fieldType();
		ei=eventInId();
#line 671 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		p->declareEventIn(t,ei);
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+EXTERNPROTO "<<p->typeName()
		<<" declares eventIn "
		<<ei<<endl;
		}
		}
		
#line 1337 "vrml97parser.cpp"
		break;
	}
	case LITERAL_eventOut:
	{
		match(LITERAL_eventOut);
		t=fieldType();
		eo=eventOutId();
#line 686 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		p->declareEventIn(t,eo);
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+EXTERNPROTO "<<p->typeName()
		<<" declares eventOut "
		<<eo<<endl;
		}
		}
		
#line 1360 "vrml97parser.cpp"
		break;
	}
	case LITERAL_field:
	{
		match(LITERAL_field);
		t=fieldType();
		f=fieldId();
#line 701 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		Node::FieldHandle h = p->declareField(t,f);
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+EXTERNPROTO "<<p->typeName()
		<<" declares field "
		<<h.fieldTypeName()<<" "<<f<<endl;
		}
		}
		
#line 1383 "vrml97parser.cpp"
		break;
	}
	case LITERAL_exposedField:
	{
		match(LITERAL_exposedField);
		t=fieldType();
		f=fieldId();
#line 716 "vrml97.g"
		
		if (modeStack_.top() == PROTO_MODE)
		{
		ProtoDeclaration* p = protoStack.top();            
		Node::FieldHandle h = p->declareField(t,f);
		if (verbose_)
		{
		cout<<"xdkwrl:"<<string(depth()*2,' ')
		<<"+EXTERNPROTO "<<p->typeName()
		<<" declares exposedField "
		<<h.fieldTypeName()<<" "<<f<<endl;
		}
		}
		
#line 1406 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::nodeBody() {
	
	{ // ( ... )*
	for (;;) {
		if ((_tokenSet_12.member(LA(1)))) {
			nodeBodyElement();
		}
		else {
			goto _loop28;
		}
		
	}
	_loop28:;
	} // ( ... )*
}

void vrml97parser::scriptBody() {
	
	{ // ( ... )*
	for (;;) {
		if ((_tokenSet_13.member(LA(1)))) {
			scriptBodyElement();
		}
		else {
			goto _loop31;
		}
		
	}
	_loop31:;
	} // ( ... )*
}

void vrml97parser::nodeBodyElement() {
	ANTLR_USE_NAMESPACE(antlr)RefToken  i0 = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i1 = ANTLR_USE_NAMESPACE(antlr)nullToken;
#line 830 "vrml97.g"
	
	string f;
	
#line 1455 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_ROUTE:
	{
		routeStatement();
		break;
	}
	case LITERAL_PROTO:
	case LITERAL_EXTERNPROTO:
	{
		protoStatement();
		break;
	}
	default:
		if ((LA(1) == Id) && (_tokenSet_14.member(LA(2)))) {
			f=fieldId();
#line 835 "vrml97.g"
			
			Node* node = currentNode();
			handleStack.push(node->field(f));
			if (currentHandle().fieldTypeId() == unknown)
			{
			ostringstream s;                
			s<<"Unknown fieldTypeId ["<<f
			<<"] for node type "<<node->typeName()<<ends;
			int l = LT(0)->getLine();
			int c = LT(0)->getColumn();
			throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);
			}            
			string t = currentHandle().fieldTypeName();
			if (verbose_)
			{
			cout<<"xdkwrl:"<<string(depth()*2,' ')
			<<"| "<<t<<string(10-t.size(),' ')<<" ["<<f<<"]"<<endl;
			}
			
#line 1492 "vrml97parser.cpp"
			fieldValue();
#line 855 "vrml97.g"
			
			handleStack.pop();
			
#line 1498 "vrml97parser.cpp"
		}
		else if ((LA(1) == Id) && (LA(2) == LITERAL_IS)) {
			i0 = LT(1);
			match(Id);
			match(LITERAL_IS);
			i1 = LT(1);
			match(Id);
#line 868 "vrml97.g"
			
			if (modeStack_.top() == PROTO_MODE)
			{            
			// When encoutering such an Id, we must be in a proto,
			// so we first check that.
			if (protoStack.empty())
			{
			ostringstream s;
			s<<"IS used outside of PROTO "<<ends;
			int l = LT(0)->getLine();
			int c = LT(0)->getColumn();
			throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);                
			}
			// Then we ask the current node an handle on the field
			// and pass it to the current proto to do the binding.
			Node* node = currentNode();
			Node::FieldHandle h = node->field(i0->getText());
			if (h.fieldTypeId() != unknown)
			{
			Node::FieldHandle k = protoStack.top()->field(i1->getText());
			if (k.fieldTypeId() == unknown)
			{
			ostringstream s;                
			s<<"Unknown field:fieldTypeId ["<<i1->getText()
			<<"] in proto "<<protoStack.top()->typeName()<<ends;
			int l = LT(0)->getLine();
			int c = LT(0)->getColumn();
			throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);
			}
			protoStack.top()->bindFields(node,
			i0->getText().c_str(),
			i1->getText().c_str());
			}
			// If if failed for a field, we try with an eventIn...
			else
			{
			Node::EventInHandle h = node->eventIn(i0->getText());
			if (h.fieldTypeId() != unknown)
			{
			Node::EventInHandle k = protoStack.top()->eventIn(i1->getText());
			if (k.fieldTypeId() == unknown)
			{
			ostringstream s;                
			s<<"Unknown eventIn:fieldTypeId ["<<i1->getText()
			<<"] in proto "<<protoStack.top()->typeName()<<ends;
			int l = LT(0)->getLine();
			int c = LT(0)->getColumn();
			throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);
			}   
			protoStack.top()->bindEventsIn(node,
			i0->getText().c_str(),
			i1->getText().c_str());
			}
			// ..and with an eventOut
			else
			{
			Node::EventOutHandle h = node->eventOut(i0->getText());
			if (h.fieldTypeId() == unknown)
			{
			ostringstream s;                
			s<<"Unknown field/eventIn/eventOut fieldTypeId ["<<i0->getText()
			<<"] in node type "<<node->typeName()<<ends;
			int l = LT(0)->getLine();
			int c = LT(0)->getColumn();
			throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);
			}
			Node::EventOutHandle k = protoStack.top()->eventOut(i1->getText());
			if (k.fieldTypeId() == unknown)
			{
			ostringstream s;                
			s<<"Unknown eventOut:fieldTypeId ["<<f
			<<"] in proto "<<protoStack.top()->typeName()<<ends;
			int l = LT(0)->getLine();
			int c = LT(0)->getColumn();
			throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);
			}   
			protoStack.top()->bindEventsOut(node,
			i0->getText().c_str(),
			i1->getText().c_str());                                
			}
			}
			}
			
#line 1590 "vrml97parser.cpp"
		}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::scriptBodyElement() {
#line 812 "vrml97.g"
	
	string ei0,ei1;
	string eo0,eo1;
	string f0,f1;
	FieldTypeId t;
	
#line 1606 "vrml97parser.cpp"
	
	if ((_tokenSet_12.member(LA(1)))) {
		nodeBodyElement();
	}
	else if (((LA(1) >= LITERAL_eventIn && LA(1) <= LITERAL_field)) && ((LA(2) >= LITERAL_MFColor && LA(2) <= 42)) && (LA(3) == Id) && (_tokenSet_15.member(LA(4)))) {
		restrictedInterfaceDeclaration();
	}
	else if ((LA(1) == LITERAL_eventIn) && ((LA(2) >= LITERAL_MFColor && LA(2) <= 42)) && (LA(3) == Id) && (LA(4) == LITERAL_IS)) {
		match(LITERAL_eventIn);
		t=fieldType();
		ei0=eventInId();
		match(LITERAL_IS);
		ei1=eventInId();
	}
	else if ((LA(1) == LITERAL_eventOut) && ((LA(2) >= LITERAL_MFColor && LA(2) <= 42)) && (LA(3) == Id) && (LA(4) == LITERAL_IS)) {
		match(LITERAL_eventOut);
		t=fieldType();
		ei1=eventOutId();
		match(LITERAL_IS);
		eo1=eventOutId();
	}
	else if ((LA(1) == LITERAL_field) && ((LA(2) >= LITERAL_MFColor && LA(2) <= 42)) && (LA(3) == Id) && (LA(4) == LITERAL_IS)) {
		match(LITERAL_field);
		t=fieldType();
		f0=fieldId();
		match(LITERAL_IS);
		f1=fieldId();
	}
	else {
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	
}

wrl::SFBool  vrml97parser::sfboolValue() {
#line 1033 "vrml97.g"
	wrl::SFBool v;
#line 1644 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_TRUE:
	{
		match(LITERAL_TRUE);
#line 1034 "vrml97.g"
		v = true;
#line 1652 "vrml97parser.cpp"
		break;
	}
	case LITERAL_FALSE:
	{
		match(LITERAL_FALSE);
#line 1035 "vrml97.g"
		v = false;
#line 1660 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	return v;
}

wrl::SFColor  vrml97parser::sfcolorValue() {
#line 1037 "vrml97.g"
	wrl::SFColor v;
#line 1674 "vrml97parser.cpp"
#line 1037 "vrml97.g"
	float f0,f1,f2;
#line 1677 "vrml97parser.cpp"
	
	f0=floatv();
	f1=floatv();
	f2=floatv();
#line 1039 "vrml97.g"
	v.setRGB(f0,f1,f2);
#line 1684 "vrml97parser.cpp"
	return v;
}

wrl::SFFloat  vrml97parser::sffloatValue() {
#line 1041 "vrml97.g"
	wrl::SFFloat v;
#line 1691 "vrml97parser.cpp"
#line 1041 "vrml97.g"
	float f;
#line 1694 "vrml97parser.cpp"
	
	f=floatv();
#line 1043 "vrml97.g"
	v = f;
#line 1699 "vrml97parser.cpp"
	return v;
}

wrl::SFImage  vrml97parser::sfimageValue() {
#line 1045 "vrml97.g"
	wrl::SFImage v;
#line 1706 "vrml97parser.cpp"
#line 1045 "vrml97.g"
	
	int i0,i1,i2;
	SFInt32  vSFInt32;
	
#line 1712 "vrml97parser.cpp"
	
	i0=int32();
	i1=int32();
	i2=int32();
#line 1051 "vrml97.g"
	mfInt32Buffer.clear();
#line 1719 "vrml97parser.cpp"
	{ // ( ... )*
	for (;;) {
		if ((LA(1) == INT)) {
			vSFInt32=sfint32Value();
#line 1052 "vrml97.g"
			mfInt32Buffer.push_back(vSFInt32);
#line 1726 "vrml97parser.cpp"
		}
		else {
			goto _loop46;
		}
		
	}
	_loop46:;
	} // ( ... )*
#line 1053 "vrml97.g"
	
	if (i0*i1 != static_cast<int>(mfInt32Buffer.size()))
	{
	ostringstream s;
	s<<"Uncorrect number of pixels in PixelTexture"<<ends;
	int l = LT(0)->getLine();
	int c = LT(0)->getColumn();
	throw ANTLR_USE_NAMESPACE(antlr)SemanticException(s.str(),getFilename(),l,c);                
	
	}
	v.setDimensions(i0,i1,i2);
	unsigned char* p = v.pixels();
	for (MFInt32::const_iterator iter=mfInt32Buffer.begin();
	iter != mfInt32Buffer.end();++iter)
	{
	int i=*iter;
	for (unsigned int n=0;n<v.numComponents();++n)
	{
	*p++ = i & 0xf;
	i>>=8;
	}
	}
	
#line 1759 "vrml97parser.cpp"
	return v;
}

wrl::SFInt32  vrml97parser::sfint32Value() {
#line 1077 "vrml97.g"
	wrl::SFInt32 v;
#line 1766 "vrml97parser.cpp"
#line 1077 "vrml97.g"
	int i;
#line 1769 "vrml97parser.cpp"
	
	i=int32();
#line 1079 "vrml97.g"
	v = i;
#line 1774 "vrml97parser.cpp"
	return v;
}

wrl::SFNode  vrml97parser::sfnodeValue() {
#line 1089 "vrml97.g"
	wrl::SFNode v;
#line 1781 "vrml97parser.cpp"
#line 1089 "vrml97.g"
	
	mfNodeBufferStack.push(MFNode());
	
#line 1786 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case LITERAL_DEF:
	case LITERAL_USE:
	case LITERAL_Script:
	case Id:
	{
		nodeStatement();
#line 1094 "vrml97.g"
		
		v = mfNodeBufferStack.top().back();
		mfNodeBufferStack.pop();
		
#line 1800 "vrml97parser.cpp"
		break;
	}
	case LITERAL_NULL:
	{
		match(LITERAL_NULL);
#line 1098 "vrml97.g"
		v = NULL;mfNodeBufferStack.pop();
#line 1808 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	return v;
}

wrl::SFRotation  vrml97parser::sfrotationValue() {
#line 1100 "vrml97.g"
	wrl::SFRotation v;
#line 1822 "vrml97parser.cpp"
#line 1100 "vrml97.g"
	float f0,f1,f2,f3;
#line 1825 "vrml97parser.cpp"
	
	f0=floatv();
	f1=floatv();
	f2=floatv();
	f3=floatv();
#line 1102 "vrml97.g"
	v.setAxisAndAngle(f0,f1,f2,f3);
#line 1833 "vrml97parser.cpp"
	return v;
}

wrl::SFString  vrml97parser::sfstringValue() {
#line 1104 "vrml97.g"
	wrl::SFString v;
#line 1840 "vrml97parser.cpp"
#line 1104 "vrml97.g"
	string s;
#line 1843 "vrml97parser.cpp"
	
	s=stringv();
#line 1106 "vrml97.g"
	v = s;
#line 1848 "vrml97parser.cpp"
	return v;
}

wrl::SFTime  vrml97parser::sftimeValue() {
#line 1108 "vrml97.g"
	wrl::SFTime v;
#line 1855 "vrml97parser.cpp"
#line 1108 "vrml97.g"
	float f;
#line 1858 "vrml97parser.cpp"
	
	f=floatv();
#line 1110 "vrml97.g"
	v.setNbSeconds(f);
#line 1863 "vrml97parser.cpp"
	return v;
}

wrl::SFVec2f  vrml97parser::sfvec2fValue() {
#line 1112 "vrml97.g"
	wrl::SFVec2f v;
#line 1870 "vrml97parser.cpp"
#line 1112 "vrml97.g"
	float f0,f1;
#line 1873 "vrml97parser.cpp"
	
	f0=floatv();
	f1=floatv();
#line 1114 "vrml97.g"
	v.setXY(f0,f1);
#line 1879 "vrml97parser.cpp"
	return v;
}

wrl::SFVec3f  vrml97parser::sfvec3fValue() {
#line 1116 "vrml97.g"
	wrl::SFVec3f v;
#line 1886 "vrml97parser.cpp"
#line 1116 "vrml97.g"
	float f0,f1,f2;
#line 1889 "vrml97parser.cpp"
	
	f0=floatv();
	f1=floatv();
	f2=floatv();
#line 1118 "vrml97.g"
	v.setXYZ(f0,f1,f2);
#line 1896 "vrml97parser.cpp"
	return v;
}

void vrml97parser::mfcolorValue() {
#line 1120 "vrml97.g"
	
	SFColor v;
	mfColorBuffer.clear();
	
#line 1906 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case FLOAT:
	case INT:
	{
		v=sfcolorValue();
#line 1125 "vrml97.g"
		mfColorBuffer.push_back(v);
#line 1915 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == FLOAT || LA(1) == INT)) {
				v=sfcolorValue();
#line 1126 "vrml97.g"
				mfColorBuffer.push_back(v);
#line 1927 "vrml97parser.cpp"
			}
			else {
				goto _loop56;
			}
			
		}
		_loop56:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::mffloatValue() {
#line 1128 "vrml97.g"
	
	SFFloat v;
	mfFloatBuffer.clear();
	
#line 1952 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case FLOAT:
	case INT:
	{
		v=sffloatValue();
#line 1133 "vrml97.g"
		mfFloatBuffer.push_back(v);
#line 1961 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == FLOAT || LA(1) == INT)) {
				v=sffloatValue();
#line 1134 "vrml97.g"
				mfFloatBuffer.push_back(v);
#line 1973 "vrml97parser.cpp"
			}
			else {
				goto _loop59;
			}
			
		}
		_loop59:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::mfint32Value() {
#line 1136 "vrml97.g"
	
	SFInt32 v;
	mfInt32Buffer.clear();
	
#line 1998 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case INT:
	{
		v=sfint32Value();
#line 1141 "vrml97.g"
		mfInt32Buffer.push_back(v);
#line 2006 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == INT)) {
				v=sfint32Value();
#line 1142 "vrml97.g"
				mfInt32Buffer.push_back(v);
#line 2018 "vrml97parser.cpp"
			}
			else {
				goto _loop62;
			}
			
		}
		_loop62:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::mfnodeValue() {
#line 1153 "vrml97.g"
	
	mfNodeBufferStack.push(MFNode());
	
#line 2042 "vrml97parser.cpp"
	
	{
	switch ( LA(1)) {
	case LITERAL_DEF:
	case LITERAL_USE:
	case LITERAL_Script:
	case Id:
	{
		nodeStatement();
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((_tokenSet_16.member(LA(1)))) {
				nodeStatement();
			}
			else {
				goto _loop66;
			}
			
		}
		_loop66:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	}
#line 1159 "vrml97.g"
	
	mfNodeBuffer.swap(mfNodeBufferStack.top());
	mfNodeBufferStack.pop();
	
#line 2083 "vrml97parser.cpp"
}

void vrml97parser::mfrotationValue() {
#line 1164 "vrml97.g"
	
	SFRotation v;
	mfRotationBuffer.clear();
	
#line 2092 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case FLOAT:
	case INT:
	{
		v=sfrotationValue();
#line 1169 "vrml97.g"
		mfRotationBuffer.push_back(v);
#line 2101 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == FLOAT || LA(1) == INT)) {
				v=sfrotationValue();
#line 1170 "vrml97.g"
				mfRotationBuffer.push_back(v);
#line 2113 "vrml97parser.cpp"
			}
			else {
				goto _loop69;
			}
			
		}
		_loop69:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::mfvec2fValue() {
#line 1181 "vrml97.g"
	
	SFVec2f v;
	mfVec2fBuffer.clear();
	
#line 2138 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case FLOAT:
	case INT:
	{
		v=sfvec2fValue();
#line 1186 "vrml97.g"
		mfVec2fBuffer.push_back(v);
#line 2147 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == FLOAT || LA(1) == INT)) {
				v=sfvec2fValue();
#line 1187 "vrml97.g"
				mfVec2fBuffer.push_back(v);
#line 2159 "vrml97parser.cpp"
			}
			else {
				goto _loop75;
			}
			
		}
		_loop75:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

void vrml97parser::mfvec3fValue() {
#line 1189 "vrml97.g"
	
	SFVec3f v;
	mfVec3fBuffer.clear();
	
#line 2184 "vrml97parser.cpp"
	
	switch ( LA(1)) {
	case FLOAT:
	case INT:
	{
		v=sfvec3fValue();
#line 1194 "vrml97.g"
		mfVec3fBuffer.push_back(v);
#line 2193 "vrml97parser.cpp"
		break;
	}
	case LBRACKET:
	{
		match(LBRACKET);
		{ // ( ... )*
		for (;;) {
			if ((LA(1) == FLOAT || LA(1) == INT)) {
				v=sfvec3fValue();
#line 1195 "vrml97.g"
				mfVec3fBuffer.push_back(v);
#line 2205 "vrml97parser.cpp"
			}
			else {
				goto _loop78;
			}
			
		}
		_loop78:;
		} // ( ... )*
		match(RBRACKET);
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
}

float  vrml97parser::floatv() {
#line 1197 "vrml97.g"
	float v=0.0f;
#line 2227 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  t = ANTLR_USE_NAMESPACE(antlr)nullToken;
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	switch ( LA(1)) {
	case FLOAT:
	{
		t = LT(1);
		match(FLOAT);
#line 1198 "vrml97.g"
		v = static_cast<float>(atof(t->getText().c_str()));
#line 2238 "vrml97parser.cpp"
		break;
	}
	case INT:
	{
		i = LT(1);
		match(INT);
#line 1199 "vrml97.g"
		v = static_cast<float>(atof(i->getText().c_str()));
#line 2247 "vrml97parser.cpp"
		break;
	}
	default:
	{
		throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
	}
	}
	return v;
}

int  vrml97parser::int32() {
#line 1201 "vrml97.g"
	int v=0;
#line 2261 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  i = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	i = LT(1);
	match(INT);
#line 1202 "vrml97.g"
	v = atoi(i->getText().c_str());
#line 2268 "vrml97parser.cpp"
	return v;
}

std::string  vrml97parser::stringv() {
#line 1204 "vrml97.g"
	std::string v;
#line 2275 "vrml97parser.cpp"
	ANTLR_USE_NAMESPACE(antlr)RefToken  t = ANTLR_USE_NAMESPACE(antlr)nullToken;
	
	t = LT(1);
	match(STRING);
#line 1206 "vrml97.g"
	v = string(t->getText());
#line 2282 "vrml97parser.cpp"
	return v;
}

void vrml97parser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& )
{
}
const char* vrml97parser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"HEADER",
	"\"DEF\"",
	"\"USE\"",
	"\"PROTO\"",
	"LBRACKET",
	"RBRACKET",
	"LBRACE",
	"RBRACE",
	"\"eventIn\"",
	"\"eventOut\"",
	"\"field\"",
	"\"exposedField\"",
	"\"EXTERNPROTO\"",
	"\"ROUTE\"",
	"DOT",
	"\"TO\"",
	"\"Script\"",
	"\"IS\"",
	"Id",
	"\"MFColor\"",
	"\"MFFloat\"",
	"\"MFInt32\"",
	"\"MFNode\"",
	"\"MFRotation\"",
	"\"MFString\"",
	"\"MFTime\"",
	"\"MFVec2f\"",
	"\"MFVec3f\"",
	"\"SFBool\"",
	"\"SFColor\"",
	"\"SFFloat\"",
	"\"SFImage\"",
	"\"SFInt32\"",
	"\"SFNode\"",
	"\"SFRotation\"",
	"\"SFString\"",
	"\"SFTime\"",
	"\"SFVec2f\"",
	"\"SFVec3f\"",
	"\"TRUE\"",
	"\"FALSE\"",
	"\"NULL\"",
	"FLOAT",
	"INT",
	"STRING",
	"ROOTFLOAT",
	"NOROOTFLOAT",
	"ABS_INT",
	"FLOAT_OR_INT_OR_DOT",
	"ESC",
	"STRING_INTERNAL",
	"IdFirstChar",
	"IdRestChar",
	"WS",
	"COMMENT",
	"COMMENT_OR_HEADER",
	0
};

const unsigned long vrml97parser::_tokenSet_0_data_[] = { 5439712UL, 0UL, 0UL, 0UL };
// "DEF" "USE" "PROTO" "EXTERNPROTO" "ROUTE" "Script" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_0(_tokenSet_0_data_,4);
const unsigned long vrml97parser::_tokenSet_1_data_[] = { 4455040UL, 0UL, 0UL, 0UL };
// "PROTO" RBRACKET RBRACE "eventIn" "eventOut" "field" "exposedField" 
// "EXTERNPROTO" "ROUTE" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_1(_tokenSet_1_data_,4);
const unsigned long vrml97parser::_tokenSet_2_data_[] = { 4294180834UL, 131071UL, 0UL, 0UL };
// EOF "DEF" "USE" "PROTO" LBRACKET RBRACKET LBRACE RBRACE "eventIn" "eventOut" 
// "field" "exposedField" "EXTERNPROTO" "ROUTE" "Script" "IS" Id "MFColor" 
// "MFFloat" "MFInt32" "MFNode" "MFRotation" "MFString" "MFTime" "MFVec2f" 
// "MFVec3f" "SFBool" "SFColor" "SFFloat" "SFImage" "SFInt32" "SFNode" 
// "SFRotation" "SFString" "SFTime" "SFVec2f" "SFVec3f" "TRUE" "FALSE" 
// "NULL" FLOAT INT STRING 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_2(_tokenSet_2_data_,4);
const unsigned long vrml97parser::_tokenSet_3_data_[] = { 4294442978UL, 131071UL, 0UL, 0UL };
// EOF "DEF" "USE" "PROTO" LBRACKET RBRACKET LBRACE RBRACE "eventIn" "eventOut" 
// "field" "exposedField" "EXTERNPROTO" "ROUTE" DOT "Script" "IS" Id "MFColor" 
// "MFFloat" "MFInt32" "MFNode" "MFRotation" "MFString" "MFTime" "MFVec2f" 
// "MFVec3f" "SFBool" "SFColor" "SFFloat" "SFImage" "SFInt32" "SFNode" 
// "SFRotation" "SFString" "SFTime" "SFVec2f" "SFVec3f" "TRUE" "FALSE" 
// "NULL" FLOAT INT STRING 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_3(_tokenSet_3_data_,4);
const unsigned long vrml97parser::_tokenSet_4_data_[] = { 4455040UL, 32768UL, 0UL, 0UL };
// "PROTO" RBRACKET RBRACE "eventIn" "eventOut" "field" "exposedField" 
// "EXTERNPROTO" "ROUTE" Id INT 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_4(_tokenSet_4_data_,4);
const unsigned long vrml97parser::_tokenSet_5_data_[] = { 5242976UL, 8192UL, 0UL, 0UL };
// "DEF" "USE" "Script" Id "NULL" 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_5(_tokenSet_5_data_,4);
const unsigned long vrml97parser::_tokenSet_6_data_[] = { 4456064UL, 0UL, 0UL, 0UL };
// "PROTO" RBRACKET LBRACE RBRACE "eventIn" "eventOut" "field" "exposedField" 
// "EXTERNPROTO" "ROUTE" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_6(_tokenSet_6_data_,4);
const unsigned long vrml97parser::_tokenSet_7_data_[] = { 4455040UL, 49152UL, 0UL, 0UL };
// "PROTO" RBRACKET RBRACE "eventIn" "eventOut" "field" "exposedField" 
// "EXTERNPROTO" "ROUTE" Id FLOAT INT 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_7(_tokenSet_7_data_,4);
const unsigned long vrml97parser::_tokenSet_8_data_[] = { 5243232UL, 0UL, 0UL, 0UL };
// "DEF" "USE" LBRACKET "Script" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_8(_tokenSet_8_data_,4);
const unsigned long vrml97parser::_tokenSet_9_data_[] = { 5244512UL, 0UL, 0UL, 0UL };
// "DEF" "USE" RBRACKET LBRACE "Script" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_9(_tokenSet_9_data_,4);
const unsigned long vrml97parser::_tokenSet_10_data_[] = { 5504640UL, 0UL, 0UL, 0UL };
// "PROTO" RBRACKET LBRACE RBRACE "eventIn" "eventOut" "field" "exposedField" 
// "EXTERNPROTO" "ROUTE" "Script" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_10(_tokenSet_10_data_,4);
const unsigned long vrml97parser::_tokenSet_11_data_[] = { 4455040UL, 65536UL, 0UL, 0UL };
// "PROTO" RBRACKET RBRACE "eventIn" "eventOut" "field" "exposedField" 
// "EXTERNPROTO" "ROUTE" Id STRING 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_11(_tokenSet_11_data_,4);
const unsigned long vrml97parser::_tokenSet_12_data_[] = { 4391040UL, 0UL, 0UL, 0UL };
// "PROTO" "EXTERNPROTO" "ROUTE" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_12(_tokenSet_12_data_,4);
const unsigned long vrml97parser::_tokenSet_13_data_[] = { 4419712UL, 0UL, 0UL, 0UL };
// "PROTO" "eventIn" "eventOut" "field" "EXTERNPROTO" "ROUTE" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_13(_tokenSet_13_data_,4);
const unsigned long vrml97parser::_tokenSet_14_data_[] = { 5243232UL, 129024UL, 0UL, 0UL };
// "DEF" "USE" LBRACKET "Script" Id "TRUE" "FALSE" "NULL" FLOAT INT STRING 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_14(_tokenSet_14_data_,4);
const unsigned long vrml97parser::_tokenSet_15_data_[] = { 5470688UL, 129024UL, 0UL, 0UL };
// "DEF" "USE" "PROTO" LBRACKET RBRACE "eventIn" "eventOut" "field" "EXTERNPROTO" 
// "ROUTE" "Script" Id "TRUE" "FALSE" "NULL" FLOAT INT STRING 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_15(_tokenSet_15_data_,4);
const unsigned long vrml97parser::_tokenSet_16_data_[] = { 5242976UL, 0UL, 0UL, 0UL };
// "DEF" "USE" "Script" Id 
const ANTLR_USE_NAMESPACE(antlr)BitSet vrml97parser::_tokenSet_16(_tokenSet_16_data_,4);


