#include <xdkwrl/nodes/visibilitysensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of VisibilitySensor
//************************************************************
/*! \class wrl::VisibilitySensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude visibilitysensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  center.setXYZ(0.0f,0.0f,0.0f);
  enabled = true;
  size.setXYZ(0.0f,0.0f,0.0f);
  \endcode
  */
wrl::VisibilitySensor::VisibilitySensor(const char* name)
 : Node(name)
{
  center.setXYZ(0.0f,0.0f,0.0f);
  enabled = true;
  size.setXYZ(0.0f,0.0f,0.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::VisibilitySensor::~VisibilitySensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - center
 *  - enabled
 *  - size
 */
wrl::Node::FieldHandle
wrl::VisibilitySensor::field(const std::string& n)
{
  if(n==std::string("center"))
  {
    return Node::field(n,sfVec3f,(void*) &center);
  }
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  if(n==std::string("size"))
  {
    return Node::field(n,sfVec3f,(void*) &size);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center
 *  - 1 : enabled
 *  - 2 : size
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::VisibilitySensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("center",sfVec3f,&center);
  case 1: return Node::field("enabled",sfBool,&enabled);
  case 2: return Node::field("size",sfVec3f,&size);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_center
 *  - set_enabled
 *  - set_size
 */
wrl::Node::EventInHandle
wrl::VisibilitySensor::eventIn(const std::string& n)
{
  if(n==std::string("set_center"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_center);
  }
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  if(n==std::string("set_size"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_size);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::VisibilitySensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_center",sfVec3f,&set_center);
  case 1: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  case 2: return Node::eventIn("set_size",sfVec3f,&set_size);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - enterTime
 *  - exitTime
 *  - isActive
 *  - center_changed
 *  - enabled_changed
 *  - size_changed
 */
wrl::Node::EventOutHandle
wrl::VisibilitySensor::eventOut(const std::string& n)
{
  if(n==std::string("enterTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &enterTime);
  }
  if(n==std::string("exitTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &exitTime);
  }
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("center_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &center_changed);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  if(n==std::string("size_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &size_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : enterTime
 *  - 1 : exitTime
 *  - 2 : isActive
 *  - 3 : center_changed
 *  - 4 : enabled_changed
 *  - 5 : size_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::VisibilitySensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("enterTime",sfTime,&enterTime);
  case 1: return Node::eventOut("exitTime",sfTime,&exitTime);
  case 2: return Node::eventOut("isActive",sfBool,&isActive);
  case 3: return Node::eventOut("center_changed",sfVec3f,&center_changed);
  case 4: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  case 5: return Node::eventOut("size_changed",sfVec3f,&size_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::VisibilitySensor::duplicate() const
{
  VisibilitySensor* n = new VisibilitySensor(name());
  n->center = center;
  n->enabled = enabled;
  n->size = size;
  return n;
}
wrl::Node* 
wrl::VisibilitySensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  VisibilitySensor* n = new VisibilitySensor(name());
  nodeMap[this] = n;  n->center = center;
  n->enabled = enabled;
  n->size = size;
  return n;
}
bool
wrl::VisibilitySensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec3f centerDV_(0.0f,0.0f,0.0f);
  static const SFBool enabledDV_(true);
  static const SFVec3f sizeDV_(0.0f,0.0f,0.0f);
  switch (i)
  {
  case 0: return center == centerDV_;
  case 1: return enabled == enabledDV_;
  case 2: return size == sizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
