#include <xdkwrl/nodes/transform.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Transform
//************************************************************
/*! \class wrl::Transform
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude transform.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  center.setXYZ(0.0f,0.0f,0.0f);
  rotation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  scale.setXYZ(1.0f,1.0f,1.0f);
  scaleOrientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  translation.setXYZ(0.0f,0.0f,0.0f);
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
  \endcode
  */
wrl::Transform::Transform(const char* name)
 : Node(name)
{
  center.setXYZ(0.0f,0.0f,0.0f);
  rotation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  scale.setXYZ(1.0f,1.0f,1.0f);
  scaleOrientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
  translation.setXYZ(0.0f,0.0f,0.0f);
  bboxCenter.setXYZ(0.0f,0.0f,0.0f);
  bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::Transform::~Transform()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - center
 *  - children
 *  - rotation
 *  - scale
 *  - scaleOrientation
 *  - translation
 *  - bboxCenter
 *  - bboxSize
 */
wrl::Node::FieldHandle
wrl::Transform::field(const std::string& n)
{
  if(n==std::string("center"))
  {
    return Node::field(n,sfVec3f,(void*) &center);
  }
  if(n==std::string("children"))
  {
    return Node::field(n,mfNode,(void*) &children);
  }
  if(n==std::string("rotation"))
  {
    return Node::field(n,sfRotation,(void*) &rotation);
  }
  if(n==std::string("scale"))
  {
    return Node::field(n,sfVec3f,(void*) &scale);
  }
  if(n==std::string("scaleOrientation"))
  {
    return Node::field(n,sfRotation,(void*) &scaleOrientation);
  }
  if(n==std::string("translation"))
  {
    return Node::field(n,sfVec3f,(void*) &translation);
  }
  if(n==std::string("bboxCenter"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxCenter);
  }
  if(n==std::string("bboxSize"))
  {
    return Node::field(n,sfVec3f,(void*) &bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center
 *  - 1 : children
 *  - 2 : rotation
 *  - 3 : scale
 *  - 4 : scaleOrientation
 *  - 5 : translation
 *  - 6 : bboxCenter
 *  - 7 : bboxSize
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Transform::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("center",sfVec3f,&center);
  case 1: return Node::field("children",mfNode,&children);
  case 2: return Node::field("rotation",sfRotation,&rotation);
  case 3: return Node::field("scale",sfVec3f,&scale);
  case 4: return Node::field("scaleOrientation",sfRotation,&scaleOrientation);
  case 5: return Node::field("translation",sfVec3f,&translation);
  case 6: return Node::field("bboxCenter",sfVec3f,&bboxCenter);
  case 7: return Node::field("bboxSize",sfVec3f,&bboxSize);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - addChildren
 *  - removeChildren
 *  - set_center
 *  - set_children
 *  - set_rotation
 *  - set_scale
 *  - set_scaleOrientation
 *  - set_translation
 */
wrl::Node::EventInHandle
wrl::Transform::eventIn(const std::string& n)
{
  if(n==std::string("addChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &addChildren);
  }
  if(n==std::string("removeChildren"))
  {
    return Node::eventIn(n,mfNode,(void*) &removeChildren);
  }
  if(n==std::string("set_center"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_center);
  }
  if(n==std::string("set_children"))
  {
    return Node::eventIn(n,mfNode,(void*) &set_children);
  }
  if(n==std::string("set_rotation"))
  {
    return Node::eventIn(n,sfRotation,(void*) &set_rotation);
  }
  if(n==std::string("set_scale"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_scale);
  }
  if(n==std::string("set_scaleOrientation"))
  {
    return Node::eventIn(n,sfRotation,(void*) &set_scaleOrientation);
  }
  if(n==std::string("set_translation"))
  {
    return Node::eventIn(n,sfVec3f,(void*) &set_translation);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : addChildren
 *  - 1 : removeChildren
 *  - 2 : set_center
 *  - 3 : set_children
 *  - 4 : set_rotation
 *  - 5 : set_scale
 *  - 6 : set_scaleOrientation
 *  - 7 : set_translation

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Transform::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("addChildren",mfNode,&addChildren);
  case 1: return Node::eventIn("removeChildren",mfNode,&removeChildren);
  case 2: return Node::eventIn("set_center",sfVec3f,&set_center);
  case 3: return Node::eventIn("set_children",mfNode,&set_children);
  case 4: return Node::eventIn("set_rotation",sfRotation,&set_rotation);
  case 5: return Node::eventIn("set_scale",sfVec3f,&set_scale);
  case 6: return Node::eventIn("set_scaleOrientation",sfRotation,&set_scaleOrientation);
  case 7: return Node::eventIn("set_translation",sfVec3f,&set_translation);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - center_changed
 *  - children_changed
 *  - rotation_changed
 *  - scale_changed
 *  - scaleOrientation_changed
 *  - translation_changed
 */
wrl::Node::EventOutHandle
wrl::Transform::eventOut(const std::string& n)
{
  if(n==std::string("center_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &center_changed);
  }
  if(n==std::string("children_changed"))
  {
    return Node::eventOut(n,mfNode,(void*) &children_changed);
  }
  if(n==std::string("rotation_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &rotation_changed);
  }
  if(n==std::string("scale_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &scale_changed);
  }
  if(n==std::string("scaleOrientation_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &scaleOrientation_changed);
  }
  if(n==std::string("translation_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &translation_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center_changed
 *  - 1 : children_changed
 *  - 2 : rotation_changed
 *  - 3 : scale_changed
 *  - 4 : scaleOrientation_changed
 *  - 5 : translation_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Transform::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("center_changed",sfVec3f,&center_changed);
  case 1: return Node::eventOut("children_changed",mfNode,&children_changed);
  case 2: return Node::eventOut("rotation_changed",sfRotation,&rotation_changed);
  case 3: return Node::eventOut("scale_changed",sfVec3f,&scale_changed);
  case 4: return Node::eventOut("scaleOrientation_changed",sfRotation,&scaleOrientation_changed);
  case 5: return Node::eventOut("translation_changed",sfVec3f,&translation_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Transform::duplicate() const
{
  Transform* n = new Transform(name());
  n->center = center;
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate()));
  }
  n->rotation = rotation;
  n->scale = scale;
  n->scaleOrientation = scaleOrientation;
  n->translation = translation;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
wrl::Node* 
wrl::Transform::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Transform* n = new Transform(name());
  nodeMap[this] = n;  n->center = center;
  for (MFNode::const_iterator iter = children.begin();
       iter != children.end();++iter)
  {
     n->children.push_back(SFNode((*iter)->duplicate(nodeMap)));
  }
  n->rotation = rotation;
  n->scale = scale;
  n->scaleOrientation = scaleOrientation;
  n->translation = translation;
  n->bboxCenter = bboxCenter;
  n->bboxSize = bboxSize;
  return n;
}
bool
wrl::Transform::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec3f centerDV_(0.0f,0.0f,0.0f);
  static const SFRotation rotationDV_(0.0f,0.0f,1.0f,0.0f);
  static const SFVec3f scaleDV_(1.0f,1.0f,1.0f);
  static const SFRotation scaleOrientationDV_(0.0f,0.0f,1.0f,0.0f);
  static const SFVec3f translationDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxCenterDV_(0.0f,0.0f,0.0f);
  static const SFVec3f bboxSizeDV_(-1.0f,-1.0f,-1.0f);
  switch (i)
  {
  case 0: return center == centerDV_;
  case 1: return children == MFNode();
  case 2: return rotation == rotationDV_;
  case 3: return scale == scaleDV_;
  case 4: return scaleOrientation == scaleOrientationDV_;
  case 5: return translation == translationDV_;
  case 6: return bboxCenter == bboxCenterDV_;
  case 7: return bboxSize == bboxSizeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
