#include <xdkwrl/nodes/timesensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of TimeSensor
//************************************************************
/*! \class wrl::TimeSensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude timesensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  cycleInterval.setNbSeconds(1);
  enabled = true;
  loop = false;
  startTime.setNbSeconds(0);
  stopTime.setNbSeconds(0);
  \endcode
  */
wrl::TimeSensor::TimeSensor(const char* name)
 : Node(name)
{
  cycleInterval.setNbSeconds(1);
  enabled = true;
  loop = false;
  startTime.setNbSeconds(0);
  stopTime.setNbSeconds(0);}
/*!
 * Virtual destructor, does nothing
 */
wrl::TimeSensor::~TimeSensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - cycleInterval
 *  - enabled
 *  - loop
 *  - startTime
 *  - stopTime
 */
wrl::Node::FieldHandle
wrl::TimeSensor::field(const std::string& n)
{
  if(n==std::string("cycleInterval"))
  {
    return Node::field(n,sfTime,(void*) &cycleInterval);
  }
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  if(n==std::string("loop"))
  {
    return Node::field(n,sfBool,(void*) &loop);
  }
  if(n==std::string("startTime"))
  {
    return Node::field(n,sfTime,(void*) &startTime);
  }
  if(n==std::string("stopTime"))
  {
    return Node::field(n,sfTime,(void*) &stopTime);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : cycleInterval
 *  - 1 : enabled
 *  - 2 : loop
 *  - 3 : startTime
 *  - 4 : stopTime
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::TimeSensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("cycleInterval",sfTime,&cycleInterval);
  case 1: return Node::field("enabled",sfBool,&enabled);
  case 2: return Node::field("loop",sfBool,&loop);
  case 3: return Node::field("startTime",sfTime,&startTime);
  case 4: return Node::field("stopTime",sfTime,&stopTime);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_cycleInterval
 *  - set_enabled
 *  - set_loop
 *  - set_startTime
 *  - set_stopTime
 */
wrl::Node::EventInHandle
wrl::TimeSensor::eventIn(const std::string& n)
{
  if(n==std::string("set_cycleInterval"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_cycleInterval);
  }
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  if(n==std::string("set_loop"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_loop);
  }
  if(n==std::string("set_startTime"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_startTime);
  }
  if(n==std::string("set_stopTime"))
  {
    return Node::eventIn(n,sfTime,(void*) &set_stopTime);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::TimeSensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_cycleInterval",sfTime,&set_cycleInterval);
  case 1: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  case 2: return Node::eventIn("set_loop",sfBool,&set_loop);
  case 3: return Node::eventIn("set_startTime",sfTime,&set_startTime);
  case 4: return Node::eventIn("set_stopTime",sfTime,&set_stopTime);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - cycleTime
 *  - fraction_changed
 *  - isActive
 *  - time
 *  - cycleInterval_changed
 *  - enabled_changed
 *  - loop_changed
 *  - startTime_changed
 *  - stopTime_changed
 */
wrl::Node::EventOutHandle
wrl::TimeSensor::eventOut(const std::string& n)
{
  if(n==std::string("cycleTime"))
  {
    return Node::eventOut(n,sfTime,(void*) &cycleTime);
  }
  if(n==std::string("fraction_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &fraction_changed);
  }
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("time"))
  {
    return Node::eventOut(n,sfTime,(void*) &time);
  }
  if(n==std::string("cycleInterval_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &cycleInterval_changed);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  if(n==std::string("loop_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &loop_changed);
  }
  if(n==std::string("startTime_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &startTime_changed);
  }
  if(n==std::string("stopTime_changed"))
  {
    return Node::eventOut(n,sfTime,(void*) &stopTime_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : cycleTime
 *  - 1 : fraction_changed
 *  - 2 : isActive
 *  - 3 : time
 *  - 4 : cycleInterval_changed
 *  - 5 : enabled_changed
 *  - 6 : loop_changed
 *  - 7 : startTime_changed
 *  - 8 : stopTime_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::TimeSensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("cycleTime",sfTime,&cycleTime);
  case 1: return Node::eventOut("fraction_changed",sfFloat,&fraction_changed);
  case 2: return Node::eventOut("isActive",sfBool,&isActive);
  case 3: return Node::eventOut("time",sfTime,&time);
  case 4: return Node::eventOut("cycleInterval_changed",sfTime,&cycleInterval_changed);
  case 5: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  case 6: return Node::eventOut("loop_changed",sfBool,&loop_changed);
  case 7: return Node::eventOut("startTime_changed",sfTime,&startTime_changed);
  case 8: return Node::eventOut("stopTime_changed",sfTime,&stopTime_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::TimeSensor::duplicate() const
{
  TimeSensor* n = new TimeSensor(name());
  n->cycleInterval = cycleInterval;
  n->enabled = enabled;
  n->loop = loop;
  n->startTime = startTime;
  n->stopTime = stopTime;
  return n;
}
wrl::Node* 
wrl::TimeSensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  TimeSensor* n = new TimeSensor(name());
  nodeMap[this] = n;  n->cycleInterval = cycleInterval;
  n->enabled = enabled;
  n->loop = loop;
  n->startTime = startTime;
  n->stopTime = stopTime;
  return n;
}
bool
wrl::TimeSensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFTime cycleIntervalDV_(1);
  static const SFBool enabledDV_(true);
  static const SFBool loopDV_(false);
  static const SFTime startTimeDV_(0);
  static const SFTime stopTimeDV_(0);
  switch (i)
  {
  case 0: return cycleInterval == cycleIntervalDV_;
  case 1: return enabled == enabledDV_;
  case 2: return loop == loopDV_;
  case 3: return startTime == startTimeDV_;
  case 4: return stopTime == stopTimeDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
