#include <xdkwrl/nodes/texturetransform.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of TextureTransform
//************************************************************
/*! \class wrl::TextureTransform
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude texturetransform.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  center.setXY(0.0f,0.0f);
  rotation = 0.0f;
  scale.setXY(1.0f,1.0f);
  translation.setXY(0.0f,0.0f);
  \endcode
  */
wrl::TextureTransform::TextureTransform(const char* name)
 : Node(name)
{
  center.setXY(0.0f,0.0f);
  rotation = 0.0f;
  scale.setXY(1.0f,1.0f);
  translation.setXY(0.0f,0.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::TextureTransform::~TextureTransform()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - center
 *  - rotation
 *  - scale
 *  - translation
 */
wrl::Node::FieldHandle
wrl::TextureTransform::field(const std::string& n)
{
  if(n==std::string("center"))
  {
    return Node::field(n,sfVec2f,(void*) &center);
  }
  if(n==std::string("rotation"))
  {
    return Node::field(n,sfFloat,(void*) &rotation);
  }
  if(n==std::string("scale"))
  {
    return Node::field(n,sfVec2f,(void*) &scale);
  }
  if(n==std::string("translation"))
  {
    return Node::field(n,sfVec2f,(void*) &translation);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center
 *  - 1 : rotation
 *  - 2 : scale
 *  - 3 : translation
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::TextureTransform::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("center",sfVec2f,&center);
  case 1: return Node::field("rotation",sfFloat,&rotation);
  case 2: return Node::field("scale",sfVec2f,&scale);
  case 3: return Node::field("translation",sfVec2f,&translation);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_center
 *  - set_rotation
 *  - set_scale
 *  - set_translation
 */
wrl::Node::EventInHandle
wrl::TextureTransform::eventIn(const std::string& n)
{
  if(n==std::string("set_center"))
  {
    return Node::eventIn(n,sfVec2f,(void*) &set_center);
  }
  if(n==std::string("set_rotation"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_rotation);
  }
  if(n==std::string("set_scale"))
  {
    return Node::eventIn(n,sfVec2f,(void*) &set_scale);
  }
  if(n==std::string("set_translation"))
  {
    return Node::eventIn(n,sfVec2f,(void*) &set_translation);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::TextureTransform::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_center",sfVec2f,&set_center);
  case 1: return Node::eventIn("set_rotation",sfFloat,&set_rotation);
  case 2: return Node::eventIn("set_scale",sfVec2f,&set_scale);
  case 3: return Node::eventIn("set_translation",sfVec2f,&set_translation);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - center_changed
 *  - rotation_changed
 *  - scale_changed
 *  - translation_changed
 */
wrl::Node::EventOutHandle
wrl::TextureTransform::eventOut(const std::string& n)
{
  if(n==std::string("center_changed"))
  {
    return Node::eventOut(n,sfVec2f,(void*) &center_changed);
  }
  if(n==std::string("rotation_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &rotation_changed);
  }
  if(n==std::string("scale_changed"))
  {
    return Node::eventOut(n,sfVec2f,(void*) &scale_changed);
  }
  if(n==std::string("translation_changed"))
  {
    return Node::eventOut(n,sfVec2f,(void*) &translation_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : center_changed
 *  - 1 : rotation_changed
 *  - 2 : scale_changed
 *  - 3 : translation_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::TextureTransform::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("center_changed",sfVec2f,&center_changed);
  case 1: return Node::eventOut("rotation_changed",sfFloat,&rotation_changed);
  case 2: return Node::eventOut("scale_changed",sfVec2f,&scale_changed);
  case 3: return Node::eventOut("translation_changed",sfVec2f,&translation_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::TextureTransform::duplicate() const
{
  TextureTransform* n = new TextureTransform(name());
  n->center = center;
  n->rotation = rotation;
  n->scale = scale;
  n->translation = translation;
  return n;
}
wrl::Node* 
wrl::TextureTransform::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  TextureTransform* n = new TextureTransform(name());
  nodeMap[this] = n;  n->center = center;
  n->rotation = rotation;
  n->scale = scale;
  n->translation = translation;
  return n;
}
bool
wrl::TextureTransform::isSetToDefaultValue(unsigned int i) const
{
  static const SFVec2f centerDV_(0.0f,0.0f);
  static const SFFloat rotationDV_(0.0f);
  static const SFVec2f scaleDV_(1.0f,1.0f);
  static const SFVec2f translationDV_(0.0f,0.0f);
  switch (i)
  {
  case 0: return center == centerDV_;
  case 1: return rotation == rotationDV_;
  case 2: return scale == scaleDV_;
  case 3: return translation == translationDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
