#include <xdkwrl/nodes/text.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Text
//************************************************************
/*! \class wrl::Text
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude text.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  maxExtent = 0.0f;
  \endcode
  */
wrl::Text::Text(const char* name)
 : Node(name)
{

  maxExtent = 0.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Text::~Text()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - string
 *  - fontStyle
 *  - length
 *  - maxExtent
 */
wrl::Node::FieldHandle
wrl::Text::field(const std::string& n)
{
  if(n==std::string("string"))
  {
    return Node::field(n,mfString,(void*) &string);
  }
  if(n==std::string("fontStyle"))
  {
    return Node::field(n,sfNode,(void*) &fontStyle);
  }
  if(n==std::string("length"))
  {
    return Node::field(n,mfFloat,(void*) &length);
  }
  if(n==std::string("maxExtent"))
  {
    return Node::field(n,sfFloat,(void*) &maxExtent);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : string
 *  - 1 : fontStyle
 *  - 2 : length
 *  - 3 : maxExtent
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Text::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("string",mfString,&string);
  case 1: return Node::field("fontStyle",sfNode,&fontStyle);
  case 2: return Node::field("length",mfFloat,&length);
  case 3: return Node::field("maxExtent",sfFloat,&maxExtent);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_string
 *  - set_fontStyle
 *  - set_length
 *  - set_maxExtent
 */
wrl::Node::EventInHandle
wrl::Text::eventIn(const std::string& n)
{
  if(n==std::string("set_string"))
  {
    return Node::eventIn(n,mfString,(void*) &set_string);
  }
  if(n==std::string("set_fontStyle"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_fontStyle);
  }
  if(n==std::string("set_length"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_length);
  }
  if(n==std::string("set_maxExtent"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_maxExtent);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Text::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_string",mfString,&set_string);
  case 1: return Node::eventIn("set_fontStyle",sfNode,&set_fontStyle);
  case 2: return Node::eventIn("set_length",mfFloat,&set_length);
  case 3: return Node::eventIn("set_maxExtent",sfFloat,&set_maxExtent);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - string_changed
 *  - fontStyle_changed
 *  - length_changed
 *  - maxExtent_changed
 */
wrl::Node::EventOutHandle
wrl::Text::eventOut(const std::string& n)
{
  if(n==std::string("string_changed"))
  {
    return Node::eventOut(n,mfString,(void*) &string_changed);
  }
  if(n==std::string("fontStyle_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &fontStyle_changed);
  }
  if(n==std::string("length_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &length_changed);
  }
  if(n==std::string("maxExtent_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &maxExtent_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : string_changed
 *  - 1 : fontStyle_changed
 *  - 2 : length_changed
 *  - 3 : maxExtent_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Text::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("string_changed",mfString,&string_changed);
  case 1: return Node::eventOut("fontStyle_changed",sfNode,&fontStyle_changed);
  case 2: return Node::eventOut("length_changed",mfFloat,&length_changed);
  case 3: return Node::eventOut("maxExtent_changed",sfFloat,&maxExtent_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::Text::duplicate() const
{
  Text* n = new Text(name());
  n->string = string;
  if (fontStyle != NULL)
  {
    n->fontStyle = fontStyle->duplicate();
  }
  else
  {
    n->fontStyle = NULL;
  }
  n->length = length;
  n->maxExtent = maxExtent;
  return n;
}
wrl::Node* 
wrl::Text::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Text* n = new Text(name());
  nodeMap[this] = n;  n->string = string;
  if (fontStyle != NULL)
  {
    n->fontStyle = fontStyle->duplicate(nodeMap);
  }
  else
  {
    n->fontStyle = NULL;
  }
  n->length = length;
  n->maxExtent = maxExtent;
  return n;
}
bool
wrl::Text::isSetToDefaultValue(unsigned int i) const
{

  static const SFFloat maxExtentDV_(0.0f);
  switch (i)
  {
  case 0: return string == MFString();
  case 1: return fontStyle == SFNode();
  case 2: return length == MFFloat();
  case 3: return maxExtent == maxExtentDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
