#include <xdkwrl/nodes/spheresensor.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of SphereSensor
//************************************************************
/*! \class wrl::SphereSensor
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude spheresensor.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  autoOffset = true;
  enabled = true;
  offset.setAxisAndAngle(0.0f,1.0f,0.0f,0.0f);
  \endcode
  */
wrl::SphereSensor::SphereSensor(const char* name)
 : Node(name)
{
  autoOffset = true;
  enabled = true;
  offset.setAxisAndAngle(0.0f,1.0f,0.0f,0.0f);}
/*!
 * Virtual destructor, does nothing
 */
wrl::SphereSensor::~SphereSensor()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - autoOffset
 *  - enabled
 *  - offset
 */
wrl::Node::FieldHandle
wrl::SphereSensor::field(const std::string& n)
{
  if(n==std::string("autoOffset"))
  {
    return Node::field(n,sfBool,(void*) &autoOffset);
  }
  if(n==std::string("enabled"))
  {
    return Node::field(n,sfBool,(void*) &enabled);
  }
  if(n==std::string("offset"))
  {
    return Node::field(n,sfRotation,(void*) &offset);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : autoOffset
 *  - 1 : enabled
 *  - 2 : offset
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::SphereSensor::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("autoOffset",sfBool,&autoOffset);
  case 1: return Node::field("enabled",sfBool,&enabled);
  case 2: return Node::field("offset",sfRotation,&offset);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_autoOffset
 *  - set_enabled
 *  - set_offset
 */
wrl::Node::EventInHandle
wrl::SphereSensor::eventIn(const std::string& n)
{
  if(n==std::string("set_autoOffset"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_autoOffset);
  }
  if(n==std::string("set_enabled"))
  {
    return Node::eventIn(n,sfBool,(void*) &set_enabled);
  }
  if(n==std::string("set_offset"))
  {
    return Node::eventIn(n,sfRotation,(void*) &set_offset);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::SphereSensor::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_autoOffset",sfBool,&set_autoOffset);
  case 1: return Node::eventIn("set_enabled",sfBool,&set_enabled);
  case 2: return Node::eventIn("set_offset",sfRotation,&set_offset);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - isActive
 *  - rotation_changed
 *  - trackPoint_changed
 *  - autoOffset_changed
 *  - enabled_changed
 *  - offset_changed
 */
wrl::Node::EventOutHandle
wrl::SphereSensor::eventOut(const std::string& n)
{
  if(n==std::string("isActive"))
  {
    return Node::eventOut(n,sfBool,(void*) &isActive);
  }
  if(n==std::string("rotation_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &rotation_changed);
  }
  if(n==std::string("trackPoint_changed"))
  {
    return Node::eventOut(n,sfVec3f,(void*) &trackPoint_changed);
  }
  if(n==std::string("autoOffset_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &autoOffset_changed);
  }
  if(n==std::string("enabled_changed"))
  {
    return Node::eventOut(n,sfBool,(void*) &enabled_changed);
  }
  if(n==std::string("offset_changed"))
  {
    return Node::eventOut(n,sfRotation,(void*) &offset_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : isActive
 *  - 1 : rotation_changed
 *  - 2 : trackPoint_changed
 *  - 3 : autoOffset_changed
 *  - 4 : enabled_changed
 *  - 5 : offset_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::SphereSensor::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("isActive",sfBool,&isActive);
  case 1: return Node::eventOut("rotation_changed",sfRotation,&rotation_changed);
  case 2: return Node::eventOut("trackPoint_changed",sfVec3f,&trackPoint_changed);
  case 3: return Node::eventOut("autoOffset_changed",sfBool,&autoOffset_changed);
  case 4: return Node::eventOut("enabled_changed",sfBool,&enabled_changed);
  case 5: return Node::eventOut("offset_changed",sfRotation,&offset_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::SphereSensor::duplicate() const
{
  SphereSensor* n = new SphereSensor(name());
  n->autoOffset = autoOffset;
  n->enabled = enabled;
  n->offset = offset;
  return n;
}
wrl::Node* 
wrl::SphereSensor::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  SphereSensor* n = new SphereSensor(name());
  nodeMap[this] = n;  n->autoOffset = autoOffset;
  n->enabled = enabled;
  n->offset = offset;
  return n;
}
bool
wrl::SphereSensor::isSetToDefaultValue(unsigned int i) const
{
  static const SFBool autoOffsetDV_(true);
  static const SFBool enabledDV_(true);
  static const SFRotation offsetDV_(0.0f,1.0f,0.0f,0.0f);
  switch (i)
  {
  case 0: return autoOffset == autoOffsetDV_;
  case 1: return enabled == enabledDV_;
  case 2: return offset == offsetDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
