#include <xdkwrl/nodes/sphere.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of Sphere
//************************************************************
/*! \class wrl::Sphere
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude sphere.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code
  radius = 1.0f;
  \endcode
  */
wrl::Sphere::Sphere(const char* name)
 : Node(name)
{
  radius = 1.0f;}
/*!
 * Virtual destructor, does nothing
 */
wrl::Sphere::~Sphere()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - radius
 */
wrl::Node::FieldHandle
wrl::Sphere::field(const std::string& n)
{
  if(n==std::string("radius"))
  {
    return Node::field(n,sfFloat,(void*) &radius);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : radius
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::Sphere::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("radius",sfFloat,&radius);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventInHandle
wrl::Sphere::eventIn(const std::string&)
{
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::Sphere::eventIn(unsigned int)
{
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 */
wrl::Node::EventOutHandle
wrl::Sphere::eventOut(const std::string&)
{
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::Sphere::eventOut(unsigned int)
{
  return EventOutHandle();
}
wrl::Node* 
wrl::Sphere::duplicate() const
{
  Sphere* n = new Sphere(name());
  n->radius = radius;
  return n;
}
wrl::Node* 
wrl::Sphere::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  Sphere* n = new Sphere(name());
  nodeMap[this] = n;  n->radius = radius;
  return n;
}
bool
wrl::Sphere::isSetToDefaultValue(unsigned int i) const
{
  static const SFFloat radiusDV_(1.0f);
  switch (i)
  {
  case 0: return radius == radiusDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
