#include <xdkwrl/nodes/scalarinterpolator.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of ScalarInterpolator
//************************************************************
/*! \class wrl::ScalarInterpolator
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude scalarinterpolator.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::ScalarInterpolator::ScalarInterpolator(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::ScalarInterpolator::~ScalarInterpolator()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - key
 *  - keyValue
 */
wrl::Node::FieldHandle
wrl::ScalarInterpolator::field(const std::string& n)
{
  if(n==std::string("key"))
  {
    return Node::field(n,mfFloat,(void*) &key);
  }
  if(n==std::string("keyValue"))
  {
    return Node::field(n,mfFloat,(void*) &keyValue);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : key
 *  - 1 : keyValue
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::ScalarInterpolator::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("key",mfFloat,&key);
  case 1: return Node::field("keyValue",mfFloat,&keyValue);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_fraction
 *  - set_key
 *  - set_keyValue
 */
wrl::Node::EventInHandle
wrl::ScalarInterpolator::eventIn(const std::string& n)
{
  if(n==std::string("set_fraction"))
  {
    return Node::eventIn(n,sfFloat,(void*) &set_fraction);
  }
  if(n==std::string("set_key"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_key);
  }
  if(n==std::string("set_keyValue"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_keyValue);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : set_fraction
 *  - 1 : set_key
 *  - 2 : set_keyValue

 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::ScalarInterpolator::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_fraction",sfFloat,&set_fraction);
  case 1: return Node::eventIn("set_key",mfFloat,&set_key);
  case 2: return Node::eventIn("set_keyValue",mfFloat,&set_keyValue);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - value_changed
 *  - key_changed
 *  - keyValue_changed
 */
wrl::Node::EventOutHandle
wrl::ScalarInterpolator::eventOut(const std::string& n)
{
  if(n==std::string("value_changed"))
  {
    return Node::eventOut(n,sfFloat,(void*) &value_changed);
  }
  if(n==std::string("key_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &key_changed);
  }
  if(n==std::string("keyValue_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &keyValue_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : value_changed
 *  - 1 : key_changed
 *  - 2 : keyValue_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::ScalarInterpolator::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("value_changed",sfFloat,&value_changed);
  case 1: return Node::eventOut("key_changed",mfFloat,&key_changed);
  case 2: return Node::eventOut("keyValue_changed",mfFloat,&keyValue_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::ScalarInterpolator::duplicate() const
{
  ScalarInterpolator* n = new ScalarInterpolator(name());
  n->key = key;
  n->keyValue = keyValue;
  return n;
}
wrl::Node* 
wrl::ScalarInterpolator::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  ScalarInterpolator* n = new ScalarInterpolator(name());
  nodeMap[this] = n;  n->key = key;
  n->keyValue = keyValue;
  return n;
}
bool
wrl::ScalarInterpolator::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return key == MFFloat();
  case 1: return keyValue == MFFloat();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
