#include <xdkwrl/nodes/pointset.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of PointSet
//************************************************************
/*! \class wrl::PointSet
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude pointset.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  \endcode
  */
wrl::PointSet::PointSet(const char* name)
 : Node(name)
{
}
/*!
 * Virtual destructor, does nothing
 */
wrl::PointSet::~PointSet()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - color
 *  - coord
 */
wrl::Node::FieldHandle
wrl::PointSet::field(const std::string& n)
{
  if(n==std::string("color"))
  {
    return Node::field(n,sfNode,(void*) &color);
  }
  if(n==std::string("coord"))
  {
    return Node::field(n,sfNode,(void*) &coord);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color
 *  - 1 : coord
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::PointSet::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("color",sfNode,&color);
  case 1: return Node::field("coord",sfNode,&coord);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_color
 *  - set_coord
 */
wrl::Node::EventInHandle
wrl::PointSet::eventIn(const std::string& n)
{
  if(n==std::string("set_color"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_color);
  }
  if(n==std::string("set_coord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_coord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::PointSet::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_color",sfNode,&set_color);
  case 1: return Node::eventIn("set_coord",sfNode,&set_coord);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - color_changed
 *  - coord_changed
 */
wrl::Node::EventOutHandle
wrl::PointSet::eventOut(const std::string& n)
{
  if(n==std::string("color_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &color_changed);
  }
  if(n==std::string("coord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &coord_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : color_changed
 *  - 1 : coord_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::PointSet::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("color_changed",sfNode,&color_changed);
  case 1: return Node::eventOut("coord_changed",sfNode,&coord_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::PointSet::duplicate() const
{
  PointSet* n = new PointSet(name());
  if (color != NULL)
  {
    n->color = color->duplicate();
  }
  else
  {
    n->color = NULL;
  }
  if (coord != NULL)
  {
    n->coord = coord->duplicate();
  }
  else
  {
    n->coord = NULL;
  }
  return n;
}
wrl::Node* 
wrl::PointSet::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  PointSet* n = new PointSet(name());
  nodeMap[this] = n;  if (color != NULL)
  {
    n->color = color->duplicate(nodeMap);
  }
  else
  {
    n->color = NULL;
  }
  if (coord != NULL)
  {
    n->coord = coord->duplicate(nodeMap);
  }
  else
  {
    n->coord = NULL;
  }
  return n;
}
bool
wrl::PointSet::isSetToDefaultValue(unsigned int i) const
{

  switch (i)
  {
  case 0: return color == SFNode();
  case 1: return coord == SFNode();
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
