#include <xdkwrl/nodes/nurbssurface.h>

using namespace std;
using namespace wrl;

//************************************************************
// Implementation of NurbsSurface
//************************************************************
/*! \class wrl::NurbsSurface
 * \ingroup nodetypes
 * 
 * Here is the documentation for this node type,
 * from the ISO standard.
 * \htmlinclude nurbssurface.html
 */
 /*!
  * Construct a node with all its fields set to default value, 
  * which is equivalent to the code below:
  \code

  uTessellation = 0;
  vTessellation = 0;
  ccw = true;
  solid = true;
  uDimension = 0;
  uOrder = 3;
  vDimension = 0;
  vOrder = 3;
  \endcode
  */
wrl::NurbsSurface::NurbsSurface(const char* name)
 : Node(name)
{

  uTessellation = 0;
  vTessellation = 0;
  ccw = true;
  solid = true;
  uDimension = 0;
  uOrder = 3;
  vDimension = 0;
  vOrder = 3;}
/*!
 * Virtual destructor, does nothing
 */
wrl::NurbsSurface::~NurbsSurface()
{
}
/*!
 * Return a handle on the field named \p n of the node or a "unknown" typed
 * handle if there is no such field.  Valid names are:
 *  - controlPoint
 *  - texCoord
 *  - uTessellation
 *  - vTessellation
 *  - weight
 *  - ccw
 *  - solid
 *  - uDimension
 *  - uKnot
 *  - uOrder
 *  - vDimension
 *  - vKnot
 *  - vOrder
 */
wrl::Node::FieldHandle
wrl::NurbsSurface::field(const std::string& n)
{
  if(n==std::string("controlPoint"))
  {
    return Node::field(n,mfVec3f,(void*) &controlPoint);
  }
  if(n==std::string("texCoord"))
  {
    return Node::field(n,sfNode,(void*) &texCoord);
  }
  if(n==std::string("uTessellation"))
  {
    return Node::field(n,sfInt32,(void*) &uTessellation);
  }
  if(n==std::string("vTessellation"))
  {
    return Node::field(n,sfInt32,(void*) &vTessellation);
  }
  if(n==std::string("weight"))
  {
    return Node::field(n,mfFloat,(void*) &weight);
  }
  if(n==std::string("ccw"))
  {
    return Node::field(n,sfBool,(void*) &ccw);
  }
  if(n==std::string("solid"))
  {
    return Node::field(n,sfBool,(void*) &solid);
  }
  if(n==std::string("uDimension"))
  {
    return Node::field(n,sfInt32,(void*) &uDimension);
  }
  if(n==std::string("uKnot"))
  {
    return Node::field(n,mfFloat,(void*) &uKnot);
  }
  if(n==std::string("uOrder"))
  {
    return Node::field(n,sfInt32,(void*) &uOrder);
  }
  if(n==std::string("vDimension"))
  {
    return Node::field(n,sfInt32,(void*) &vDimension);
  }
  if(n==std::string("vKnot"))
  {
    return Node::field(n,mfFloat,(void*) &vKnot);
  }
  if(n==std::string("vOrder"))
  {
    return Node::field(n,sfInt32,(void*) &vOrder);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the \p i th field of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : controlPoint
 *  - 1 : texCoord
 *  - 2 : uTessellation
 *  - 3 : vTessellation
 *  - 4 : weight
 *  - 5 : ccw
 *  - 6 : solid
 *  - 7 : uDimension
 *  - 8 : uKnot
 *  - 9 : uOrder
 *  - 10 : vDimension
 *  - 11 : vKnot
 *  - 12 : vOrder
 * This function is useful, with nbFields() if you want to traverse 
 * all fields of a Node. 
 */
wrl::Node::FieldHandle
wrl::NurbsSurface::field(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::field("controlPoint",mfVec3f,&controlPoint);
  case 1: return Node::field("texCoord",sfNode,&texCoord);
  case 2: return Node::field("uTessellation",sfInt32,&uTessellation);
  case 3: return Node::field("vTessellation",sfInt32,&vTessellation);
  case 4: return Node::field("weight",mfFloat,&weight);
  case 5: return Node::field("ccw",sfBool,&ccw);
  case 6: return Node::field("solid",sfBool,&solid);
  case 7: return Node::field("uDimension",sfInt32,&uDimension);
  case 8: return Node::field("uKnot",mfFloat,&uKnot);
  case 9: return Node::field("uOrder",sfInt32,&uOrder);
  case 10: return Node::field("vDimension",sfInt32,&vDimension);
  case 11: return Node::field("vKnot",mfFloat,&vKnot);
  case 12: return Node::field("vOrder",sfInt32,&vOrder);
  }
  return FieldHandle();
}
/*!
 * Return a handle on the event in named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - set_controlPoint
 *  - set_texCoord
 *  - set_uTessellation
 *  - set_vTessellation
 *  - set_weight
 */
wrl::Node::EventInHandle
wrl::NurbsSurface::eventIn(const std::string& n)
{
  if(n==std::string("set_controlPoint"))
  {
    return Node::eventIn(n,mfVec3f,(void*) &set_controlPoint);
  }
  if(n==std::string("set_texCoord"))
  {
    return Node::eventIn(n,sfNode,(void*) &set_texCoord);
  }
  if(n==std::string("set_uTessellation"))
  {
    return Node::eventIn(n,sfInt32,(void*) &set_uTessellation);
  }
  if(n==std::string("set_vTessellation"))
  {
    return Node::eventIn(n,sfInt32,(void*) &set_vTessellation);
  }
  if(n==std::string("set_weight"))
  {
    return Node::eventIn(n,mfFloat,(void*) &set_weight);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the \p i th event in of the node or a "unknown" typed
 * handle if there is no such node.
emarks This class has no eventIn.
 * This function is useful, with nbEventsIn() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventInHandle
wrl::NurbsSurface::eventIn(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventIn("set_controlPoint",mfVec3f,&set_controlPoint);
  case 1: return Node::eventIn("set_texCoord",sfNode,&set_texCoord);
  case 2: return Node::eventIn("set_uTessellation",sfInt32,&set_uTessellation);
  case 3: return Node::eventIn("set_vTessellation",sfInt32,&set_vTessellation);
  case 4: return Node::eventIn("set_weight",mfFloat,&set_weight);
  }
  return EventInHandle();
}
/*!
 * Return a handle on the event out named \p n of the node or a "unknown" typed
 * handle if there is no such event.  Valid names are:
 *  - controlPoint_changed
 *  - texCoord_changed
 *  - uTessellation_changed
 *  - vTessellation_changed
 *  - weight_changed
 */
wrl::Node::EventOutHandle
wrl::NurbsSurface::eventOut(const std::string& n)
{
  if(n==std::string("controlPoint_changed"))
  {
    return Node::eventOut(n,mfVec3f,(void*) &controlPoint_changed);
  }
  if(n==std::string("texCoord_changed"))
  {
    return Node::eventOut(n,sfNode,(void*) &texCoord_changed);
  }
  if(n==std::string("uTessellation_changed"))
  {
    return Node::eventOut(n,sfInt32,(void*) &uTessellation_changed);
  }
  if(n==std::string("vTessellation_changed"))
  {
    return Node::eventOut(n,sfInt32,(void*) &vTessellation_changed);
  }
  if(n==std::string("weight_changed"))
  {
    return Node::eventOut(n,mfFloat,(void*) &weight_changed);
  }
  return EventOutHandle();
}
/*!
 * Return a handle on the \p i th event out of the node or a "unknown" typed
 * handle if there is no such node.  Here is how \p i is related to fields:
 *  - 0 : controlPoint_changed
 *  - 1 : texCoord_changed
 *  - 2 : uTessellation_changed
 *  - 3 : vTessellation_changed
 *  - 4 : weight_changed
 * This function is useful, with nbEventsOut() if you want to traverse 
 * all events in of a Node. 
 */
wrl::Node::EventOutHandle
wrl::NurbsSurface::eventOut(unsigned int n)
{
  switch (n)
  {
  case 0: return Node::eventOut("controlPoint_changed",mfVec3f,&controlPoint_changed);
  case 1: return Node::eventOut("texCoord_changed",sfNode,&texCoord_changed);
  case 2: return Node::eventOut("uTessellation_changed",sfInt32,&uTessellation_changed);
  case 3: return Node::eventOut("vTessellation_changed",sfInt32,&vTessellation_changed);
  case 4: return Node::eventOut("weight_changed",mfFloat,&weight_changed);
  }
  return EventOutHandle();
}
wrl::Node* 
wrl::NurbsSurface::duplicate() const
{
  NurbsSurface* n = new NurbsSurface(name());
  n->controlPoint = controlPoint;
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate();
  }
  else
  {
    n->texCoord = NULL;
  }
  n->uTessellation = uTessellation;
  n->vTessellation = vTessellation;
  n->weight = weight;
  n->ccw = ccw;
  n->solid = solid;
  n->uDimension = uDimension;
  n->uKnot = uKnot;
  n->uOrder = uOrder;
  n->vDimension = vDimension;
  n->vKnot = vKnot;
  n->vOrder = vOrder;
  return n;
}
wrl::Node* 
wrl::NurbsSurface::duplicate(map<const Node*,Node*>& nodeMap) const
{
  map<const Node*,Node*>::const_iterator fter = nodeMap.find(this);
  if (fter != nodeMap.end())
  {
    return fter->second;
  }
  NurbsSurface* n = new NurbsSurface(name());
  nodeMap[this] = n;  n->controlPoint = controlPoint;
  if (texCoord != NULL)
  {
    n->texCoord = texCoord->duplicate(nodeMap);
  }
  else
  {
    n->texCoord = NULL;
  }
  n->uTessellation = uTessellation;
  n->vTessellation = vTessellation;
  n->weight = weight;
  n->ccw = ccw;
  n->solid = solid;
  n->uDimension = uDimension;
  n->uKnot = uKnot;
  n->uOrder = uOrder;
  n->vDimension = vDimension;
  n->vKnot = vKnot;
  n->vOrder = vOrder;
  return n;
}
bool
wrl::NurbsSurface::isSetToDefaultValue(unsigned int i) const
{

  static const SFInt32 uTessellationDV_(0);
  static const SFInt32 vTessellationDV_(0);
  static const SFBool ccwDV_(true);
  static const SFBool solidDV_(true);
  static const SFInt32 uDimensionDV_(0);
  static const SFInt32 uOrderDV_(3);
  static const SFInt32 vDimensionDV_(0);
  static const SFInt32 vOrderDV_(3);
  switch (i)
  {
  case 0: return controlPoint == MFVec3f();
  case 1: return texCoord == SFNode();
  case 2: return uTessellation == uTessellationDV_;
  case 3: return vTessellation == vTessellationDV_;
  case 4: return weight == MFFloat();
  case 5: return ccw == ccwDV_;
  case 6: return solid == solidDV_;
  case 7: return uDimension == uDimensionDV_;
  case 8: return uKnot == MFFloat();
  case 9: return uOrder == uOrderDV_;
  case 10: return vDimension == vDimensionDV_;
  case 11: return vKnot == MFFloat();
  case 12: return vOrder == vOrderDV_;
  }
  return false;
}

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../../include" "../../../include/xdkwrl/nodes")
// End:
